/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.directaccess.ui;

import com.android.tools.idea.devicemanager.ActivateDeviceFileExplorerWindowValue;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.PopUpMenuValue;
import com.google.gct.directaccess.ui.FirebaseItem;
import com.google.gct.directaccess.ui.FirebaseItemManager;
import com.intellij.openapi.project.Project;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/google/gct/directaccess/ui/FirebaseDeviceTableModel;", "Ljavax/swing/table/AbstractTableModel;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "uiDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;)V", "itemManager", "Lcom/google/gct/directaccess/ui/FirebaseItemManager;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getColumnClass", "Ljava/lang/Class;", "columnIndex", "", "getColumnCount", "getColumnName", "", "modelColumnIndex", "getRowCount", "getValueAt", "", "rowIndex", "isCellEditable", "", "setValueAt", "", "value", "directaccess"})
public final class FirebaseDeviceTableModel
extends AbstractTableModel {
    @NotNull
    private final Project project;
    @NotNull
    private final FirebaseItemManager itemManager;

    public FirebaseDeviceTableModel(@NotNull Project project, @NotNull CoroutineScope scope, @NotNull CoroutineDispatcher uiDispatcher) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)uiDispatcher, (String)"uiDispatcher");
        this.project = project;
        this.itemManager = new FirebaseItemManager(this.project, this, scope, uiDispatcher);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public int getRowCount() {
        return this.itemManager.getItemCount();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    @NotNull
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object object = switch (columnIndex) {
            case 0 -> this.itemManager.getItem(rowIndex).getDeviceType();
            case 1 -> this.itemManager.getItem(rowIndex);
            case 2 -> Integer.valueOf(this.itemManager.getItem(rowIndex).getApiLevel());
            case 3 -> Boolean.valueOf(this.itemManager.getItem(rowIndex).isActive());
            case 4 -> ActivateDeviceFileExplorerWindowValue.INSTANCE;
            case 5 -> PopUpMenuValue.INSTANCE;
            default -> "";
        };
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"when (columnIndex) {\n   \u2026CE\n      else -> \"\"\n    }");
        return object;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return switch (columnIndex) {
            case 0, 1, 2 -> false;
            case 3 -> this.itemManager.getItem(rowIndex).isActive();
            case 4, 5 -> this.itemManager.getItem(rowIndex).isOnline();
            default -> false;
        };
    }

    @Override
    @NotNull
    public String getColumnName(int modelColumnIndex) {
        return switch (modelColumnIndex) {
            case 1 -> "Device";
            case 2 -> "API";
            default -> "";
        };
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int columnIndex) {
        Class clazz;
        switch (columnIndex) {
            case 0: {
                clazz = DeviceType.class;
                break;
            }
            case 1: {
                clazz = FirebaseItem.class;
                break;
            }
            case 3: {
                clazz = Boolean.TYPE;
                break;
            }
            case 4: {
                clazz = ActivateDeviceFileExplorerWindowValue.class;
                break;
            }
            case 5: {
                clazz = PopUpMenuValue.class;
                break;
            }
            default: {
                Class<?> clazz2 = super.getColumnClass(columnIndex);
                clazz = clazz2;
                Intrinsics.checkNotNullExpressionValue(clazz2, (String)"super.getColumnClass(columnIndex)");
            }
        }
        return clazz;
    }

    @Override
    public void setValueAt(@Nullable Object value, int rowIndex, int columnIndex) {
        FirebaseItem item;
        if (columnIndex == 3 && (item = this.itemManager.getItem(rowIndex)).isActive() && Intrinsics.areEqual((Object)value, (Object)false)) {
            item.startAction();
        }
    }
}

