/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.directaccess;

import com.android.adblib.AdbSession;
import com.android.tools.idea.adblib.AdbLibService;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.io.grpc.Channel;
import com.android.tools.idea.io.grpc.ManagedChannel;
import com.android.tools.idea.io.grpc.netty.NettyChannelBuilder;
import com.android.tools.idea.io.netty.channel.ChannelOption;
import com.google.gct.directaccess.DirectAccessService;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.google.gct.login.common.LoginListener;
import com.google.services.firebase.directaccess.client.DirectAccessConnection;
import com.google.services.firebase.directaccess.client.DirectAccessConnectionManager;
import com.google.services.firebase.directaccess.client.DirectAccessConnectionManagerKt;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManager;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManagerImpl;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00138F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lcom/google/gct/directaccess/DirectAccessService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "channel", "Lcom/android/tools/idea/io/grpc/ManagedChannel;", "kotlin.jvm.PlatformType", "connectionManager", "Lcom/google/services/firebase/directaccess/client/DirectAccessConnectionManager;", "getConnectionManager", "()Lcom/google/services/firebase/directaccess/client/DirectAccessConnectionManager;", "gcpProject", "", "getGcpProject", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "<set-?>", "Lcom/google/services/firebase/directaccess/client/DirectAccessReservationManager;", "reservationManager", "getReservationManager", "()Lcom/google/services/firebase/directaccess/client/DirectAccessReservationManager;", "connectToReservation", "Lcom/google/services/firebase/directaccess/client/DirectAccessConnection;", "reservationName", "scope", "Lkotlinx/coroutines/CoroutineScope;", "dispose", "", "directaccess"})
@SourceDebugExtension(value={"SMAP\nDirectAccessService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectAccessService.kt\ncom/google/gct/directaccess/DirectAccessService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class DirectAccessService
implements Disposable {
    @NotNull
    private final Project project;
    private final ManagedChannel channel;
    @Nullable
    private DirectAccessReservationManager reservationManager;
    @Nullable
    private DirectAccessConnectionManager connectionManager;

    public DirectAccessService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.channel = NettyChannelBuilder.forTarget((String)("dns:///" + StudioFlags.DIRECT_ACCESS_ENDPOINT.get())).withOption(ChannelOption.TCP_NODELAY, (Object)true).build();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final String getGcpProject() {
        Object object = StudioFlags.DIRECT_ACCESS_PROJECT.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DIRECT_ACCESS_PROJECT.get()");
        return (String)object;
    }

    @Nullable
    public final DirectAccessReservationManager getReservationManager() {
        DirectAccessReservationManager directAccessReservationManager = this.reservationManager;
        if (directAccessReservationManager == null) {
            DirectAccessReservationManagerImpl directAccessReservationManagerImpl;
            String string = this.getGcpProject();
            CoroutineScope coroutineScope = CoroutinesUtilsKt.AndroidCoroutineScope$default((Disposable)this, null, (int)2, null);
            ManagedChannel managedChannel = this.channel;
            Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"channel");
            DirectAccessReservationManagerImpl it = directAccessReservationManagerImpl = DirectAccessReservationManagerKt.DirectAccessReservationManager(string, coroutineScope, (Channel)managedChannel, (Function0<String>)((Function0)reservationManager.1.INSTANCE));
            boolean bl = false;
            this.reservationManager = it;
            CredentialedUser credentialedUser = GoogleLogin.Companion.getInstance().getActiveUser();
            if (credentialedUser != null && (credentialedUser = credentialedUser.getGoogleLoginState()) != null) {
                credentialedUser.addLoginListener(new LoginListener(this){
                    final /* synthetic */ DirectAccessService this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void statusChanged(boolean loggedIn) {
                        if (!loggedIn) {
                            DirectAccessService.access$setReservationManager$p(this.this$0, null);
                        }
                    }
                });
            }
            directAccessReservationManager = directAccessReservationManagerImpl;
        }
        return directAccessReservationManager;
    }

    private final DirectAccessConnectionManager getConnectionManager() {
        DirectAccessConnectionManager directAccessConnectionManager = this.connectionManager;
        if (directAccessConnectionManager == null) {
            DirectAccessReservationManager directAccessReservationManager = this.getReservationManager();
            if (directAccessReservationManager != null) {
                DirectAccessConnectionManager directAccessConnectionManager2;
                DirectAccessReservationManager reservationManager2 = directAccessReservationManager;
                boolean bl = false;
                AdbSession adbSession = AdbLibService.Companion.getSession(this.project);
                Function0 function0 = connectionManager.1.1.INSTANCE;
                ManagedChannel managedChannel = this.channel;
                Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"channel");
                DirectAccessConnectionManager it = directAccessConnectionManager2 = DirectAccessConnectionManagerKt.DirectAccessConnectionManager$default(adbSession, function0, (Channel)managedChannel, reservationManager2, null, null, 48, null);
                boolean bl2 = false;
                this.connectionManager = it;
                directAccessConnectionManager = directAccessConnectionManager2;
            } else {
                directAccessConnectionManager = null;
            }
        }
        return directAccessConnectionManager;
    }

    @Nullable
    public final DirectAccessConnection connectToReservation(@NotNull String reservationName, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)reservationName, (String)"reservationName");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        DirectAccessConnectionManager directAccessConnectionManager = this.getConnectionManager();
        return directAccessConnectionManager != null ? directAccessConnectionManager.connect(reservationName, scope) : null;
    }

    public void dispose() {
    }

    public static final /* synthetic */ void access$setReservationManager$p(DirectAccessService $this, DirectAccessReservationManager directAccessReservationManager) {
        $this.reservationManager = directAccessReservationManager;
    }
}

