/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MavenRemoteRepository
implements Serializable {
    private final String myId;
    private final String myName;
    private final String myUrl;
    private final String myLayout;
    private final Policy myReleasesPolicy;
    private final Policy mySnapshotsPolicy;

    public MavenRemoteRepository(@NotNull String id, @Nullable String name, @NotNull String url, @Nullable String layout, @Nullable Policy releasesPolicy, @Nullable Policy snapshotsPolicy) {
        this.myId = id;
        this.myName = name;
        this.myUrl = url;
        this.myLayout = layout;
        this.myReleasesPolicy = releasesPolicy;
        this.mySnapshotsPolicy = snapshotsPolicy;
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getUrl() {
        return this.myUrl;
    }

    @Nullable
    public String getLayout() {
        return this.myLayout;
    }

    @Nullable
    public Policy getReleasesPolicy() {
        return this.myReleasesPolicy;
    }

    @Nullable
    public Policy getSnapshotsPolicy() {
        return this.mySnapshotsPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenRemoteRepository that = (MavenRemoteRepository)o;
        return this.myId.equals(that.myId);
    }

    public int hashCode() {
        return this.myId.hashCode();
    }

    public static class Policy
    implements Serializable {
        private final boolean myEnabled;
        private final String myUpdatePolicy;
        private final String myChecksumPolicy;

        public Policy(boolean enabled, String updatePolicy, String checksumPolicy) {
            this.myEnabled = enabled;
            this.myUpdatePolicy = updatePolicy;
            this.myChecksumPolicy = checksumPolicy;
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public String getUpdatePolicy() {
            return this.myUpdatePolicy;
        }

        public String getChecksumPolicy() {
            return this.myChecksumPolicy;
        }
    }
}

