/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import com.intellij.openapi.util.text.StringUtilRt;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenArchetype
implements Serializable {
    @NotNull
    public final String groupId;
    @NotNull
    public final String artifactId;
    @NotNull
    public final String version;
    @Nullable
    public final String repository;
    @Nullable
    public final String description;

    public MavenArchetype(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String repository, @Nullable String description) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.repository = StringUtilRt.isEmptyOrSpaces((CharSequence)repository) ? null : repository;
        this.description = StringUtilRt.isEmptyOrSpaces((CharSequence)description) ? null : description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArchetype that = (MavenArchetype)o;
        if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
            return false;
        }
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }
}

