/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConsoleLine;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class GitVcsConsoleWriter {
    private static final Logger LOG = Logger.getInstance(GitVcsConsoleWriter.class);
    private static final int MAX_CONSOLE_OUTPUT_SIZE = 10000;
    private final Project myProject;

    @NotNull
    public static GitVcsConsoleWriter getInstance(@NotNull Project project) {
        return (GitVcsConsoleWriter)project.getService(GitVcsConsoleWriter.class);
    }

    public GitVcsConsoleWriter(@NotNull Project project) {
        this.myProject = project;
    }

    public void showMessage(@NotNull @NlsSafe String message) {
        this.showMessage(message, ConsoleViewContentType.NORMAL_OUTPUT);
    }

    public void showErrorMessage(@NotNull @NlsSafe String line) {
        this.showMessage(line, ConsoleViewContentType.ERROR_OUTPUT);
    }

    public void showCommandLine(@NotNull @NlsSafe String cmdLine) {
        SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss.SSS");
        this.showMessage(f.format(new Date()) + ": " + cmdLine, ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    public void showMessage(@NotNull @NlsSafe String message, @NotNull ConsoleViewContentType contentType) {
        String shortMessage = StringUtil.shortenPathWithEllipsis((String)message, (int)10000);
        this.showMessage(VcsConsoleLine.create((String)shortMessage, (ConsoleViewContentType)contentType));
    }

    public void showMessage(@NotNull List<Pair<String, Key>> lineChunks) {
        int totalLength = 0;
        for (Pair<String, Key> chunk : lineChunks) {
            totalLength += ((String)chunk.first).length();
        }
        int prefixEnd = 3000;
        int suffixStart = totalLength - 7000;
        boolean useEllipsis = (double)totalLength > 12000.0;
        int index = 0;
        ArrayList<Pair> messages = new ArrayList<Pair>();
        for (Pair<String, Key> chunk : lineChunks) {
            String message = (String)chunk.first;
            if (message.isEmpty()) continue;
            ConsoleViewContentType type = ConsoleViewContentType.getConsoleViewType((Key)((Key)chunk.second));
            if (useEllipsis) {
                TextRange range = new TextRange(index, index + message.length());
                TextRange range1 = range.intersection(new TextRange(0, prefixEnd));
                TextRange range2 = range.intersection(new TextRange(suffixStart, totalLength));
                if (range1 != null && !range1.isEmpty()) {
                    Object message1 = range1.shiftLeft(index).substring(message);
                    if (!range1.equals((Object)range)) {
                        message1 = (String)message1 + "...";
                    }
                    messages.add(Pair.create((Object)message1, (Object)type));
                }
                if (range2 != null && !range2.isEmpty()) {
                    String message2 = range2.shiftLeft(index).substring(message);
                    messages.add(Pair.create((Object)message2, (Object)type));
                }
            } else {
                messages.add(Pair.create((Object)message, (Object)type));
            }
            index += message.length();
        }
        this.showMessage(VcsConsoleLine.create(messages));
    }

    private void showMessage(@Nullable VcsConsoleLine line) {
        if (this.myProject.isDisposed()) {
            return;
        }
        ProjectLevelVcsManager.getInstance((Project)this.myProject).addMessageToConsoleWindow(line);
    }
}

