/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.DialogManager;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.util.GitSimplePathsBrowser;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitUntrackedFilesHelper {
    private static final Logger LOG = Logger.getInstance(GitUntrackedFilesHelper.class);

    private GitUntrackedFilesHelper() {
    }

    public static void notifyUntrackedFilesOverwrittenBy(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths, @NotNull @Nls String operation, @Nullable @NlsContexts.DetailedDescription String description2) {
        GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(project, root, relativePaths, operation, description2, null, new NotificationAction[0]);
    }

    public static void notifyUntrackedFilesOverwrittenBy(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths, @NotNull @Nls String operation, @Nullable @NlsContexts.DetailedDescription String description2, @Nullable NotificationListener listener2, NotificationAction ... actions2) {
        Notification notification2 = GitUntrackedFilesHelper.getUntrackedFilesOverwrittenByNotification(project, root, relativePaths, operation, description2, listener2);
        for (NotificationAction action : actions2) {
            notification2.addAction((AnAction)action);
        }
        VcsNotifier.getInstance((Project)project).notify(notification2);
    }

    public static boolean showUntrackedFilesDialogWithRollback(@NotNull Project project, @NotNull @Nls String operationName, @NotNull @NlsContexts.Label String rollbackProposal, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativePaths);
        List untrackedFiles = ContainerUtil.mapNotNull(absolutePaths, absolutePath -> GitUtil.findRefreshFileOrLog(absolutePath));
        Ref rollback = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            JComponent filesBrowser;
            if (untrackedFiles.isEmpty()) {
                LOG.debug("Couldn't find the untracked files, displaying simplified dialog.");
                filesBrowser = new GitSimplePathsBrowser(project, absolutePaths);
            } else {
                long validFiles = untrackedFiles.stream().filter(VirtualFile::isValid).count();
                LOG.debug(String.format("Untracked files: [%s]. Valid: %d (of %d)", untrackedFiles, validFiles, untrackedFiles.size()));
                filesBrowser = ScrollPaneFactory.createScrollPane((Component)new SelectFilesDialog.VirtualFileList(project, false, true, untrackedFiles));
            }
            String title = GitBundle.message("dialog.title.could.not.operation", StringUtil.capitalize((String)operationName));
            String description2 = GitBundle.message("dialog.message.untracked.files.will.be.overwritten.by.operation", operationName);
            UntrackedFilesRollBackDialog dialog2 = new UntrackedFilesRollBackDialog(project, filesBrowser, description2, rollbackProposal);
            dialog2.setTitle(title);
            DialogManager.show(dialog2);
            rollback.set((Object)dialog2.isOK());
        });
        return (Boolean)rollback.get();
    }

    @NotNull
    private static Notification getUntrackedFilesOverwrittenByNotification(final @NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths, final @NotNull @Nls String operation, @Nullable @NlsContexts.DetailedDescription String description2, @Nullable NotificationListener listener2) {
        if (description2 == null) {
            description2 = "";
        }
        String notificationTitle = GitBundle.message("notification.title.untracked.files.prevent.operation", StringUtil.capitalize((String)operation));
        String notificationDesc = GitBundle.message("notification.content.untracked.files.prevent.operation.move.or.commit", operation, description2);
        final Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativePaths);
        final List untrackedFiles = ContainerUtil.mapNotNull(absolutePaths, absolutePath -> GitUtil.findRefreshFileOrLog(absolutePath));
        Notification notification2 = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(notificationTitle, notificationDesc, NotificationType.ERROR).setDisplayId("untracked.files.overwritten");
        if (listener2 != null) {
            notification2.setListener(listener2);
        }
        notification2.addAction((AnAction)new NotificationAction(VcsBundle.messagePointer((String)"action.NotificationAction.VFSListener.text.view.files", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                String dialogDesc = GitBundle.message("dialog.message.untracked.files.will.be.overwritten.by.operation", operation);
                String title = GitBundle.message("dialog.title.untracked.files.preventing.operation", StringUtil.capitalize((String)operation));
                if (untrackedFiles.isEmpty()) {
                    GitUtil.showPathsInDialog(project, absolutePaths, title, dialogDesc);
                } else {
                    UntrackedFilesDialog dialog2 = new UntrackedFilesDialog(project, untrackedFiles, dialogDesc);
                    dialog2.setTitle(title);
                    dialog2.show();
                }
            }
        });
        return notification2;
    }

    private static class UntrackedFilesRollBackDialog
    extends DialogWrapper {
        @NotNull
        private final JComponent myFilesBrowser;
        @NotNull
        private final @NlsContexts.Label String myPrompt;
        @NotNull
        private final @NlsContexts.Label String myRollbackProposal;

        UntrackedFilesRollBackDialog(@NotNull Project project, @NotNull JComponent filesBrowser, @NotNull @NlsContexts.Label String prompt, @NotNull @NlsContexts.Label String rollbackProposal) {
            super(project);
            this.myFilesBrowser = filesBrowser;
            this.myPrompt = prompt;
            this.myRollbackProposal = rollbackProposal;
            this.setOKButtonText(GitBundle.message("button.rollback", new Object[0]));
            this.setCancelButtonText(GitBundle.message("button.don.t.rollback", new Object[0]));
            this.init();
        }

        protected JComponent createSouthPanel() {
            JComponent buttons = super.createSouthPanel();
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            panel2.add((Component)new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)this.myRollbackProposal)));
            if (buttons != null) {
                panel2.add(buttons);
            }
            return panel2;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myFilesBrowser;
        }

        @Nullable
        protected JComponent createNorthPanel() {
            JLabel label = new JLabel(this.myPrompt);
            label.setUI((LabelUI)new MultiLineLabelUI());
            label.setBorder(new EmptyBorder(5, 1, 5, 1));
            return label;
        }
    }

    private static class UntrackedFilesDialog
    extends SelectFilesDialog {
        UntrackedFilesDialog(Project project, @NotNull Collection<? extends VirtualFile> untrackedFiles, @NotNull @NlsContexts.Label String dialogDesc) {
            super(project, new ArrayList<VirtualFile>(untrackedFiles), StringUtil.stripHtml((String)dialogDesc, (boolean)true), null, false, true);
            this.init();
        }

        protected Action @NotNull [] createActions() {
            return new Action[]{this.getOKAction()};
        }
    }
}

