/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.commands.Git;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFreezingProcess;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPreservingProcess {
    private static final Logger LOG = Logger.getInstance(GitPreservingProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final Collection<? extends VirtualFile> myRootsToSave;
    @NotNull
    @Nls
    private final String myOperationTitle;
    @NotNull
    @Nls
    private final String myDestinationName;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @NotNull
    private final Runnable myOperation;
    @NotNull
    @Nls
    private final String myStashMessage;
    @NotNull
    private final GitChangesSaver mySaver;
    @NotNull
    private final AtomicBoolean myLoaded = new AtomicBoolean();

    public GitPreservingProcess(@NotNull Project project, @NotNull Git git, @NotNull Collection<? extends VirtualFile> rootsToSave, @Nls @NotNull String operationTitle, @Nls @NotNull String destinationName, @NotNull GitSaveChangesPolicy saveMethod, @NotNull ProgressIndicator indicator, @NotNull Runnable operation) {
        this.myProject = project;
        this.myGit = git;
        this.myRootsToSave = rootsToSave;
        this.myOperationTitle = operationTitle;
        this.myDestinationName = destinationName;
        this.myProgressIndicator = indicator;
        this.myOperation = operation;
        this.myStashMessage = VcsBundle.message((String)"stash.changes.message.with.date", (Object[])new Object[]{StringUtil.capitalize((String)this.myOperationTitle), DateFormatUtil.formatDateTime((long)Clock.getTime())});
        this.mySaver = this.configureSaver(saveMethod);
    }

    public void execute() {
        this.execute(null);
    }

    public void execute(@Nullable Computable<Boolean> autoLoadDecision) {
        Runnable operation = () -> {
            boolean savedSuccessfully = (Boolean)ProgressManager.getInstance().computeInNonCancelableSection(() -> this.save());
            LOG.debug("save result: " + savedSuccessfully);
            if (savedSuccessfully) {
                try {
                    LOG.debug("running operation");
                    this.myOperation.run();
                    LOG.debug("operation completed.");
                }
                finally {
                    if (autoLoadDecision == null || ((Boolean)autoLoadDecision.compute()).booleanValue()) {
                        LOG.debug("loading");
                        ProgressManager.getInstance().executeNonCancelableSection(() -> this.load());
                    } else {
                        this.mySaver.notifyLocalChangesAreNotRestored();
                    }
                }
            }
            LOG.debug("finished.");
        };
        new GitFreezingProcess(this.myProject, this.myOperationTitle, operation).execute();
    }

    @NotNull
    private GitChangesSaver configureSaver(final @NotNull GitSaveChangesPolicy saveMethod) {
        GitChangesSaver saver = GitChangesSaver.getSaver(this.myProject, this.myGit, this.myProgressIndicator, this.myStashMessage, saveMethod);
        MergeDialogCustomizer mergeDialogCustomizer = new MergeDialogCustomizer(){

            @NotNull
            public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
                return XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("restore.conflict.dialog.description.label.text", GitPreservingProcess.this.myOperationTitle, XmlStringUtil.wrapInHtmlTag((String)GitPreservingProcess.this.myDestinationName, (String)"code")));
            }

            @NotNull
            public String getLeftPanelTitle(@NotNull VirtualFile file2) {
                return saveMethod.selectBundleMessage(GitBundle.message("restore.conflict.diff.dialog.left.stash.title", new Object[0]), GitBundle.message("restore.conflict.diff.dialog.left.shelf.title", new Object[0]));
            }

            @NotNull
            public String getRightPanelTitle(@NotNull VirtualFile file2, VcsRevisionNumber revisionNumber) {
                return XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("restore.conflict.diff.dialog.right.title", XmlStringUtil.wrapInHtmlTag((String)GitPreservingProcess.this.myDestinationName, (String)"b")));
            }
        };
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject).setReverse(true).setMergeDialogCustomizer(mergeDialogCustomizer).setErrorNotificationTitle(GitBundle.message("preserving.process.local.changes.not.restored.error.title", new Object[0]));
        saver.setConflictResolverParams(params);
        return saver;
    }

    private boolean save() {
        try {
            this.mySaver.saveLocalChanges(this.myRootsToSave);
            return true;
        }
        catch (VcsException e) {
            LOG.info("Couldn't save local changes", (Throwable)e);
            VcsNotifier.getInstance((Project)this.myProject).notifyError("git.could.not.save.uncommitted.changes", GitBundle.message("save.notification.failed.title", new Object[0]), this.mySaver.getSaveMethod().selectBundleMessage(GitBundle.message("save.notification.failed.stash.text", this.myOperationTitle, StringUtil.join((String[])e.getMessages())), GitBundle.message("save.notification.failed.shelf.text", this.myOperationTitle, StringUtil.join((String[])e.getMessages()))));
            return false;
        }
    }

    public void load() {
        if (this.myLoaded.compareAndSet(false, true)) {
            this.mySaver.load();
        } else {
            LOG.info("The changes were already loaded");
        }
    }
}

