/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.index.GitIndexUtil;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.repo.GitRepository;
import git4idea.util.GitTextConvMode;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitFileUtils {
    private static final Logger LOG = Logger.getInstance(GitFileUtils.class);
    public static final String READ_CONTENT_WITH = "git.read.content.with";

    private GitFileUtils() {
    }

    public static void deletePaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, String ... additionalOptions) throws VcsException {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitFileUtils.doDelete(project, root, paths, additionalOptions);
        }
    }

    public static void deleteFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files, String ... additionalOptions) throws VcsException {
        for (List paths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
            GitFileUtils.doDelete(project, root, paths, additionalOptions);
        }
    }

    public static void deleteFiles(@NotNull Project project, @NotNull VirtualFile root, VirtualFile ... files) throws VcsException {
        GitFileUtils.deleteFiles(project, root, Arrays.asList(files), new String[0]);
    }

    private static void doDelete(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths, String ... additionalOptions) throws VcsException {
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RM);
        handler.addParameters(additionalOptions);
        handler.endOptions();
        handler.addParameters(paths);
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
    }

    public static void deleteFilesFromCache(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files) throws VcsException {
        List paths = ContainerUtil.map(files, VcsUtil::getFilePath);
        GitFileUtils.deletePaths(project, root, paths, "--cached");
        GitFileUtils.updateUntrackedFilesHolderOnFileRemove(project, root, paths);
    }

    public static void addFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files) throws VcsException {
        List paths = ContainerUtil.mapNotNull(files, VcsUtil::getFilePath);
        GitFileUtils.addPaths(project, root, paths);
    }

    public static void addFilesForce(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files) throws VcsException {
        List paths = ContainerUtil.mapNotNull(files, VcsUtil::getFilePath);
        GitFileUtils.addPathsForce(project, root, paths);
    }

    private static void updateUntrackedFilesHolderOnFileAdd(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> addedFiles) {
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.warn("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getUntrackedFilesHolder().remove(addedFiles);
    }

    private static void updateIgnoredFilesHolderOnFileAdd(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> addedFiles) {
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.warn("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getIgnoredFilesHolder().removeIgnoredFiles(addedFiles);
    }

    private static void updateUntrackedFilesHolderOnFileRemove(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> removedFiles) {
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.warn("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getUntrackedFilesHolder().add(removedFiles);
    }

    private static void updateUntrackedFilesHolderOnFileReset(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> resetFiles) {
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.warn("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getUntrackedFilesHolder().markPossiblyUntracked(resetFiles);
    }

    public static void addFiles(@NotNull Project project, @NotNull VirtualFile root, VirtualFile ... files) throws VcsException {
        GitFileUtils.addFiles(project, root, Arrays.asList(files));
    }

    public static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> paths) throws VcsException {
        GitFileUtils.addPaths(project, root, paths, false);
    }

    public static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, boolean force) throws VcsException {
        GitFileUtils.addPaths(project, root, files, force, !force);
    }

    public static void addPathsToIndex(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files) throws VcsException {
        for (FilePath filePath : files) {
            GitIndexUtil.write(project, root, filePath, new ByteArrayInputStream(ArrayUtil.EMPTY_BYTE_ARRAY), false, true);
        }
        GitFileUtils.updateAndRefresh(project, root, files, false);
    }

    public static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, boolean force, boolean filterOutIgnored) throws VcsException {
        GitFileUtils.addPaths(project, root, files, force, filterOutIgnored, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, boolean force, boolean filterOutIgnored, String ... additionalOptions) throws VcsException {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitFileUtils.addPathsImpl(project, root, paths, force, filterOutIgnored, additionalOptions);
        }
        GitFileUtils.updateAndRefresh(project, root, files, force);
    }

    private static void updateAndRefresh(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, boolean updateIgnoredHolders) {
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, files);
        if (updateIgnoredHolders) {
            GitFileUtils.updateIgnoredFilesHolderOnFileAdd(project, root, files);
        }
        GitIndexFileSystemRefresher.refreshFilePaths(project, files);
    }

    public static void addPathsForce(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files) throws VcsException {
        GitFileUtils.addPaths(project, root, files, true, false);
    }

    private static void addPathsImpl(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths, boolean force, boolean filterOutIgnored, String ... additionalOptions) throws VcsException {
        if (filterOutIgnored && (paths = GitFileUtils.excludeIgnoredFiles(project, root, paths)).isEmpty()) {
            return;
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.ADD);
        handler.addParameters("--ignore-errors", "-A");
        if (force) {
            handler.addParameters("-f");
        }
        handler.addParameters(additionalOptions);
        handler.endOptions();
        handler.addParameters(paths);
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
    }

    @NotNull
    private static List<String> excludeIgnoredFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths) throws VcsException {
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.LS_FILES);
        handler.setSilent(true);
        handler.addParameters("--ignored", "--others", "--exclude-standard");
        handler.endOptions();
        handler.addParameters(paths);
        String output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        ArrayList<String> nonIgnoredFiles = new ArrayList<String>(paths.size());
        HashSet<String> ignoredPaths = new HashSet<String>(Arrays.asList(StringUtil.splitByLines((String)output)));
        for (String pathToCheck : paths) {
            if (ignoredPaths.contains(pathToCheck)) continue;
            nonIgnoredFiles.add(pathToCheck);
        }
        return nonIgnoredFiles;
    }

    public static void resetPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files) throws VcsException {
        for (List filesChunk : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESET);
            handler.endOptions();
            handler.addParameters(filesChunk);
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
        GitFileUtils.updateUntrackedFilesHolderOnFileReset(project, root, files);
        GitIndexFileSystemRefresher.refreshFilePaths(project, files);
    }

    public static void revertUnstagedPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.CHECKOUT);
            handler.endOptions();
            handler.addParameters(paths);
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
    }

    public static byte @NotNull [] getFileContent(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NonNls String revisionOrBranch, @NotNull @NonNls String relativePath) throws VcsException {
        GitBinaryHandler h = new GitBinaryHandler(project, root, GitCommand.CAT_FILE);
        h.setSilent(true);
        GitFileUtils.addTextConvParameters(project, h, true);
        h.addParameters(revisionOrBranch + ":" + relativePath);
        return h.run();
    }

    public static void addTextConvParameters(@NotNull Project project, @NotNull GitBinaryHandler h, boolean addp) {
        GitFileUtils.addTextConvParameters(GitExecutableManager.getInstance().tryGetVersion(project), h, addp);
    }

    public static void addTextConvParameters(@Nullable GitVersion version, @NotNull GitBinaryHandler h, boolean addp) {
        version = (GitVersion)ObjectUtils.chooseNotNull((Object)version, (Object)GitVersion.NULL);
        GitTextConvMode mode = (GitTextConvMode)AdvancedSettings.getEnum((String)READ_CONTENT_WITH, GitTextConvMode.class);
        if (mode == GitTextConvMode.FILTERS && GitVersionSpecialty.CAT_FILE_SUPPORTS_FILTERS.existsIn(version)) {
            h.addParameters("--filters");
            return;
        }
        if (mode == GitTextConvMode.TEXTCONV && GitVersionSpecialty.CAT_FILE_SUPPORTS_TEXTCONV.existsIn(version)) {
            h.addParameters("--textconv");
            return;
        }
        if (addp) {
            h.addParameters("-p");
        }
    }
}

