/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBranchPair;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdatedRangesKt;
import git4idea.update.HashRange;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0005J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u0005H\u0002J\"\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgit4idea/update/GitUpdatedRanges;", "", "project", "Lcom/intellij/openapi/project/Project;", "sourceAndTargetBranches", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/branch/GitBranchPair;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;)V", "initialPositions", "Lcom/intellij/vcs/log/Hash;", "calcCurrentPositions", "Lgit4idea/update/HashRange;", "calcPublishedTipPositions", "getMergeBase", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "firstRef", "", "secondRef", "Companion", "intellij.vcs.git"})
public final class GitUpdatedRanges {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<GitRepository, GitBranchPair> sourceAndTargetBranches;
    @NotNull
    private final Map<GitRepository, Hash> initialPositions;

    private GitUpdatedRanges(Project project, Map<GitRepository, GitBranchPair> sourceAndTargetBranches) {
        this.project = project;
        this.sourceAndTargetBranches = sourceAndTargetBranches;
        this.initialPositions = this.calcPublishedTipPositions();
    }

    @NotNull
    public final Map<GitRepository, HashRange> calcCurrentPositions() {
        Map<GitRepository, Hash> newPositions = this.calcPublishedTipPositions();
        LinkedHashMap result2 = new LinkedHashMap();
        for (Map.Entry<GitRepository, Hash> entry : newPositions.entrySet()) {
            GitRepository repository = entry.getKey();
            Hash newHash = entry.getValue();
            Hash before = this.initialPositions.get(repository);
            if (before == null) continue;
            ((Map)result2).put(repository, new HashRange(before, newHash));
        }
        return result2;
    }

    private final Map<GitRepository, Hash> calcPublishedTipPositions() {
        LinkedHashMap result2 = new LinkedHashMap();
        for (Map.Entry<GitRepository, GitBranchPair> entry : this.sourceAndTargetBranches.entrySet()) {
            GitRepository repository = entry.getKey();
            GitBranchPair branchPair = entry.getValue();
            GitLocalBranch localBranch = branchPair.component1();
            GitBranch trackedBranch = branchPair.component2();
            VirtualFile virtualFile = repository.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repository.root");
            String string = localBranch.getFullName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"localBranch.fullName");
            String string2 = trackedBranch.getFullName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trackedBranch.fullName");
            Hash mergeBase = this.getMergeBase(virtualFile, string, string2);
            if (mergeBase == null) continue;
            ((Map)result2).put(repository, mergeBase);
        }
        return result2;
    }

    private final Hash getMergeBase(VirtualFile root, String firstRef, String secondRef) {
        GitLineHandler h = new GitLineHandler(this.project, root, GitCommand.MERGE_BASE);
        String[] stringArray = new String[]{firstRef, secondRef};
        h.addParameters(stringArray);
        try {
            String string = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().runCommand(h).getOutputOrThrow()");
            String output = ((Object)StringsKt.trim((CharSequence)string)).toString();
            return HashImpl.build((String)output);
        }
        catch (Throwable t) {
            GitUpdatedRangesKt.access$getLOG$p().warn("Couldn't find merge-base between " + firstRef + " and " + secondRef);
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final GitUpdatedRanges calcInitialPositions(@NotNull Project project, @NotNull Map<GitRepository, GitBranchPair> trackedBranches) {
        return Companion.calcInitialPositions(project, trackedBranches);
    }

    public /* synthetic */ GitUpdatedRanges(Project project, Map sourceAndTargetBranches, DefaultConstructorMarker $constructor_marker) {
        this(project, sourceAndTargetBranches);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0007\u00a8\u0006\u000b"}, d2={"Lgit4idea/update/GitUpdatedRanges$Companion;", "", "()V", "calcInitialPositions", "Lgit4idea/update/GitUpdatedRanges;", "project", "Lcom/intellij/openapi/project/Project;", "trackedBranches", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/branch/GitBranchPair;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GitUpdatedRanges calcInitialPositions(@NotNull Project project, @NotNull Map<GitRepository, GitBranchPair> trackedBranches) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(trackedBranches, (String)"trackedBranches");
            return new GitUpdatedRanges(project, trackedBranches, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

