/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.toolbar;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.toolbar.GitToolbarWidget;
import git4idea.ui.toolbar.GitToolbarWidgetActionKt;
import git4idea.ui.toolbar.MyRepoChanges;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0015\u0010\u0012\u001a\u00020\u00112\u000b\u0010\u0013\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0014H\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\u0018\u001a\u00020\u0019*\u0004\u0018\u00010\u001aH\u0002J\f\u0010\u001b\u001a\u00020\u0011*\u00020\u001aH\u0003J\f\u0010\u001c\u001a\u00020\u0011*\u00020\u001aH\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgit4idea/ui/toolbar/GitToolbarWidgetAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "()V", "MAX_TEXT_LENGTH", "", "SHORTENED_BEGIN_PART", "SHORTENED_END_PART", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "cutText", "value", "Lcom/intellij/openapi/util/NlsSafe;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "calcIcon", "Ljavax/swing/Icon;", "Lgit4idea/repo/GitRepository;", "calcText", "calcTooltip", "intellij.vcs.git"})
public final class GitToolbarWidgetAction
extends AnAction
implements CustomComponentAction {
    private final int MAX_TEXT_LENGTH;
    private final int SHORTENED_BEGIN_PART;
    private final int SHORTENED_END_PART;

    public GitToolbarWidgetAction() {
        this.MAX_TEXT_LENGTH = 24;
        this.SHORTENED_BEGIN_PART = 16;
        this.SHORTENED_END_PART = 8;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return (JComponent)((Object)new GitToolbarWidget(presentation));
    }

    public void update(@NotNull AnActionEvent e) {
        MyRepoChanges myRepoChanges;
        GitRepository gitRepository;
        Project project;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = project = e.getProject();
        if (project2 != null) {
            Project it = project2;
            boolean bl = false;
            gitRepository = GitBranchUtil.guessWidgetRepository(project, e.getDataContext());
        } else {
            gitRepository = null;
        }
        GitRepository repository = gitRepository;
        e.getPresentation().putClientProperty(GitToolbarWidgetActionKt.access$getProjectKey$p(), (Object)project);
        e.getPresentation().putClientProperty(GitToolbarWidgetActionKt.access$getRepositoryKey$p(), (Object)repository);
        Presentation presentation = e.getPresentation();
        Object object = repository;
        if (object == null || (object = this.calcText((GitRepository)object)) == null) {
            object = GitBundle.message("git.toolbar.widget.no.repo", new Object[0]);
        }
        presentation.setText((String)object);
        e.getPresentation().setIcon(this.calcIcon(repository));
        Presentation presentation2 = e.getPresentation();
        Object object2 = repository;
        if (object2 == null || (object2 = this.calcTooltip((GitRepository)object2)) == null) {
            object2 = GitBundle.message("git.toolbar.widget.no.repo.tooltip", new Object[0]);
        }
        presentation2.setDescription((String)object2);
        Object object3 = repository;
        if (object3 != null && (object3 = object3.getCurrentBranchName()) != null) {
            Object branch = object3;
            boolean bl = false;
            GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)gitBranchIncomingOutgoingManager, (String)"getInstance(project)");
            GitBranchIncomingOutgoingManager incomingOutgoingManager = gitBranchIncomingOutgoingManager;
            myRepoChanges = new MyRepoChanges(incomingOutgoingManager.hasIncomingFor(repository, (String)branch), incomingOutgoingManager.hasOutgoingFor(repository, (String)branch));
        } else {
            myRepoChanges = new MyRepoChanges(false, false);
        }
        MyRepoChanges changes = myRepoChanges;
        e.getPresentation().putClientProperty(GitToolbarWidgetActionKt.access$getChangesKey$p(), (Object)changes);
    }

    @NlsSafe
    private final String calcText(GitRepository $this$calcText) {
        String string = StringUtil.escapeMnemonics((String)GitBranchUtil.getDisplayableBranchText($this$calcText, this::cutText));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeMnemonics(GitBranc\u2026nchText(this, ::cutText))");
        return string;
    }

    private final Icon calcIcon(GitRepository $this$calcIcon) {
        if ($this$calcIcon == null) {
            Icon icon = AllIcons.Vcs.Branch;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Branch");
            return icon;
        }
        if ($this$calcIcon.getState() != Repository.State.NORMAL) {
            Icon icon = AllIcons.General.Warning;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
            return icon;
        }
        Icon icon = AllIcons.Vcs.Branch;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Branch");
        return icon;
    }

    @NlsContexts.Tooltip
    private final String calcTooltip(GitRepository $this$calcTooltip) {
        if ($this$calcTooltip.getState() == Repository.State.DETACHED) {
            String string = GitBundle.message("git.status.bar.widget.tooltip.detached", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"git.status.bar.widget.tooltip.detached\")");
            return string;
        }
        Object[] objectArray = new Object[]{GitVcs.DISPLAY_NAME.get(), GitBranchUtil.getBranchNameOrRev($this$calcTooltip)};
        String string = DvcsBundle.message((String)"tooltip.branch.widget.vcs.branch.name.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"tooltip.branch.\u2026getBranchNameOrRev(this))");
        Object message = string;
        if (!GitUtil.justOneGitRepository($this$calcTooltip.getProject())) {
            message = (String)message + "\n";
            Object[] objectArray2 = new Object[]{$this$calcTooltip.getRoot().getName()};
            message = (String)message + DvcsBundle.message((String)"tooltip.branch.widget.root.name.text", (Object[])objectArray2);
        }
        return message;
    }

    @NlsSafe
    private final String cutText(String value) {
        if (value.length() <= this.MAX_TEXT_LENGTH) {
            return value;
        }
        IntRange beginRange = new IntRange(0, this.SHORTENED_BEGIN_PART - 1);
        IntRange endRange = new IntRange(value.length() - this.SHORTENED_END_PART, value.length() - 1);
        return StringsKt.substring((String)value, (IntRange)beginRange) + "..." + StringsKt.substring((String)value, (IntRange)endRange);
    }
}

