/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.ide.ui.UISettings;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00042\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\bH\u0002J\u000e\u0010\r\u001a\u0004\u0018\u00010\b*\u00020\tH\u0002J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\b*\u00020\tH\u0002J \u0010\u000f\u001a\u0004\u0018\u00010\b*\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u001e\u0010\u0011\u001a\u0004\u0018\u00010\b*\u00020\t2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J&\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00040\u0018J\n\u0010\u001a\u001a\u00020\u0004*\u00020\u0014J\n\u0010\u001b\u001a\u00020\u0004*\u00020\u0014J\n\u0010\u001c\u001a\u00020\u0004*\u00020\u0014J\n\u0010\u001d\u001a\u00020\u0004*\u00020\u0014R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lgit4idea/ui/branch/GitBranchesTreeUtil;", "", "()V", "cycleScrolling", "", "getCycleScrolling", "()Z", "findChildLeaf", "Ljavax/swing/tree/TreePath;", "Ljavax/swing/tree/TreeModel;", "parentPath", "forward", "startChild", "findFirstLeaf", "findLastLeaf", "findNextLeaf", "start", "findNextSiblingLeaf", "overrideBuiltInAction", "", "Ljavax/swing/JTree;", "actionKey", "", "override", "Lkotlin/Function1;", "Ljava/awt/event/ActionEvent;", "selectFirstLeaf", "selectLastLeaf", "selectNextLeaf", "selectPrevLeaf", "intellij.vcs.git"})
public final class GitBranchesTreeUtil {
    @NotNull
    public static final GitBranchesTreeUtil INSTANCE = new GitBranchesTreeUtil();

    private GitBranchesTreeUtil() {
    }

    public final void overrideBuiltInAction(@NotNull JTree $this$overrideBuiltInAction, @NotNull String actionKey, @NotNull Function1<? super ActionEvent, Boolean> override) {
        Intrinsics.checkNotNullParameter((Object)$this$overrideBuiltInAction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actionKey, (String)"actionKey");
        Intrinsics.checkNotNullParameter(override, (String)"override");
        Action originalAction = $this$overrideBuiltInAction.getActionMap().get(actionKey);
        $this$overrideBuiltInAction.getActionMap().put(actionKey, new AbstractAction(override, originalAction){
            final /* synthetic */ Function1<ActionEvent, Boolean> $override;
            final /* synthetic */ Action $originalAction;
            {
                this.$override = $override;
                this.$originalAction = $originalAction;
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (((Boolean)this.$override.invoke((Object)e)).booleanValue()) {
                    return;
                }
                this.$originalAction.actionPerformed(e);
            }
        });
    }

    private final boolean getCycleScrolling() {
        return UISettings.Companion.getInstance().getCycleScrolling();
    }

    public final boolean selectNextLeaf(@NotNull JTree $this$selectNextLeaf) {
        Intrinsics.checkNotNullParameter((Object)$this$selectNextLeaf, (String)"<this>");
        TreeModel treeModel = $this$selectNextLeaf.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"model");
        TreePath nextLeaf = this.findNextLeaf(treeModel, $this$selectNextLeaf.getSelectionPath(), true);
        TreePath treePath = nextLeaf;
        if (treePath == null) {
            if (this.getCycleScrolling()) {
                TreeModel treeModel2 = $this$selectNextLeaf.getModel();
                Intrinsics.checkNotNullExpressionValue((Object)treeModel2, (String)"model");
                treePath = this.findFirstLeaf(treeModel2);
            } else {
                return false;
            }
        }
        TreePath toSelect = treePath;
        $this$selectNextLeaf.scrollPathToVisible(toSelect);
        $this$selectNextLeaf.setSelectionPath(toSelect);
        return true;
    }

    public final boolean selectPrevLeaf(@NotNull JTree $this$selectPrevLeaf) {
        Intrinsics.checkNotNullParameter((Object)$this$selectPrevLeaf, (String)"<this>");
        TreeModel treeModel = $this$selectPrevLeaf.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"model");
        TreePath prevLeaf = this.findNextLeaf(treeModel, $this$selectPrevLeaf.getSelectionPath(), false);
        TreePath treePath = prevLeaf;
        if (treePath == null) {
            if (this.getCycleScrolling()) {
                TreeModel treeModel2 = $this$selectPrevLeaf.getModel();
                Intrinsics.checkNotNullExpressionValue((Object)treeModel2, (String)"model");
                treePath = this.findLastLeaf(treeModel2);
            } else {
                return false;
            }
        }
        TreePath toSelect = treePath;
        $this$selectPrevLeaf.scrollPathToVisible(toSelect);
        $this$selectPrevLeaf.setSelectionPath(toSelect);
        return true;
    }

    public final boolean selectFirstLeaf(@NotNull JTree $this$selectFirstLeaf) {
        Intrinsics.checkNotNullParameter((Object)$this$selectFirstLeaf, (String)"<this>");
        TreeModel treeModel = $this$selectFirstLeaf.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"model");
        TreePath treePath = this.findFirstLeaf(treeModel);
        if (treePath == null) {
            return false;
        }
        TreePath toSelect = treePath;
        $this$selectFirstLeaf.scrollPathToVisible(toSelect);
        $this$selectFirstLeaf.setSelectionPath(toSelect);
        return true;
    }

    public final boolean selectLastLeaf(@NotNull JTree $this$selectLastLeaf) {
        Intrinsics.checkNotNullParameter((Object)$this$selectLastLeaf, (String)"<this>");
        TreeModel treeModel = $this$selectLastLeaf.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"model");
        TreePath treePath = this.findLastLeaf(treeModel);
        if (treePath == null) {
            return false;
        }
        TreePath toSelect = treePath;
        $this$selectLastLeaf.scrollPathToVisible(toSelect);
        $this$selectLastLeaf.setSelectionPath(toSelect);
        return true;
    }

    private final TreePath findNextLeaf(TreeModel $this$findNextLeaf, TreePath start, boolean forward) {
        if (start == null) {
            return null;
        }
        if (start.getParentPath() == null) {
            return null;
        }
        TreePath treePath = GitBranchesTreeUtil.findChildLeaf$default(this, $this$findNextLeaf, start, forward, null, 4, null);
        if (treePath == null) {
            treePath = this.findNextSiblingLeaf($this$findNextLeaf, start, forward);
        }
        return treePath;
    }

    private final TreePath findChildLeaf(TreeModel $this$findChildLeaf, TreePath parentPath, boolean forward, TreePath startChild) {
        int startIndex;
        Object parent = parentPath.getLastPathComponent();
        int childCount = $this$findChildLeaf.getChildCount(parent);
        if (childCount <= 0) {
            return null;
        }
        if (startChild == null) {
            v0 = forward ? 0 : childCount - 1;
        } else {
            int startChildIndex = $this$findChildLeaf.getIndexOfChild(parentPath.getLastPathComponent(), startChild.getLastPathComponent());
            v0 = startIndex = forward ? startChildIndex + 1 : startChildIndex - 1;
        }
        if (startIndex < 0 || startIndex >= childCount) {
            return null;
        }
        IntProgression indices2 = forward ? (IntProgression)RangesKt.until((int)startIndex, (int)childCount) : RangesKt.downTo((int)startIndex, (int)0);
        int i = indices2.getFirst();
        int n = indices2.getLast();
        int n2 = indices2.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                Object child;
                Intrinsics.checkNotNull((Object)$this$findChildLeaf.getChild(parent, i));
                TreePath childPath = parentPath.pathByAddingChild(child);
                if ($this$findChildLeaf.isLeaf(child)) {
                    return childPath;
                }
                Intrinsics.checkNotNullExpressionValue((Object)childPath, (String)"childPath");
                TreePath childOfChild = GitBranchesTreeUtil.findChildLeaf$default(this, $this$findChildLeaf, childPath, forward, null, 4, null);
                if (childOfChild != null) {
                    return childOfChild;
                }
                if (i == n) break;
                i += n2;
            }
        }
        return null;
    }

    static /* synthetic */ TreePath findChildLeaf$default(GitBranchesTreeUtil gitBranchesTreeUtil, TreeModel treeModel, TreePath treePath, boolean bl, TreePath treePath2, int n, Object object) {
        if ((n & 4) != 0) {
            treePath2 = null;
        }
        return gitBranchesTreeUtil.findChildLeaf(treeModel, treePath, bl, treePath2);
    }

    private final TreePath findNextSiblingLeaf(TreeModel $this$findNextSiblingLeaf, TreePath start, boolean forward) {
        TreePath parent = start.getParentPath();
        if (parent == null) {
            return null;
        }
        TreePath treePath = this.findChildLeaf($this$findNextSiblingLeaf, parent, forward, start);
        if (treePath == null) {
            TreePath treePath2 = start.getParentPath();
            Intrinsics.checkNotNullExpressionValue((Object)treePath2, (String)"start.parentPath");
            treePath = this.findNextSiblingLeaf($this$findNextSiblingLeaf, treePath2, forward);
        }
        return treePath;
    }

    private final TreePath findFirstLeaf(TreeModel $this$findFirstLeaf) {
        TreePath rootPath = new TreePath($this$findFirstLeaf.getRoot());
        return GitBranchesTreeUtil.findChildLeaf$default(this, $this$findFirstLeaf, rootPath, true, null, 4, null);
    }

    private final TreePath findLastLeaf(TreeModel $this$findLastLeaf) {
        TreePath rootPath = new TreePath($this$findLastLeaf.getRoot());
        return GitBranchesTreeUtil.findChildLeaf$default(this, $this$findLastLeaf, rootPath, false, null, 4, null);
    }
}

