/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.RowIcon;
import com.intellij.ui.popup.ActionPopupStep;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.FList;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitVcs;
import git4idea.actions.branch.GitBranchActionsUtil;
import git4idea.actions.branch.GitNewBranchAction;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchType;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.GitBranchesTreeModel;
import git4idea.ui.branch.GitBranchesTreeModelImpl;
import icons.DvcsImplIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 F2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001FB#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\tH\u0002J\n\u0010!\u001a\u0004\u0018\u00010\u0013H\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010\u001d2\b\u0010#\u001a\u0004\u0018\u00010\u00022\u0006\u0010 \u001a\u00020\tJ\u0012\u0010$\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u001d2\b\u0010#\u001a\u0004\u0018\u00010\u0002J\n\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010\u001d2\b\u0010#\u001a\u0004\u0018\u00010\u00022\u0006\u0010 \u001a\u00020\tJ\b\u0010)\u001a\u0004\u0018\u00010*J\u0017\u0010+\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b,2\b\u0010#\u001a\u0004\u0018\u00010\u0002J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020.H\u0016J\u0017\u0010/\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b,2\b\u0010#\u001a\u0004\u0018\u00010\u0002J\n\u00100\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u00101\u001a\u00020\t2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u00103\u001a\u00020\tH\u0016J\u0006\u00104\u001a\u00020\tJ\b\u00105\u001a\u00020\tH\u0016J\u0010\u00106\u001a\u00020\t2\b\u00107\u001a\u0004\u0018\u00010\u0002J\u0015\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020*H\u0000\u00a2\u0006\u0002\b:J\b\u0010;\u001a\u00020\tH\u0016J$\u0010<\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u00012\b\u00102\u001a\u0004\u0018\u00010\u00022\u0006\u0010=\u001a\u00020\tH\u0016J\u0015\u0010>\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b@J\u0010\u0010A\u001a\u00020\u001b2\b\u0010B\u001a\u0004\u0018\u00010\fJ\u001c\u0010C\u001a\u0004\u0018\u00010D*\u00020E2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006G"}, d2={"Lgit4idea/ui/branch/GitBranchesTreePopupStep;", "Lcom/intellij/openapi/ui/popup/PopupStep;", "", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "isFirstStep", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Z)V", "LOCAL_SEARCH_PREFIX", "", "REMOTE_SEARCH_PREFIX", "_treeModel", "Lgit4idea/ui/branch/GitBranchesTreeModel;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManagerImpl;", "finalRunnable", "Ljava/lang/Runnable;", "getRepositories$intellij_vcs_git", "()Ljava/util/List;", "treeModel", "Ljavax/swing/tree/TreeModel;", "getTreeModel", "()Ljavax/swing/tree/TreeModel;", "canceled", "", "getBranchIcon", "Ljavax/swing/Icon;", "branch", "Lgit4idea/GitBranch;", "isSelected", "getFinalRunnable", "getIcon", "treeNode", "getIncomingOutgoingBranchIcon", "getIncomingOutgoingIcon", "getMnemonicNavigationFilter", "", "getNodeIcon", "getPreferredSelection", "Ljavax/swing/tree/TreePath;", "getSecondaryText", "Lcom/intellij/openapi/util/NlsSafe;", "getSpeedSearchFilter", "Lcom/intellij/openapi/ui/popup/SpeedSearchFilter;", "getText", "getTitle", "hasSubstep", "selectedValue", "isAutoSelectionEnabled", "isBranchesDiverged", "isMnemonicsNavigationEnabled", "isSelectable", "node", "isSeparatorAboveRequired", "path", "isSeparatorAboveRequired$intellij_vcs_git", "isSpeedSearchEnabled", "onChosen", "finalChoice", "setPrefixGrouping", "state", "setPrefixGrouping$intellij_vcs_git", "setSearchPattern", "pattern", "getCommonTrackedBranch", "Lgit4idea/GitRemoteBranch;", "Lgit4idea/GitLocalBranch;", "Companion", "intellij.vcs.git"})
public final class GitBranchesTreePopupStep
implements PopupStep<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<GitRepository> repositories;
    private final boolean isFirstStep;
    @Nullable
    private Runnable finalRunnable;
    @NotNull
    private final GitBranchesTreeModel _treeModel;
    @NotNull
    private final String LOCAL_SEARCH_PREFIX;
    @NotNull
    private final String REMOTE_SEARCH_PREFIX;
    @NotNull
    private final VcsLogColorManagerImpl colorManager;
    @NotNull
    public static final String HEADER_SETTINGS_ACTION_GROUP = "Git.Branches.Popup.Settings";
    @NotNull
    private static final String TOP_LEVEL_ACTION_GROUP = "Git.Branches.List";
    @NotNull
    private static final String BRANCH_ACTION_GROUP = "Git.Branch";
    @NotNull
    private static final String ACTION_PLACE;

    public GitBranchesTreePopupStep(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, boolean isFirstStep) {
        ActionGroup actionGroup;
        AnAction anAction;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        this.project = project;
        this.repositories = repositories;
        this.isFirstStep = isFirstStep;
        List topLevelItems = new ArrayList();
        if (ExperimentalUI.isNewUI() && this.isFirstStep) {
            ActionGroup experimentalUIActionsGroup;
            anAction = ActionManager.getInstance().getAction("Git.Experimental.Branch.Popup.Actions");
            ActionGroup actionGroup2 = experimentalUIActionsGroup = anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
            if (experimentalUIActionsGroup != null) {
                topLevelItems.addAll(GitBranchesTreePopupStep.Companion.createActionItems(experimentalUIActionsGroup, this.project, this.repositories));
            }
        }
        ActionGroup actionGroup3 = actionGroup = (anAction = ActionManager.getInstance().getAction(TOP_LEVEL_ACTION_GROUP)) instanceof ActionGroup ? (ActionGroup)anAction : null;
        if (actionGroup != null) {
            topLevelItems.addAll(GitBranchesTreePopupStep.Companion.createActionItems(actionGroup, this.project, this.repositories));
        }
        this._treeModel = new GitBranchesTreeModelImpl(this.project, this.repositories, topLevelItems);
        this.LOCAL_SEARCH_PREFIX = "/l";
        this.REMOTE_SEARCH_PREFIX = "/r";
        this.colorManager = RepositoryChangesBrowserNode.Companion.getColorManager(this.project);
    }

    @NotNull
    public final List<GitRepository> getRepositories$intellij_vcs_git() {
        return this.repositories;
    }

    @Nullable
    public Runnable getFinalRunnable() {
        return this.finalRunnable;
    }

    @NotNull
    public final TreeModel getTreeModel() {
        return this._treeModel;
    }

    public final boolean isBranchesDiverged() {
        return this.repositories.size() > 1 && MultiRootBranches.diverged((Collection)this.repositories) && GitBranchActionsUtil.userWantsSyncControl(this.project);
    }

    @Nullable
    public final TreePath getPreferredSelection() {
        return this._treeModel.getPreferredSelection();
    }

    public final void setPrefixGrouping$intellij_vcs_git(boolean state) {
        this._treeModel.setPrefixGrouping(state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSeparatorAboveRequired$intellij_vcs_git(@NotNull TreePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (ExperimentalUI.isNewUI() && this.isFirstStep) {
            Object object = path.getLastPathComponent();
            PopupFactoryImpl.ActionItem actionItem = object instanceof PopupFactoryImpl.ActionItem ? (PopupFactoryImpl.ActionItem)object : null;
            if ((actionItem != null ? actionItem.getAction() : null) instanceof GitNewBranchAction) return true;
        }
        if (Intrinsics.areEqual((Object)path.getLastPathComponent(), (Object)CollectionsKt.firstOrNull(this.repositories))) return true;
        if (path.getLastPathComponent() != GitBranchType.LOCAL) return false;
        return true;
    }

    public final void setSearchPattern(@Nullable String pattern) {
        if (pattern == null || Intrinsics.areEqual((Object)pattern, (Object)"/")) {
            GitBranchesTreeModel.filterBranches$default(this._treeModel, null, null, 3, null);
            return;
        }
        GitBranchType branchType = null;
        String processedPattern = pattern;
        if (StringsKt.startsWith$default((String)pattern, (String)this.LOCAL_SEARCH_PREFIX, (boolean)false, (int)2, null)) {
            branchType = GitBranchType.LOCAL;
            processedPattern = ((Object)StringsKt.trimStart((CharSequence)StringsKt.removePrefix((String)pattern, (CharSequence)this.LOCAL_SEARCH_PREFIX))).toString();
        }
        if (StringsKt.startsWith$default((String)pattern, (String)this.REMOTE_SEARCH_PREFIX, (boolean)false, (int)2, null)) {
            branchType = GitBranchType.REMOTE;
            processedPattern = ((Object)StringsKt.trimStart((CharSequence)StringsKt.removePrefix((String)pattern, (CharSequence)this.REMOTE_SEARCH_PREFIX))).toString();
        }
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)("*" + processedPattern)).build();
        Intrinsics.checkNotNullExpressionValue((Object)minusculeMatcher, (String)"buildMatcher(\"*$processedPattern\").build()");
        Companion.PreferStartMatchMatcherWrapper matcher = new Companion.PreferStartMatchMatcherWrapper(minusculeMatcher);
        this._treeModel.filterBranches(branchType, matcher);
    }

    public boolean hasSubstep(@Nullable Object selectedValue) {
        Object object = selectedValue;
        if (object == null) {
            return false;
        }
        Object userValue = object;
        return userValue instanceof GitRepository || userValue instanceof GitBranch || userValue instanceof PopupFactoryImpl.ActionItem && ((PopupFactoryImpl.ActionItem)userValue).isEnabled() && ((PopupFactoryImpl.ActionItem)userValue).getAction() instanceof ActionGroup;
    }

    public final boolean isSelectable(@Nullable Object node) {
        Object object = node;
        if (object == null) {
            return false;
        }
        Object userValue = object;
        return userValue instanceof GitRepository || userValue instanceof GitBranch || userValue instanceof PopupFactoryImpl.ActionItem && ((PopupFactoryImpl.ActionItem)userValue).isEnabled();
    }

    @Nullable
    public PopupStep<? extends Object> onChosen(@Nullable Object selectedValue, boolean finalChoice) {
        if (selectedValue instanceof GitRepository) {
            return new GitBranchesTreePopupStep(this.project, CollectionsKt.listOf((Object)selectedValue), false);
        }
        if (selectedValue instanceof GitBranch) {
            AnAction anAction = ActionManager.getInstance().getAction(BRANCH_ACTION_GROUP);
            ActionGroup actionGroup = anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
            if (actionGroup == null) {
                actionGroup = (ActionGroup)new DefaultActionGroup();
            }
            ActionGroup actionGroup2 = actionGroup;
            return (PopupStep)GitBranchesTreePopupStep.Companion.createActionStep(actionGroup2, this.project, this.repositories, (GitBranch)selectedValue);
        }
        if (selectedValue instanceof PopupFactoryImpl.ActionItem) {
            if (!((PopupFactoryImpl.ActionItem)selectedValue).isEnabled()) {
                return PopupStep.FINAL_CHOICE;
            }
            AnAction anAction = ((PopupFactoryImpl.ActionItem)selectedValue).getAction();
            Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"selectedValue.action");
            AnAction action = anAction;
            if (!(!(action instanceof ActionGroup) || finalChoice && ((PopupFactoryImpl.ActionItem)selectedValue).isPerformGroup())) {
                return (PopupStep)git4idea.ui.branch.GitBranchesTreePopupStep$Companion.createActionStep$default(Companion, (ActionGroup)action, this.project, this.repositories, null, 8, null);
            }
            this.finalRunnable = () -> GitBranchesTreePopupStep.onChosen$lambda$0(action, this);
        }
        return PopupStep.FINAL_CHOICE;
    }

    @Nullable
    public String getTitle() {
        String string;
        if (!this.isFirstStep) {
            string = null;
        } else if (this.repositories.size() > 1) {
            Object[] objectArray = new Object[]{GitVcs.DISPLAY_NAME.get()};
            string = DvcsBundle.message((String)"branch.popup.vcs.name.branches", (Object[])objectArray);
        } else {
            GitRepository it = (GitRepository)CollectionsKt.single(this.repositories);
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getVcs().getDisplayName(), DvcsUtil.getShortRepositoryName((Repository)it)};
            string = DvcsBundle.message((String)"branch.popup.vcs.name.branches.in.repo", (Object[])objectArray);
        }
        return string;
    }

    @Nullable
    public final Icon getIncomingOutgoingIcon(@Nullable Object treeNode) {
        Object object = treeNode;
        if (object == null) {
            return null;
        }
        Object value = object;
        return value instanceof GitBranch ? this.getIncomingOutgoingBranchIcon((GitBranch)value) : null;
    }

    private final Icon getIncomingOutgoingBranchIcon(GitBranch branch) {
        Icon icon;
        boolean bl;
        boolean hasIncoming;
        block10: {
            boolean bl2;
            GitBranchIncomingOutgoingManager incomingOutgoingManager;
            String branchName;
            block9: {
                String string = branch.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"branch.name");
                branchName = string;
                ComponentManager $this$service$iv = (ComponentManager)this.project;
                boolean $i$f$service = false;
                Class<GitBranchIncomingOutgoingManager> serviceClass$iv = GitBranchIncomingOutgoingManager.class;
                Iterator iterator = $this$service$iv.getService(serviceClass$iv);
                if (iterator == null) {
                    throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                }
                incomingOutgoingManager = (GitBranchIncomingOutgoingManager)((Object)iterator);
                Iterable $this$any$iv = this.repositories;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl3 = false;
                        if (!incomingOutgoingManager.hasIncomingFor(it, branchName)) continue;
                        bl2 = true;
                        break block9;
                    }
                    bl2 = false;
                }
            }
            hasIncoming = bl2;
            Iterable $this$any$iv = this.repositories;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitRepository it = (GitRepository)element$iv;
                    boolean bl4 = false;
                    if (!incomingOutgoingManager.hasOutgoingFor(it, branchName)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        boolean hasOutgoing = bl;
        if (hasIncoming && hasOutgoing) {
            Icon[] iconArray = new Icon[]{DvcsImplIcons.Incoming, DvcsImplIcons.Outgoing};
            icon = (Icon)new RowIcon(iconArray);
        } else {
            icon = hasIncoming ? DvcsImplIcons.Incoming : (hasOutgoing ? DvcsImplIcons.Outgoing : null);
        }
        return icon;
    }

    @Nullable
    public final Icon getNodeIcon(@Nullable Object treeNode, boolean isSelected) {
        Object object = treeNode;
        if (object == null) {
            return null;
        }
        Object value = object;
        Object object2 = value;
        return object2 instanceof PopupFactoryImpl.ActionItem ? ((PopupFactoryImpl.ActionItem)value).getIcon(isSelected) : (object2 instanceof GitRepository ? (Icon)RepositoryChangesBrowserNode.Companion.getRepositoryIcon((Repository)value, (VcsLogColorManager)this.colorManager) : null);
    }

    @Nullable
    public final Icon getIcon(@Nullable Object treeNode, boolean isSelected) {
        Object object = treeNode;
        if (object == null) {
            return null;
        }
        Object value = object;
        Object object2 = value;
        return object2 instanceof GitBranchesTreeModel.BranchesPrefixGroup ? PlatformIcons.FOLDER_ICON : (object2 instanceof GitBranch ? this.getBranchIcon((GitBranch)value, isSelected) : null);
    }

    private final Icon getBranchIcon(GitBranch branch, boolean isSelected) {
        Icon icon;
        boolean bl;
        boolean isCurrent;
        block18: {
            boolean bl2;
            block17: {
                Iterable $this$all$iv = this.repositories;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl3 = false;
                        if (Intrinsics.areEqual((Object)it.getCurrentBranch(), (Object)branch)) continue;
                        bl2 = false;
                        break block17;
                    }
                    bl2 = true;
                }
            }
            isCurrent = bl2;
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
            Iterator iterator = $this$service$iv.getService(serviceClass$iv);
            if (iterator == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            GitBranchManager branchManager = (GitBranchManager)((Object)iterator);
            Iterable $this$all$iv = this.repositories;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    GitRepository it = (GitRepository)element$iv;
                    boolean bl4 = false;
                    if (branchManager.isFavorite(GitBranchType.Companion.of(branch), it, branch.getName())) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
        }
        boolean isFavorite = bl;
        if (isSelected && isFavorite) {
            Icon icon2 = AllIcons.Nodes.Favorite;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Favorite");
        } else if (isSelected) {
            Icon icon3 = AllIcons.Nodes.NotFavoriteOnHover;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"NotFavoriteOnHover");
        } else if (isCurrent && isFavorite) {
            Icon icon4 = DvcsImplIcons.CurrentBranchFavoriteLabel;
            icon = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"CurrentBranchFavoriteLabel");
        } else if (isCurrent) {
            Icon icon5 = DvcsImplIcons.CurrentBranchLabel;
            icon = icon5;
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"CurrentBranchLabel");
        } else if (isFavorite) {
            Icon icon6 = AllIcons.Nodes.Favorite;
            icon = icon6;
            Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"Favorite");
        } else {
            Icon icon7 = AllIcons.Vcs.BranchNode;
            icon = icon7;
            Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"BranchNode");
        }
        return icon;
    }

    @Nullable
    public final String getText(@Nullable Object treeNode) {
        String string;
        Object object = treeNode;
        if (object == null) {
            return null;
        }
        Object value = object;
        Object object2 = value;
        if (object2 == GitBranchType.LOCAL) {
            string = this.repositories.size() > 1 ? GitBundle.message("common.local.branches", new Object[0]) : GitBundle.message("group.Git.Local.Branch.title", new Object[0]);
        } else if (object2 == GitBranchType.REMOTE) {
            string = this.repositories.size() > 1 ? GitBundle.message("common.remote.branches", new Object[0]) : GitBundle.message("group.Git.Remote.Branch.title", new Object[0]);
        } else if (object2 instanceof GitBranchesTreeModel.BranchesPrefixGroup) {
            string = (String)CollectionsKt.last(((GitBranchesTreeModel.BranchesPrefixGroup)value).getPrefix());
        } else if (object2 instanceof GitRepository) {
            string = DvcsUtil.getShortRepositoryName((Repository)((Repository)value));
        } else if (object2 instanceof GitBranch) {
            if (this._treeModel.isPrefixGrouping()) {
                String string2 = ((GitBranch)value).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.name");
                char[] cArray = new char[]{'/'};
                string = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null));
            } else {
                String string3 = ((GitBranch)value).getName();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"value.name");
            }
        } else {
            string = object2 instanceof PopupFactoryImpl.ActionItem ? ((PopupFactoryImpl.ActionItem)value).getText() : value.toString();
        }
        return string;
    }

    @Nullable
    public final String getSecondaryText(@Nullable Object treeNode) {
        String string;
        Object object = treeNode;
        if (object instanceof PopupFactoryImpl.ActionItem) {
            string = KeymapUtil.getFirstKeyboardShortcutText((AnAction)((PopupFactoryImpl.ActionItem)treeNode).getAction());
        } else if (object instanceof GitRepository) {
            GitLocalBranch gitLocalBranch = ((GitRepository)treeNode).getCurrentBranch();
            string = gitLocalBranch != null ? gitLocalBranch.getName() : null;
            if (string == null) {
                string = "";
            }
        } else if (object instanceof GitLocalBranch) {
            GitRemoteBranch gitRemoteBranch = this.getCommonTrackedBranch((GitLocalBranch)treeNode, this.repositories);
            string = gitRemoteBranch != null ? gitRemoteBranch.getName() : null;
        } else {
            string = null;
        }
        return string;
    }

    private final GitRemoteBranch getCommonTrackedBranch(GitLocalBranch $this$getCommonTrackedBranch, List<? extends GitRepository> repositories) {
        GitRemoteBranch commonTrackedBranch = null;
        for (GitRepository gitRepository : repositories) {
            GitRemoteBranch trackedBranch;
            if ($this$getCommonTrackedBranch.findTrackedBranch(gitRepository) == null) {
                return null;
            }
            if (commonTrackedBranch == null) {
                commonTrackedBranch = trackedBranch;
                continue;
            }
            if (Intrinsics.areEqual((Object)commonTrackedBranch.getName(), (Object)trackedBranch.getName())) continue;
            return null;
        }
        return commonTrackedBranch;
    }

    public void canceled() {
    }

    public boolean isMnemonicsNavigationEnabled() {
        return false;
    }

    @Nullable
    public Void getMnemonicNavigationFilter() {
        return null;
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    @NotNull
    public SpeedSearchFilter<Object> getSpeedSearchFilter() {
        return arg_0 -> GitBranchesTreePopupStep.getSpeedSearchFilter$lambda$6(this, arg_0);
    }

    public boolean isAutoSelectionEnabled() {
        return false;
    }

    private static final void onChosen$lambda$0(AnAction $action, GitBranchesTreePopupStep this$0) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ActionUtil.invokeAction((AnAction)$action, (DataContext)git4idea.ui.branch.GitBranchesTreePopupStep$Companion.createDataContext$intellij_vcs_git$default(Companion, this$0.project, this$0.repositories, null, 4, null), (String)ACTION_PLACE, null, null);
    }

    private static final String getSpeedSearchFilter$lambda$6(GitBranchesTreePopupStep this$0, Object node) {
        Object object;
        block3: {
            block4: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    if (!(node instanceof GitBranch)) break block2;
                    object = ((GitBranch)node).getName();
                    break block3;
                }
                object = node;
                if (object == null) break block4;
                Object p0 = object;
                boolean bl = false;
                String string = this$0.getText(p0);
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    static {
        String string = ActionPlaces.getPopupPlace((String)"GitBranchesPopup");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPopupPlace(\"GitBranchesPopup\")");
        ACTION_PLACE = string;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\fH\u0002J6\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J/\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0000\u00a2\u0006\u0002\b\u001aR\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgit4idea/ui/branch/GitBranchesTreePopupStep$Companion;", "", "()V", "ACTION_PLACE", "", "Lorg/jetbrains/annotations/NotNull;", "getACTION_PLACE$intellij_vcs_git", "()Ljava/lang/String;", "BRANCH_ACTION_GROUP", "HEADER_SETTINGS_ACTION_GROUP", "TOP_LEVEL_ACTION_GROUP", "createActionItems", "", "Lcom/intellij/ui/popup/PopupFactoryImpl$ActionItem;", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "Lgit4idea/repo/GitRepository;", "createActionStep", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "branch", "Lgit4idea/GitBranch;", "createDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "createDataContext$intellij_vcs_git", "PreferStartMatchMatcherWrapper", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getACTION_PLACE$intellij_vcs_git() {
            return ACTION_PLACE;
        }

        private final List<PopupFactoryImpl.ActionItem> createActionItems(ActionGroup actionGroup, Project project, List<? extends GitRepository> repositories) {
            DataContext dataContext = git4idea.ui.branch.GitBranchesTreePopupStep$Companion.createDataContext$intellij_vcs_git$default(this, project, repositories, null, 4, null);
            List list2 = ActionPopupStep.createActionItems((ActionGroup)actionGroup, (DataContext)dataContext, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (String)this.getACTION_PLACE$intellij_vcs_git(), null);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createActionItems(action\u2026alse, ACTION_PLACE, null)");
            return list2;
        }

        private final ListPopupStep<?> createActionStep(ActionGroup actionGroup, Project project, List<? extends GitRepository> repositories, GitBranch branch) {
            DataContext dataContext = this.createDataContext$intellij_vcs_git(project, repositories, branch);
            ListPopupStep listPopupStep = JBPopupFactory.getInstance().createActionsStep(actionGroup, dataContext, this.getACTION_PLACE$intellij_vcs_git(), false, true, null, null, true, 0, false);
            Intrinsics.checkNotNullExpressionValue((Object)listPopupStep, (String)"getInstance()\n        .c\u2026ll, null, true, 0, false)");
            return listPopupStep;
        }

        static /* synthetic */ ListPopupStep createActionStep$default(Companion companion, ActionGroup actionGroup, Project project, List list2, GitBranch gitBranch, int n, Object object) {
            if ((n & 8) != 0) {
                gitBranch = null;
            }
            return companion.createActionStep(actionGroup, project, list2, gitBranch);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DataContext createDataContext$intellij_vcs_git(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @Nullable GitBranch branch) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
            SimpleDataContext.Builder builder = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project).add(GitBranchActionsUtil.REPOSITORIES_KEY, repositories);
            DataKey<List<GitBranch>> dataKey = GitBranchActionsUtil.BRANCHES_KEY;
            GitBranch gitBranch = branch;
            if (gitBranch != null) {
                void p0;
                GitBranch gitBranch2 = gitBranch;
                DataKey<List<GitBranch>> dataKey2 = dataKey;
                SimpleDataContext.Builder builder2 = builder;
                boolean bl = false;
                List list3 = CollectionsKt.listOf((Object)p0);
                builder = builder2;
                dataKey = dataKey2;
                list2 = list3;
            } else {
                list2 = null;
            }
            DataContext dataContext = builder.add(dataKey, list2).build();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"builder()\n        .add(C\u2026listOf))\n        .build()");
            return dataContext;
        }

        public static /* synthetic */ DataContext createDataContext$intellij_vcs_git$default(Companion companion, Project project, List list2, GitBranch gitBranch, int n, Object object) {
            if ((n & 4) != 0) {
                gitBranch = null;
            }
            return companion.createDataContext$intellij_vcs_git(project, list2, gitBranch);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\fH\u0016J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/ui/branch/GitBranchesTreePopupStep$Companion$PreferStartMatchMatcherWrapper;", "Lcom/intellij/psi/codeStyle/MinusculeMatcher;", "delegate", "(Lcom/intellij/psi/codeStyle/MinusculeMatcher;)V", "getPattern", "", "matchingDegree", "", "name", "valueStartCaseMatch", "", "fragments", "Lcom/intellij/util/containers/FList;", "Lcom/intellij/openapi/util/TextRange;", "matchingFragments", "Companion", "intellij.vcs.git"})
        private static final class PreferStartMatchMatcherWrapper
        extends MinusculeMatcher {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final MinusculeMatcher delegate;
            private static final int MATCH_OFFSET = 10000;

            public PreferStartMatchMatcherWrapper(@NotNull MinusculeMatcher delegate) {
                Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
                this.delegate = delegate;
            }

            @NotNull
            public String getPattern() {
                String string = this.delegate.getPattern();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"delegate.pattern");
                return string;
            }

            @Nullable
            public FList<TextRange> matchingFragments(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return this.delegate.matchingFragments(name);
            }

            public int matchingDegree(@NotNull String name, boolean valueStartCaseMatch, @Nullable FList<? extends TextRange> fragments) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int degree = this.delegate.matchingDegree(name, valueStartCaseMatch, fragments);
                Collection collection = (Collection)fragments;
                if (collection == null || collection.isEmpty()) {
                    return degree;
                }
                return degree += 10000 - ((TextRange)fragments.getHead()).getStartOffset();
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgit4idea/ui/branch/GitBranchesTreePopupStep$Companion$PreferStartMatchMatcherWrapper$Companion;", "", "()V", "MATCH_OFFSET", "", "intellij.vcs.git"})
            public static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

