/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchPopup;
import git4idea.ui.branch.GitBranchesTreePopup;
import org.jetbrains.annotations.NotNull;

public class GitBranchesAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        if (Registry.is((String)"git.branches.popup.tree", (boolean)false)) {
            GitBranchesTreePopup.show(project);
        } else {
            GitRepository repository = GitBranchUtil.guessRepositoryForOperation(project, e.getDataContext());
            if (repository != null) {
                GitBranchPopup.getInstance(project, repository, e.getDataContext()).asListPopup().showCenteredInCurrentWindow(project);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && !project.isDisposed() && !GitRepositoryManager.getInstance(project).getRepositories().isEmpty());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

