/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.TimedVcsCommit;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitNewBranchOptions;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J(\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgit4idea/ui/branch/GitBranchCheckoutOperation;", "", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "brancher", "Lgit4idea/branch/GitBrancher;", "kotlin.jvm.PlatformType", "checkout", "", "startPoint", "", "name", "localConflictResolution", "Lgit4idea/ui/branch/GitBranchCheckoutOperation$Companion$CheckoutConflictResolution;", "create", "reset", "", "perform", "options", "Lgit4idea/branch/GitNewBranchOptions;", "performCheckout", "localHasMoreCommits", "performCreate", "Companion", "intellij.vcs.git"})
public final class GitBranchCheckoutOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<GitRepository> repositories;
    private final GitBrancher brancher;
    @NotNull
    private static final Logger LOG;

    public GitBranchCheckoutOperation(@NotNull Project project, @NotNull List<? extends GitRepository> repositories) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        this.project = project;
        this.repositories = repositories;
        this.brancher = GitBrancher.getInstance(this.project);
        boolean bl2 = bl = !((Collection)this.repositories).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final void perform(@NotNull String startPoint, @NotNull GitNewBranchOptions options) {
        Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        boolean checkout = options.shouldCheckout();
        String name = options.getName();
        boolean reset = options.shouldReset();
        boolean localHasMoreCommits = Companion.checkLocalHasMoreCommits$intellij_vcs_git(this.project, this.repositories, name, startPoint);
        if (checkout) {
            this.performCheckout(startPoint, name, localHasMoreCommits, reset);
        } else {
            this.performCreate(startPoint, name, localHasMoreCommits, reset);
        }
    }

    private final void performCheckout(String startPoint, String name, boolean localHasMoreCommits, boolean reset) {
        if (localHasMoreCommits) {
            if (reset) {
                Object[] objectArray = new Object[]{name, startPoint};
                String string = GitBundle.message("branches.checkout.with.reset.local.has.more.commits", objectArray);
                objectArray = new Object[]{startPoint};
                int result2 = Messages.showYesNoCancelDialog((String)string, (String)GitBundle.message("checkout.0", objectArray), (String)GitBundle.message("checkout.and.rebase", new Object[0]), (String)GitBundle.message("branches.drop.local.commits", new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), null);
                switch (result2) {
                    case 0: {
                        this.checkout(startPoint, name, Companion.CheckoutConflictResolution.REBASE);
                        break;
                    }
                    case 1: {
                        this.checkout(startPoint, name, Companion.CheckoutConflictResolution.RESET);
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            } else {
                Object[] objectArray = new Object[]{name, startPoint};
                String string = GitBundle.message("branches.checkout.local.has.more.commits", objectArray);
                objectArray = new Object[]{startPoint};
                int result3 = Messages.showYesNoCancelDialog((String)string, (String)GitBundle.message("checkout.0", objectArray), (String)GitBundle.message("checkout.and.rebase", new Object[0]), (String)GitBundle.message("branches.checkout.local", new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), null);
                switch (result3) {
                    case 0: {
                        this.checkout(startPoint, name, Companion.CheckoutConflictResolution.REBASE);
                        break;
                    }
                    case 1: {
                        this.checkout(startPoint, name, Companion.CheckoutConflictResolution.USE_LOCAL);
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
        } else {
            this.checkout(startPoint, name, reset ? Companion.CheckoutConflictResolution.RESET : Companion.CheckoutConflictResolution.TRY);
        }
    }

    private final void performCreate(String startPoint, String name, boolean localHasMoreCommits, boolean reset) {
        if (localHasMoreCommits) {
            if (reset) {
                Object[] objectArray = new Object[]{name, startPoint};
                String string = GitBundle.message("branches.create.with.reset.local.has.more.commits", objectArray);
                objectArray = new Object[]{startPoint};
                int result2 = Messages.showYesNoDialog((String)string, (String)GitBundle.message("checkout.0", objectArray), (String)GitBundle.message("branches.drop.local.commits", new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), null);
                if (result2 == 0) {
                    this.create(startPoint, name, true);
                }
            } else {
                Object[] objectArray = new Object[]{name, startPoint};
                String string = GitBundle.message("branches.create.local.has.more.commits", objectArray);
                objectArray = new Object[]{startPoint};
                int result3 = Messages.showYesNoDialog((String)string, (String)GitBundle.message("checkout.0", objectArray), (String)GitBundle.message("new.branch.dialog.operation.create.name", new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), null);
                if (result3 == 0) {
                    this.create(startPoint, name, false);
                }
            }
        } else {
            this.create(startPoint, name, reset);
        }
    }

    private final void checkout(String startPoint, String name, Companion.CheckoutConflictResolution localConflictResolution) {
        Iterable $this$partition$iv = this.repositories;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            GitRepository it = (GitRepository)element$iv;
            boolean bl = false;
            if (it.getBranches().findLocalBranch(name) != null) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        kotlin.Pair pair = new kotlin.Pair(first$iv, second$iv);
        List reposWithLocalBranch = (List)pair.component1();
        List reposWithoutLocalBranch = (List)pair.component2();
        if (!((Collection)reposWithLocalBranch).isEmpty()) {
            switch (WhenMappings.$EnumSwitchMapping$0[localConflictResolution.ordinal()]) {
                case 1: {
                    this.brancher.checkout(name, false, reposWithLocalBranch, null);
                    break;
                }
                case 2: {
                    this.brancher.checkoutNewBranchStartingFrom(name, startPoint, true, reposWithLocalBranch, null);
                    break;
                }
                case 3: {
                    this.brancher.rebase(reposWithLocalBranch, startPoint, name);
                    break;
                }
                case 4: {
                    this.brancher.checkoutNewBranchStartingFrom(name, startPoint, false, reposWithLocalBranch, null);
                }
            }
        }
        if (!((Collection)reposWithoutLocalBranch).isEmpty()) {
            this.brancher.checkoutNewBranchStartingFrom(name, startPoint, false, reposWithoutLocalBranch, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void create(String startPoint, String name, boolean reset) {
        String string;
        Map map2;
        Object t;
        GitBrancher gitBrancher;
        String string2;
        Iterable $this$partition$iv = this.repositories;
        boolean $i$f$partition = false;
        kotlin.Pair first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            GitRepository it = (GitRepository)element$iv;
            boolean bl = false;
            if (it.getBranches().findLocalBranch(name) != null) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        kotlin.Pair pair = new kotlin.Pair(first$iv, second$iv);
        List reposWithLocalBranch = (List)pair.component1();
        List reposWithoutLocalBranch = (List)pair.component2();
        if (!((Collection)reposWithLocalBranch).isEmpty() && reset) {
            Iterable $this$partition$iv2 = reposWithLocalBranch;
            boolean $i$f$partition2 = false;
            Iterable<Object> first$iv2 = new ArrayList();
            ArrayList second$iv2 = new ArrayList();
            for (Object element$iv : $this$partition$iv2) {
                GitRepository it = (GitRepository)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getCurrentBranchName(), (Object)name)) {
                    first$iv2.add(element$iv);
                    continue;
                }
                second$iv2.add(element$iv);
            }
            first$iv = new kotlin.Pair(first$iv2, second$iv2);
            List currentBranchOfSameName = (List)first$iv.component1();
            List currentBranchOfDifferentName = (List)first$iv.component2();
            if (!((Collection)currentBranchOfSameName).isEmpty()) {
                this.brancher.checkoutNewBranchStartingFrom(name, startPoint, true, currentBranchOfSameName, null);
            }
            if (!((Collection)currentBranchOfDifferentName).isEmpty()) {
                void $this$associateWith$iv;
                first$iv2 = currentBranchOfDifferentName;
                string2 = name;
                gitBrancher = this.brancher;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                void $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo2 = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    GitRepository gitRepository = (GitRepository)element$iv$iv;
                    t = element$iv$iv;
                    map2 = result$iv;
                    boolean bl = false;
                    string = startPoint;
                    map2.put(t, string);
                }
                map2 = result$iv;
                gitBrancher.createBranch(string2, map2, true);
            }
        }
        if (!((Collection)reposWithoutLocalBranch).isEmpty()) {
            void $this$associateWith$iv;
            first$iv = reposWithoutLocalBranch;
            string2 = name;
            gitBrancher = this.brancher;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                GitRepository $i$f$associateWithTo2 = (GitRepository)element$iv$iv;
                t = element$iv$iv;
                map2 = result$iv;
                boolean bl = false;
                string = startPoint;
                map2.put(t, string);
            }
            map2 = result$iv;
            gitBrancher.createBranch(string2, map2);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitBranchCheckoutOperation.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J.\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J3\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0014J(\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lgit4idea/ui/branch/GitBranchCheckoutOperation$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "checkCommitsBetweenRefAndBranchName", "", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "startRef", "", "branchName", "checkCommitsUnderProgress", "checkLocalHasMoreCommits", "localBranch", "startPoint", "checkLocalHasMoreCommits$intellij_vcs_git", "hasCommits", "repository", "endRef", "CheckoutConflictResolution", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean checkLocalHasMoreCommits$intellij_vcs_git(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String localBranch, @NotNull String startPoint) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
            Intrinsics.checkNotNullParameter((Object)localBranch, (String)"localBranch");
            Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
            Map map2 = ContainerUtil.map2MapNotNull((Collection)repositories, arg_0 -> Companion.checkLocalHasMoreCommits$lambda$0((Function1)new Function1<GitRepository, Pair<? extends GitRepository, ? extends GitLocalBranch>>(localBranch){
                final /* synthetic */ String $localBranch;
                {
                    this.$localBranch = $localBranch;
                    super(1);
                }

                public final Pair<? extends GitRepository, ? extends GitLocalBranch> invoke(@NotNull GitRepository r) {
                    GitLocalBranch local;
                    Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                    GitLocalBranch gitLocalBranch = local = r.getBranches().findLocalBranch(this.$localBranch);
                    return gitLocalBranch != null ? Pair.create((Object)r, (Object)gitLocalBranch) : null;
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"localBranch: String, sta\u2026 local) else null\n      }");
            Map existingLocalBranches2 = map2;
            boolean existingLocalHasCommits = !existingLocalBranches2.isEmpty() ? this.checkCommitsUnderProgress(project, CollectionsKt.toList((Iterable)existingLocalBranches2.keySet()), startPoint, localBranch) : false;
            return existingLocalHasCommits;
        }

        private final boolean checkCommitsUnderProgress(Project project, List<? extends GitRepository> repositories, String startRef, String branchName) {
            Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Companion.checkCommitsUnderProgress$lambda$1(project, repositories, startRef, branchName), GitBundle.message("branches.checking.existing.commits.process", new Object[0]), true, project);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance().runProcess\u2026process\"), true, project)");
            return (Boolean)object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean checkCommitsBetweenRefAndBranchName(Project project, List<? extends GitRepository> repositories, String startRef, String branchName) {
            boolean bl;
            Iterable $this$any$iv = repositories;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                GitRepository it = (GitRepository)element$iv;
                boolean bl2 = false;
                GitLocalBranch existingBranch = it.getBranches().findLocalBranch(branchName);
                if (existingBranch != null) {
                    String string = existingBranch.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"existingBranch.name");
                    if (Companion.hasCommits(project, it, startRef, string)) {
                        return true;
                    }
                }
                bl = false;
            } while (!bl);
            return true;
        }

        private final boolean hasCommits(Project project, GitRepository repository, String startRef, String endRef) {
            try {
                String[] stringArray = new String[]{startRef + ".." + endRef};
                List<? extends TimedVcsCommit> list2 = GitHistoryUtils.collectTimedCommits(project, repository.getRoot(), stringArray);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"collectTimedCommits(proj\u2026ot, \"$startRef..$endRef\")");
                return !((Collection)list2).isEmpty();
            }
            catch (VcsException ex) {
                LOG.warn("Couldn't collect commits in " + repository.getPresentableUrl() + " for " + startRef + ".." + endRef);
                return true;
            }
        }

        private static final Pair checkLocalHasMoreCommits$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Pair)$tmp0.invoke(p0);
        }

        private static final Boolean checkCommitsUnderProgress$lambda$1(Project $project, List $repositories, String $startRef, String $branchName) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$repositories, (String)"$repositories");
            Intrinsics.checkNotNullParameter((Object)$startRef, (String)"$startRef");
            Intrinsics.checkNotNullParameter((Object)$branchName, (String)"$branchName");
            return Companion.checkCommitsBetweenRefAndBranchName($project, $repositories, $startRef, $branchName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/ui/branch/GitBranchCheckoutOperation$Companion$CheckoutConflictResolution;", "", "(Ljava/lang/String;I)V", "USE_LOCAL", "RESET", "REBASE", "TRY", "intellij.vcs.git"})
        private static final class CheckoutConflictResolution
        extends Enum<CheckoutConflictResolution> {
            public static final /* enum */ CheckoutConflictResolution USE_LOCAL = new CheckoutConflictResolution();
            public static final /* enum */ CheckoutConflictResolution RESET = new CheckoutConflictResolution();
            public static final /* enum */ CheckoutConflictResolution REBASE = new CheckoutConflictResolution();
            public static final /* enum */ CheckoutConflictResolution TRY = new CheckoutConflictResolution();
            private static final /* synthetic */ CheckoutConflictResolution[] $VALUES;

            public static CheckoutConflictResolution[] values() {
                return (CheckoutConflictResolution[])$VALUES.clone();
            }

            public static CheckoutConflictResolution valueOf(String value) {
                return Enum.valueOf(CheckoutConflictResolution.class, value);
            }

            static {
                $VALUES = checkoutConflictResolutionArray = new CheckoutConflictResolution[]{CheckoutConflictResolution.USE_LOCAL, CheckoutConflictResolution.RESET, CheckoutConflictResolution.REBASE, CheckoutConflictResolution.TRY};
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Companion.CheckoutConflictResolution.values().length];
            try {
                nArray[Companion.CheckoutConflictResolution.USE_LOCAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.CheckoutConflictResolution.RESET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.CheckoutConflictResolution.REBASE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.CheckoutConflictResolution.TRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

