/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.application.Topics;
import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.ui.CloneDvcsValidationUtils;
import com.intellij.dvcs.ui.DvcsCloneDialogComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.Topic;
import git4idea.checkout.GitCheckoutProvider;
import git4idea.commands.Git;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableInlineComponent;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitVersion;
import git4idea.config.InlineErrorNotifier;
import git4idea.i18n.GitBundle;
import git4idea.remote.GitRememberedInputs;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001%B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0015J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lgit4idea/ui/GitCloneDialogComponent;", "Lcom/intellij/dvcs/ui/DvcsCloneDialogComponent;", "project", "Lcom/intellij/openapi/project/Project;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "dialogStateListener", "Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogComponentStateListener;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/application/ModalityState;Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogComponentStateListener;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "checkVersionAlarm", "Lcom/intellij/util/Alarm;", "errorNotifier", "Lgit4idea/config/InlineErrorNotifier;", "executableManager", "Lgit4idea/config/GitExecutableManager;", "kotlin.jvm.PlatformType", "getExecutableManager", "()Lgit4idea/config/GitExecutableManager;", "executableProblemHandler", "Lgit4idea/config/GitExecutableProblemHandler;", "inlineComponent", "Lgit4idea/config/GitExecutableInlineComponent;", "versionCheckState", "Lgit4idea/ui/GitCloneDialogComponent$VersionCheckState;", "checkGitVersion", "", "doClone", "listener", "Lcom/intellij/openapi/vcs/CheckoutProvider$Listener;", "isOkActionEnabled", "", "notifyCloneError", "onComponentSelected", "scheduleCheckVersion", "VersionCheckState", "intellij.vcs.git"})
public final class GitCloneDialogComponent
extends DvcsCloneDialogComponent {
    @NotNull
    private final ModalityState modalityState;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final GitExecutableInlineComponent inlineComponent;
    @NotNull
    private final InlineErrorNotifier errorNotifier;
    @NotNull
    private final GitExecutableProblemHandler executableProblemHandler;
    @NotNull
    private final Alarm checkVersionAlarm;
    @NotNull
    private VersionCheckState versionCheckState;

    public GitCloneDialogComponent(@NotNull Project project, @NotNull ModalityState modalityState, @NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        Intrinsics.checkNotNullParameter((Object)dialogStateListener, (String)"dialogStateListener");
        DvcsRememberedInputs dvcsRememberedInputs = GitRememberedInputs.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dvcsRememberedInputs, (String)"getInstance()");
        super(project, ".git", dvcsRememberedInputs, dialogStateListener);
        this.modalityState = modalityState;
        Logger logger = Logger.getInstance(GitCloneDialogComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(GitCloneDialogComponent::class.java)");
        this.LOG = logger;
        this.inlineComponent = new GitExecutableInlineComponent(this.getErrorComponent(), this.modalityState, this.getMainPanel());
        this.errorNotifier = new InlineErrorNotifier(this.inlineComponent, this.modalityState, (Disposable)this);
        this.executableProblemHandler = GitExecutableProblemHandlersKt.findGitExecutableProblemHandler(project);
        this.checkVersionAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.versionCheckState = VersionCheckState.NOT_CHECKED;
    }

    private final GitExecutableManager getExecutableManager() {
        return GitExecutableManager.getInstance();
    }

    public void doClone(@NotNull CheckoutProvider.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Path parent = Paths.get(this.getDirectory(), new String[0]).toAbsolutePath().getParent();
        ValidationInfo destinationValidation = CloneDvcsValidationUtils.createDestination((String)((Object)parent).toString());
        if (destinationValidation != null) {
            String[] stringArray = new String[]{destinationValidation.message};
            this.LOG.error("Unable to create destination directory", stringArray);
            this.notifyCloneError(this.getProject());
            return;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile destinationParent = lfs.findFileByIoFile(parent.toFile());
        if (destinationParent == null) {
            destinationParent = lfs.refreshAndFindFileByIoFile(parent.toFile());
        }
        if (destinationParent == null) {
            this.LOG.error("Clone Failed. Destination doesn't exist");
            this.notifyCloneError(this.getProject());
            return;
        }
        String sourceRepositoryURL = this.getUrl();
        String directoryName = ((Object)Paths.get(this.getDirectory(), new String[0]).getFileName()).toString();
        String parentDirectory = ((Object)parent.toAbsolutePath()).toString();
        GitCheckoutProvider.clone(this.getProject(), Git.getInstance(), listener2, destinationParent, sourceRepositoryURL, directoryName, parentDirectory);
        DvcsRememberedInputs dvcsRememberedInputs = GitRememberedInputs.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dvcsRememberedInputs, (String)"getInstance()");
        DvcsRememberedInputs rememberedInputs = dvcsRememberedInputs;
        rememberedInputs.addUrl(sourceRepositoryURL);
        rememberedInputs.setCloneParentDir(parentDirectory);
    }

    @RequiresEdt
    public void onComponentSelected(@NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        Intrinsics.checkNotNullParameter((Object)dialogStateListener, (String)"dialogStateListener");
        this.updateOkActionState(dialogStateListener);
        if (this.versionCheckState == VersionCheckState.NOT_CHECKED) {
            this.versionCheckState = VersionCheckState.IN_PROGRESS;
            this.scheduleCheckVersion(dialogStateListener);
            Topic topic = ApplicationActivationListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            Topics.subscribe((Topic)topic, (Disposable)((Disposable)this), (Object)new ApplicationActivationListener(this, dialogStateListener){
                final /* synthetic */ GitCloneDialogComponent this$0;
                final /* synthetic */ VcsCloneDialogComponentStateListener $dialogStateListener;
                {
                    this.this$0 = $receiver;
                    this.$dialogStateListener = $dialogStateListener;
                }

                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
                    if (GitCloneDialogComponent.access$getVersionCheckState$p(this.this$0) == VersionCheckState.FAILED) {
                        GitCloneDialogComponent.access$scheduleCheckVersion(this.this$0, this.$dialogStateListener);
                    }
                }
            });
        }
    }

    private final void scheduleCheckVersion(VcsCloneDialogComponentStateListener dialogStateListener) {
        if (!this.errorNotifier.isTaskInProgress()) {
            this.checkVersionAlarm.addRequest(() -> GitCloneDialogComponent.scheduleCheckVersion$lambda$0(this, dialogStateListener), 0);
        }
    }

    private final void checkGitVersion(VcsCloneDialogComponentStateListener dialogStateListener) {
        ActionsKt.invokeAndWaitIfNeeded((ModalityState)this.modalityState, (Function0)((Function0)new Function0<ProgressIndicator>(this){
            final /* synthetic */ GitCloneDialogComponent this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ProgressIndicator invoke() {
                GitExecutableInlineComponent gitExecutableInlineComponent = GitCloneDialogComponent.access$getInlineComponent$p(this.this$0);
                String string = GitBundle.message("clone.dialog.checking.git.version", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"clone.dialog.checking.git.version\")");
                return gitExecutableInlineComponent.showProgress(string);
            }
        }));
        try {
            GitExecutable gitExecutable = this.getExecutableManager().getExecutable((Project)null);
            Intrinsics.checkNotNullExpressionValue((Object)gitExecutable, (String)"executableManager.getExecutable(null)");
            GitExecutable executable = gitExecutable;
            GitVersion gitVersion = this.getExecutableManager().identifyVersion(executable);
            Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"executableManager.identifyVersion(executable)");
            GitVersion gitVersion2 = gitVersion;
            ActionsKt.invokeAndWaitIfNeeded((ModalityState)this.modalityState, (Function0)((Function0)new Function0<Unit>(gitVersion2, this, dialogStateListener){
                final /* synthetic */ GitVersion $gitVersion;
                final /* synthetic */ GitCloneDialogComponent this$0;
                final /* synthetic */ VcsCloneDialogComponentStateListener $dialogStateListener;
                {
                    this.$gitVersion = $gitVersion;
                    this.this$0 = $receiver;
                    this.$dialogStateListener = $dialogStateListener;
                    super(0);
                }

                public final void invoke() {
                    if (!this.$gitVersion.isSupported()) {
                        GitExecutableProblemHandlersKt.showUnsupportedVersionError(this.this$0.getProject(), this.$gitVersion, GitCloneDialogComponent.access$getErrorNotifier$p(this.this$0));
                    } else {
                        GitCloneDialogComponent.access$getInlineComponent$p(this.this$0).hideProgress();
                    }
                    GitCloneDialogComponent.access$setVersionCheckState$p(this.this$0, VersionCheckState.SUCCESS);
                    GitCloneDialogComponent.access$updateOkActionState(this.this$0, this.$dialogStateListener);
                }
            }));
        }
        catch (Throwable t) {
            ActionsKt.invokeAndWaitIfNeeded((ModalityState)this.modalityState, (Function0)((Function0)new Function0<Unit>(this, t, dialogStateListener){
                final /* synthetic */ GitCloneDialogComponent this$0;
                final /* synthetic */ Throwable $t;
                final /* synthetic */ VcsCloneDialogComponentStateListener $dialogStateListener;
                {
                    this.this$0 = $receiver;
                    this.$t = $t;
                    this.$dialogStateListener = $dialogStateListener;
                    super(0);
                }

                public final void invoke() {
                    GitCloneDialogComponent.access$getExecutableProblemHandler$p(this.this$0).showError(this.$t, GitCloneDialogComponent.access$getErrorNotifier$p(this.this$0), (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, this.$dialogStateListener){
                        final /* synthetic */ GitCloneDialogComponent this$0;
                        final /* synthetic */ VcsCloneDialogComponentStateListener $dialogStateListener;
                        {
                            this.this$0 = $receiver;
                            this.$dialogStateListener = $dialogStateListener;
                            super(0);
                        }

                        public final void invoke() {
                            GitCloneDialogComponent.access$setVersionCheckState$p(this.this$0, VersionCheckState.SUCCESS);
                            GitCloneDialogComponent.access$updateOkActionState(this.this$0, this.$dialogStateListener);
                        }
                    }));
                    GitCloneDialogComponent.access$setVersionCheckState$p(this.this$0, VersionCheckState.FAILED);
                    GitCloneDialogComponent.access$updateOkActionState(this.this$0, this.$dialogStateListener);
                }
            }));
        }
    }

    @RequiresEdt
    protected boolean isOkActionEnabled() {
        return super.isOkActionEnabled() && this.versionCheckState == VersionCheckState.SUCCESS;
    }

    private final void notifyCloneError(Project project) {
        VcsNotifier.getInstance((Project)project).notifyError("git.clone.unable.to.create.destination.dir", VcsBundle.message((String)"clone.dialog.clone.button", (Object[])new Object[0]), VcsBundle.message((String)"clone.dialog.unable.create.destination.error", (Object[])new Object[0]));
    }

    private static final void scheduleCheckVersion$lambda$0(GitCloneDialogComponent this$0, VcsCloneDialogComponentStateListener $dialogStateListener) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dialogStateListener, (String)"$dialogStateListener");
        this$0.checkGitVersion($dialogStateListener);
    }

    public static final /* synthetic */ VersionCheckState access$getVersionCheckState$p(GitCloneDialogComponent $this) {
        return $this.versionCheckState;
    }

    public static final /* synthetic */ void access$scheduleCheckVersion(GitCloneDialogComponent $this, VcsCloneDialogComponentStateListener dialogStateListener) {
        $this.scheduleCheckVersion(dialogStateListener);
    }

    public static final /* synthetic */ GitExecutableInlineComponent access$getInlineComponent$p(GitCloneDialogComponent $this) {
        return $this.inlineComponent;
    }

    public static final /* synthetic */ InlineErrorNotifier access$getErrorNotifier$p(GitCloneDialogComponent $this) {
        return $this.errorNotifier;
    }

    public static final /* synthetic */ void access$setVersionCheckState$p(GitCloneDialogComponent $this, VersionCheckState versionCheckState) {
        $this.versionCheckState = versionCheckState;
    }

    public static final /* synthetic */ void access$updateOkActionState(GitCloneDialogComponent $this, VcsCloneDialogComponentStateListener dialogStateListener) {
        $this.updateOkActionState(dialogStateListener);
    }

    public static final /* synthetic */ GitExecutableProblemHandler access$getExecutableProblemHandler$p(GitCloneDialogComponent $this) {
        return $this.executableProblemHandler;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/ui/GitCloneDialogComponent$VersionCheckState;", "", "(Ljava/lang/String;I)V", "NOT_CHECKED", "SUCCESS", "IN_PROGRESS", "FAILED", "intellij.vcs.git"})
    private static final class VersionCheckState
    extends Enum<VersionCheckState> {
        public static final /* enum */ VersionCheckState NOT_CHECKED = new VersionCheckState();
        public static final /* enum */ VersionCheckState SUCCESS = new VersionCheckState();
        public static final /* enum */ VersionCheckState IN_PROGRESS = new VersionCheckState();
        public static final /* enum */ VersionCheckState FAILED = new VersionCheckState();
        private static final /* synthetic */ VersionCheckState[] $VALUES;

        public static VersionCheckState[] values() {
            return (VersionCheckState[])$VALUES.clone();
        }

        public static VersionCheckState valueOf(String value) {
            return Enum.valueOf(VersionCheckState.class, value);
        }

        static {
            $VALUES = versionCheckStateArray = new VersionCheckState[]{VersionCheckState.NOT_CHECKED, VersionCheckState.SUCCESS, VersionCheckState.IN_PROGRESS, VersionCheckState.FAILED};
        }
    }
}

