/*
 * Decompiled with CFR 0.152.
 */
package git4idea.terminal;

import com.intellij.execution.Executor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.TerminalShellCommandHandler;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0002J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J*\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\bH\u0016J$\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00a8\u0006\u001e"}, d2={"Lgit4idea/terminal/GitLogTerminalCustomCommandHandler;", "Lcom/intellij/terminal/TerminalShellCommandHandler;", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "", "localSession", "command", "executor", "Lcom/intellij/execution/Executor;", "getBranchFilter", "Lcom/intellij/vcs/log/VcsLogBranchFilter;", "branch", "getBranchPatternsFilter", "branchesPatterns", "repository", "Lgit4idea/repo/GitRepository;", "getUsersFilter", "Lcom/intellij/vcs/log/VcsLogUserFilter;", "users", "", "projectLog", "Lcom/intellij/vcs/log/impl/VcsProjectLog;", "matches", "parse", "Lgit4idea/terminal/GitLogTerminalCustomCommandHandler$Companion$Parameters;", "Companion", "intellij.vcs.git"})
public final class GitLogTerminalCustomCommandHandler
implements TerminalShellCommandHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String GIT_LOG_COMMAND = "git log";
    @NotNull
    private static final String AUTHOR_PARAMETER = "--author";
    @NotNull
    private static final String AUTHOR_PARAMETER_WITH_SUFFIX = "--author=";
    @NotNull
    private static final String BRANCHES_PARAMETER = "--branches=";

    public boolean matches(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return this.parse(project, workingDirectory, command) != null;
    }

    public boolean execute(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, @NotNull Executor executor) {
        Companion.Parameters parameters;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        if (workingDirectory == null) {
            LOG.warn("Cannot open git log for unknown root.");
            return false;
        }
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFileQuick(VcsUtil.getFilePath((String)workingDirectory));
        if (repository == null) {
            LOG.warn("Cannot find repository for working directory: " + workingDirectory);
            return false;
        }
        Companion.Parameters parameters2 = parameters = this.parse(project, workingDirectory, command);
        String branch = parameters2 != null ? parameters2.getBranch() : null;
        Companion.Parameters parameters3 = parameters;
        String branchesPatterns = parameters3 != null ? parameters3.getBranchesPatterns() : null;
        Companion.Parameters parameters4 = parameters;
        List<String> users = parameters4 != null ? parameters4.getUsers() : null;
        VcsProjectLog projectLog = VcsProjectLog.getInstance((Project)project);
        VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[4];
        VirtualFile virtualFile = repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repository.root");
        vcsLogFilterArray[0] = (VcsLogFilter)VcsLogFilterObject.fromRoot((VirtualFile)virtualFile);
        vcsLogFilterArray[1] = (VcsLogFilter)this.getBranchPatternsFilter(branchesPatterns, repository);
        vcsLogFilterArray[2] = (VcsLogFilter)this.getBranchFilter(branch);
        Intrinsics.checkNotNullExpressionValue((Object)projectLog, (String)"projectLog");
        vcsLogFilterArray[3] = (VcsLogFilter)this.getUsersFilter(users, projectLog);
        projectLog.openLogTab(VcsLogFilterObject.collection((VcsLogFilter[])vcsLogFilterArray));
        return true;
    }

    private final VcsLogBranchFilter getBranchFilter(String branch) {
        if (branch == null) {
            return null;
        }
        return VcsLogFilterObject.fromBranch((String)branch);
    }

    /*
     * WARNING - void declaration
     */
    private final VcsLogBranchFilter getBranchPatternsFilter(String branchesPatterns, GitRepository repository) {
        void destination$iv;
        void $this$mapTo$iv;
        if (branchesPatterns == null) {
            return null;
        }
        Sequence sequence = SequencesKt.sequenceOf((Object[])new GitBranch[0]);
        Collection<GitLocalBranch> collection = repository.getBranches().getLocalBranches();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"repository.branches.localBranches");
        Sequence sequence2 = SequencesKt.plus((Sequence)sequence, (Iterable)collection);
        Collection<GitRemoteBranch> collection2 = repository.getBranches().getRemoteBranches();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"repository.branches.remoteBranches");
        Sequence sequence3 = SequencesKt.plus((Sequence)sequence2, (Iterable)collection2);
        Collection collection3 = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            GitBranch gitBranch = (GitBranch)item$iv;
            void var11_10 = destination$iv;
            boolean bl = false;
            var11_10.add(it.getName());
        }
        Set allBranches = (Set)destination$iv;
        return VcsLogFilterObject.fromBranchPatterns$default((Collection)CollectionsKt.listOf((Object)branchesPatterns), (Set)allBranches, (boolean)false, (int)4, null);
    }

    private final VcsLogUserFilter getUsersFilter(List<String> users, VcsProjectLog projectLog) {
        Collection collection = users;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Collection collection2 = users;
        VcsLogData vcsLogData = projectLog.getDataManager();
        Intrinsics.checkNotNull((Object)vcsLogData);
        return VcsLogFilterObject.fromUserNames((Collection)collection2, (VcsLogData)vcsLogData);
    }

    /*
     * WARNING - void declaration
     */
    private final Companion.Parameters parse(Project project, String workingDirectory, String command) {
        Object v6;
        List userNames;
        List commands;
        block14: {
            VcsUser regexp;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Object element$iv;
            boolean bl;
            if (!Intrinsics.areEqual((Object)command, (Object)GIT_LOG_COMMAND) && !StringsKt.startsWith$default((String)command, (String)"git log ", (boolean)false, (int)2, null)) {
                return null;
            }
            if (workingDirectory == null || GitRepositoryManager.getInstance(project).getRepositoryForFileQuick(VcsUtil.getFilePath((String)workingDirectory)) == null) {
                return null;
            }
            List list2 = ParametersListUtil.parse((String)command);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"parse(command)");
            commands = list2;
            boolean bl2 = bl = commands.size() >= 2;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            commands.remove(0);
            commands.remove(0);
            List userRegexps = new ArrayList();
            ListIterator iterator = commands.listIterator();
            Iterator $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                Iterator parameter;
                element$iv = iterator2.next();
                String currentCommand = (String)element$iv;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)currentCommand, (Object)AUTHOR_PARAMETER)) {
                    if (!iterator.hasNext()) continue;
                    iterator.remove();
                    Object e = iterator.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"iterator.next()");
                    userRegexps.add(e);
                    iterator.remove();
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)currentCommand, (String)"currentCommand");
                if (!StringsKt.startsWith$default((String)currentCommand, (String)AUTHOR_PARAMETER_WITH_SUFFIX, (boolean)false, (int)2, null) || !(!StringsKt.isBlank((CharSequence)((CharSequence)((Object)(parameter = StringsKt.substringAfter$default((String)currentCommand, (String)AUTHOR_PARAMETER_WITH_SUFFIX, null, (int)2, null))))))) continue;
                userRegexps.add(parameter);
                iterator.remove();
            }
            Iterable $this$map$iv = userRegexps;
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$filterTo$iv$iv;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                Regex regex = new Regex(".*" + (String)regexp + ".*");
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service22 = false;
                Class<VcsUserRegistry> serviceClass$iv = VcsUserRegistry.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                }
                Set set = ((VcsUserRegistry)object).getUsers();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.service<VcsUserRegistry>().users");
                Iterable $this$filter$iv = set;
                boolean $i$f$filter = false;
                Iterable $i$f$service22 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    VcsUser user = (VcsUser)element$iv$iv;
                    boolean bl5 = false;
                    String string2 = user.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"user.name");
                    String string3 = string2.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase()");
                    if (!regex.matches((CharSequence)string3)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                collection.add((List)destination$iv$iv2);
            }
            $this$map$iv = CollectionsKt.distinct((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                regexp = (VcsUser)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(it.getName());
            }
            userNames = (List)destination$iv$iv;
            $this$mapTo$iv$iv = commands;
            for (Object t : $this$mapTo$iv$iv) {
                String it = (String)t;
                boolean bl7 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!StringsKt.startsWith$default((String)it, (String)BRANCHES_PARAMETER, (boolean)false, (int)2, null)) continue;
                v6 = t;
                break block14;
            }
            v6 = null;
        }
        String branchesParameter = v6;
        String branchesPatterns = null;
        if (branchesParameter != null) {
            branchesPatterns = StringsKt.substringAfter$default((String)branchesParameter, (String)BRANCHES_PARAMETER, null, (int)2, null);
            commands.remove(branchesParameter);
        }
        String branch = null;
        if (!((Collection)commands).isEmpty()) {
            branch = (String)commands.get(0);
            if (StringsKt.startsWith$default((CharSequence)branch, (char)'-', (boolean)false, (int)2, null)) {
                return null;
            }
            commands.remove(branch);
        }
        if (commands.isEmpty()) {
            return new Companion.Parameters(branch, branchesPatterns, userNames);
        }
        return null;
    }

    static {
        Logger logger = Logger.getInstance(GitLogTerminalCustomCommandHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(GitLogTermin\u2026mmandHandler::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/terminal/GitLogTerminalCustomCommandHandler$Companion;", "", "()V", "AUTHOR_PARAMETER", "", "AUTHOR_PARAMETER_WITH_SUFFIX", "BRANCHES_PARAMETER", "GIT_LOG_COMMAND", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "Parameters", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J1\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lgit4idea/terminal/GitLogTerminalCustomCommandHandler$Companion$Parameters;", "", "branch", "", "branchesPatterns", "users", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getBranch", "()Ljava/lang/String;", "getBranchesPatterns", "getUsers", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
        public static final class Parameters {
            @Nullable
            private final String branch;
            @Nullable
            private final String branchesPatterns;
            @NotNull
            private final List<String> users;

            public Parameters(@Nullable String branch, @Nullable String branchesPatterns, @NotNull List<String> users) {
                Intrinsics.checkNotNullParameter(users, (String)"users");
                this.branch = branch;
                this.branchesPatterns = branchesPatterns;
                this.users = users;
            }

            public /* synthetic */ Parameters(String string, String string2, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                if ((n & 2) != 0) {
                    string2 = null;
                }
                this(string, string2, list2);
            }

            @Nullable
            public final String getBranch() {
                return this.branch;
            }

            @Nullable
            public final String getBranchesPatterns() {
                return this.branchesPatterns;
            }

            @NotNull
            public final List<String> getUsers() {
                return this.users;
            }

            @Nullable
            public final String component1() {
                return this.branch;
            }

            @Nullable
            public final String component2() {
                return this.branchesPatterns;
            }

            @NotNull
            public final List<String> component3() {
                return this.users;
            }

            @NotNull
            public final Parameters copy(@Nullable String branch, @Nullable String branchesPatterns, @NotNull List<String> users) {
                Intrinsics.checkNotNullParameter(users, (String)"users");
                return new Parameters(branch, branchesPatterns, users);
            }

            public static /* synthetic */ Parameters copy$default(Parameters parameters, String string, String string2, List list2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = parameters.branch;
                }
                if ((n & 2) != 0) {
                    string2 = parameters.branchesPatterns;
                }
                if ((n & 4) != 0) {
                    list2 = parameters.users;
                }
                return parameters.copy(string, string2, list2);
            }

            @NotNull
            public String toString() {
                return "Parameters(branch=" + this.branch + ", branchesPatterns=" + this.branchesPatterns + ", users=" + this.users + ")";
            }

            public int hashCode() {
                int result2 = this.branch == null ? 0 : this.branch.hashCode();
                result2 = result2 * 31 + (this.branchesPatterns == null ? 0 : this.branchesPatterns.hashCode());
                result2 = result2 * 31 + ((Object)this.users).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Parameters)) {
                    return false;
                }
                Parameters parameters = (Parameters)other;
                if (!Intrinsics.areEqual((Object)this.branch, (Object)parameters.branch)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.branchesPatterns, (Object)parameters.branchesPatterns)) {
                    return false;
                }
                return Intrinsics.areEqual(this.users, parameters.users);
            }
        }
    }
}

