/*
 * Decompiled with CFR 0.152.
 */
package git4idea.status;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.index.GitFileStatus;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.status.GitChangesCollector;
import git4idea.status.GitRefreshListener;
import git4idea.status.GitStagingAreaHolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class GitChangeProvider
implements ChangeProvider {
    static final Logger LOG = Logger.getInstance((String)"#GitStatus");
    private volatile boolean isRefreshInProgress = false;
    @NotNull
    private final Project project;

    public GitChangeProvider(@NotNull Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getChanges(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder, @NotNull ProgressIndicator progress, @NotNull ChangeListManagerGate addGate) throws VcsException {
        ((GitRefreshListener)BackgroundTaskUtil.syncPublisher((Project)this.project, GitRefreshListener.TOPIC)).progressStarted();
        this.isRefreshInProgress = true;
        try {
            LOG.debug("initial dirty scope: ", new Object[]{dirtyScope});
            GitChangeProvider.appendNestedVcsRootsToDirt((VcsModifiableDirtyScope)dirtyScope);
            LOG.debug("after adding nested vcs roots to dirt: ", new Object[]{dirtyScope});
            GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(this.project);
            Collection affectedRoots = dirtyScope.getAffectedContentRoots();
            Set repos = ContainerUtil.map2SetNotNull((Collection)affectedRoots, arg_0 -> ((GitRepositoryManager)repositoryManager).getRepositoryForRoot(arg_0));
            ArrayList<FilePath> newDirtyPaths = new ArrayList<FilePath>();
            NonChangedHolder holder = new NonChangedHolder(this.project, addGate);
            Map<VirtualFile, List<FilePath>> dirtyPaths = GitStagingAreaHolder.collectDirtyPaths(dirtyScope);
            for (GitRepository repo : repos) {
                LOG.debug("checking root: ", new Object[]{repo.getRoot()});
                List rootDirtyPaths = ContainerUtil.notNullize(dirtyPaths.get(repo.getRoot()));
                if (rootDirtyPaths.isEmpty()) continue;
                GitStagingAreaHolder stageAreaHolder = repo.getStagingAreaHolder();
                List<GitFileStatus> newChanges = stageAreaHolder.refresh(rootDirtyPaths);
                GitChangesCollector collector = GitChangesCollector.collect(this.project, repo, newChanges);
                holder.markHeadRevision(repo.getRoot(), collector.getHead());
                Collection<Change> changes = collector.getChanges();
                for (Change change : changes) {
                    LOG.debug("process change: ", new Object[]{change});
                    builder.processChange(change, GitVcs.getKey());
                    FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
                    FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
                    if (beforePath != null) {
                        holder.markPathProcessed(beforePath);
                    }
                    if (afterPath != null) {
                        holder.markPathProcessed(afterPath);
                    }
                    if (!change.isMoved() && !change.isRenamed() || dirtyScope.belongsTo(beforePath) == dirtyScope.belongsTo(afterPath)) continue;
                    LOG.debug("schedule rename check for: ", new Object[]{change});
                    newDirtyPaths.add(beforePath);
                    newDirtyPaths.add(afterPath);
                }
                ((GitRefreshListener)BackgroundTaskUtil.syncPublisher((Project)this.project, GitRefreshListener.TOPIC)).repositoryUpdated(repo);
            }
            holder.feedBuilder(dirtyScope, builder);
            VcsDirtyScopeManager.getInstance((Project)this.project).filePathsDirty(newDirtyPaths, null);
        }
        finally {
            this.isRefreshInProgress = false;
            ((GitRefreshListener)BackgroundTaskUtil.syncPublisher((Project)this.project, GitRefreshListener.TOPIC)).progressStopped();
        }
    }

    private static void appendNestedVcsRootsToDirt(@NotNull VcsModifiableDirtyScope dirtyScope) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)dirtyScope.getProject());
        Set recursivelyDirtyDirectories = dirtyScope.getRecursivelyDirtyDirectories();
        if (recursivelyDirtyDirectories.isEmpty()) {
            return;
        }
        VirtualFile[] rootsUnderGit = vcsManager.getRootsUnderVcs(dirtyScope.getVcs());
        HashSet<VirtualFile> dirtyDirs = new HashSet<VirtualFile>();
        for (FilePath dir : recursivelyDirtyDirectories) {
            VirtualFile vf = VcsUtil.getVirtualFileWithRefresh((File)dir.getIOFile());
            if (vf == null) continue;
            dirtyDirs.add(vf);
        }
        block1: for (VirtualFile root : rootsUnderGit) {
            if (dirtyDirs.contains(root)) continue;
            for (VirtualFile dirtyDir : dirtyDirs) {
                if (!VfsUtilCore.isAncestor((VirtualFile)dirtyDir, (VirtualFile)root, (boolean)false)) continue;
                LOG.debug("adding git root for check. root: ", new Object[]{root, ", dir: ", dirtyDir});
                dirtyScope.addDirtyDirRecursively(VcsUtil.getFilePath((VirtualFile)root));
                continue block1;
            }
        }
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public boolean isRefreshInProgress() {
        return this.isRefreshInProgress;
    }

    private static final class NonChangedHolder {
        private final Project myProject;
        private final ChangeListManagerGate myAddGate;
        private final Set<FilePath> myProcessedPaths = new HashSet<FilePath>();
        private final Map<VirtualFile, VcsRevisionNumber> myHeadRevisions = new HashMap<VirtualFile, VcsRevisionNumber>();

        private NonChangedHolder(Project project, ChangeListManagerGate addGate) {
            this.myProject = project;
            this.myAddGate = addGate;
        }

        public void markPathProcessed(@NotNull FilePath path) {
            this.myProcessedPaths.add(path);
        }

        public void markHeadRevision(@NotNull VirtualFile root, @NotNull VcsRevisionNumber revision) {
            this.myHeadRevisions.put(root, revision);
        }

        public void feedBuilder(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder) throws VcsException {
            VcsKey gitKey = GitVcs.getKey();
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            for (Document document : fileDocumentManager.getUnsavedDocuments()) {
                GitRepository repository;
                FilePath filePath;
                VirtualFile vf = fileDocumentManager.getFile(document);
                if (vf == null || !vf.isValid() || !fileDocumentManager.isFileModified(vf) || this.myAddGate.getStatus(vf) != null || this.myProcessedPaths.contains(filePath = VcsUtil.getFilePath((VirtualFile)vf)) || !dirtyScope.belongsTo(filePath) || (repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(vf)) == null || repository.getUntrackedFilesHolder().containsFile(filePath)) continue;
                VirtualFile root = repository.getRoot();
                VcsRevisionNumber beforeRevisionNumber = this.myHeadRevisions.get(root);
                if (beforeRevisionNumber == null) {
                    beforeRevisionNumber = GitChangesCollector.getHead(repository);
                    this.myHeadRevisions.put(root, beforeRevisionNumber);
                }
                Change change = new Change(GitContentRevision.createRevision(filePath, beforeRevisionNumber, this.myProject), GitContentRevision.createRevision(filePath, null, this.myProject), FileStatus.MODIFIED);
                LOG.debug("process in-memory change ", new Object[]{change});
                builder.processChange(change, gitKey);
            }
        }
    }
}

