/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.ShowDiffWithLocalAction;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesProvider;
import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesTree;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserStringNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeCellRenderer;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.ui.render.LabelIconCache;
import git4idea.GitCommit;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitStashCache;
import git4idea.stash.GitStashTracker;
import git4idea.stash.GitStashTrackerKt;
import git4idea.stash.GitStashTrackerListener;
import git4idea.stash.ui.GitStashActionsKt;
import git4idea.stash.ui.GitStashPainter;
import git4idea.stash.ui.GitStashProvider;
import git4idea.ui.StashInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 72\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0006789:;<B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u001fH\u0016J$\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\u0010\u0010+\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030-0,H\u0016J\b\u0010.\u001a\u00020/H\u0016J\u001e\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u00032\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001f03H\u0016J \u00104\u001a\u00020\u001f*\u00020!2\u0006\u00105\u001a\u0002062\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030#H\u0002R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006="}, d2={"Lgit4idea/stash/ui/GitStashProvider;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider;", "Lgit4idea/ui/StashInfo;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "applyAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getApplyAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "dataClass", "Ljava/lang/Class;", "getDataClass", "()Ljava/lang/Class;", "iconCache", "Lcom/intellij/vcs/log/ui/render/LabelIconCache;", "popAction", "getPopAction", "getProject", "()Lcom/intellij/openapi/project/Project;", "stashCache", "Lgit4idea/stash/GitStashCache;", "getStashCache", "()Lgit4idea/stash/GitStashCache;", "stashTracker", "Lgit4idea/stash/GitStashTracker;", "getStashTracker", "()Lgit4idea/stash/GitStashTracker;", "buildPatchesTree", "", "modelBuilder", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "createRootNode", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "getData", "", "dataId", "", "selectedObjects", "Ljava/util/stream/Stream;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$PatchObject;", "isEmpty", "", "subscribeToPatchesListChanges", "disposable", "listener", "Lkotlin/Function0;", "insertErrorNode", "error", "Lcom/intellij/openapi/vcs/VcsException;", "Companion", "GitStashChange", "MyTag", "StashInfoChangesBrowserNode", "StashObject", "StashRepositoryChangesBrowserNode", "intellij.vcs.git"})
public final class GitStashProvider
implements SavedPatchesProvider<StashInfo>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LabelIconCache iconCache;
    @NotNull
    private static final String GIT_STASH_APPLY_ACTION = "Git.Stash.Apply";
    @NotNull
    private static final String GIT_STASH_POP_ACTION = "Git.Stash.Pop";

    public GitStashProvider(@NotNull Project project, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.project = project;
        this.iconCache = new LabelIconCache();
        Disposer.register((Disposable)parent, (Disposable)this);
        this.getStashTracker().addListener(new GitStashTrackerListener(){

            @Override
            public void stashesUpdated() {
                this.getStashCache().preloadStashes$intellij_vcs_git();
            }
        }, this);
        this.getStashCache().preloadStashes$intellij_vcs_git();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final GitStashTracker getStashTracker() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitStashTracker> serviceClass$iv = GitStashTracker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        return (GitStashTracker)object;
    }

    private final GitStashCache getStashCache() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitStashCache> serviceClass$iv = GitStashCache.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        return (GitStashCache)object;
    }

    @NotNull
    public Class<StashInfo> getDataClass() {
        return StashInfo.class;
    }

    @NotNull
    public AnAction getApplyAction() {
        AnAction anAction = ActionManager.getInstance().getAction(GIT_STASH_APPLY_ACTION);
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getInstance().getAction(GIT_STASH_APPLY_ACTION)");
        return anAction;
    }

    @NotNull
    public AnAction getPopAction() {
        AnAction anAction = ActionManager.getInstance().getAction(GIT_STASH_POP_ACTION);
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getInstance().getAction(GIT_STASH_POP_ACTION)");
        return anAction;
    }

    public void subscribeToPatchesListChanges(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.getStashTracker().addListener(new GitStashTrackerListener(listener2){
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.$listener = $listener;
            }

            public void stashesUpdated() {
                this.$listener.invoke();
            }
        }, disposable);
    }

    public boolean isEmpty() {
        return !GitStashTrackerKt.isNotEmpty(this.getStashTracker());
    }

    public void buildPatchesTree(@NotNull TreeModelBuilder modelBuilder) {
        Intrinsics.checkNotNullParameter((Object)modelBuilder, (String)"modelBuilder");
        Map<VirtualFile, GitStashTracker.Stashes> stashesMap = this.getStashTracker().getStashes();
        String string = GitBundle.message("stash.root.node.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"stash.root.node.title\")");
        SavedPatchesTree.TagWithCounterChangesBrowserNode stashesRoot = new SavedPatchesTree.TagWithCounterChangesBrowserNode(string, false, null, 6, null);
        modelBuilder.insertSubtreeRoot((ChangesBrowserNode)stashesRoot);
        for (Map.Entry<VirtualFile, GitStashTracker.Stashes> entry : stashesMap.entrySet()) {
            ChangesBrowserNode<?> changesBrowserNode;
            VirtualFile root = entry.getKey();
            GitStashTracker.Stashes stashesList = entry.getValue();
            if (!(stashesMap.size() <= 1 || stashesList instanceof GitStashTracker.Stashes.Loaded && ((GitStashTracker.Stashes.Loaded)stashesList).getStashes().isEmpty())) {
                if (this.createRootNode(root) != null) {
                    ChangesBrowserNode<?> changesBrowserNode2;
                    ChangesBrowserNode<?> it = changesBrowserNode2;
                    boolean bl = false;
                    modelBuilder.insertSubtreeRoot(it, (ChangesBrowserNode)stashesRoot);
                    changesBrowserNode = changesBrowserNode2;
                } else {
                    changesBrowserNode = (ChangesBrowserNode)stashesRoot;
                }
            } else {
                changesBrowserNode = (ChangesBrowserNode<?>)stashesRoot;
            }
            ChangesBrowserNode<?> rootNode = changesBrowserNode;
            GitStashTracker.Stashes stashes = stashesList;
            if (stashes instanceof GitStashTracker.Stashes.Error) {
                this.insertErrorNode(modelBuilder, ((GitStashTracker.Stashes.Error)stashesList).getError(), rootNode);
                continue;
            }
            if (!(stashes instanceof GitStashTracker.Stashes.Loaded)) continue;
            for (StashInfo stash : ((GitStashTracker.Stashes.Loaded)stashesList).getStashes()) {
                modelBuilder.insertSubtreeRoot((ChangesBrowserNode)new StashInfoChangesBrowserNode(new StashObject(stash)), rootNode);
            }
        }
    }

    private final ChangesBrowserNode<?> createRootNode(VirtualFile root) {
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForRootQuick(root);
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository = gitRepository;
        return (ChangesBrowserNode)new StashRepositoryChangesBrowserNode(repository);
    }

    private final void insertErrorNode(TreeModelBuilder $this$insertErrorNode, VcsException error, ChangesBrowserNode<?> parent) {
        ChangesBrowserStringNode errorNode = new ChangesBrowserStringNode(error.getLocalizedMessage(), SimpleTextAttributes.ERROR_ATTRIBUTES);
        $this$insertErrorNode.insertSubtreeRoot((ChangesBrowserNode)errorNode, parent);
    }

    @Nullable
    public Object getData(@NotNull String dataId, @NotNull Stream<SavedPatchesProvider.PatchObject<?>> selectedObjects) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        Intrinsics.checkNotNullParameter(selectedObjects, (String)"selectedObjects");
        if (GitStashActionsKt.getSTASH_INFO().is(dataId)) {
            StreamEx streamEx = StreamEx.of(selectedObjects.map(arg_0 -> GitStashProvider.getData$lambda$1((Function1)getData.1.INSTANCE, arg_0)));
            Intrinsics.checkNotNullExpressionValue((Object)streamEx, (String)"of(selectedObjects.map(S\u2026er.PatchObject<*>::data))");
            return CollectionsKt.toList((Iterable)CollectionsKt.filterIsInstance((Iterable)((Iterable)streamEx), this.getDataClass()));
        }
        return null;
    }

    public void dispose() {
        this.getStashCache().clear$intellij_vcs_git();
    }

    private static final Object getData$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/stash/ui/GitStashProvider$MyTag;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "text", "", "hash", "Lcom/intellij/vcs/log/Hash;", "(Ljava/lang/String;Lcom/intellij/vcs/log/Hash;)V", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class MyTag
    implements ChangesBrowserNode.Tag {
        @NotNull
        private final String text;
        @NotNull
        private final Hash hash;

        public MyTag(@Nls @NotNull String text, @NotNull Hash hash) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            this.text = text;
            this.hash = hash;
        }

        @NotNull
        public String toString() {
            return this.text;
        }

        private final String component1() {
            return this.text;
        }

        private final Hash component2() {
            return this.hash;
        }

        @NotNull
        public final MyTag copy(@Nls @NotNull String text, @NotNull Hash hash) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return new MyTag(text, hash);
        }

        public static /* synthetic */ MyTag copy$default(MyTag myTag, String string, Hash hash, int n, Object object) {
            if ((n & 1) != 0) {
                string = myTag.text;
            }
            if ((n & 2) != 0) {
                hash = myTag.hash;
            }
            return myTag.copy(string, hash);
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.hash.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MyTag)) {
                return false;
            }
            MyTag myTag = (MyTag)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)myTag.text)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.hash, (Object)myTag.hash);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B\u0011\u0012\n\u0010\u0004\u001a\u00060\u0002R\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016R\u0012\u0010\u0004\u001a\u00060\u0002R\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/stash/ui/GitStashProvider$StashInfoChangesBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lgit4idea/stash/ui/GitStashProvider$StashObject;", "Lgit4idea/stash/ui/GitStashProvider;", "stash", "(Lgit4idea/stash/ui/GitStashProvider$StashObject;)V", "getTextPresentation", "", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "intellij.vcs.git"})
    private static final class StashInfoChangesBrowserNode
    extends ChangesBrowserNode<StashObject> {
        @NotNull
        private final StashObject stash;

        public StashInfoChangesBrowserNode(@NotNull StashObject stash) {
            Intrinsics.checkNotNullParameter((Object)stash, (String)"stash");
            super((Object)stash);
            this.stash = stash;
        }

        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
            renderer2.append(StashInfo.Companion.getSubject(this.stash.getData()));
            Object[] objectArray = new Object[]{this.stash.getData().getStash(), DateFormatUtil.formatDate((long)this.stash.getData().getAuthorTime()), DateFormatUtil.formatTime((long)this.stash.getData().getAuthorTime())};
            renderer2.setToolTipText(VcsBundle.message((String)"saved.patch.created.on.date.at.time.tooltip", (Object[])objectArray));
        }

        @NotNull
        public String getTextPresentation() {
            return StashInfo.Companion.getSubject(this.stash.getData());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0014R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgit4idea/stash/ui/GitStashProvider$StashRepositoryChangesBrowserNode;", "Lcom/intellij/dvcs/ui/RepositoryChangesBrowserNode;", "repository", "Lgit4idea/repo/GitRepository;", "(Lgit4idea/repo/GitRepository;)V", "stashCount", "Lcom/intellij/openapi/util/ClearableLazyValue;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getCountText", "", "resetCounters", "", "intellij.vcs.git"})
    private static final class StashRepositoryChangesBrowserNode
    extends RepositoryChangesBrowserNode {
        @NotNull
        private final ClearableLazyValue<Integer> stashCount;

        public StashRepositoryChangesBrowserNode(@NotNull GitRepository repository) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            super((Repository)repository, null, 2, null);
            ClearableLazyValue clearableLazyValue = ClearableLazyValue.create(() -> StashRepositoryChangesBrowserNode.stashCount$lambda$0(this));
            Intrinsics.checkNotNullExpressionValue((Object)clearableLazyValue, (String)"create {\n      VcsTreeMo\u2026t::class.java).size\n    }");
            this.stashCount = clearableLazyValue;
        }

        @NotNull
        protected String getCountText() {
            return FontUtil.spaceAndThinSpace() + this.stashCount.getValue();
        }

        protected void resetCounters() {
            super.resetCounters();
            this.stashCount.drop();
        }

        private static final Integer stashCount$lambda$0(StashRepositoryChangesBrowserNode this$0) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            return VcsTreeModelData.children((ChangesBrowserNode)((ChangesBrowserNode)this$0)).userObjects(StashObject.class).size();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0016J\u0012\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\u001dH\u0002R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lgit4idea/stash/ui/GitStashProvider$StashObject;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$PatchObject;", "Lgit4idea/ui/StashInfo;", "data", "(Lgit4idea/stash/ui/GitStashProvider;Lgit4idea/ui/StashInfo;)V", "getData", "()Lgit4idea/ui/StashInfo;", "cachedChanges", "", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$ChangeObject;", "createPainter", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$PatchObject$Painter;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeCellRenderer;", "row", "", "selected", "", "getDiffPreviewTitle", "", "changeName", "loadChanges", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$LoadingResult;", "toChangeObjects", "", "Lgit4idea/stash/ui/GitStashProvider$GitStashChange;", "Lgit4idea/stash/GitStashCache$StashData$Changes;", "intellij.vcs.git"})
    public final class StashObject
    implements SavedPatchesProvider.PatchObject<StashInfo> {
        @NotNull
        private final StashInfo data;

        public StashObject(StashInfo data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @NotNull
        public StashInfo getData() {
            return this.data;
        }

        @Nullable
        public Collection<SavedPatchesProvider.ChangeObject> cachedChanges() {
            GitStashCache.StashData.Changes changes = GitStashProvider.this.getStashCache().getCachedData(this.getData());
            return changes != null ? this.toChangeObjects(changes) : null;
        }

        @Nullable
        public CompletableFuture<SavedPatchesProvider.LoadingResult> loadChanges() {
            CompletionStage processResults2;
            block0: {
                CompletableFuture<GitStashCache.StashData> loadStashData;
                CompletableFuture<GitStashCache.StashData> completableFuture = loadStashData = GitStashProvider.this.getStashCache().loadStashData(this.getData());
                CompletionStage completionStage = processResults2 = completableFuture != null ? completableFuture.thenApply(arg_0 -> StashObject.loadChanges$lambda$0((Function1)new Function1<GitStashCache.StashData, SavedPatchesProvider.LoadingResult>(this){
                    final /* synthetic */ StashObject this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final SavedPatchesProvider.LoadingResult invoke(GitStashCache.StashData stashData) {
                        SavedPatchesProvider.LoadingResult loadingResult;
                        GitStashCache.StashData stashData2 = stashData;
                        if (stashData2 instanceof GitStashCache.StashData.Changes) {
                            Intrinsics.checkNotNullExpressionValue((Object)stashData, (String)"stashData");
                            loadingResult = (SavedPatchesProvider.LoadingResult)new SavedPatchesProvider.LoadingResult.Changes((Collection)StashObject.access$toChangeObjects(this.this$0, (GitStashCache.StashData.Changes)stashData));
                        } else if (stashData2 instanceof GitStashCache.StashData.Error) {
                            loadingResult = (SavedPatchesProvider.LoadingResult)new SavedPatchesProvider.LoadingResult.Error(((GitStashCache.StashData.Error)stashData).getError());
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        return loadingResult;
                    }
                }, arg_0)) : null;
                if (completionStage == null) break block0;
                Companion.propagateCancellationTo((CompletableFuture<?>)completionStage, loadStashData);
            }
            return processResults2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<GitStashChange> toChangeObjects(GitStashCache.StashData.Changes $this$toChangeObjects) {
            void $this$flatMapTo$iv$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$toChangeObjects.getChanges();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Change change = (Change)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new GitStashChange((Change)it, null));
            }
            List stashChanges = (List)destination$iv$iv;
            Iterable $this$flatMap$iv = $this$toChangeObjects.getParentCommits();
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                GitCommit parent = (GitCommit)((Object)element$iv$iv);
                boolean bl = false;
                String string = parent.getSubject();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parent.subject");
                String string2 = StringUtil.capitalize((String)StringsKt.substringBefore$default((String)string, (String)":", null, (int)2, null));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capitalize(parent.subject.substringBefore(\":\"))");
                Hash hash = parent.getId();
                Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"parent.id");
                ChangesBrowserNode.Tag tag = new MyTag(string2, hash);
                Collection collection = parent.getChanges();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"parent.changes");
                Iterable $this$map$iv2 = collection;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Change change = (Change)item$iv$iv;
                    Collection collection2 = destination$iv$iv3;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection2.add(new GitStashChange((Change)it, tag));
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List otherChanges = (List)destination$iv$iv2;
            return CollectionsKt.plus((Collection)stashChanges, (Iterable)otherChanges);
        }

        @NotNull
        public String getDiffPreviewTitle(@Nullable String changeName) {
            String string;
            String string2;
            String string3 = changeName;
            if (string3 != null) {
                String name = string3;
                boolean bl = false;
                Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.getData().getStash()), name};
                v1 = GitBundle.message("stash.editor.diff.preview.id.change.title", objectArray);
            } else {
                v1 = string2 = null;
            }
            if (string2 == null) {
                String string4 = GitBundle.message("stash.editor.diff.preview.empty.title", new Object[0]);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"stash.editor.diff.preview.empty.title\")");
            } else {
                string = string2;
            }
            return string;
        }

        @NotNull
        public SavedPatchesProvider.PatchObject.Painter createPainter(@NotNull ChangesTree tree2, @NotNull ChangesTreeCellRenderer renderer2, int row, boolean selected) {
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
            GitStashPainter painter = new GitStashPainter(tree2, renderer2, GitStashProvider.this.iconCache);
            painter.customise(this.getData(), row, selected);
            return painter;
        }

        private static final SavedPatchesProvider.LoadingResult loadChanges$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (SavedPatchesProvider.LoadingResult)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ List access$toChangeObjects(StashObject $this, GitStashCache.StashData.Changes $receiver) {
            return $this.toChangeObjects($receiver);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\u0017\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lgit4idea/stash/ui/GitStashProvider$GitStashChange;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$ChangeObject;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "changeTag", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "(Lcom/intellij/openapi/vcs/changes/Change;Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;)V", "originalFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "getOriginalFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "asChange", "createDiffRequestProducer", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "project", "Lcom/intellij/openapi/project/Project;", "createDiffWithLocalRequestProducer", "useBeforeVersion", "", "getFilePath", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "getTag", "prepareChangeContext", "", "Lcom/intellij/openapi/util/Key;", "", "intellij.vcs.git"})
    public static final class GitStashChange
    implements SavedPatchesProvider.ChangeObject {
        @NotNull
        private final Change change;
        @Nullable
        private final ChangesBrowserNode.Tag changeTag;

        public GitStashChange(@NotNull Change change, @Nullable ChangesBrowserNode.Tag changeTag) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            this.change = change;
            this.changeTag = changeTag;
        }

        @Nullable
        public ChangeDiffRequestChain.Producer createDiffRequestProducer(@Nullable Project project) {
            return (ChangeDiffRequestChain.Producer)ChangeDiffRequestProducer.create((Project)project, (Change)this.change, this.prepareChangeContext());
        }

        @Nullable
        public ChangeDiffRequestChain.Producer createDiffWithLocalRequestProducer(@Nullable Project project, boolean useBeforeVersion) {
            Change change = ShowDiffWithLocalAction.getChangeWithLocal((Change)this.change, (boolean)useBeforeVersion);
            if (change == null) {
                return null;
            }
            Change changeWithLocal = change;
            return (ChangeDiffRequestChain.Producer)ChangeDiffRequestProducer.create((Project)project, (Change)changeWithLocal, this.prepareChangeContext());
        }

        @NotNull
        public Change asChange() {
            return this.change;
        }

        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = ChangesUtil.getFilePath((Change)this.change);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(change)");
            return filePath;
        }

        @Nullable
        public FilePath getOriginalFilePath() {
            return ChangesUtil.getBeforePath((Change)this.change);
        }

        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.change.getFileStatus();
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"change.fileStatus");
            return fileStatus;
        }

        @Nullable
        public ChangesBrowserNode.Tag getTag() {
            return this.changeTag;
        }

        private final Map<Key<?>, Object> prepareChangeContext() {
            Map context;
            block0: {
                context = new LinkedHashMap();
                ChangesBrowserNode.Tag tag = this.changeTag;
                if (tag == null) break block0;
                ChangesBrowserNode.Tag it = tag;
                boolean bl = false;
                Map map2 = context;
                Key key = ChangeDiffRequestProducer.TAG_KEY;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"TAG_KEY");
                map2.put(key, it);
            }
            return context;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/stash/ui/GitStashProvider$Companion;", "", "()V", "GIT_STASH_APPLY_ACTION", "", "GIT_STASH_POP_ACTION", "propagateCancellationTo", "", "Ljava/util/concurrent/CompletableFuture;", "future", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public final void propagateCancellationTo(@NotNull CompletableFuture<?> $this$propagateCancellationTo, @NotNull CompletableFuture<?> future2) {
            Intrinsics.checkNotNullParameter($this$propagateCancellationTo, (String)"<this>");
            Intrinsics.checkNotNullParameter(future2, (String)"future");
            $this$propagateCancellationTo.whenComplete((arg_0, arg_1) -> Companion.propagateCancellationTo$lambda$0((Function2)new Function2<Object, Throwable, Unit>(future2){
                final /* synthetic */ CompletableFuture<?> $future;
                {
                    this.$future = $future;
                    super(2);
                }

                public final void invoke(Object object, Throwable t) {
                    if (t instanceof CancellationException || t instanceof ProcessCanceledException) {
                        this.$future.cancel(false);
                    }
                }
            }, arg_0, arg_1));
        }

        private static final void propagateCancellationTo$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

