/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitStashTrackerListener;
import git4idea.stash.GitStashUtils;
import git4idea.stash.ui.GitStashContentProviderKt;
import git4idea.ui.StashInfo;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0001J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u000eJ\u0006\u0010\u001d\u001a\u00020\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lgit4idea/stash/GitStashTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "disposableFlag", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lgit4idea/stash/GitStashTrackerListener;", "kotlin.jvm.PlatformType", "<set-?>", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lgit4idea/stash/GitStashTracker$Stashes;", "stashes", "getStashes", "()Ljava/util/Map;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "addListener", "", "listener", "disposable", "dispose", "", "Lgit4idea/ui/StashInfo;", "root", "scheduleRefresh", "Companion", "Stashes", "intellij.vcs.git"})
public final class GitStashTracker
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CheckedDisposable disposableFlag;
    @NotNull
    private final EventDispatcher<GitStashTrackerListener> eventDispatcher;
    @NotNull
    private final MergingUpdateQueue updateQueue;
    @NotNull
    private Map<VirtualFile, ? extends Stashes> stashes;
    @NotNull
    private static final Logger LOG;

    public GitStashTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable()");
        this.disposableFlag = checkedDisposable;
        EventDispatcher eventDispatcher = EventDispatcher.create(GitStashTrackerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(GitStashTrackerListener::class.java)");
        this.eventDispatcher = eventDispatcher;
        this.updateQueue = new MergingUpdateQueue("GitStashTracker", 300, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.stashes = MapsKt.emptyMap();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection connection = messageBusConnection;
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        connection.subscribe(topic, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                boolean bl;
                block8: {
                    Intrinsics.checkNotNullParameter(events, (String)"events");
                    List<GitRepository> list2 = GitRepositoryManager.getInstance(project).getRepositories();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance(project).repositories");
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean bl2;
                            block7: {
                                GitRepository repo = (GitRepository)element$iv;
                                boolean bl3 = false;
                                Iterable $this$any$iv2 = events;
                                boolean $i$f$any2 = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv2) {
                                        VFileEvent e = (VFileEvent)element$iv2;
                                        boolean bl4 = false;
                                        if (!repo.getRepositoryFiles().isStashReflogFile(e.getPath())) continue;
                                        bl2 = true;
                                        break block7;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (!bl2) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    this.scheduleRefresh();
                }
            }
        });
        Topic topic2 = ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VCS_CONFIGURATION_CHANGED");
        connection.subscribe(topic2, () -> GitStashTracker._init_$lambda$0(this));
        Topic<GitRepositoryChangeListener> topic3 = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic3, (String)"GIT_REPO_CHANGE");
        connection.subscribe(topic3, arg_0 -> GitStashTracker._init_$lambda$1(this, arg_0));
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.disposableFlag));
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.scheduleRefresh();
        }
    }

    @NotNull
    public final Map<VirtualFile, Stashes> getStashes() {
        return this.stashes;
    }

    public final void scheduleRefresh() {
        if (!GitStashContentProviderKt.isStashToolWindowEnabled(this.project)) {
            return;
        }
        this.updateQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)"update", () -> GitStashTracker.scheduleRefresh$lambda$2(this)));
    }

    public final void addListener(@NotNull GitStashTrackerListener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.eventDispatcher.addListener((EventListener)listener2, disposable);
    }

    @NotNull
    public final List<StashInfo> getStashes(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Stashes stashes = this.stashes.get(root);
        return stashes instanceof Stashes.Loaded ? ((Stashes.Loaded)stashes).getStashes() : CollectionsKt.emptyList();
    }

    public void dispose() {
        this.stashes = MapsKt.emptyMap();
    }

    private static final void _init_$lambda$0(GitStashTracker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scheduleRefresh();
    }

    private static final void _init_$lambda$1(GitStashTracker this$0, GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.scheduleRefresh();
    }

    private static final void scheduleRefresh$lambda$2(GitStashTracker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map newStashes = new LinkedHashMap();
        for (GitRepository repo : GitRepositoryManager.getInstance(this$0.project).getRepositories()) {
            Map map2;
            Object object;
            try {
                Map map3 = newStashes;
                Intrinsics.checkNotNullExpressionValue((Object)repo.getRoot(), (String)"repo.root");
                Project project = this$0.project;
                VirtualFile virtualFile = repo.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repo.root");
                object = new Stashes.Loaded(GitStashUtils.loadStashStack(project, virtualFile));
                map3.put(map2, object);
            }
            catch (VcsException e) {
                map2 = newStashes;
                Intrinsics.checkNotNullExpressionValue((Object)repo.getRoot(), (String)"repo.root");
                Stashes.Error error = new Stashes.Error(e);
                map2.put(object, error);
                LOG.warn((Throwable)e);
            }
        }
        BaseSingleTaskControllerKt.runInEdt((CheckedDisposable)this$0.disposableFlag, (Function0)((Function0)new Function0<Unit>(this$0, (Map<VirtualFile, Stashes>)newStashes){
            final /* synthetic */ GitStashTracker this$0;
            final /* synthetic */ Map<VirtualFile, Stashes> $newStashes;
            {
                this.this$0 = $receiver;
                this.$newStashes = $newStashes;
                super(0);
            }

            public final void invoke() {
                GitStashTracker.access$setStashes$p(this.this$0, this.$newStashes);
                ((GitStashTrackerListener)GitStashTracker.access$getEventDispatcher$p(this.this$0).getMulticaster()).stashesUpdated();
            }
        }));
    }

    public static final /* synthetic */ void access$setStashes$p(GitStashTracker $this, Map map2) {
        $this.stashes = map2;
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(GitStashTracker $this) {
        return $this.eventDispatcher;
    }

    static {
        Logger logger = Logger.getInstance(GitStashTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(GitStashTracker::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/stash/GitStashTracker$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/stash/GitStashTracker$Stashes;", "", "()V", "Error", "Loaded", "Lgit4idea/stash/GitStashTracker$Stashes$Error;", "Lgit4idea/stash/GitStashTracker$Stashes$Loaded;", "intellij.vcs.git"})
    public static abstract class Stashes {
        private Stashes() {
        }

        public /* synthetic */ Stashes(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/stash/GitStashTracker$Stashes$Loaded;", "Lgit4idea/stash/GitStashTracker$Stashes;", "stashes", "", "Lgit4idea/ui/StashInfo;", "(Ljava/util/List;)V", "getStashes", "()Ljava/util/List;", "intellij.vcs.git"})
        public static final class Loaded
        extends Stashes {
            @NotNull
            private final List<StashInfo> stashes;

            public Loaded(@NotNull List<StashInfo> stashes) {
                Intrinsics.checkNotNullParameter(stashes, (String)"stashes");
                super(null);
                this.stashes = stashes;
            }

            @NotNull
            public final List<StashInfo> getStashes() {
                return this.stashes;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/stash/GitStashTracker$Stashes$Error;", "Lgit4idea/stash/GitStashTracker$Stashes;", "error", "Lcom/intellij/openapi/vcs/VcsException;", "(Lcom/intellij/openapi/vcs/VcsException;)V", "getError", "()Lcom/intellij/openapi/vcs/VcsException;", "intellij.vcs.git"})
        public static final class Error
        extends Stashes {
            @NotNull
            private final VcsException error;

            public Error(@NotNull VcsException error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final VcsException getError() {
                return this.error;
            }
        }
    }
}

