/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.changes.ui.LoadingCommittedChangeListPanel;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.Hash;
import git4idea.GitCommit;
import git4idea.GitStashUsageCollector;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitStashUtils;
import git4idea.stash.UnstashConflictResolver;
import git4idea.ui.StashInfo;
import git4idea.util.GitUIUtil;
import git4idea.util.GitUntrackedFilesHelper;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\"\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0007JF\u0010\u000e\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0007J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J2\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0007JB\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$H\u0007J \u0010%\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0004H\u0007\u00a8\u0006'"}, d2={"Lgit4idea/stash/GitStashOperations;", "", "()V", "clearStashesWithConfirmation", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "parentComponent", "Ljava/awt/Component;", "dropStashWithConfirmation", "stash", "Lgit4idea/ui/StashInfo;", "loadStashChanges", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/vcs/changes/Change;", "", "Lgit4idea/GitCommit;", "hash", "Lcom/intellij/vcs/log/Hash;", "parentHashes", "refreshUnstashedChanges", "", "unstash", "branch", "", "popStash", "reinstateIndex", "rootAndRevisions", "", "handlerProvider", "Lkotlin/Function1;", "Lgit4idea/commands/GitLineHandler;", "conflictResolver", "Lgit4idea/merge/GitConflictResolver;", "viewStash", "compareWithLocal", "intellij.vcs.git"})
public final class GitStashOperations {
    @NotNull
    public static final GitStashOperations INSTANCE = new GitStashOperations();

    private GitStashOperations() {
    }

    @JvmStatic
    public static final boolean dropStashWithConfirmation(@NotNull Project project, @Nullable Component parentComponent, @NotNull StashInfo stash) {
        boolean confirmed;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stash, (String)"stash");
        Object[] objectArray = new Object[]{stash.getStash()};
        String string = GitBundle.message("git.unstash.drop.confirmation.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"git.unstash.dro\u2026tion.title\", stash.stash)");
        objectArray = new Object[]{stash.getStash(), stash.getMessage()};
        String string2 = GitBundle.message("git.unstash.drop.confirmation.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"git.unstash.dro\u2026           stash.message)");
        MessageDialogBuilder.YesNo dialogBuilder = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).icon(Messages.getQuestionIcon());
        Component component2 = parentComponent;
        boolean bl = confirmed = component2 != null ? dialogBuilder.ask(component2) : dialogBuilder.ask(project);
        if (!confirmed) {
            return false;
        }
        GitLineHandler h = new GitLineHandler(project, stash.getRoot(), GitCommand.STASH);
        Object[] objectArray2 = new String[]{"drop", stash.getStash()};
        h.addParameters((String[])objectArray2);
        try {
            objectArray2 = new Object[]{stash.getStash()};
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitStashOperations.dropStashWithConfirmation$lambda$0(h), GitBundle.message("unstash.dialog.remove.stash.progress.indicator.title", objectArray2), true, project);
            return true;
        }
        catch (VcsException ex) {
            GitUIUtil.showOperationError(project, ex, h.printableCommandLine());
            return false;
        }
    }

    @JvmStatic
    public static final boolean clearStashesWithConfirmation(@NotNull Project project, @NotNull VirtualFile root, @Nullable Component parentComponent) {
        boolean confirmed;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        String string = GitBundle.message("git.unstash.clear.confirmation.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"git.unstash.clear.confirmation.title\")");
        String string2 = GitBundle.message("git.unstash.clear.confirmation.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"git.unstash.clear.confirmation.message\")");
        MessageDialogBuilder.YesNo dialogBuilder = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).icon(Messages.getWarningIcon());
        Component component2 = parentComponent;
        boolean bl = confirmed = component2 != null ? dialogBuilder.ask(component2) : dialogBuilder.ask(project);
        if (!confirmed) {
            return false;
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.STASH);
        String[] stringArray = new String[]{"clear"};
        h.addParameters(stringArray);
        try {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitStashOperations.clearStashesWithConfirmation$lambda$1(h), GitBundle.message("unstash.clearing.stashes", new Object[0]), false, project);
            return true;
        }
        catch (VcsException ex) {
            GitUIUtil.showOperationError(project, ex, h.printableCommandLine());
            return false;
        }
    }

    @JvmStatic
    public static final void viewStash(@NotNull Project project, @NotNull StashInfo stash, boolean compareWithLocal) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stash, (String)"stash");
        LoadingCommittedChangeListPanel panel2 = new LoadingCommittedChangeListPanel(project);
        panel2.loadChangesInBackground(() -> GitStashOperations.viewStash$lambda$2(project, stash, compareWithLocal));
        Object[] objectArray = new Object[]{stash.getStash()};
        ChangeListViewerDialog.show((Project)project, (String)GitBundle.message("unstash.view.dialog.title", objectArray), (LoadingCommittedChangeListPanel)panel2, null, (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @NotNull
    public final Pair<Collection<Change>, List<GitCommit>> loadStashChanges(@NotNull Project project, @NotNull VirtualFile root, @NotNull Hash hash, @NotNull List<? extends Hash> parentHashes) throws VcsException {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter(parentHashes, (String)"parentHashes");
        List stashCommits = new ArrayList();
        Object[] objectArray = (Object[])parentHashes;
        Collection collection2 = CollectionsKt.listOf((Object)hash.asString());
        VirtualFile virtualFile = root;
        Project project2 = project;
        boolean $i$f$map = false;
        void var8_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Hash hash2 = (Hash)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asString());
        }
        collection = (List)destination$iv$iv;
        GitLogUtil.readFullDetailsForHashes(project2, virtualFile, CollectionsKt.plus((Collection)collection2, (Iterable)collection), new GitCommitRequirements(true, null, GitCommitRequirements.DiffInMergeCommits.FIRST_PARENT, 2, null), (Consumer<? super GitCommit>)((Consumer)arg_0 -> GitStashOperations.loadStashChanges$lambda$4(stashCommits, arg_0)));
        if (stashCommits.isEmpty()) {
            objectArray = new Object[]{root.getName(), hash.asString()};
            throw new VcsException(GitBundle.message("stash.load.changes.error", objectArray));
        }
        return new Pair((Object)((GitCommit)((Object)CollectionsKt.first((List)stashCommits))).getChanges(0), (Object)CollectionsKt.drop((Iterable)stashCommits, (int)1));
    }

    @JvmStatic
    public static final boolean unstash(@NotNull Project project, @NotNull StashInfo stash, @Nullable String branch, boolean popStash, boolean reinstateIndex) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stash, (String)"stash");
        Boolean completed2 = (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitStashOperations.unstash$lambda$5(project, stash, branch, popStash, reinstateIndex), GitBundle.message("unstash.unstashing", new Object[0]), true, project);
        if (!completed2.booleanValue()) {
            return false;
        }
        VcsNotifier.getInstance((Project)project).notifySuccess("git.unstash.patch.applied", "", VcsBundle.message((String)"patch.apply.success.applied.text", (Object[])new Object[0]));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final boolean unstash(@NotNull Project project, @NotNull Map<VirtualFile, ? extends Hash> rootAndRevisions, @NotNull Function1<? super VirtualFile, ? extends GitLineHandler> handlerProvider, @NotNull GitConflictResolver conflictResolver) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(rootAndRevisions, (String)"rootAndRevisions");
        Intrinsics.checkNotNullParameter(handlerProvider, (String)"handlerProvider");
        Intrinsics.checkNotNullParameter((Object)conflictResolver, (String)"conflictResolver");
        AutoCloseable autoCloseable = (AutoCloseable)DvcsUtil.workingTreeChangeStarted((Project)project, (String)GitBundle.message("activity.name.unstash", new Object[0]));
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            for (Map.Entry<VirtualFile, ? extends Hash> entry : rootAndRevisions.entrySet()) {
                GitCommandResult result2;
                Object object;
                VirtualFile root = entry.getKey();
                Hash hash = entry.getValue();
                GitLineHandler handler = (GitLineHandler)handlerProvider.invoke((Object)root);
                GitSimpleEventDetector indexConflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.INDEX_CONFLICT_ON_UNSTASH);
                GitSimpleEventDetector conflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT_ON_UNSTASH);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
                handler.addLineListener(indexConflictDetector);
                handler.addLineListener(conflictDetector);
                handler.addLineListener(untrackedFilesDetector);
                handler.addLineListener(localChangesDetector);
                StructuredIdeActivity activity = GitStashUsageCollector.Companion.logStashPop(project);
                Intrinsics.checkNotNullExpressionValue((Object)Git.getInstance().runCommand(handler), (String)"getInstance().runCommand(handler)");
                StructuredIdeActivity.finished$default((StructuredIdeActivity)activity, null, (int)1, null);
                if (hash != null) {
                    INSTANCE.refreshUnstashedChanges(project, hash, root);
                }
                if ((object = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFileQuick(root)) != null && (object = object.getRepositoryFiles()) != null) {
                    ((GitRepositoryFiles)object).refreshIndexFile();
                }
                if (indexConflictDetector.hasHappened()) {
                    VcsNotifier.getInstance((Project)project).notifyError("git.unstash.failed", GitBundle.message("notification.title.unstash.failed.index.conflict", new Object[0]), result2.getErrorOutputAsHtmlString(), true);
                    boolean bl2 = false;
                    return bl2;
                }
                if (conflictDetector.hasHappened()) {
                    boolean bl3 = conflictResolver.merge();
                    return bl3;
                }
                if (untrackedFilesDetector.wasMessageDetected()) {
                    GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(project, root, (Collection<String>)untrackedFilesDetector.getRelativeFilePaths(), GitBundle.message("unstash.operation.name", new Object[0]), null);
                    boolean bl4 = false;
                    return bl4;
                }
                if (localChangesDetector.wasMessageDetected()) {
                    LocalChangesWouldBeOverwrittenHelper.showErrorNotification(project, "git.stash.local.changes.detected", root, GitBundle.message("unstash.operation.name", new Object[0]), (Collection<String>)localChangesDetector.getRelativeFilePaths());
                    boolean bl5 = false;
                    return bl5;
                }
                if (result2.success()) continue;
                VcsNotifier.getInstance((Project)project).notifyError("git.unstash.failed", GitBundle.message("notification.title.unstash.failed", new Object[0]), result2.getErrorOutputAsHtmlString(), true);
                boolean bl6 = false;
                return bl6;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshUnstashedChanges(Project project, Hash hash, VirtualFile root) {
        try {
            void $this$flatMapTo$iv$iv;
            CollectConsumer consumer2 = new CollectConsumer();
            GitLogUtil.readFullDetailsForHashes(project, root, CollectionsKt.listOf((Object)hash.asString()), new GitCommitRequirements(false, GitCommitRequirements.DiffRenameLimit.NoRenames.INSTANCE, GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS), (Consumer<? super GitCommit>)((Consumer)consumer2));
            Collection collection = consumer2.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"consumer.result");
            GitCommit stashCommit = (GitCommit)((Object)CollectionsKt.first((Iterable)collection));
            Iterable $this$flatMap$iv = (Iterable)RangesKt.until((int)0, (int)stashCommit.getParents().size());
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv$iv;
                int it = element$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                Collection collection2 = stashCommit.getChanges(it);
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"stashCommit.getChanges(it)");
                Iterable list$iv$iv = collection2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List changesInStash = (List)destination$iv$iv;
            GitUtil.refreshVfs(root, changesInStash);
        }
        catch (Exception e) {
            GitStashUtils.access$getLOG$p().warn("Couldn't load changes in root [" + root + "] in stash resolved to [" + hash + "]", (Throwable)e);
        }
    }

    private static final Unit dropStashWithConfirmation$lambda$0(GitLineHandler $h) {
        Intrinsics.checkNotNullParameter((Object)$h, (String)"$h");
        Git.getInstance().runCommand($h).throwOnError(new int[0]);
        return Unit.INSTANCE;
    }

    private static final Unit clearStashesWithConfirmation$lambda$1(GitLineHandler $h) {
        Intrinsics.checkNotNullParameter((Object)$h, (String)"$h");
        Git.getInstance().runCommand($h).throwOnError(new int[0]);
        return Unit.INSTANCE;
    }

    private static final LoadingCommittedChangeListPanel.ChangelistData viewStash$lambda$2(Project $project, StashInfo $stash, boolean $compareWithLocal) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$stash, (String)"$stash");
        GitCommittedChangeList changes = GitChangeUtils.getRevisionChanges($project, GitUtil.getRootForFile($project, $stash.getRoot()), $stash.getHash().asString(), true, $compareWithLocal, false);
        return new LoadingCommittedChangeListPanel.ChangelistData((CommittedChangeList)changes, null);
    }

    private static final void loadStashChanges$lambda$4(List $stashCommits, GitCommit it) {
        Intrinsics.checkNotNullParameter((Object)$stashCommits, (String)"$stashCommits");
        Intrinsics.checkNotNullExpressionValue((Object)((Object)it), (String)"it");
        $stashCommits.add(it);
    }

    private static final Boolean unstash$lambda$5(Project $project, StashInfo $stash, String $branch, boolean $popStash, boolean $reinstateIndex) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$stash, (String)"$stash");
        return GitStashOperations.unstash($project, MapsKt.mapOf((Pair)new Pair((Object)$stash.getRoot(), (Object)$stash.getHash())), (Function1<? super VirtualFile, ? extends GitLineHandler>)((Function1)new Function1<VirtualFile, GitLineHandler>($project, $stash, $branch, $popStash, $reinstateIndex){
            final /* synthetic */ Project $project;
            final /* synthetic */ StashInfo $stash;
            final /* synthetic */ String $branch;
            final /* synthetic */ boolean $popStash;
            final /* synthetic */ boolean $reinstateIndex;
            {
                this.$project = $project;
                this.$stash = $stash;
                this.$branch = $branch;
                this.$popStash = $popStash;
                this.$reinstateIndex = $reinstateIndex;
                super(1);
            }

            @NotNull
            public final GitLineHandler invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GitStashUtils.access$createUnstashHandler(this.$project, this.$stash, this.$branch, this.$popStash, this.$reinstateIndex);
            }
        }), new UnstashConflictResolver($project, $stash));
    }
}

