/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.Git;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.stash.GitShelveChangesSaver;
import git4idea.stash.GitStashChangesSaver;
import java.util.Collection;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitChangesSaver.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final Git myGit;
    @NotNull
    protected final ProgressIndicator myProgressIndicator;
    @NotNull
    protected final String myStashMessage;
    @NotNull
    private final GitSaveChangesPolicy mySaveMethod;
    protected GitConflictResolver.Params myParams;

    @NotNull
    public static GitChangesSaver getSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator progressIndicator, @NotNull @Nls String stashMessage, @NotNull GitSaveChangesPolicy saveMethod) {
        if (saveMethod == GitSaveChangesPolicy.SHELVE) {
            return new GitShelveChangesSaver(project, git, progressIndicator, stashMessage);
        }
        return new GitStashChangesSaver(project, git, progressIndicator, stashMessage);
    }

    protected GitChangesSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator indicator, @NotNull GitSaveChangesPolicy saveMethod, @NotNull String stashMessage) {
        this.myProject = project;
        this.myGit = git;
        this.myProgressIndicator = indicator;
        this.mySaveMethod = saveMethod;
        this.myStashMessage = stashMessage;
    }

    public void saveLocalChanges(@Nullable Collection<? extends VirtualFile> rootsToSave) throws VcsException {
        if (rootsToSave == null || rootsToSave.isEmpty()) {
            return;
        }
        this.save(rootsToSave);
    }

    public void notifyLocalChangesAreNotRestored() {
        if (this.wereChangesSaved()) {
            LOG.info("Update is incomplete, changes are not restored");
            VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("git.local.changes.not.restored", GitBundle.message("restore.notification.failed.title", new Object[0]), this.getSaveMethod().selectBundleMessage(GitBundle.message("restore.notification.failed.stash.message", new Object[0]), GitBundle.message("restore.notification.failed.shelf.message", new Object[0])), (NotificationListener)new ShowSavedChangesNotificationListener());
        }
    }

    public void setConflictResolverParams(GitConflictResolver.Params params) {
        this.myParams = params;
    }

    protected abstract void save(Collection<? extends VirtualFile> var1) throws VcsException;

    public abstract void load();

    public abstract boolean wereChangesSaved();

    @NotNull
    public GitSaveChangesPolicy getSaveMethod() {
        return this.mySaveMethod;
    }

    public abstract void showSavedChanges();

    @NotNull
    protected static String getConflictRightPanelTitle() {
        return GitBundle.message("save.load.conflict.dialog.diff.right.title", new Object[0]);
    }

    @NotNull
    protected static String getConflictLeftPanelTitle() {
        return GitBundle.message("save.load.conflict.dialog.diff.left.title", new Object[0]);
    }

    protected final class ShowSavedChangesNotificationListener
    implements NotificationListener {
        protected ShowSavedChangesNotificationListener() {
        }

        public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("saver")) {
                GitChangesSaver.this.showSavedChanges();
            }
        }
    }
}

