/*
 * Decompiled with CFR 0.152.
 */
package git4idea.search;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFiltersAction;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.ide.util.TypeVisibilityStateHolder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.render.IconCompCompPanel;
import com.intellij.util.Processor;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.render.LabelIcon;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitReference;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.log.GitRefManager;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.search.GitSearchEverywhereContributor;
import git4idea.search.GitSearchEverywhereFilterConfiguration;
import git4idea.search.GitSearchEverywhereItemType;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0099\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001\f\b\u0000\u0018\u0000 :2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001:B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0014\u0010\u0019\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00020\u001b0\u001aH\u0016J$\u0010\u001c\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010!\u001a\u0004\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u0017H\u0016J\u0010\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020%H\u0016J\u0012\u0010&\u001a\f0\u0017\u00a2\u0006\u0002\b'\u00a2\u0006\u0002\b(H\u0016J\u0012\u0010)\u001a\f0\u0017\u00a2\u0006\u0002\b'\u00a2\u0006\u0002\b(H\u0016J\b\u0010*\u001a\u00020\u0017H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016J6\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\t2\u0006\u00103\u001a\u0002042\u0014\u0010\u0019\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00020\u001b0\u001aH\u0002J \u00105\u001a\u00020.2\u0006\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u00020,2\u0006\u00108\u001a\u00020\u0017H\u0016J\b\u00109\u001a\u00020.H\u0016R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006;"}, d2={"Lgit4idea/search/GitSearchEverywhereContributor;", "Lcom/intellij/ide/actions/searcheverywhere/WeightedSearchEverywhereContributor;", "", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "filter", "Lcom/intellij/ide/actions/searcheverywhere/PersistentSearchEverywhereContributorFilter;", "Lgit4idea/search/GitSearchEverywhereItemType;", "kotlin.jvm.PlatformType", "renderer", "git4idea/search/GitSearchEverywhereContributor$renderer$1", "Lgit4idea/search/GitSearchEverywhereContributor$renderer$1;", "awaitFullLogDataPack", "Lcom/intellij/vcs/log/data/DataPack;", "dataManager", "Lcom/intellij/vcs/log/data/VcsLogData;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "fetchWeightedElements", "", "pattern", "", "progressIndicator", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/ide/actions/searcheverywhere/FoundItemDescriptor;", "getActions", "", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereFiltersAction;", "onChanged", "Ljava/lang/Runnable;", "getDataForItem", "element", "dataId", "getElementsRenderer", "Ljavax/swing/ListCellRenderer;", "getFullGroupName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getGroupName", "getSearchProviderId", "getSortWeight", "", "isShownInSeparateTab", "", "processRefOfType", "ref", "Lcom/intellij/vcs/log/VcsRef;", "type", "matcher", "Lcom/intellij/util/text/Matcher;", "processSelectedItem", "selected", "modifiers", "searchText", "showInFindResults", "Companion", "intellij.vcs.git"})
public final class GitSearchEverywhereContributor
implements WeightedSearchEverywhereContributor<Object>,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PersistentSearchEverywhereContributorFilter<GitSearchEverywhereItemType> filter;
    @NotNull
    private final renderer.1 renderer;

    public GitSearchEverywhereContributor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitSearchEverywhereFilterConfiguration> serviceClass$iv = GitSearchEverywhereFilterConfiguration.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        this.filter = new PersistentSearchEverywhereContributorFilter(ArraysKt.asList((Object[])GitSearchEverywhereItemType.values()), (TypeVisibilityStateHolder)object, GitSearchEverywhereContributor::filter$lambda$0, (Function)filter.2.INSTANCE);
        this.renderer = new ListCellRenderer<Object>(this){
            @NotNull
            private final IconCompCompPanel<JLabel, JLabel> panel;
            final /* synthetic */ GitSearchEverywhereContributor this$0;
            {
                void $this$panel_u24lambda_u240;
                IconCompCompPanel iconCompCompPanel;
                this.this$0 = $receiver;
                IconCompCompPanel iconCompCompPanel2 = iconCompCompPanel = new IconCompCompPanel((JComponent)new JLabel(), (JComponent)new JLabel());
                renderer.1 var5_4 = this;
                boolean bl = false;
                $this$panel_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)0, (int)8));
                var5_4.panel = iconCompCompPanel;
            }

            @NotNull
            public Component getListCellRendererComponent(@NotNull JList<? extends Object> list2, @Nullable Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                this.panel.reset();
                this.panel.setBackground(UIUtil.getListBackground((boolean)isSelected, (boolean)cellHasFocus));
                this.panel.setIcon(value instanceof VcsRef ? (Icon)new LabelIcon(this.panel.getCenter(), JBUI.scale((int)16), this.panel.getBackground(), CollectionsKt.listOf((Object)((VcsRef)value).getType().getBackgroundColor())) : AllIcons.Vcs.CommitNode);
                JComponent jComponent = this.panel.getCenter();
                JLabel $this$getListCellRendererComponent_u24lambda_u241 = (JLabel)jComponent;
                boolean bl = false;
                $this$getListCellRendererComponent_u24lambda_u241.setFont(list2.getFont());
                Object object = value;
                $this$getListCellRendererComponent_u24lambda_u241.setText(object instanceof VcsRef ? ((VcsRef)value).getName() : (object instanceof VcsCommitMetadata ? ((VcsCommitMetadata)value).getSubject() : null));
                $this$getListCellRendererComponent_u24lambda_u241.setForeground(UIUtil.getListForeground((boolean)isSelected, (boolean)cellHasFocus));
                jComponent = this.panel.getRight();
                JLabel $this$getListCellRendererComponent_u24lambda_u242 = (JLabel)jComponent;
                boolean bl2 = false;
                $this$getListCellRendererComponent_u24lambda_u242.setFont(list2.getFont());
                object = value;
                $this$getListCellRendererComponent_u24lambda_u242.setText(object instanceof VcsRef ? this.getTrackingRemoteBranchName((VcsRef)value) : (object instanceof VcsCommitMetadata ? ((Hash)((VcsCommitMetadata)value).getId()).toShortString() : null));
                $this$getListCellRendererComponent_u24lambda_u242.setForeground(!isSelected ? NamedColorUtil.getInactiveTextColor() : UIUtil.getListForeground((boolean)isSelected, (boolean)cellHasFocus));
                return (Component)this.panel;
            }

            @NlsSafe
            private final String getTrackingRemoteBranchName(VcsRef vcsRef) {
                if (!Intrinsics.areEqual((Object)vcsRef.getType(), (Object)GitRefManager.LOCAL_BRANCH)) {
                    return null;
                }
                GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(GitSearchEverywhereContributor.access$getProject$p(this.this$0)).getRepositoryForRootQuick(vcsRef.getRoot());
                if (gitRepository == null) {
                    return null;
                }
                GitRepository repository = gitRepository;
                Object object = GitBranchUtil.getTrackInfo(repository, vcsRef.getName());
                return object != null && (object = ((GitBranchTrackInfo)object).getRemoteBranch()) != null ? ((GitReference)object).getName() : null;
            }
        };
    }

    public void fetchWeightedElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super FoundItemDescriptor<Object>> consumer2) {
        block11: {
            boolean allRootsIndexed;
            VcsLogIndex index;
            VcsLogData dataManager;
            block10: {
                CommitId commitId;
                Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
                Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
                Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
                if (!ProjectLevelVcsManager.getInstance((Project)this.project).checkVcsIsActive("Git")) {
                    return;
                }
                VcsLogManager vcsLogManager = VcsProjectLog.getInstance((Project)this.project).getLogManager();
                if (vcsLogManager == null) {
                    return;
                }
                VcsLogManager logManager = vcsLogManager;
                VcsLogData vcsLogData = logManager.getDataManager();
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"logManager.dataManager");
                dataManager = vcsLogData;
                VcsLogStorage vcsLogStorage = dataManager.getStorage();
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"dataManager.storage");
                VcsLogStorage storage = vcsLogStorage;
                VcsLogIndex vcsLogIndex = dataManager.getIndex();
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogIndex, (String)"dataManager.index");
                index = vcsLogIndex;
                DataPack dataPack = this.awaitFullLogDataPack(dataManager, progressIndicator);
                if (dataPack == null) {
                    return;
                }
                DataPack dataPack2 = dataPack;
                if (this.filter.isSelected((Object)GitSearchEverywhereItemType.COMMIT_BY_HASH) && pattern.length() >= 7 && VcsLogUtil.HASH_REGEX.matcher(pattern).matches() && (commitId = storage.findCommitId(arg_0 -> GitSearchEverywhereContributor.fetchWeightedElements$lambda$1((Function1)new Function1<CommitId, Boolean>(progressIndicator, pattern, dataPack2, storage){
                    final /* synthetic */ ProgressIndicator $progressIndicator;
                    final /* synthetic */ String $pattern;
                    final /* synthetic */ DataPack $dataPack;
                    final /* synthetic */ VcsLogStorage $storage;
                    {
                        this.$progressIndicator = $progressIndicator;
                        this.$pattern = $pattern;
                        this.$dataPack = $dataPack;
                        this.$storage = $storage;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(CommitId it) {
                        this.$progressIndicator.checkCanceled();
                        String string = it.getHash().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.hash.asString()");
                        return StringsKt.startsWith((String)string, (String)this.$pattern, (boolean)true) && DataPackUtilKt.containsAll((DataPack)this.$dataPack, (Collection)CollectionsKt.listOf((Object)it), (VcsLogStorage)this.$storage);
                    }
                }, arg_0))) != null) {
                    CommitId commitId2 = commitId;
                    boolean bl = false;
                    int id = storage.getCommitIndex(commitId2.getHash(), commitId2.getRoot());
                    dataManager.getMiniDetailsGetter().loadCommitsDataSynchronously((Iterable)CollectionsKt.listOf((Object)id), progressIndicator, arg_0 -> GitSearchEverywhereContributor.fetchWeightedElements$lambda$3$lambda$2((Function1)new Function1<VcsCommitMetadata, Unit>(consumer2){
                        final /* synthetic */ Processor<? super FoundItemDescriptor<Object>> $consumer;
                        {
                            this.$consumer = $consumer;
                            super(1);
                        }

                        public final void invoke(VcsCommitMetadata it) {
                            this.$consumer.process((Object)new FoundItemDescriptor((Object)it, GitSearchEverywhereItemType.COMMIT_BY_HASH.getWeight()));
                        }
                    }, arg_0));
                }
                MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern)).withCaseSensitivity(NameUtil.MatchingCaseSensitivity.NONE).typoTolerant().build();
                dataPack2.getRefsModel().stream().forEach(arg_0 -> GitSearchEverywhereContributor.fetchWeightedElements$lambda$4((Function1)new Function1<VcsRef, Unit>(progressIndicator, this, matcher, consumer2){
                    final /* synthetic */ ProgressIndicator $progressIndicator;
                    final /* synthetic */ GitSearchEverywhereContributor this$0;
                    final /* synthetic */ MinusculeMatcher $matcher;
                    final /* synthetic */ Processor<? super FoundItemDescriptor<Object>> $consumer;
                    {
                        this.$progressIndicator = $progressIndicator;
                        this.this$0 = $receiver;
                        this.$matcher = $matcher;
                        this.$consumer = $consumer;
                        super(1);
                    }

                    public final void invoke(VcsRef it) {
                        this.$progressIndicator.checkCanceled();
                        VcsRefType vcsRefType = it.getType();
                        if (Intrinsics.areEqual((Object)vcsRefType, (Object)GitRefManager.LOCAL_BRANCH) ? true : Intrinsics.areEqual((Object)vcsRefType, (Object)GitRefManager.HEAD)) {
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            MinusculeMatcher minusculeMatcher = this.$matcher;
                            Intrinsics.checkNotNullExpressionValue((Object)minusculeMatcher, (String)"matcher");
                            GitSearchEverywhereContributor.access$processRefOfType(this.this$0, it, GitSearchEverywhereItemType.LOCAL_BRANCH, (Matcher)minusculeMatcher, this.$consumer);
                        } else if (Intrinsics.areEqual((Object)vcsRefType, (Object)GitRefManager.REMOTE_BRANCH)) {
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            MinusculeMatcher minusculeMatcher = this.$matcher;
                            Intrinsics.checkNotNullExpressionValue((Object)minusculeMatcher, (String)"matcher");
                            GitSearchEverywhereContributor.access$processRefOfType(this.this$0, it, GitSearchEverywhereItemType.REMOTE_BRANCH, (Matcher)minusculeMatcher, this.$consumer);
                        } else if (Intrinsics.areEqual((Object)vcsRefType, (Object)GitRefManager.TAG)) {
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            MinusculeMatcher minusculeMatcher = this.$matcher;
                            Intrinsics.checkNotNullExpressionValue((Object)minusculeMatcher, (String)"matcher");
                            GitSearchEverywhereContributor.access$processRefOfType(this.this$0, it, GitSearchEverywhereItemType.TAG, (Matcher)minusculeMatcher, this.$consumer);
                        }
                    }
                }, arg_0));
                if (!this.filter.isSelected((Object)GitSearchEverywhereItemType.COMMIT_BY_MESSAGE) || !Registry.is((String)"git.search.everywhere.commit.by.message")) break block11;
                if (pattern.length() < 3) {
                    return;
                }
                List<GitRepository> list2 = GitRepositoryManager.getInstance(this.project).getRepositories();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance(project).repositories");
                Iterable $this$all$iv = list2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v6 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl = false;
                        if (index.isIndexed(it.getRoot())) continue;
                        v6 = false;
                        break block10;
                    }
                    v6 = allRootsIndexed = true;
                }
            }
            if (!allRootsIndexed) {
                return;
            }
            IndexDataGetter indexDataGetter = index.getDataGetter();
            if (indexDataGetter != null) {
                indexDataGetter.filterMessages(VcsLogFilterObject.fromPattern$default((String)pattern, (boolean)false, (boolean)false, (int)6, null), arg_0 -> GitSearchEverywhereContributor.fetchWeightedElements$lambda$7(progressIndicator, dataManager, consumer2, arg_0));
            }
        }
    }

    private final void processRefOfType(VcsRef ref, GitSearchEverywhereItemType type, Matcher matcher, Processor<? super FoundItemDescriptor<Object>> consumer2) {
        if (!this.filter.isSelected((Object)type)) {
            return;
        }
        if (matcher.matches(ref.getName())) {
            consumer2.process((Object)new FoundItemDescriptor((Object)ref, type.getWeight()));
        }
    }

    private final DataPack awaitFullLogDataPack(VcsLogData dataManager, ProgressIndicator indicator) {
        if (!Registry.is((String)"vcs.log.keep.up.to.date")) {
            return null;
        }
        DataPack dataPack = null;
        do {
            indicator.checkCanceled();
            Intrinsics.checkNotNullExpressionValue((Object)dataManager.getDataPack(), (String)"dataManager.dataPack");
            if (dataPack.isFull()) break;
            Thread.sleep(1000L);
        } while (Intrinsics.areEqual((Object)Unit.INSTANCE, (Object)Unit.INSTANCE));
        return dataPack;
    }

    @NotNull
    public ListCellRenderer<? super Object> getElementsRenderer() {
        return this.renderer;
    }

    public boolean processSelectedItem(@NotNull Object selected, int modifiers, @NotNull String searchText) {
        Intrinsics.checkNotNullParameter((Object)selected, (String)"selected");
        Intrinsics.checkNotNullParameter((Object)searchText, (String)"searchText");
        Hash hash = null;
        VirtualFile root = null;
        Object object = selected;
        if (object instanceof VcsRef) {
            hash = ((VcsRef)selected).getCommitHash();
            root = ((VcsRef)selected).getRoot();
        } else if (object instanceof VcsCommitMetadata) {
            hash = (Hash)((VcsCommitMetadata)selected).getId();
            root = ((VcsCommitMetadata)selected).getRoot();
        } else {
            hash = null;
            root = null;
        }
        if (hash != null && root != null) {
            VcsLogContentUtil.runInMainLog((Project)this.project, arg_0 -> GitSearchEverywhereContributor.processSelectedItem$lambda$8((Function1)new Function1<MainVcsLogUi, Unit>(hash, root){
                final /* synthetic */ Hash $hash;
                final /* synthetic */ VirtualFile $root;
                {
                    this.$hash = $hash;
                    this.$root = $root;
                    super(1);
                }

                public final void invoke(MainVcsLogUi it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    VcsLogNavigationUtil.jumpToCommit((VcsLogUiEx)((VcsLogUiEx)it), (Hash)this.$hash, (VirtualFile)this.$root, (boolean)false, (boolean)true);
                }
            }, arg_0));
            return true;
        }
        return false;
    }

    @NotNull
    public List<SearchEverywhereFiltersAction<GitSearchEverywhereItemType>> getActions(@NotNull Runnable onChanged) {
        Intrinsics.checkNotNullParameter((Object)onChanged, (String)"onChanged");
        return CollectionsKt.listOf((Object)new SearchEverywhereFiltersAction(this.filter, onChanged));
    }

    @NotNull
    public String getSearchProviderId() {
        return "Vcs.Git";
    }

    @NotNull
    public String getGroupName() {
        String string = GitBundle.message("search.everywhere.group.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"search.everywhere.group.name\")");
        return string;
    }

    @NotNull
    public String getFullGroupName() {
        String string = GitBundle.message("search.everywhere.group.full.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"search.everywhere.group.full.name\")");
        return string;
    }

    public int getSortWeight() {
        return 500;
    }

    public boolean showInFindResults() {
        return false;
    }

    public boolean isShownInSeparateTab() {
        return ProjectLevelVcsManager.getInstance((Project)this.project).checkVcsIsActive("Git") && VcsProjectLog.getInstance((Project)this.project).getLogManager() != null;
    }

    @Nullable
    public Object getDataForItem(@NotNull Object element, @NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return null;
    }

    private static final String filter$lambda$0(GitSearchEverywhereItemType it) {
        return it.getDisplayName();
    }

    private static final boolean fetchWeightedElements$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void fetchWeightedElements$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void fetchWeightedElements$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void fetchWeightedElements$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void fetchWeightedElements$lambda$7(ProgressIndicator $progressIndicator, VcsLogData $dataManager, Processor $consumer, int commitIdx) {
        Intrinsics.checkNotNullParameter((Object)$progressIndicator, (String)"$progressIndicator");
        Intrinsics.checkNotNullParameter((Object)$dataManager, (String)"$dataManager");
        Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
        $progressIndicator.checkCanceled();
        $dataManager.getMiniDetailsGetter().loadCommitsDataSynchronously((Iterable)CollectionsKt.listOf((Object)commitIdx), $progressIndicator, arg_0 -> GitSearchEverywhereContributor.fetchWeightedElements$lambda$7$lambda$6((Function1)new Function1<VcsCommitMetadata, Unit>((Processor<? super FoundItemDescriptor<Object>>)$consumer){
            final /* synthetic */ Processor<? super FoundItemDescriptor<Object>> $consumer;
            {
                this.$consumer = $consumer;
                super(1);
            }

            public final void invoke(VcsCommitMetadata it) {
                this.$consumer.process((Object)new FoundItemDescriptor((Object)it, GitSearchEverywhereItemType.COMMIT_BY_MESSAGE.getWeight()));
            }
        }, arg_0));
    }

    private static final void processSelectedItem$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$processRefOfType(GitSearchEverywhereContributor $this, VcsRef ref, GitSearchEverywhereItemType type, Matcher matcher, Processor consumer2) {
        $this.processRefOfType(ref, type, matcher, (Processor<? super FoundItemDescriptor<Object>>)consumer2);
    }

    public static final /* synthetic */ Project access$getProject$p(GitSearchEverywhereContributor $this) {
        return $this.project;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lgit4idea/search/GitSearchEverywhereContributor$Companion;", "", "()V", "Factory", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/search/GitSearchEverywhereContributor$Companion$Factory;", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereContributorFactory;", "", "()V", "createContributor", "Lgit4idea/search/GitSearchEverywhereContributor;", "initEvent", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
        public static final class Factory
        implements SearchEverywhereContributorFactory<Object> {
            @NotNull
            public GitSearchEverywhereContributor createContributor(@NotNull AnActionEvent initEvent) {
                Intrinsics.checkNotNullParameter((Object)initEvent, (String)"initEvent");
                Object object = initEvent.getRequiredData(CommonDataKeys.PROJECT);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"initEvent.getRequiredData(CommonDataKeys.PROJECT)");
                Project project = (Project)object;
                return new GitSearchEverywhereContributor(project);
            }
        }
    }
}

