/*
 * Decompiled with CFR 0.152.
 */
package git4idea.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class GitRootChecker
extends VcsRootChecker {
    GitRootChecker() {
    }

    public boolean isRoot(@NotNull VirtualFile path) {
        return GitUtil.isGitRoot(path.toNioPath());
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        return GitVcs.getKey();
    }

    public boolean isVcsDir(@NotNull String dirName) {
        return dirName.equalsIgnoreCase(".git");
    }

    public boolean isIgnored(@NotNull VirtualFile root, @NotNull VirtualFile checkForIgnore) {
        GitLineHandler handler = new GitLineHandler(null, root, GitCommand.CHECK_IGNORE);
        handler.addParameters("--quiet");
        handler.addRelativeFiles(Collections.singletonList(checkForIgnore));
        return Git.getInstance().runCommand(handler).success();
    }

    @NotNull
    public List<VirtualFile> suggestDependentRoots(@NotNull VirtualFile vcsRoot) {
        try {
            GitLineHandler handler = new GitLineHandler(null, vcsRoot, GitCommand.SUBMODULE_HELPER);
            handler.addParameters("list");
            GitCommandResult result2 = Git.getInstance().runCommand(handler);
            if (!result2.success()) {
                return Collections.emptyList();
            }
            ArrayList<VirtualFile> submodules = new ArrayList<VirtualFile>();
            for (String line : result2.getOutput()) {
                StringScanner scanner = new StringScanner(line);
                scanner.tabToken();
                String path = scanner.line();
                ContainerUtil.addIfNotNull(submodules, (Object)VcsUtil.getFilePath((VirtualFile)vcsRoot, (String)path).getVirtualFile());
            }
            return submodules;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(GitRootChecker.class).warn((Throwable)e);
            return Collections.emptyList();
        }
    }
}

