/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.AbstractDataGetter;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitSingleCommitEditingAction;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.reset.GitResetOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUncommitAction
extends GitSingleCommitEditingAction {
    private static final Logger LOG = Logger.getInstance(GitUncommitAction.class);

    @Override
    protected void update(@NotNull AnActionEvent e, @NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData) {
        if (e.getPresentation().isEnabledAndVisible()) {
            if (commitEditingData.isHeadCommit()) {
                e.getPresentation().setEnabled(true);
            } else {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription(GitBundle.message("git.undo.action.description", new Object[0]));
            }
        }
    }

    @Override
    public void actionPerformedAfterChecks(@NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData) {
        LocalChangeList targetList;
        Project project = commitEditingData.getProject();
        VcsCommitMetadata commit = commitEditingData.getSelectedCommit();
        if (ChangeListManager.getInstance((Project)project).areChangeListsEnabled()) {
            ChangeListChooser chooser = new ChangeListChooser(project, GitBundle.message("git.undo.action.select.target.changelist.title", new Object[0]));
            chooser.setSuggestedName(commit.getSubject());
            if (!chooser.showAndGet()) {
                return;
            }
            targetList = chooser.getSelectedList();
        } else {
            targetList = null;
        }
        GitUncommitAction.resetInBackground(commitEditingData.getLogData(), commitEditingData.getRepository(), (VcsShortCommitDetails)commit, targetList);
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        return GitBundle.message("git.undo.action.cant.undo.commit.failure", new Object[0]);
    }

    private static void resetInBackground(final @NotNull VcsLogData data, final @NotNull GitRepository repository, final @NotNull VcsShortCommitDetails commit, final @Nullable LocalChangeList targetChangeList) {
        final Project project = repository.getProject();
        new Task.Backgroundable(project, GitBundle.message("git.undo.action.undoing.last.commit.process", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                Collection changesInCommit;
                try {
                    changesInCommit = ((VcsFullCommitDetails)AbstractDataGetter.getCommitDetails((AbstractDataGetter)data.getCommitDetailsGetter(), (Hash)((Hash)commit.getId()), (VirtualFile)commit.getRoot())).getChanges();
                }
                catch (VcsException e) {
                    String message = GitBundle.message("git.undo.action.could.not.load.changes.of.commit", ((Hash)commit.getId()).asString());
                    LOG.warn(message, (Throwable)e);
                    VcsNotifier.getInstance((Project)project).notifyError("git.could.not.load.changes.of.commit", "", message);
                    return;
                }
                GitResetOperation.OperationPresentation presentation = new GitResetOperation.OperationPresentation();
                presentation.activityName = "git.undo.action.process";
                presentation.operationTitle = "git.undo.action.operation";
                presentation.notificationSuccess = "git.undo.action.successful.notification.message";
                presentation.notificationFailure = "git.undo.action.failed.notification.title";
                Map<GitRepository, Hash> targetCommits = Collections.singletonMap(repository, (Hash)commit.getParents().get(0));
                new GitResetOperation(project, targetCommits, GitResetMode.SOFT, indicator, presentation).execute();
                if (targetChangeList != null) {
                    ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                    changeListManager.invokeAfterUpdateWithModal(true, GitBundle.message("git.undo.action.refreshing.changes.process", new Object[0]), () -> {
                        Collection<Change> changes = GitUtil.findCorrespondentLocalChanges(changeListManager, changesInCommit);
                        changeListManager.moveChangesTo(targetChangeList, changes.toArray(Change.EMPTY_CHANGE_ARRAY));
                    });
                }
            }
        }.queue();
    }
}

