/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.reset.GitNewResetDialog;
import git4idea.reset.GitOneCommitPerRepoLogAction;
import git4idea.reset.GitResetMode;
import git4idea.reset.GitResetOperation;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class GitResetAction
extends GitOneCommitPerRepoLogAction {
    protected void actionPerformed(final @NotNull Project project, final @NotNull Map<GitRepository, VcsFullCommitDetails> commits2) {
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        GitResetMode defaultMode = (GitResetMode)((Object)ObjectUtils.notNull((Object)((Object)settings.getResetMode()), (Object)((Object)GitResetMode.getDefault())));
        GitNewResetDialog dialog2 = new GitNewResetDialog(project, commits2, defaultMode);
        if (dialog2.showAndGet()) {
            final GitResetMode selectedMode = dialog2.getResetMode();
            settings.setResetMode(selectedMode);
            new Task.Backgroundable(project, GitBundle.message("git.reset.process", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    Map<GitRepository, Hash> hashes2 = commits2.keySet().stream().collect(Collectors.toMap(Function.identity(), repo -> (Hash)((VcsFullCommitDetails)commits2.get(repo)).getId()));
                    new GitResetOperation(project, hashes2, selectedMode, indicator).execute();
                }
            }.queue();
        }
    }
}

