/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.ignore.IgnoredToExcludedSynchronizer;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl;
import com.intellij.openapi.vcs.changes.VcsManagedFilesHolder;
import com.intellij.openapi.vcs.impl.projectlevelman.RecursiveFilePathSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRefreshUsageCollector;
import git4idea.index.GitIndexStatusUtilKt;
import git4idea.index.LightFileStatus;
import git4idea.repo.GitRepository;
import git4idea.status.GitRefreshListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GitUntrackedFilesHolder
implements Disposable {
    private static final Logger LOG = Logger.getInstance(GitUntrackedFilesHolder.class);
    private final Project myProject;
    private final VirtualFile myRoot;
    private final GitRepository myRepository;
    private final Set<FilePath> myUntrackedFiles = new HashSet<FilePath>();
    private final RecursiveFilePathSet myIgnoredFiles;
    private final Set<FilePath> myDirtyFiles = new HashSet<FilePath>();
    private boolean myEverythingDirty = true;
    private final MergingUpdateQueue myQueue;
    private final Object LOCK = new Object();
    private boolean myInUpdate = false;

    GitUntrackedFilesHolder(@NotNull GitRepository repository) {
        this.myRepository = repository;
        this.myProject = repository.getProject();
        this.myRoot = repository.getRoot();
        this.myIgnoredFiles = new RecursiveFilePathSet(this.myRoot.isCaseSensitive());
        this.myQueue = VcsIgnoreManagerImpl.getInstanceImpl((Project)this.myProject).getIgnoreRefreshQueue();
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myUntrackedFiles.clear();
            this.myIgnoredFiles.clear();
            this.myDirtyFiles.clear();
        }
    }

    public void add(@NotNull FilePath file2) {
        this.add(Collections.singletonList(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull Collection<? extends FilePath> files) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myUntrackedFiles.addAll(files);
            if (!this.myEverythingDirty) {
                this.myDirtyFiles.addAll(files);
            }
        }
        ChangeListManagerImpl.getInstanceImpl((Project)this.myProject).notifyUnchangedFileStatusChanged();
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NotNull Collection<? extends FilePath> files) {
        Object object = this.LOCK;
        synchronized (object) {
            files.forEach(this.myUntrackedFiles::remove);
            if (!this.myEverythingDirty) {
                this.myDirtyFiles.addAll(files);
            }
        }
        ChangeListManagerImpl.getInstanceImpl((Project)this.myProject).notifyUnchangedFileStatusChanged();
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIgnored(@NotNull Collection<? extends FilePath> files) {
        Object object = this.LOCK;
        synchronized (object) {
            files.forEach(arg_0 -> ((RecursiveFilePathSet)this.myIgnoredFiles).remove(arg_0));
            if (!this.myEverythingDirty) {
                if (ContainerUtil.exists(files, arg_0 -> ((RecursiveFilePathSet)this.myIgnoredFiles).hasAncestor(arg_0))) {
                    this.myEverythingDirty = true;
                } else {
                    this.myDirtyFiles.addAll(files);
                }
            }
        }
        ChangeListManagerImpl.getInstanceImpl((Project)this.myProject).notifyUnchangedFileStatusChanged();
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markPossiblyUntracked(@NotNull Collection<? extends FilePath> files) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myEverythingDirty) {
                return;
            }
            for (FilePath filePath : files) {
                if (!this.myIgnoredFiles.contains(filePath) && this.myIgnoredFiles.hasAncestor(filePath)) continue;
                this.myDirtyFiles.add(filePath);
            }
        }
        this.scheduleUpdate();
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Collection<VirtualFile> retrieveUntrackedFiles() throws VcsException {
        return ContainerUtil.mapNotNull(this.retrieveUntrackedFilePaths(), FilePath::getVirtualFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myEverythingDirty = true;
            this.myDirtyFiles.clear();
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInUpdateMode() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myInUpdate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<FilePath> getUntrackedFilePaths() {
        Object object = this.LOCK;
        synchronized (object) {
            return new ArrayList<FilePath>(this.myUntrackedFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<FilePath> getIgnoredFilePaths() {
        Object object = this.LOCK;
        synchronized (object) {
            return new ArrayList<FilePath>(this.myIgnoredFiles.filePaths());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsFile(@NotNull FilePath filePath) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myUntrackedFiles.contains(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsIgnoredFile(@NotNull FilePath filePath) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myIgnoredFiles.hasAncestor(filePath);
        }
    }

    @NotNull
    public Collection<FilePath> retrieveUntrackedFilePaths() throws VcsException {
        VcsIgnoreManagerImpl.getInstanceImpl((Project)this.myProject).awaitRefreshQueue();
        return this.getUntrackedFilePaths();
    }

    @NotNull
    public Collection<FilePath> retrieveIgnoredFilePaths() {
        VcsIgnoreManagerImpl.getInstanceImpl((Project)this.myProject).awaitRefreshQueue();
        return this.getIgnoredFilePaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirty() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myEverythingDirty || !this.myDirtyFiles.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdate() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.isDirty()) {
                return;
            }
            this.myInUpdate = true;
        }
        ((VcsManagedFilesHolder.VcsManagedFilesHolderListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VcsManagedFilesHolder.TOPIC)).updatingModeChanged();
        this.myQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)new ComparableObject.Impl(new Object[]{this, "update"}), this::update));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        ArrayList<FilePath> dirtyFiles;
        boolean nothingToDo;
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = nothingToDo = !this.isDirty();
            if (nothingToDo) {
                this.myInUpdate = false;
            }
            dirtyFiles = this.myEverythingDirty ? null : new ArrayList<FilePath>(this.myDirtyFiles);
            this.myDirtyFiles.clear();
            this.myEverythingDirty = false;
        }
        if (nothingToDo) {
            ((VcsManagedFilesHolder.VcsManagedFilesHolderListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VcsManagedFilesHolder.TOPIC)).updatingModeChanged();
            return;
        }
        ((GitRefreshListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, GitRefreshListener.TOPIC)).progressStarted();
        try {
            ArrayList<FilePath> newIgnored;
            HashSet<FilePath> oldIgnored;
            boolean everythingDirty = dirtyFiles == null || dirtyFiles.contains(VcsUtil.getFilePath((VirtualFile)this.myRoot));
            StructuredIdeActivity activity = GitRefreshUsageCollector.logUntrackedRefresh(this.myProject, everythingDirty);
            RefreshResult result2 = this.refreshFiles(dirtyFiles);
            activity.finished();
            this.removePathsUnderOtherRoots(result2.untracked, "unversioned");
            this.removePathsUnderOtherRoots(result2.ignored, "ignored");
            RecursiveFilePathSet dirtyScope = null;
            if (dirtyFiles != null) {
                dirtyScope = new RecursiveFilePathSet(this.myRoot.isCaseSensitive());
                dirtyScope.addAll(dirtyFiles);
            }
            Object object2 = this.LOCK;
            synchronized (object2) {
                oldIgnored = new HashSet<FilePath>(this.myIgnoredFiles.filePaths());
                this.applyRefreshResult(result2, dirtyScope, oldIgnored);
                newIgnored = new ArrayList<FilePath>(this.myIgnoredFiles.filePaths());
                this.myInUpdate = this.isDirty();
            }
            ((GitRefreshListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, GitRefreshListener.TOPIC)).repositoryUpdated(this.myRepository);
            ((VcsManagedFilesHolder.VcsManagedFilesHolderListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VcsManagedFilesHolder.TOPIC)).updatingModeChanged();
            ChangeListManagerImpl.getInstanceImpl((Project)this.myProject).notifyUnchangedFileStatusChanged();
            this.notifyExcludedSynchronizer(oldIgnored, newIgnored);
        }
        finally {
            ((GitRefreshListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, GitRefreshListener.TOPIC)).progressStopped();
        }
    }

    private void applyRefreshResult(@NotNull RefreshResult result2, @Nullable RecursiveFilePathSet dirtyScope, @NotNull Set<FilePath> oldIgnored) {
        if (dirtyScope != null) {
            this.myUntrackedFiles.removeIf(filePath -> dirtyScope.hasAncestor(filePath));
            this.myUntrackedFiles.addAll(result2.untracked);
            this.myIgnoredFiles.clear();
            for (FilePath filePath2 : oldIgnored) {
                if (dirtyScope.hasAncestor(filePath2)) continue;
                this.myIgnoredFiles.add(filePath2);
            }
            for (FilePath filePath2 : result2.ignored) {
                if (this.myIgnoredFiles.hasAncestor(filePath2)) continue;
                this.myIgnoredFiles.add(filePath2);
            }
        } else {
            this.myUntrackedFiles.clear();
            this.myUntrackedFiles.addAll(result2.untracked);
            this.myIgnoredFiles.clear();
            this.myIgnoredFiles.addAll(result2.ignored);
        }
    }

    private void notifyExcludedSynchronizer(@NotNull Set<FilePath> oldIgnored, @NotNull List<FilePath> newIgnored) {
        ArrayList<FilePath> addedIgnored = new ArrayList<FilePath>();
        for (FilePath filePath : newIgnored) {
            if (oldIgnored.contains(filePath)) continue;
            addedIgnored.add(filePath);
        }
        if (!addedIgnored.isEmpty()) {
            ((IgnoredToExcludedSynchronizer)this.myProject.getService(IgnoredToExcludedSynchronizer.class)).ignoredUpdateFinished(addedIgnored);
        }
    }

    private void removePathsUnderOtherRoots(@NotNull Collection<FilePath> untrackedFiles, @NonNls String type) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        int removedFiles = 0;
        int maxFilesToReport = 10;
        Iterator<FilePath> it = untrackedFiles.iterator();
        while (it.hasNext()) {
            FilePath filePath = it.next();
            VirtualFile root = vcsManager.getVcsRootFor(filePath);
            if (this.myRoot.equals(root)) continue;
            it.remove();
            if (++removedFiles >= maxFilesToReport) continue;
            LOG.debug(String.format("Ignoring %s file under another root: %s; root: %s; mapped root: %s", type, filePath.getPresentableUrl(), this.myRoot.getPresentableUrl(), root != null ? root.getPresentableUrl() : "null"));
        }
        if (removedFiles >= maxFilesToReport) {
            LOG.debug(String.format("Ignoring %s files under another root: %s files total", type, removedFiles));
        }
    }

    @NotNull
    private RefreshResult refreshFiles(@Nullable List<FilePath> dirty) {
        try {
            boolean withIgnored = AdvancedSettings.getBoolean((String)"vcs.process.ignored");
            List<LightFileStatus.StatusRecord> fileStatuses = GitIndexStatusUtilKt.getFileStatus(this.myProject, this.myRoot, ContainerUtil.notNullize(dirty), false, true, withIgnored);
            RefreshResult result2 = new RefreshResult();
            for (LightFileStatus.StatusRecord status : fileStatuses) {
                if (GitIndexStatusUtilKt.isUntracked(status.getIndex())) {
                    result2.untracked.add(GitUntrackedFilesHolder.getFilePath(this.myRoot, status));
                }
                if (!GitIndexStatusUtilKt.isIgnored(status.getIndex())) continue;
                result2.ignored.add(GitUntrackedFilesHolder.getFilePath(this.myRoot, status));
            }
            return result2;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return new RefreshResult();
        }
    }

    @NotNull
    private static FilePath getFilePath(@NotNull VirtualFile root, @NotNull LightFileStatus.StatusRecord status) {
        String path = status.getPath();
        return GitContentRevision.createPath(root, path, path.endsWith("/"));
    }

    @TestOnly
    public Waiter createWaiter() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        return new Waiter(this.myQueue);
    }

    private static class RefreshResult {
        @NotNull
        public final Set<FilePath> untracked = new HashSet<FilePath>();
        @NotNull
        public final Set<FilePath> ignored = new HashSet<FilePath>();

        private RefreshResult() {
        }
    }

    @TestOnly
    public static class Waiter {
        private final MergingUpdateQueue myQueue;

        public Waiter(@NotNull MergingUpdateQueue queue) {
            this.myQueue = queue;
        }

        public void waitFor() {
            CountDownLatch waiter = new CountDownLatch(1);
            this.myQueue.queue(Update.create((Object)waiter, () -> waiter.countDown()));
            ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)waiter);
            try {
                this.myQueue.waitForAllExecuted(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

