/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.GitSilentFileAdder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0016\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lgit4idea/repo/GitSilentFileAdderImpl;", "Lcom/intellij/openapi/GitSilentFileAdder;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "gitVcs", "Lgit4idea/GitVcs;", "Lorg/jetbrains/annotations/NotNull;", "pendingAddition", "", "Lcom/intellij/openapi/vcs/FilePath;", "vcsFileListenerContextHelper", "Lcom/intellij/openapi/vcs/VcsFileListenerContextHelper;", "kotlin.jvm.PlatformType", "vcsManager", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "addFile", "", "filePath", "addToVcs", "filePaths", "", "finish", "markFileForAdding", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/io/File;", "isDirectory", "", "path", "Ljava/nio/file/Path;", "", "intellij.vcs.git"})
public final class GitSilentFileAdderImpl
implements GitSilentFileAdder {
    @NotNull
    private final Project project;
    @NotNull
    private final GitVcs gitVcs;
    private final ProjectLevelVcsManager vcsManager;
    private final VcsFileListenerContextHelper vcsFileListenerContextHelper;
    @NotNull
    private final Set<FilePath> pendingAddition;

    public GitSilentFileAdderImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        GitVcs gitVcs = GitVcs.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"getInstance(project)");
        this.gitVcs = gitVcs;
        this.vcsManager = ProjectLevelVcsManager.getInstance((Project)this.project);
        this.vcsFileListenerContextHelper = VcsFileListenerContextHelper.getInstance((Project)this.project);
        this.pendingAddition = new HashSet();
    }

    public void markFileForAdding(@NotNull String path, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FilePath filePath = VcsUtil.getFilePath((String)path, (boolean)isDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(path, isDirectory)");
        this.addFile(filePath);
    }

    public void markFileForAdding(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (file2.isInLocalFileSystem()) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)file2);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(file)");
            this.addFile(filePath);
        }
    }

    public void markFileForAdding(@NotNull File file2, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FilePath filePath = VcsUtil.getFilePath((File)file2, (boolean)isDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(file, isDirectory)");
        this.addFile(filePath);
    }

    public void markFileForAdding(@NotNull Path path, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FilePath filePath = VcsUtil.getFilePath((Path)path, (boolean)isDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(path, isDirectory)");
        this.addFile(filePath);
    }

    private final void addFile(FilePath filePath) {
        VcsRoot vcsRoot = this.vcsManager.getVcsRootObjectFor(filePath);
        if (vcsRoot == null || !Intrinsics.areEqual((Object)vcsRoot.getVcs(), (Object)((Object)this.gitVcs))) {
            return;
        }
        if (filePath.isDirectory()) {
            this.vcsFileListenerContextHelper.ignoreAddedRecursive((Collection)CollectionsKt.listOf((Object)filePath));
        } else {
            this.vcsFileListenerContextHelper.ignoreAdded((Collection)CollectionsKt.listOf((Object)filePath));
        }
        this.pendingAddition.add(filePath);
    }

    public void finish() {
        this.vcsFileListenerContextHelper.clearContext();
        List filesToAdd = CollectionsKt.toList((Iterable)this.pendingAddition);
        this.pendingAddition.clear();
        BackgroundTaskUtil.executeOnPooledThread((Disposable)((Disposable)this.project), () -> GitSilentFileAdderImpl.finish$lambda$0(this, filesToAdd));
    }

    private final void addToVcs(Collection<? extends FilePath> filePaths) {
        Map<VirtualFile, List<FilePath>> map2 = GitUtil.sortFilePathsByGitRoot(this.project, filePaths);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"sortFilePathsByGitRoot(project, filePaths)");
        Map<VirtualFile, List<FilePath>> map3 = map2;
        for (Map.Entry<VirtualFile, List<FilePath>> entry : map3.entrySet()) {
            VirtualFile root = entry.getKey();
            List<FilePath> rootPaths = entry.getValue();
            try {
                GitFileUtils.addPaths(this.project, root, (Collection<? extends FilePath>)rootPaths);
            }
            catch (VcsException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitSilentFileAdderImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.warn((Throwable)e);
            }
        }
    }

    private static final void finish$lambda$0(GitSilentFileAdderImpl this$0, List $filesToAdd) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$filesToAdd, (String)"$filesToAdd");
        this$0.addToVcs($filesToAdd);
    }
}

