/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitSvnRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitHooksInfo;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepositoryFiles;
import git4idea.validators.GitRefNameValidator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepositoryReader {
    private static final Logger LOG = Logger.getInstance(GitRepositoryReader.class);
    @NotNull
    private final File myHeadFile;
    @NotNull
    private final File myRefsHeadsDir;
    @NotNull
    private final File myRefsRemotesDir;
    @NotNull
    private final File myPackedRefsFile;
    @NotNull
    private final GitRepositoryFiles myGitFiles;

    GitRepositoryReader(@NotNull GitRepositoryFiles gitFiles) {
        this.myGitFiles = gitFiles;
        this.myHeadFile = gitFiles.getHeadFile();
        this.myRefsHeadsDir = gitFiles.getRefsHeadsFile();
        this.myRefsRemotesDir = gitFiles.getRefsRemotesFile();
        this.myPackedRefsFile = gitFiles.getPackedRefsPath();
    }

    @NotNull
    GitBranchState readState(@NotNull Collection<GitRemote> remotes) {
        String currentRevision;
        GitLocalBranch currentBranch;
        Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> branches = this.readBranches(remotes);
        Map localBranches = (Map)branches.first;
        HeadInfo headInfo = this.readHead();
        Repository.State state = this.readRepositoryState(headInfo);
        if (!headInfo.isBranch || !localBranches.isEmpty()) {
            currentBranch = this.findCurrentBranch(headInfo, state, localBranches.keySet());
            currentRevision = GitRepositoryReader.getCurrentRevision(headInfo, currentBranch == null ? null : (Hash)localBranches.get(currentBranch));
        } else if (headInfo.content != null) {
            currentBranch = new GitLocalBranch(headInfo.content);
            currentRevision = null;
        } else {
            currentBranch = null;
            currentRevision = null;
        }
        if (currentBranch == null && currentRevision == null) {
            LOG.warn("Couldn't identify neither current branch nor current revision. .git/HEAD content: [" + headInfo.content + "]");
            LOG.debug("Dumping files in .git/refs/, and the content of .git/packed-refs. Debug enabled: " + LOG.isDebugEnabled());
            this.logDebugAllRefsFiles();
        }
        return new GitBranchState(currentRevision, currentBranch, state, localBranches, (Map)branches.second);
    }

    private void logDebugAllRefsFiles() {
        LOG.debug("Logging .git/refs files. .git/refs/heads " + (this.myRefsHeadsDir.exists() ? "exists" : "doesn't exist") + ".git/refs/remotes " + (this.myRefsRemotesDir.exists() ? "exists" : "doesn't exist"));
        if (LOG.isDebugEnabled()) {
            GitRepositoryReader.logDebugAllFilesIn(this.myRefsHeadsDir);
            GitRepositoryReader.logDebugAllFilesIn(this.myRefsRemotesDir);
            if (this.myPackedRefsFile.exists()) {
                try {
                    LOG.debug("packed-refs file content: [\n" + FileUtil.loadFile((File)this.myPackedRefsFile) + "\n]");
                }
                catch (IOException e) {
                    LOG.debug("Couldn't load the file " + this.myPackedRefsFile, (Throwable)e);
                }
            } else {
                LOG.debug("The file " + this.myPackedRefsFile + " doesn't exist.");
            }
        }
    }

    private static void logDebugAllFilesIn(@NotNull File dir) {
        ArrayList paths = new ArrayList();
        FileUtil.processFilesRecursively((File)dir, file2 -> {
            if (!file2.isDirectory()) {
                paths.add(FileUtil.getRelativePath((File)dir, (File)file2));
            }
            return true;
        });
        LOG.debug("Files in " + dir + ": " + paths);
    }

    @NotNull
    GitHooksInfo readHooksInfo() {
        boolean hasCommitHook = GitRepositoryReader.isExistingExecutableFile(this.myGitFiles.getPreCommitHookFile()) || GitRepositoryReader.isExistingExecutableFile(this.myGitFiles.getCommitMsgHookFile());
        boolean hasPushHook = GitRepositoryReader.isExistingExecutableFile(this.myGitFiles.getPrePushHookFile());
        return new GitHooksInfo(hasCommitHook, hasPushHook);
    }

    private static boolean isExistingExecutableFile(@NotNull File file2) {
        return file2.exists() && file2.canExecute();
    }

    boolean hasShallowCommits() {
        File shallowFile = this.myGitFiles.getShallowFile();
        if (!shallowFile.exists()) {
            return false;
        }
        return shallowFile.length() > 0L;
    }

    @Nullable
    private static String getCurrentRevision(@NotNull HeadInfo headInfo, @Nullable Hash currentBranchHash) {
        Object currentRevision = !headInfo.isBranch ? headInfo.content : (currentBranchHash == null ? null : currentBranchHash.asString());
        return currentRevision;
    }

    @Nullable
    private GitLocalBranch findCurrentBranch(@NotNull HeadInfo headInfo, @NotNull Repository.State state, @NotNull Set<? extends GitLocalBranch> localBranches) {
        String currentBranchName = this.findCurrentBranchName(state, headInfo);
        if (currentBranchName == null) {
            return null;
        }
        return (GitLocalBranch)ContainerUtil.find(localBranches, branch -> GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)branch.getFullName(), (Object)currentBranchName));
    }

    @NotNull
    private Repository.State readRepositoryState(@NotNull HeadInfo headInfo) {
        if (this.isMergeInProgress()) {
            return Repository.State.MERGING;
        }
        if (this.isRebaseInProgress()) {
            return Repository.State.REBASING;
        }
        if (!headInfo.isBranch) {
            return Repository.State.DETACHED;
        }
        if (this.isCherryPickInProgress()) {
            return Repository.State.GRAFTING;
        }
        if (this.isRevertInProgress()) {
            return Repository.State.REVERTING;
        }
        return Repository.State.NORMAL;
    }

    @Nullable
    private String findCurrentBranchName(@NotNull Repository.State state, @NotNull HeadInfo headInfo) {
        String currentBranch = null;
        if (headInfo.isBranch) {
            currentBranch = headInfo.content;
        } else if (state == Repository.State.REBASING && (currentBranch = GitRepositoryReader.readRebaseDirBranchFile(this.myGitFiles.getRebaseApplyDir())) == null) {
            currentBranch = GitRepositoryReader.readRebaseDirBranchFile(this.myGitFiles.getRebaseMergeDir());
        }
        return GitRefUtil.addRefsHeadsPrefixIfNeeded(currentBranch);
    }

    @Nullable
    private static String readRebaseDirBranchFile(@NonNls File rebaseDir) {
        File headName;
        if (rebaseDir.exists() && (headName = new File(rebaseDir, "head-name")).exists()) {
            return DvcsUtil.tryLoadFileOrReturn((File)headName, null, (String)"UTF-8");
        }
        return null;
    }

    private boolean isMergeInProgress() {
        return this.myGitFiles.getMergeHeadFile().exists();
    }

    private boolean isRebaseInProgress() {
        return this.myGitFiles.getRebaseApplyDir().exists() || this.myGitFiles.getRebaseMergeDir().exists();
    }

    private boolean isCherryPickInProgress() {
        return this.myGitFiles.getCherryPickHead().exists();
    }

    private boolean isRevertInProgress() {
        return this.myGitFiles.getRevertHead().exists();
    }

    @NotNull
    private Map<String, String> readPackedBranches() {
        if (!this.myPackedRefsFile.exists()) {
            return Collections.emptyMap();
        }
        try {
            String content = DvcsUtil.tryLoadFile((File)this.myPackedRefsFile, (String)"UTF-8");
            return ContainerUtil.map2MapNotNull((Object[])LineTokenizer.tokenize((CharSequence)content, (boolean)false), GitRefUtil::parseRefsLine);
        }
        catch (RepoStateException e) {
            return Collections.emptyMap();
        }
    }

    @NotNull
    private Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> readBranches(@NotNull Collection<GitRemote> remotes) {
        Map<String, String> data = this.readBranchRefsFromFiles();
        Map<String, Hash> resolvedRefs = GitRefUtil.resolveRefs(data);
        return GitRepositoryReader.createBranchesFromData(remotes, resolvedRefs);
    }

    @NotNull
    private Map<String, String> readBranchRefsFromFiles() {
        try {
            HashMap<String, String> result2 = new HashMap<String, String>(this.readPackedBranches());
            result2.putAll(this.readFromBranchFiles(this.myRefsHeadsDir, "refs/heads/"));
            result2.putAll(this.readFromBranchFiles(this.myRefsRemotesDir, "refs/remotes/"));
            result2.remove("refs/remotes/origin/HEAD");
            return result2;
        }
        catch (Throwable e) {
            this.logDebugAllRefsFiles();
            LOG.warn("Error reading refs from files", e);
            return Collections.emptyMap();
        }
    }

    @NotNull
    private static Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> createBranchesFromData(@NotNull Collection<GitRemote> remotes, @NotNull Map<String, Hash> data) {
        HashMap<GitLocalBranch, Hash> localBranches = new HashMap<GitLocalBranch, Hash>();
        HashMap<GitRemoteBranch, Hash> remoteBranches = new HashMap<GitRemoteBranch, Hash>();
        for (Map.Entry<String, Hash> entry : data.entrySet()) {
            String refName = entry.getKey();
            Hash hash = entry.getValue();
            GitBranch branch = GitRepositoryReader.parseBranchRef(remotes, refName);
            if (branch instanceof GitLocalBranch) {
                localBranches.put((GitLocalBranch)branch, hash);
                continue;
            }
            if (branch instanceof GitRemoteBranch) {
                remoteBranches.put((GitRemoteBranch)branch, hash);
                continue;
            }
            LOG.warn(String.format("Unexpected ref format: %s, %s", refName, branch));
        }
        return Pair.create(localBranches, remoteBranches);
    }

    @Nullable
    public static GitBranch parseBranchRef(@NotNull Collection<GitRemote> remotes, String refName) {
        if (refName.startsWith("refs/heads/")) {
            return new GitLocalBranch(refName);
        }
        if (refName.startsWith("refs/remotes/")) {
            return GitRepositoryReader.parseRemoteBranch(refName, remotes);
        }
        return null;
    }

    @Nullable
    private static String loadHashFromBranchFile(@NotNull File branchFile) {
        return DvcsUtil.tryLoadFileOrReturn((File)branchFile, null);
    }

    @NotNull
    private Map<String, String> readFromBranchFiles(@NotNull File refsRootDir, @NotNull String prefix) {
        if (!refsRootDir.exists()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        Ref couldNotLoadFile = Ref.create((Object)false);
        FileUtil.processFilesRecursively((File)refsRootDir, file2 -> {
            String relativePath;
            if (!file2.isDirectory() && !GitRepositoryReader.isHidden(file2) && (relativePath = FileUtil.getRelativePath((File)refsRootDir, (File)file2)) != null) {
                String branchName = prefix + FileUtil.toSystemIndependentName((String)relativePath);
                boolean isBranchNameValid = GitRefNameValidator.getInstance().checkInput(branchName);
                if (isBranchNameValid) {
                    String hash = GitRepositoryReader.loadHashFromBranchFile(file2);
                    if (hash != null) {
                        result2.put(branchName, hash);
                    } else {
                        couldNotLoadFile.set((Object)true);
                    }
                }
            }
            return true;
        }, dir -> !GitRepositoryReader.isHidden(dir));
        if (((Boolean)couldNotLoadFile.get()).booleanValue()) {
            this.logDebugAllRefsFiles();
        }
        return result2;
    }

    private static boolean isHidden(@NotNull File file2) {
        return file2.getName().startsWith(".");
    }

    @NotNull
    private static GitRemoteBranch parseRemoteBranch(@NotNull String fullBranchName, @NotNull Collection<GitRemote> remotes) {
        String branchName;
        String remoteName;
        GitRemote remote;
        String stdName = GitBranchUtil.stripRefsPrefix(fullBranchName);
        int slash = stdName.indexOf(47);
        if (slash == -1) {
            return new GitSvnRemoteBranch(fullBranchName);
        }
        do {
            remoteName = stdName.substring(0, slash);
            branchName = stdName.substring(slash + 1);
            remote = GitUtil.findRemoteByName(remotes, remoteName);
            slash = stdName.indexOf(47, slash + 1);
        } while (remote == null && slash >= 0);
        if (remote == null) {
            LOG.trace(String.format("No remote found with the name [%s]. All remotes: %s", remoteName, remotes));
            GitRemote fakeRemote = new GitRemote(remoteName, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            return new GitStandardRemoteBranch(fakeRemote, branchName);
        }
        return new GitStandardRemoteBranch(remote, branchName);
    }

    @NotNull
    private HeadInfo readHead() {
        String headContent;
        try {
            headContent = DvcsUtil.tryLoadFile((File)this.myHeadFile, (String)"UTF-8");
        }
        catch (RepoStateException e) {
            LOG.warn((Throwable)e);
            return new HeadInfo(false, null);
        }
        Hash hash = GitRefUtil.parseHash(headContent);
        if (hash != null) {
            return new HeadInfo(false, headContent);
        }
        String target = GitRefUtil.getTarget(headContent);
        if (target != null) {
            return new HeadInfo(true, target);
        }
        LOG.warn((Throwable)new RepoStateException("Invalid format of the .git/HEAD file: [" + headContent + "]"));
        return new HeadInfo(false, null);
    }

    private static class HeadInfo {
        @Nullable
        private final String content;
        private final boolean isBranch;

        HeadInfo(boolean branch, @Nullable String content) {
            this.isBranch = branch;
            this.content = content;
        }
    }
}

