/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.ide.impl.ProjectOriginInfoProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.PathKt;
import git4idea.repo.GitConfig;
import git4idea.repo.GitRemote;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/repo/GitProjectOriginInfoProvider;", "Lcom/intellij/ide/impl/ProjectOriginInfoProvider;", "()V", "getOriginUrl", "", "projectDir", "Ljava/nio/file/Path;", "Companion", "intellij.vcs.git"})
public final class GitProjectOriginInfoProvider
implements ProjectOriginInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Nullable
    public String getOriginUrl(@NotNull Path projectDir) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        try {
            for (Path dir = projectDir; dir != null; dir = dir.getParent()) {
                Object v1;
                block4: {
                    Path gitConfig = dir.resolve(".git/config");
                    Intrinsics.checkNotNullExpressionValue((Object)gitConfig, (String)"gitConfig");
                    if (!PathKt.exists((Path)gitConfig)) continue;
                    Collection<GitRemote> collection = GitConfig.read(gitConfig.toFile()).parseRemotes();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"read(gitConfig.toFile()).parseRemotes()");
                    Iterable iterable = collection;
                    for (Object t : iterable) {
                        GitRemote it = (GitRemote)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"origin")) continue;
                        v1 = t;
                        break block4;
                    }
                    v1 = null;
                }
                GitRemote gitRemote = v1;
                return gitRemote != null ? gitRemote.getFirstUrl() : null;
            }
            return null;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitProjectOriginInfoProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/repo/GitProjectOriginInfoProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

