/*
 * Decompiled with CFR 0.152.
 */
package git4idea.remote.hosting;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.UriUtil;
import java.net.URI;
import java.net.URISyntaxException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0007\u00a8\u0006\r"}, d2={"Lgit4idea/remote/hosting/GitHostingUrlUtil;", "", "()V", "getUriFromRemoteUrl", "Ljava/net/URI;", "remoteUrl", "", "match", "", "serverUri", "gitRemoteUrl", "removeProtocolPrefix", "url", "intellij.vcs.git"})
public final class GitHostingUrlUtil {
    @NotNull
    public static final GitHostingUrlUtil INSTANCE = new GitHostingUrlUtil();

    private GitHostingUrlUtil() {
    }

    @JvmStatic
    @NlsSafe
    @NotNull
    public static final String removeProtocolPrefix(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int index = StringsKt.indexOf$default((CharSequence)url, (char)'@', (int)0, (boolean)false, (int)6, null);
        if (index != -1) {
            String string2 = url.substring(index + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            return string2;
        }
        index = StringsKt.indexOf$default((CharSequence)url, (String)"://", (int)0, (boolean)false, (int)6, null);
        if (index != -1) {
            String string3 = url.substring(index + 3);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string = url;
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final URI getUriFromRemoteUrl(@NotNull String remoteUrl) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)remoteUrl, (String)"remoteUrl");
        String string = UriUtil.trimTrailingSlashes((String)remoteUrl);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimTrailingSlashes(remoteUrl)");
        String fixed = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string, (CharSequence)"/"), (CharSequence)".git");
        try {
            uRI = !StringsKt.contains$default((CharSequence)fixed, (CharSequence)"://", (boolean)false, (int)2, null) ? new URI("https://" + StringsKt.replace$default((String)StringsKt.replace$default((String)GitHostingUrlUtil.removeProtocolPrefix(fixed), (String)":/", (String)"/", (boolean)false, (int)4, null), (char)':', (char)'/', (boolean)false, (int)4, null)) : new URI(fixed);
        }
        catch (URISyntaxException e) {
            uRI = null;
        }
        return uRI;
    }

    @JvmStatic
    public static final boolean match(@NotNull URI serverUri, @NotNull String gitRemoteUrl) {
        Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
        Intrinsics.checkNotNullParameter((Object)gitRemoteUrl, (String)"gitRemoteUrl");
        URI uRI = GitHostingUrlUtil.getUriFromRemoteUrl(gitRemoteUrl);
        if (uRI == null) {
            return false;
        }
        URI remoteUri = uRI;
        if (!StringsKt.equals((String)serverUri.getHost(), (String)remoteUri.getHost(), (boolean)true)) {
            return false;
        }
        if (serverUri.getPath() != null) {
            String string = remoteUri.getPath();
            if (string == null) {
                return false;
            }
            String remoteUriPath = string;
            String string2 = serverUri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"serverUri.path");
            if (!StringsKt.startsWith((String)remoteUriPath, (String)string2, (boolean)true)) {
                return false;
            }
        }
        return true;
    }
}

