/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.GitProtectedBranchesKt;
import git4idea.i18n.GitBundle;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.rebase.log.GitNewCommitMessageActionDialog;
import git4idea.repo.GitRepository;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B)\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0001\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\r\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0014J\b\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0014J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0006H\u0014J\r\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u0013H\u0016J)\u0010\u001b\u001a\u00020\u000f2!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u000f0\u000eJ!\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0004\u001a\u00028\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010 R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lgit4idea/rebase/log/GitNewCommitMessageActionDialog;", "T", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "Lcom/intellij/openapi/ui/DialogWrapper;", "commitEditingData", "originMessage", "", "title", "dialogLabel", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "commitEditor", "Lcom/intellij/openapi/vcs/ui/CommitMessage;", "onOk", "Lkotlin/Function1;", "", "originalHEAD", "createCenterPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lorg/jetbrains/annotations/NotNull;", "createCommitEditor", "doOKAction", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "getDimensionServiceKey", "getPreferredFocusedComponent", "Lcom/intellij/ui/EditorTextField;", "show", "Lkotlin/ParameterName;", "name", "newMessage", "validate", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;Ljava/lang/String;)Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.vcs.git"})
public final class GitNewCommitMessageActionDialog<T extends GitCommitEditingActionBase.MultipleCommitEditingData>
extends DialogWrapper {
    @NotNull
    private final T commitEditingData;
    @NotNull
    private final String originMessage;
    @NotNull
    private final String dialogLabel;
    @Nullable
    private final String originalHEAD;
    @NotNull
    private final CommitMessage commitEditor;
    @NotNull
    private Function1<? super String, Unit> onOk;

    public GitNewCommitMessageActionDialog(@NotNull T commitEditingData, @NotNull String originMessage, @Nls @NotNull String title, @Nls @NotNull String dialogLabel) {
        Intrinsics.checkNotNullParameter(commitEditingData, (String)"commitEditingData");
        Intrinsics.checkNotNullParameter((Object)originMessage, (String)"originMessage");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)dialogLabel, (String)"dialogLabel");
        super(((GitCommitEditingActionBase.MultipleCommitEditingData)commitEditingData).getProject(), true);
        this.commitEditingData = commitEditingData;
        this.originMessage = originMessage;
        this.dialogLabel = dialogLabel;
        this.originalHEAD = ((GitCommitEditingActionBase.MultipleCommitEditingData)this.commitEditingData).getRepository().getInfo().getCurrentRevision();
        this.commitEditor = this.createCommitEditor();
        this.onOk = onOk.1.INSTANCE;
        Disposer.register((Disposable)this.getDisposable(), (Disposable)((Disposable)this.commitEditor));
        this.init();
        this.setModal(false);
        this.setTitle(title);
    }

    public final void show(@NotNull Function1<? super String, Unit> onOk2) {
        Intrinsics.checkNotNullParameter(onOk2, (String)"onOk");
        this.onOk = onOk2;
        this.show();
    }

    private final ValidationInfo validate(T commitEditingData, String originalHEAD) {
        VcsLogData logData = ((GitCommitEditingActionBase.MultipleCommitEditingData)commitEditingData).getLogData();
        GitRepository repository = ((GitCommitEditingActionBase.MultipleCommitEditingData)commitEditingData).getRepository();
        List<VcsCommitMetadata> commits2 = ((GitCommitEditingActionBase.MultipleCommitEditingData)commitEditingData).getSelectedCommitList();
        if (!Intrinsics.areEqual((Object)repository.getInfo().getCurrentRevision(), (Object)originalHEAD) || Disposer.isDisposed((Disposable)((Disposable)logData))) {
            Object[] objectArray = new Object[]{commits2.size()};
            return new ValidationInfo(GitBundle.message("rebase.log.reword.dialog.failed.repository.changed.message", objectArray));
        }
        Object object = ((VcsCommitMetadata)CollectionsKt.last(commits2)).getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"commits.last().id");
        Hash lastCommitHash = (Hash)object;
        VirtualFile virtualFile = repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repository.root");
        List<String> branches = GitCommitEditingActionBase.Companion.findContainingBranches(logData, virtualFile, lastCommitHash);
        String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranch(repository, (Collection<String>)branches);
        if (protectedBranch != null) {
            Object[] objectArray = new Object[]{commits2.size(), lastCommitHash, protectedBranch};
            return new ValidationInfo(GitBundle.message("rebase.log.reword.dialog.failed.pushed.to.protected.message", objectArray));
        }
        return null;
    }

    @NotNull
    protected BorderLayoutPanel createCenterPanel() {
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((int)10, (int)4).addToTop((Component)new JBLabel(this.dialogLabel)).addToCenter((Component)this.commitEditor);
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"simplePanel(UIUtil.DEFAU\u2026addToCenter(commitEditor)");
        return borderLayoutPanel;
    }

    @NotNull
    public EditorTextField getPreferredFocusedComponent() {
        EditorTextField editorTextField = this.commitEditor.getEditorField();
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField, (String)"commitEditor.editorField");
        return editorTextField;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "Git.Rebase.Log.Action.NewCommitMessage.Dialog";
    }

    private final CommitMessage createCommitEditor() {
        CommitMessage editor = new CommitMessage(((GitCommitEditingActionBase.MultipleCommitEditingData)this.commitEditingData).getProject(), false, false, true);
        editor.setText(this.originMessage);
        editor.getEditorField().setCaretPosition(0);
        editor.getEditorField().addSettingsProvider(arg_0 -> GitNewCommitMessageActionDialog.createCommitEditor$lambda$0(this, arg_0));
        return editor;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.validate(this.commitEditingData, this.originalHEAD);
    }

    protected void doOKAction() {
        super.doOKAction();
        String string = this.commitEditor.getComment();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commitEditor.comment");
        this.onOk.invoke((Object)string);
    }

    private static final void createCommitEditor$lambda$0(GitNewCommitMessageActionDialog this$0, EditorEx editorEx) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        int MIN_ROWS = 3;
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        if (((EditorImpl)editorEx).getVisibleLineCount() < MIN_ROWS) {
            this$0.setVerticalStretch(1.5f);
        }
    }
}

