/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.utils.DfsWalk;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 (*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0004'()*B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0015\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u000fJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00028\u0000H\u0015\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH$J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0011H%J&\u0010\u001e\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\u001f2\u0006\u0010\u000e\u001a\u00028\u00002\b\b\u0001\u0010 \u001a\u00020\u0011H\u0014\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001d\u0010\"\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010#J\f\u0010$\u001a\u00020%*\u00020&H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006+"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase;", "T", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "prohibitRebaseDuringRebasePolicy", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy;", "getProhibitRebaseDuringRebasePolicy", "()Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformedAfterChecks", "commitEditingData", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;)V", "checkCommitsEditingAvailability", "", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;)Ljava/lang/String;", "createCommitEditingData", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult;", "repository", "Lgit4idea/repo/GitRepository;", "selection", "Lcom/intellij/vcs/log/VcsLogCommitSelection;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getFailureTitle", "getProhibitedStateMessage", "Lorg/jetbrains/annotations/Nls;", "operation", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;Ljava/lang/String;)Ljava/lang/String;", "update", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;)V", "isRootOrMerge", "", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "CommitEditingDataCreationResult", "Companion", "MultipleCommitEditingData", "ProhibitRebaseDuringRebasePolicy", "intellij.vcs.git"})
public abstract class GitCommitEditingActionBase<T extends MultipleCommitEditingData>
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProhibitRebaseDuringRebasePolicy prohibitRebaseDuringRebasePolicy = ProhibitRebaseDuringRebasePolicy.Allow.INSTANCE;

    @NotNull
    protected ProhibitRebaseDuringRebasePolicy getProhibitRebaseDuringRebasePolicy() {
        return this.prohibitRebaseDuringRebasePolicy;
    }

    protected abstract void actionPerformedAfterChecks(@NotNull T var1);

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    protected abstract String getFailureTitle();

    @NotNull
    protected abstract CommitEditingDataCreationResult<T> createCommitEditingData(@NotNull GitRepository var1, @NotNull VcsLogCommitSelection var2, @NotNull VcsLogData var3);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected void update(@NotNull AnActionEvent e, @NotNull T commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(commitEditingData, (String)"commitEditingData");
    }

    public void update(@NotNull AnActionEvent e) {
        String message;
        VcsCommitMetadata commit;
        Object element$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setEnabledAndVisible(false);
        CommitEditingDataCreationResult<T> commitEditingDataCreationResult = this.createCommitEditingData(e);
        if (commitEditingDataCreationResult instanceof CommitEditingDataCreationResult.Prohibited) {
            String description2 = ((CommitEditingDataCreationResult.Prohibited)commitEditingDataCreationResult).getDescription();
            if (description2 != null) {
                e.getPresentation().setVisible(true);
                e.getPresentation().setDescription(description2);
            }
            return;
        }
        if (!(commitEditingDataCreationResult instanceof CommitEditingDataCreationResult.Created)) {
            throw new NoWhenBranchMatchedException();
        }
        Object commitEditingData = ((CommitEditingDataCreationResult.Created)commitEditingDataCreationResult).getData();
        e.getPresentation().setVisible(true);
        List<VcsCommitMetadata> commitList = ((MultipleCommitEditingData)commitEditingData).getSelectedCommitList();
        GitRepository repository = ((MultipleCommitEditingData)commitEditingData).getRepository();
        if (VcsLogUtil.findBranch((RefsModel)((MultipleCommitEditingData)commitEditingData).getLogData().getDataPack().getRefsModel(), (VirtualFile)repository.getRoot(), (String)"HEAD") == null) {
            Object[] objectArray = new Object[]{commitList.size()};
            e.getPresentation().setDescription(GitBundle.message("rebase.log.multiple.commit.editing.action.cant.find.head", objectArray));
            return;
        }
        Object $this$forEach$iv = (Object[])commitList;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            commit = (VcsCommitMetadata)element$iv;
            boolean bl = false;
            if (commit instanceof LoadingDetails || !this.isRootOrMerge((VcsShortCommitDetails)commit)) continue;
            Object[] objectArray = new Object[]{commit.getParents().size()};
            e.getPresentation().setDescription(GitBundle.message("rebase.log.commit.editing.action.disabled.parents.description", objectArray));
            return;
        }
        $this$forEach$iv = new VcsCommitMetadata[]{(VcsCommitMetadata)CollectionsKt.first(commitList), (VcsCommitMetadata)CollectionsKt.last(commitList)};
        $this$forEach$iv = CollectionsKt.listOf((Object[])$this$forEach$iv);
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            commit = (VcsCommitMetadata)element$iv;
            boolean bl = false;
            ContainingBranchesGetter containingBranchesGetter = ((MultipleCommitEditingData)commitEditingData).getLogData().getContainingBranchesGetter();
            VirtualFile virtualFile = commit.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"commit.root");
            Object object = commit.getId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"commit.id");
            List branches = containingBranchesGetter.getContainingBranchesQuickly(virtualFile, (Hash)object);
            if (branches == null) continue;
            if (!branches.contains("HEAD")) {
                e.getPresentation().setDescription(GitBundle.message("rebase.log.commit.editing.action.commit.not.in.head.error.text", new Object[0]));
                return;
            }
            String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranch(repository, branches);
            if (protectedBranch == null) continue;
            Object[] objectArray = new Object[]{protectedBranch};
            e.getPresentation().setDescription(GitBundle.message("rebase.log.commit.editing.action.commit.pushed.to.protected.branch.error.text", objectArray));
            return;
        }
        ProhibitRebaseDuringRebasePolicy policy = this.getProhibitRebaseDuringRebasePolicy();
        if (!Intrinsics.areEqual((Object)policy, (Object)ProhibitRebaseDuringRebasePolicy.Allow.INSTANCE) && policy instanceof ProhibitRebaseDuringRebasePolicy.Prohibit && (message = this.getProhibitedStateMessage(commitEditingData, ((ProhibitRebaseDuringRebasePolicy.Prohibit)policy).getOperation())) != null) {
            e.getPresentation().setDescription(message);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
        this.update(e, commitEditingData);
    }

    private final boolean isRootOrMerge(VcsShortCommitDetails $this$isRootOrMerge) {
        return $this$isRootOrMerge.getParents().size() != 1;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CommitEditingDataCreationResult<T> commitEditingDataCreationResult = this.createCommitEditingData(e);
        Intrinsics.checkNotNull(commitEditingDataCreationResult, (String)"null cannot be cast to non-null type git4idea.rebase.log.GitCommitEditingActionBase.CommitEditingDataCreationResult.Created<T of git4idea.rebase.log.GitCommitEditingActionBase>");
        Object commitEditingRequirements = ((CommitEditingDataCreationResult.Created)commitEditingDataCreationResult).getData();
        String description2 = this.checkCommitsEditingAvailability(commitEditingRequirements);
        if (description2 != null) {
            Messages.showErrorDialog((Project)((MultipleCommitEditingData)commitEditingRequirements).getProject(), (String)description2, (String)this.getFailureTitle());
            return;
        }
        this.actionPerformedAfterChecks(commitEditingRequirements);
    }

    @Nls
    @Nullable
    protected String checkCommitsEditingAvailability(@NotNull T commitEditingData) {
        Intrinsics.checkNotNullParameter(commitEditingData, (String)"commitEditingData");
        String string = GitBundle.message("rebase.log.multiple.commit.editing.action.progress.indicator.action.possibility.check", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"rebase.log.mult\u2026ction.possibility.check\")");
        String description2 = Companion.checkHeadLinearHistory((MultipleCommitEditingData)commitEditingData, string);
        if (description2 != null) {
            return description2;
        }
        VcsCommitMetadata lastCommit = (VcsCommitMetadata)CollectionsKt.last(((MultipleCommitEditingData)commitEditingData).getSelectedCommitList());
        VcsLogData vcsLogData = ((MultipleCommitEditingData)commitEditingData).getLogData();
        VirtualFile virtualFile = lastCommit.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"lastCommit.root");
        Object object = lastCommit.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lastCommit.id");
        List<String> branches = Companion.findContainingBranches(vcsLogData, virtualFile, (Hash)object);
        String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranch(((MultipleCommitEditingData)commitEditingData).getRepository(), (Collection<String>)branches);
        if (protectedBranch != null) {
            Object[] objectArray = new Object[]{protectedBranch};
            return GitBundle.message("rebase.log.commit.editing.action.commit.pushed.to.protected.branch.error.text", objectArray);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final CommitEditingDataCreationResult<T> createCommitEditingData(AnActionEvent e) {
        void $this$mapTo$iv$iv;
        List list2;
        Project project = e.getProject();
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        VcsLogData logDataProvider = (VcsLogData)e.getData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
        if (project == null || selection == null || logDataProvider == null) {
            return new CommitEditingDataCreationResult.Prohibited(null, 1, null);
        }
        List it = list2 = selection.getCachedMetadata();
        boolean bl = false;
        List list3 = !((Collection)it).isEmpty() ? list2 : null;
        if (list3 == null) {
            return new CommitEditingDataCreationResult.Prohibited(null, 1, null);
        }
        List commitList = list3;
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getRepositoryManager(project)");
        GitRepositoryManager repositoryManager = gitRepositoryManager;
        Iterable $this$map$iv = commitList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it2.getRoot());
        }
        VirtualFile virtualFile = (VirtualFile)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        if (virtualFile == null) {
            Object[] objectArray = new Object[]{commitList.size()};
            return new CommitEditingDataCreationResult.Prohibited(GitBundle.message("rebase.log.multiple.commit.editing.action.disabled.multiple.repository.description", objectArray));
        }
        VirtualFile root = virtualFile;
        GitRepository gitRepository = (GitRepository)repositoryManager.getRepositoryForRootQuick(root);
        if (gitRepository == null) {
            return new CommitEditingDataCreationResult.Prohibited(null, 1, null);
        }
        GitRepository repository = gitRepository;
        if (repositoryManager.isExternal(repository)) {
            Object[] objectArray = new Object[]{commitList.size()};
            return new CommitEditingDataCreationResult.Prohibited(GitBundle.message("rebase.log.multiple.commit.editing.action.disabled.external.repository.description", objectArray));
        }
        return this.createCommitEditingData(repository, selection, logDataProvider);
    }

    @Nullable
    protected String getProhibitedStateMessage(@NotNull T commitEditingData, @Nls @NotNull String operation) {
        Intrinsics.checkNotNullParameter(commitEditingData, (String)"commitEditingData");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        return switch (WhenMappings.$EnumSwitchMapping$0[((MultipleCommitEditingData)commitEditingData).getRepository().getState().ordinal()]) {
            case 1, 2 -> null;
            case 3 -> {
                Object[] var3_3 = new Object[]{operation};
                yield GitBundle.message("rebase.log.commit.editing.action.prohibit.state.rebasing", var3_3);
            }
            case 4 -> {
                Object[] var3_4 = new Object[]{operation};
                yield GitBundle.message("rebase.log.commit.editing.action.prohibit.state.merging", var3_4);
            }
            case 5 -> {
                Object[] var3_5 = new Object[]{operation};
                yield GitBundle.message("rebase.log.commit.editing.action.prohibit.state.grafting", var3_5);
            }
            case 6 -> {
                Object[] var3_6 = new Object[]{operation};
                yield GitBundle.message("rebase.log.commit.editing.action.prohibit.state.reverting", var3_6);
            }
            default -> {
                Object[] var3_7 = new Object[]{operation};
                yield GitBundle.message("rebase.log.commit.editing.action.prohibit.state", var3_7);
            }
        };
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0004H\u0007J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$Companion;", "", "()V", "checkHeadLinearHistory", "", "commitEditingData", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "progressText", "findContainingBranches", "", "data", "Lcom/intellij/vcs/log/data/VcsLogData;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "findContainingBranchesQuickly", "getCommitIdByNodeId", "Lcom/intellij/vcs/log/CommitId;", "permanentGraph", "Lcom/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl;", "", "nodeId", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> findContainingBranches(@NotNull VcsLogData data, @NotNull VirtualFile root, @NotNull Hash hash) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            List<String> branches = this.findContainingBranchesQuickly(data, root, hash);
            if (branches == null) {
                ContainingBranchesGetter containingBranchesGetter = data.getContainingBranchesGetter();
                Intrinsics.checkNotNullExpressionValue((Object)containingBranchesGetter, (String)"data.containingBranchesGetter");
                ContainingBranchesGetter branchesGetter = containingBranchesGetter;
                Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Companion.findContainingBranches$lambda$0(branchesGetter, root, hash), GitBundle.message("rebase.log.commit.editing.action.progress.containing.branches.title", new Object[0]), true, data.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance()\n          \u2026 data.project\n          )");
                return (List)object;
            }
            return branches;
        }

        @Nullable
        public final List<String> findContainingBranchesQuickly(@NotNull VcsLogData data, @NotNull VirtualFile root, @NotNull Hash hash) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            ContainingBranchesGetter containingBranchesGetter = data.getContainingBranchesGetter();
            Intrinsics.checkNotNullExpressionValue((Object)containingBranchesGetter, (String)"data.containingBranchesGetter");
            ContainingBranchesGetter branchesGetter = containingBranchesGetter;
            return branchesGetter.getContainingBranchesQuickly(root, hash);
        }

        @Nls
        @Nullable
        public final String checkHeadLinearHistory(@NotNull MultipleCommitEditingData commitEditingData, @NlsContexts.ProgressTitle @NotNull String progressText) {
            Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
            Intrinsics.checkNotNullParameter((Object)progressText, (String)"progressText");
            Project project = commitEditingData.getProject();
            VirtualFile virtualFile = commitEditingData.getRepository().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"commitEditingData.repository.root");
            VirtualFile root = virtualFile;
            VcsLogData logData = commitEditingData.getLogData();
            DataPack dataPack = logData.getDataPack();
            Intrinsics.checkNotNullExpressionValue((Object)dataPack, (String)"logData.dataPack");
            DataPack dataPack2 = dataPack;
            PermanentGraph permanentGraph = dataPack2.getPermanentGraph();
            Intrinsics.checkNotNull((Object)permanentGraph, (String)"null cannot be cast to non-null type com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl<kotlin.Int>");
            PermanentGraphImpl permanentGraph2 = (PermanentGraphImpl)permanentGraph;
            PermanentCommitsInfoImpl permanentCommitsInfoImpl = permanentGraph2.getPermanentCommitsInfo();
            Intrinsics.checkNotNullExpressionValue((Object)permanentCommitsInfoImpl, (String)"permanentGraph.permanentCommitsInfo");
            PermanentCommitsInfoImpl commitsInfo = permanentCommitsInfoImpl;
            List commitIndices = commitEditingData.getSelection().getIds();
            Ref.ObjectRef description2 = new Ref.ObjectRef();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Companion.checkHeadLinearHistory$lambda$1(commitsInfo, commitIndices, dataPack2, root, logData, permanentGraph2, description2), progressText, true, project);
            return (String)description2.element;
        }

        private final CommitId getCommitIdByNodeId(VcsLogData data, PermanentGraphImpl<Integer> permanentGraph, int nodeId) {
            Object object = permanentGraph.getPermanentCommitsInfo().getCommitId(nodeId);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"permanentGraph.permanent\u2026sInfo.getCommitId(nodeId)");
            CommitId commitId = data.getCommitId(((Number)object).intValue());
            Intrinsics.checkNotNull((Object)commitId);
            return commitId;
        }

        private static final List findContainingBranches$lambda$0(ContainingBranchesGetter $branchesGetter, VirtualFile $root, Hash $hash) {
            Intrinsics.checkNotNullParameter((Object)$branchesGetter, (String)"$branchesGetter");
            Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
            Intrinsics.checkNotNullParameter((Object)$hash, (String)"$hash");
            return $branchesGetter.getContainingBranchesSynchronously($root, $hash);
        }

        private static final void checkHeadLinearHistory$lambda$1(PermanentCommitsInfoImpl $commitsInfo, List $commitIndices, DataPack $dataPack, VirtualFile $root, VcsLogData $logData, PermanentGraphImpl $permanentGraph, Ref.ObjectRef $description) {
            Intrinsics.checkNotNullParameter((Object)$commitsInfo, (String)"$commitsInfo");
            Intrinsics.checkNotNullParameter((Object)$commitIndices, (String)"$commitIndices");
            Intrinsics.checkNotNullParameter((Object)$dataPack, (String)"$dataPack");
            Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
            Intrinsics.checkNotNullParameter((Object)$logData, (String)"$logData");
            Intrinsics.checkNotNullParameter((Object)$permanentGraph, (String)"$permanentGraph");
            Intrinsics.checkNotNullParameter((Object)$description, (String)"$description");
            Set set = $commitsInfo.convertToNodeIds((Collection)$commitIndices);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commitsInfo.convertToNodeIds(commitIndices)");
            Set commitNodeIds = CollectionsKt.toMutableSet((Iterable)set);
            VcsRef vcsRef = VcsLogUtil.findBranch((RefsModel)$dataPack.getRefsModel(), (VirtualFile)$root, (String)"HEAD");
            Intrinsics.checkNotNull((Object)vcsRef);
            VcsRef headRef = vcsRef;
            int headIndex = $logData.getCommitIndex(headRef.getCommitHash(), $root);
            int headId = $commitsInfo.getNodeId((Object)headIndex);
            Comparable comparable = CollectionsKt.maxOrNull((Iterable)commitNodeIds);
            Intrinsics.checkNotNull((Object)comparable);
            int maxNodeId = ((Number)((Object)comparable)).intValue();
            LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph((LinearGraph)((LinearGraph)$permanentGraph.getLinearGraph()));
            Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"asLiteLinearGraph(permanentGraph.linearGraph)");
            LiteLinearGraph graph = liteLinearGraph;
            BitSetFlags used = new BitSetFlags($permanentGraph.getLinearGraph().nodesCount());
            new DfsWalk((Collection)CollectionsKt.listOf((Object)headId), graph, (Flags)used).walk(true, (Function1)new Function1<Integer, Boolean>(graph, $logData, (PermanentGraphImpl<Integer>)$permanentGraph, (Ref.ObjectRef<String>)$description, maxNodeId, (Set<Integer>)commitNodeIds){
                final /* synthetic */ LiteLinearGraph $graph;
                final /* synthetic */ VcsLogData $logData;
                final /* synthetic */ PermanentGraphImpl<Integer> $permanentGraph;
                final /* synthetic */ Ref.ObjectRef<String> $description;
                final /* synthetic */ int $maxNodeId;
                final /* synthetic */ Set<Integer> $commitNodeIds;
                {
                    this.$graph = $graph;
                    this.$logData = $logData;
                    this.$permanentGraph = $permanentGraph;
                    this.$description = $description;
                    this.$maxNodeId = $maxNodeId;
                    this.$commitNodeIds = $commitNodeIds;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(int nodeId) {
                    boolean bl;
                    ProgressManager.checkCanceled();
                    List list2 = this.$graph.getNodes(nodeId, LiteLinearGraph.NodeFilter.DOWN);
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"graph.getNodes(nodeId, L\u2026earGraph.NodeFilter.DOWN)");
                    List parents = list2;
                    if (parents.size() != 1) {
                        CommitId commit = git4idea.rebase.log.GitCommitEditingActionBase$Companion.access$getCommitIdByNodeId(GitCommitEditingActionBase.Companion, this.$logData, this.$permanentGraph, nodeId);
                        Object[] objectArray = new Object[]{commit.getHash(), parents.size()};
                        this.$description.element = GitBundle.message("rebase.log.multiple.commit.editing.action.specific.commit.root.or.merge", objectArray);
                        bl = false;
                    } else if (nodeId > this.$maxNodeId) {
                        Object object = CollectionsKt.first((Iterable)this.$commitNodeIds);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"commitNodeIds.first()");
                        CommitId commitNotInHead = git4idea.rebase.log.GitCommitEditingActionBase$Companion.access$getCommitIdByNodeId(GitCommitEditingActionBase.Companion, this.$logData, this.$permanentGraph, ((Number)object).intValue());
                        Object[] objectArray = new Object[]{commitNotInHead.getHash()};
                        this.$description.element = GitBundle.message("rebase.log.multiple.commit.editing.action.specific.commit.not.in.head", objectArray);
                        bl = false;
                    } else {
                        this.$commitNodeIds.remove(nodeId);
                        bl = !((Collection)this.$commitNodeIds).isEmpty();
                    }
                    return bl;
                }
            });
        }

        public static final /* synthetic */ CommitId access$getCommitIdByNodeId(Companion $this, VcsLogData data, PermanentGraphImpl permanentGraph, int nodeId) {
            return $this.getCommitIdByNodeId(data, (PermanentGraphImpl<Integer>)permanentGraph, nodeId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "", "repository", "Lgit4idea/repo/GitRepository;", "selection", "Lcom/intellij/vcs/log/VcsLogCommitSelection;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsLogCommitSelection;Lcom/intellij/vcs/log/data/VcsLogData;)V", "getLogData", "()Lcom/intellij/vcs/log/data/VcsLogData;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepository", "()Lgit4idea/repo/GitRepository;", "selectedCommitList", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "getSelectedCommitList", "()Ljava/util/List;", "getSelection", "()Lcom/intellij/vcs/log/VcsLogCommitSelection;", "intellij.vcs.git"})
    public static class MultipleCommitEditingData {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final VcsLogCommitSelection selection;
        @NotNull
        private final VcsLogData logData;
        @NotNull
        private final Project project;
        @NotNull
        private final List<VcsCommitMetadata> selectedCommitList;

        public MultipleCommitEditingData(@NotNull GitRepository repository, @NotNull VcsLogCommitSelection selection, @NotNull VcsLogData logData) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            this.repository = repository;
            this.selection = selection;
            this.logData = logData;
            Project project = this.repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"repository.project");
            this.project = project;
            this.selectedCommitList = this.selection.getCachedMetadata();
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final VcsLogCommitSelection getSelection() {
            return this.selection;
        }

        @NotNull
        public final VcsLogData getLogData() {
            return this.logData;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final List<VcsCommitMetadata> getSelectedCommitList() {
            return this.selectedCommitList;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy;", "", "()V", "Allow", "Prohibit", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Allow;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Prohibit;", "intellij.vcs.git"})
    protected static abstract class ProhibitRebaseDuringRebasePolicy {
        private ProhibitRebaseDuringRebasePolicy() {
        }

        public /* synthetic */ ProhibitRebaseDuringRebasePolicy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Allow;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy;", "()V", "intellij.vcs.git"})
        public static final class Allow
        extends ProhibitRebaseDuringRebasePolicy {
            @NotNull
            public static final Allow INSTANCE = new Allow();

            private Allow() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Prohibit;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy;", "operation", "", "(Ljava/lang/String;)V", "getOperation", "()Ljava/lang/String;", "intellij.vcs.git"})
        public static final class Prohibit
        extends ProhibitRebaseDuringRebasePolicy {
            @NotNull
            private final String operation;

            public Prohibit(@Nls @NotNull String operation) {
                Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                super(null);
                this.operation = operation;
            }

            @NotNull
            public final String getOperation() {
                return this.operation;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0004\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult;", "T", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "", "()V", "Created", "Prohibited", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult$Created;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult$Prohibited;", "intellij.vcs.git"})
    protected static abstract class CommitEditingDataCreationResult<T extends MultipleCommitEditingData> {
        private CommitEditingDataCreationResult() {
        }

        public /* synthetic */ CommitEditingDataCreationResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0005R\u0013\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult$Created;", "T", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult;", "data", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;)V", "getData", "()Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "intellij.vcs.git"})
        public static final class Created<T extends MultipleCommitEditingData>
        extends CommitEditingDataCreationResult<T> {
            @NotNull
            private final T data;

            public Created(@NotNull T data) {
                Intrinsics.checkNotNullParameter(data, (String)"data");
                super(null);
                this.data = data;
            }

            @NotNull
            public final T getData() {
                return this.data;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0011\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult$Prohibited;", "T", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult;", "description", "", "(Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "intellij.vcs.git"})
        public static final class Prohibited<T extends MultipleCommitEditingData>
        extends CommitEditingDataCreationResult<T> {
            @Nullable
            private final String description;

            public Prohibited(@Nls @Nullable String description2) {
                super(null);
                this.description = description2;
            }

            public /* synthetic */ Prohibited(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                this(string);
            }

            @Nullable
            public final String getDescription() {
                return this.description;
            }

            public Prohibited() {
                this(null, 1, null);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Repository.State.values().length];
            try {
                nArray[Repository.State.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.DETACHED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.REBASING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.MERGING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.GRAFTING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.REVERTING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

