/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive.dialog.view;

import git4idea.rebase.interactive.dialog.view.CommitMessageCellEditor;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B0\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgit4idea/rebase/interactive/dialog/view/HeightResizeMouseListener;", "Ljavax/swing/event/MouseInputAdapter;", "panel", "Ljavax/swing/JPanel;", "updateHeight", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "newHeight", "", "(Ljavax/swing/JPanel;Lkotlin/jvm/functions/Function1;)V", "previousPoint", "Ljava/awt/Point;", "resizedHeight", "mouseDragged", "e", "Ljava/awt/event/MouseEvent;", "mouseMoved", "mousePressed", "mouseReleased", "updateCursor", "intellij.vcs.git"})
final class HeightResizeMouseListener
extends MouseInputAdapter {
    @NotNull
    private final JPanel panel;
    @NotNull
    private final Function1<Integer, Unit> updateHeight;
    private int resizedHeight;
    @Nullable
    private Point previousPoint;

    public HeightResizeMouseListener(@NotNull JPanel panel2, @NotNull Function1<? super Integer, Unit> updateHeight) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter(updateHeight, (String)"updateHeight");
        this.panel = panel2;
        this.updateHeight = updateHeight;
        this.resizedHeight = this.panel.getHeight();
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.updateCursor(e);
        this.previousPoint = null;
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.updateCursor(e);
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Point current = e.getLocationOnScreen();
        Point point = this.previousPoint;
        if (point != null) {
            Point it = point;
            boolean bl = false;
            int deltaY = current.y - it.y;
            this.resizedHeight += deltaY;
            this.updateHeight.invoke((Object)this.resizedHeight);
        }
        this.previousPoint = current;
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.previousPoint = e.getLocationOnScreen();
        this.resizedHeight = this.panel.getHeight();
    }

    private final void updateCursor(MouseEvent e) {
        Point point = e.getPoint();
        int n = this.panel.getHeight();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"point");
        this.panel.setCursor(CommitMessageCellEditor.Companion.canResize$intellij_vcs_git(n, point) ? Cursor.getPredefinedCursor(9) : Cursor.getDefaultCursor());
    }
}

