/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive.dialog;

import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.data.index.IndexedDetails;
import git4idea.rebase.interactive.GitRebaseTodoModel;
import git4idea.rebase.interactive.dialog.GitRebaseCommitsTableView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0014J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0012\u0010\u0017\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\f\u0010\u001a\u001a\u00020\u000b*\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u000b*\u00020\u001bH\u0002J\u0014\u0010\u001d\u001a\u00020\u000b*\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\f\u0010\u001f\u001a\u00020\u000b*\u00020\u001bH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lgit4idea/rebase/interactive/dialog/SubjectRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "()V", "connectionCenterY", "", "getConnectionCenterY", "()I", "graphType", "Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType;", "rowHeight", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "column", "getRowGraphType", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "paint", "g", "Ljava/awt/Graphics;", "drawCenterLine", "Ljava/awt/Graphics2D;", "drawDownLine", "drawUpLine", "withArrow", "paintFixupGraph", "Companion", "GraphType", "intellij.vcs.git"})
final class SubjectRenderer
extends ColoredTableCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private GraphType graphType = GraphType.NoGraph.INSTANCE;
    private int rowHeight = GitRebaseCommitsTableView.Companion.getDEFAULT_CELL_HEIGHT();
    private static final int GRAPH_WIDTH = 20;
    private static final int CONNECTION_CENTER_X = 5;

    private final int getConnectionCenterY() {
        return this.rowHeight / 2;
    }

    public void paint(@Nullable Graphics g) {
        super.paint(g);
        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        this.paintFixupGraph((Graphics2D)g);
    }

    private final void paintFixupGraph(Graphics2D $this$paintFixupGraph) {
        GraphType type = this.graphType;
        if (!(type instanceof GraphType.NoGraph) && type instanceof GraphType.FixupGraph) {
            $this$paintFixupGraph.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            $this$paintFixupGraph.setColor((Color)GitRebaseCommitsTableView.Companion.getGRAPH_COLOR());
            $this$paintFixupGraph.setStroke(new BasicStroke(GitRebaseCommitsTableView.Companion.getGRAPH_LINE_WIDTH(), 1, 2));
            this.drawCenterLine($this$paintFixupGraph);
            this.drawUpLine($this$paintFixupGraph, ((GraphType.FixupGraph)type).isFirst());
            if (!((GraphType.FixupGraph)type).isLast()) {
                this.drawDownLine($this$paintFixupGraph);
            }
        }
    }

    private final void drawCenterLine(Graphics2D $this$drawCenterLine) {
        int gap = 4;
        int xRight = 20 - gap;
        $this$drawCenterLine.drawLine(5, this.getConnectionCenterY(), xRight, this.getConnectionCenterY());
    }

    private final void drawDownLine(Graphics2D $this$drawDownLine) {
        $this$drawDownLine.drawLine(5, this.getConnectionCenterY(), 5, this.rowHeight);
    }

    private final void drawUpLine(Graphics2D $this$drawUpLine, boolean withArrow) {
        int triangleSide = JBUI.scale((int)8);
        int triangleBottomY = triangleSide / 2;
        int triangleBottomXDiff = triangleSide / 2;
        int upLineY = withArrow ? triangleBottomY : 0;
        $this$drawUpLine.drawLine(5, this.getConnectionCenterY(), 5, upLineY);
        if (withArrow) {
            int[] nArray = new int[]{5, 5 - triangleBottomXDiff, 5 + triangleBottomXDiff};
            int[] xPoints = nArray;
            int[] nArray2 = new int[]{0, triangleBottomY, triangleBottomY};
            int[] yPoints = nArray2;
            $this$drawUpLine.fillPolygon(xPoints, yPoints, xPoints.length);
        }
    }

    private final GraphType getRowGraphType(GitRebaseCommitsTableView table, int row) {
        GitRebaseTodoModel.Element<?> element = table.getModel().getElement(row);
        return element instanceof GitRebaseTodoModel.Element.UniteChild ? (GraphType)new GraphType.FixupGraph(table.getModel().isFirstFixup((GitRebaseTodoModel.Element.UniteChild)element), table.getModel().isLastFixup((GitRebaseTodoModel.Element.UniteChild)element)) : (GraphType)GraphType.NoGraph.INSTANCE;
    }

    protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        if (value != null) {
            this.setBorder(null);
            this.setOpaque(false);
            GitRebaseCommitsTableView commitsTable2 = (GitRebaseCommitsTableView)((Object)table);
            this.graphType = this.getRowGraphType(commitsTable2, row);
            this.rowHeight = table.getRowHeight(row);
            SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            GitRebaseTodoModel.Element<?> element = commitsTable2.getModel().getRebaseTodoModel().getElements().get(row);
            GitRebaseTodoModel.Type type = element.getType();
            if (Intrinsics.areEqual((Object)type, (Object)GitRebaseTodoModel.Type.NonUnite.Drop.INSTANCE)) {
                attributes = new SimpleTextAttributes(4, null);
            } else if (type instanceof GitRebaseTodoModel.Type.NonUnite.KeepCommit.Reword) {
                attributes = new SimpleTextAttributes(0, (Color)JBColor.BLUE);
            } else if (Intrinsics.areEqual((Object)type, (Object)GitRebaseTodoModel.Type.Unite.INSTANCE)) {
                this.append("");
                this.appendTextPadding(20);
            }
            this.append(IndexedDetails.Companion.getSubject(commitsTable2.getModel().getCommitMessage(row)), attributes, true);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)((SimpleColoredComponent)this), (boolean)true, (boolean)selected);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/rebase/interactive/dialog/SubjectRenderer$Companion;", "", "()V", "CONNECTION_CENTER_X", "", "GRAPH_WIDTH", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType;", "", "()V", "FixupGraph", "NoGraph", "Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType$FixupGraph;", "Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType$NoGraph;", "intellij.vcs.git"})
    private static abstract class GraphType {
        private GraphType() {
        }

        public /* synthetic */ GraphType(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType$NoGraph;", "Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType;", "()V", "intellij.vcs.git"})
        public static final class NoGraph
        extends GraphType {
            @NotNull
            public static final NoGraph INSTANCE = new NoGraph();

            private NoGraph() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType$FixupGraph;", "Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType;", "isFirst", "", "isLast", "(ZZ)V", "()Z", "intellij.vcs.git"})
        public static final class FixupGraph
        extends GraphType {
            private final boolean isFirst;
            private final boolean isLast;

            public FixupGraph(boolean isFirst, boolean isLast) {
                super(null);
                this.isFirst = isFirst;
                this.isLast = isLast;
            }

            public final boolean isFirst() {
                return this.isFirst;
            }

            public final boolean isLast() {
                return this.isLast;
            }
        }
    }
}

