/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.conflict;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitRevisionNumber;
import git4idea.branch.GitRebaseParams;
import git4idea.history.GitHistoryUtils;
import git4idea.merge.GitDefaultMergeDialogCustomizer;
import git4idea.rebase.GitRebaseSpec;
import git4idea.rebase.conflict.GitRebaseMergeDialogCustomizer;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createRebaseDialogCustomizer", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;", "repository", "Lgit4idea/repo/GitRepository;", "rebaseSpec", "Lgit4idea/rebase/GitRebaseSpec;", "intellij.vcs.git"})
public final class GitRebaseMergeDialogCustomizerKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final MergeDialogCustomizer createRebaseDialogCustomizer(@NotNull GitRepository repository, @NotNull GitRebaseSpec rebaseSpec) {
        Hash hash;
        String branch;
        String string;
        String upstream;
        String string2;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)rebaseSpec, (String)"rebaseSpec");
        GitRebaseParams rebaseParams = rebaseSpec.getParams();
        if (rebaseParams == null) {
            Project project = repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"repository.project");
            return new GitDefaultMergeDialogCustomizer(project);
        }
        String currentBranchAtTheStartOfRebase = rebaseSpec.getInitialBranchNames().get(repository);
        String it = string2 = rebaseParams.getUpstream();
        boolean bl = false;
        String string3 = !Intrinsics.areEqual((Object)it, (Object)"HEAD") ? string2 : null;
        if (string3 == null) {
            string3 = upstream = currentBranchAtTheStartOfRebase;
        }
        if ((string = rebaseParams.getBranch()) == null) {
            string = branch = currentBranchAtTheStartOfRebase;
        }
        if (upstream == null || branch == null) {
            Project project = repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"repository.project");
            return new GitDefaultMergeDialogCustomizer(project);
        }
        try {
            it = HashImpl.build((String)GitRevisionNumber.resolve(repository.getProject(), repository.getRoot(), "REBASE_HEAD").asString());
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            it = null;
        }
        String rebaseHead = it;
        try {
            Hash hash2;
            GitRevisionNumber gitRevisionNumber = GitHistoryUtils.getMergeBase(repository.getProject(), repository.getRoot(), upstream, branch);
            if (gitRevisionNumber != null) {
                GitRevisionNumber it2 = gitRevisionNumber;
                boolean bl2 = false;
                hash2 = HashImpl.build((String)it2.getRev());
            } else {
                hash2 = null;
            }
            hash = hash2;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            hash = null;
        }
        Hash mergeBase = hash;
        return new GitRebaseMergeDialogCustomizer(repository, upstream, branch, (Hash)rebaseHead, mergeBase);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitRebaseMergeDialogCustomizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }
}

