/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.commands.GitTask;
import git4idea.commands.GitTaskResultHandlerAdapter;
import git4idea.commands.GitTaskResultNotificationHandler;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.rebase.GitHandlerRebaseEditorManager;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaseUtils;
import git4idea.update.GitUpdateResult;
import git4idea.util.GitUntrackedFilesHelper;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaser {
    private static final Logger LOG = Logger.getInstance(GitRebaser.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @NotNull
    private final List<GitRebaseUtils.CommitInfo> mySkippedCommits;

    public GitRebaser(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator progressIndicator) {
        this.myProject = project;
        this.myGit = git;
        this.myProgressIndicator = progressIndicator;
        this.myVcs = GitVcs.getInstance(project);
        this.mySkippedCommits = new ArrayList<GitRebaseUtils.CommitInfo>();
    }

    public GitUpdateResult rebase(@NotNull VirtualFile root, @NotNull List<String> parameters, @Nullable Runnable onCancel, @Nullable GitLineHandlerListener lineListener) {
        GitUpdateResult gitUpdateResult;
        block10: {
            GitLineHandler rebaseHandler = this.createHandler(root);
            rebaseHandler.setStdoutSuppressed(false);
            rebaseHandler.addParameters(parameters);
            if (lineListener != null) {
                rebaseHandler.addLineListener(lineListener);
            }
            GitRebaseProblemDetector rebaseConflictDetector = new GitRebaseProblemDetector();
            rebaseHandler.addLineListener(rebaseConflictDetector);
            GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
            GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.CHECKOUT);
            rebaseHandler.addLineListener(untrackedFilesDetector);
            rebaseHandler.addLineListener(localChangesDetector);
            rebaseHandler.addLineListener(GitStandardProgressAnalyzer.createListener(this.myProgressIndicator));
            AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)GitBundle.message("activity.name.rebase", new Object[0]));
            try {
                String oldText = this.myProgressIndicator.getText();
                this.myProgressIndicator.setText(GitBundle.message("rebase.progress.indicator.title", new Object[0]));
                GitCommandResult result2 = this.myGit.runCommand(rebaseHandler);
                this.myProgressIndicator.setText(oldText);
                GitUpdateResult gitUpdateResult2 = gitUpdateResult = result2.success() ? GitUpdateResult.SUCCESS : this.handleRebaseFailure(rebaseHandler, root, result2, rebaseConflictDetector, untrackedFilesDetector, localChangesDetector);
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ProcessCanceledException pce) {
                    if (onCancel != null) {
                        onCancel.run();
                    }
                    return GitUpdateResult.CANCEL;
                }
            }
            ignore.close();
        }
        return gitUpdateResult;
    }

    protected GitLineHandler createHandler(VirtualFile root) {
        return new GitLineHandler(this.myProject, root, GitCommand.REBASE);
    }

    public void abortRebase(@NotNull VirtualFile root) {
        LOG.info("abortRebase " + root);
        GitLineHandler rh = new GitLineHandler(this.myProject, root, GitCommand.REBASE);
        rh.setStdoutSuppressed(false);
        rh.addParameters("--abort");
        GitTask task = new GitTask(this.myProject, rh, GitBundle.message("rebase.update.project.abort.task.title", new Object[0]));
        task.setProgressIndicator(this.myProgressIndicator);
        task.executeAsync(new GitTaskResultNotificationHandler(this.myProject, "git.rebase.abort", GitBundle.message("rebase.update.project.notification.abort.success.message", new Object[0]), GitBundle.message("rebase.update.project.notification.abort.cancel.message", new Object[0]), GitBundle.message("rebase.update.project.notification.abort.error.message", new Object[0])));
    }

    public boolean continueRebase(@NotNull VirtualFile root) {
        return this.continueRebase(root, false);
    }

    private boolean skipCommitAndContinue(@NotNull VirtualFile root) {
        return this.continueRebase(root, true);
    }

    public boolean continueRebase(@NotNull Collection<? extends VirtualFile> rebasingRoots) {
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)GitBundle.message("activity.name.rebase", new Object[0]));){
            boolean success = true;
            for (VirtualFile virtualFile : rebasingRoots) {
                success &= this.continueRebase(virtualFile);
            }
            boolean bl = success;
            return bl;
        }
    }

    private boolean continueRebase(@NotNull VirtualFile root, boolean skip) {
        LOG.info(String.format("continueRebase in %s, skip: %s", root, skip));
        GitLineHandler rh = new GitLineHandler(this.myProject, root, GitCommand.REBASE);
        rh.setStdoutSuppressed(false);
        rh.addParameters(skip ? "--skip" : "--continue");
        GitRebaseProblemDetector rebaseConflictDetector = new GitRebaseProblemDetector();
        rh.addLineListener(rebaseConflictDetector);
        TrivialEditor editor = new TrivialEditor();
        try (GitHandlerRebaseEditorManager ignored = GitHandlerRebaseEditorManager.prepareEditor(rh, editor);){
            GitTask rebaseTask = new GitTask(this.myProject, rh, GitBundle.message("rebase.progress.indicator.continue.title", new Object[0]));
            rebaseTask.setProgressAnalyzer(new GitStandardProgressAnalyzer());
            rebaseTask.setProgressIndicator(this.myProgressIndicator);
            boolean bl = this.executeRebaseTaskInBackground(root, rh, rebaseConflictDetector, rebaseTask);
            return bl;
        }
    }

    @NotNull
    public Collection<VirtualFile> getRebasingRoots() {
        HashSet<VirtualFile> rebasingRoots = new HashSet<VirtualFile>();
        for (VirtualFile root : ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)this.myVcs)) {
            if (!GitRebaseUtils.isRebaseInTheProgress(this.myProject, root)) continue;
            rebasingRoots.add(root);
        }
        return rebasingRoots;
    }

    private boolean executeRebaseTaskInBackground(VirtualFile root, GitLineHandler h, GitRebaseProblemDetector rebaseConflictDetector, GitTask rebaseTask) {
        final AtomicBoolean result2 = new AtomicBoolean();
        final AtomicBoolean failure = new AtomicBoolean();
        rebaseTask.executeInBackground(true, new GitTaskResultHandlerAdapter(){

            @Override
            protected void onSuccess() {
                result2.set(true);
            }

            @Override
            protected void onCancel() {
                result2.set(false);
            }

            @Override
            protected void onFailure() {
                failure.set(true);
            }
        });
        if (failure.get()) {
            result2.set(this.handleRebaseFailure(root, h, rebaseConflictDetector));
        }
        return result2.get();
    }

    private boolean handleRebaseFailure(final VirtualFile root, GitLineHandler h, GitRebaseProblemDetector rebaseConflictDetector) {
        if (rebaseConflictDetector.isMergeConflict()) {
            LOG.info("handleRebaseFailure merge conflict");
            return new GitConflictResolver(this.myProject, Collections.singleton(root), GitRebaser.makeParams(this.myProject)){

                @Override
                protected boolean proceedIfNothingToMerge() {
                    this.notifyUnresolvedRemain();
                    return false;
                }

                @Override
                protected boolean proceedAfterAllMerged() {
                    return GitRebaser.this.continueRebase(root);
                }
            }.merge();
        }
        if (rebaseConflictDetector.isNoChangeError()) {
            LOG.info("handleRebaseFailure no changes error detected");
            try {
                if (GitUtil.hasLocalChanges(true, this.myProject, root)) {
                    LOG.error("The rebase detector incorrectly detected 'no changes' situation. Attempting to continue rebase.");
                    return this.continueRebase(root);
                }
                if (GitUtil.hasLocalChanges(false, this.myProject, root)) {
                    LOG.warn("No changes from patch were not added to the index. Adding all changes from tracked files.");
                    this.stageEverything(root);
                    return this.continueRebase(root);
                }
                GitRebaseUtils.CommitInfo commit = GitRebaseUtils.getCurrentRebaseCommit(this.myProject, root);
                LOG.info("no changes confirmed. Skipping commit " + commit);
                this.mySkippedCommits.add(commit);
                return this.skipCommitAndContinue(root);
            }
            catch (VcsException e) {
                LOG.info("Failed to work around 'no changes' error.", (Throwable)e);
                VcsNotifier.getInstance((Project)this.myProject).notifyError("git.rebase.update.project.error", GitBundle.message("rebase.update.project.notification.failed.title", new Object[0]), GitBundle.message("rebase.update.project.notification.failed.message", e.getMessage()));
                return false;
            }
        }
        LOG.info("handleRebaseFailure error " + h.errors());
        VcsNotifier.getInstance((Project)this.myProject).notifyError("git.rebase.update.project.error", GitBundle.message("rebase.update.project.notification.failed.title", new Object[0]), "", h.errors());
        return false;
    }

    private void stageEverything(@NotNull VirtualFile root) throws VcsException {
        GitLineHandler handler = new GitLineHandler(this.myProject, root, GitCommand.ADD);
        handler.setSilent(false);
        handler.addParameters("--update");
        this.myGit.runCommand(handler).throwOnError(new int[0]);
    }

    @NotNull
    private static GitConflictResolver.Params makeParams(@NotNull Project project) {
        return new GitConflictResolver.Params(project).setReverse(true).setErrorNotificationTitle(GitBundle.message("rebase.update.project.conflict.error.notification.title", new Object[0])).setMergeDescription(GitBundle.message("rebase.update.project.conflict.merge.description.label", new Object[0])).setErrorNotificationAdditionalDescription(GitBundle.message("rebase.update.project.conflict.error.notification.description", new Object[0]));
    }

    @NotNull
    public GitUpdateResult handleRebaseFailure(@NotNull GitLineHandler handler, @NotNull VirtualFile root, @NotNull GitCommandResult result2, @NotNull GitRebaseProblemDetector rebaseConflictDetector, @NotNull GitMessageWithFilesDetector untrackedWouldBeOverwrittenDetector, @NotNull GitLocalChangesWouldBeOverwrittenDetector localChangesDetector) {
        if (rebaseConflictDetector.isMergeConflict()) {
            LOG.info("handleRebaseFailure merge conflict");
            boolean allMerged = new ConflictResolver(this.myProject, this.myGit, root, this).merge();
            return allMerged ? GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS : GitUpdateResult.INCOMPLETE;
        }
        if (untrackedWouldBeOverwrittenDetector.wasMessageDetected()) {
            LOG.info("handleRebaseFailure: untracked files would be overwritten by checkout");
            GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, root, untrackedWouldBeOverwrittenDetector.getRelativeFilePaths(), GitBundle.message("rebase.operation.name", new Object[0]), null);
            return GitUpdateResult.ERROR;
        }
        if (localChangesDetector.wasMessageDetected()) {
            LocalChangesWouldBeOverwrittenHelper.showErrorNotification(this.myProject, "git.merge.local.changes.detected", root, GitBundle.message("rebase.git.operation.name", new Object[0]), localChangesDetector.getRelativeFilePaths());
            return GitUpdateResult.ERROR;
        }
        LOG.info("handleRebaseFailure error " + handler.errors());
        VcsNotifier.getInstance((Project)this.myProject).notifyError("git.rebase.update.project.error", GitBundle.message("rebase.update.project.notification.failed.title", new Object[0]), result2.getErrorOutputAsHtmlString(), true);
        return GitUpdateResult.ERROR;
    }

    public static class TrivialEditor
    implements GitRebaseEditorHandler {
        @Override
        public int editCommits(@NotNull File file2) {
            return 0;
        }

        @Override
        public boolean wasCommitListEditorCancelled() {
            return false;
        }

        @Override
        public boolean wasUnstructuredEditorCancelled() {
            return false;
        }
    }

    public static class ConflictResolver
    extends GitConflictResolver {
        @NotNull
        private final GitRebaser myRebaser;
        @NotNull
        private final VirtualFile myRoot;

        public ConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull VirtualFile root, @NotNull GitRebaser rebaser) {
            super(project, Collections.singleton(root), GitRebaser.makeParams(project));
            this.myRebaser = rebaser;
            this.myRoot = root;
        }

        @Override
        protected boolean proceedIfNothingToMerge() {
            return this.myRebaser.continueRebase(this.myRoot);
        }

        @Override
        protected boolean proceedAfterAllMerged() {
            return this.myRebaser.continueRebase(this.myRoot);
        }
    }
}

