/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.StartupUiUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseHelpPopupPanel;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u0001H\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgit4idea/rebase/GitRebaseHelpPopupPanel;", "Ljavax/swing/JPanel;", "()V", "content", "helpLink", "Lcom/intellij/ui/components/BrowserLink;", "getHelpLink", "()Lcom/intellij/ui/components/BrowserLink;", "rebaseBranchImage", "Ljavax/swing/JComponent;", "chooseImage", "", "imagePath", "createContent", "createHelpLink", "createImageComponent", "loadImage", "Ljava/awt/Image;", "path", "Companion", "intellij.vcs.git"})
public final class GitRebaseHelpPopupPanel
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrowserLink helpLink = this.createHelpLink();
    @NotNull
    private final JComponent rebaseBranchImage = this.createImageComponent("/images/rebase-branch");
    @NotNull
    private final JPanel content = this.createContent();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String REBASE_BRANCH_IMG = "/images/rebase-branch";
    @NotNull
    private static final String DARK_POSTFIX = "-dark";
    @NotNull
    private static final String HIDPI_POSTFIX = "@2x";

    public GitRebaseHelpPopupPanel() {
        this.add((Component)this.content, "Center");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@Nullable KeyEvent e) {
                KeyEvent keyEvent = e;
                boolean bl = keyEvent != null ? keyEvent.getKeyCode() == 32 : false;
                if (bl) {
                    this.getHelpLink().doClick();
                }
            }
        });
    }

    @NotNull
    public final BrowserLink getHelpLink() {
        return this.helpLink;
    }

    private final JPanel createContent() {
        return (JPanel)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ GitRebaseHelpPopupPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)createContent.1.INSTANCE, (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ GitRebaseHelpPopupPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell(GitRebaseHelpPopupPanel.access$getRebaseBranchImage$p(this.this$0));
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ GitRebaseHelpPopupPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)this.this$0.getHelpLink());
                    }
                }), (int)1, null);
            }
        }));
    }

    private final BrowserLink createHelpLink() {
        String string = GitBundle.message("rebase.help.link", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"rebase.help.link\")");
        return new BrowserLink(string, "https://git-scm.com/docs/git-rebase");
    }

    private final JComponent createImageComponent(String imagePath) {
        JBImageIcon jBImageIcon;
        Image image;
        String suitableImagePath = this.chooseImage(imagePath);
        Image image2 = image = this.loadImage(suitableImagePath);
        if (image2 != null) {
            Image p0 = image2;
            boolean bl = false;
            jBImageIcon = new JBImageIcon(p0);
        } else {
            jBImageIcon = null;
        }
        Icon icon = (Icon)jBImageIcon;
        return new JLabel(icon);
    }

    private final Image loadImage(String path) {
        Image image;
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResourceAsStream(path));
            image = (Image)new JBHiDPIScaledImage((Image)img, 274, 140, img.getType());
        }
        catch (Exception e) {
            LOG.warn("Failed to load image: " + path, (Throwable)e);
            image = null;
        }
        return image;
    }

    private final String chooseImage(String imagePath) {
        String themePart = StartupUiUtil.isUnderDarcula() ? DARK_POSTFIX : "";
        String retinaPart = StartupUiUtil.isJreHiDPI() ? HIDPI_POSTFIX : "";
        return imagePath + themePart + retinaPart + ".png";
    }

    public static final /* synthetic */ JComponent access$getRebaseBranchImage$p(GitRebaseHelpPopupPanel $this) {
        return $this.rebaseBranchImage;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitRebaseHelpPopupPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/rebase/GitRebaseHelpPopupPanel$Companion;", "", "()V", "DARK_POSTFIX", "", "HIDPI_POSTFIX", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "REBASE_BRANCH_IMG", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

