/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.Pair;
import git4idea.commands.GitHandler;
import git4idea.commands.GitScriptGenerator;
import git4idea.config.GitExecutable;
import git4idea.editor.GitRebaseEditorApp;
import git4idea.editor.GitRebaseEditorXmlRpcHandler;
import git4idea.rebase.GitRebaseEditorHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;

@Service(value={Service.Level.APP})
public final class GitRebaseEditorService
implements Disposable {
    private final Object myScriptLock = new Object();
    private final Map<UUID, Pair<GitRebaseEditorHandler, GitExecutable>> myHandlers = new HashMap<UUID, Pair<GitRebaseEditorHandler, GitExecutable>>();
    private final Object myHandlersLock = new Object();

    @NotNull
    public static GitRebaseEditorService getInstance() {
        GitRebaseEditorService service = (GitRebaseEditorService)ApplicationManager.getApplication().getService(GitRebaseEditorService.class);
        if (service == null) {
            throw new IllegalStateException("The service " + GitRebaseEditorService.class.getName() + " cannot be located");
        }
        return service;
    }

    private void addInternalHandler() {
        XmlRpcServer xmlRpcServer = XmlRpcServer.getInstance();
        if (!xmlRpcServer.hasHandler(GitRebaseEditorXmlRpcHandler.HANDLER_NAME)) {
            xmlRpcServer.addHandler(GitRebaseEditorXmlRpcHandler.HANDLER_NAME, (Object)new InternalHandlerRebase());
        }
    }

    public void dispose() {
        XmlRpcServer xmlRpcServer = (XmlRpcServer)ApplicationManager.getApplication().getServiceIfCreated(XmlRpcServer.class);
        if (xmlRpcServer != null) {
            xmlRpcServer.removeHandler(GitRebaseEditorXmlRpcHandler.HANDLER_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public synchronized String getEditorCommand(@NotNull GitExecutable executable) {
        Object object = this.myScriptLock;
        synchronized (object) {
            int port = BuiltInServerManager.getInstance().waitForStart().getPort();
            return new GitScriptGenerator(executable).addParameters(new String[]{Integer.toString(port)}).commandLine(GitRebaseEditorApp.class, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public UUID registerHandler(@NotNull GitHandler handler, @NotNull GitRebaseEditorHandler editorHandler) {
        this.addInternalHandler();
        Object object = this.myHandlersLock;
        synchronized (object) {
            UUID key = UUID.randomUUID();
            this.myHandlers.put(key, (Pair<GitRebaseEditorHandler, GitExecutable>)Pair.create((Object)editorHandler, (Object)handler.getExecutable()));
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(@NotNull UUID handlerNo) {
        Object object = this.myHandlersLock;
        synchronized (object) {
            if (this.myHandlers.remove(handlerNo) == null) {
                throw new IllegalStateException("The handler " + handlerNo + " has been already removed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    Pair<GitRebaseEditorHandler, GitExecutable> getHandler(@NotNull UUID handlerNo) {
        Object object = this.myHandlersLock;
        synchronized (object) {
            Pair<GitRebaseEditorHandler, GitExecutable> pair = this.myHandlers.get(handlerNo);
            if (pair == null) {
                throw new IllegalStateException("The handler " + handlerNo + " is not registered");
            }
            return pair;
        }
    }

    public class InternalHandlerRebase
    implements GitRebaseEditorXmlRpcHandler {
        public int editCommits(@NotNull String handlerNo, @NotNull String path, @NotNull String workingDir) {
            Pair<GitRebaseEditorHandler, GitExecutable> pair = GitRebaseEditorService.this.getHandler(UUID.fromString(handlerNo));
            GitExecutable executable = (GitExecutable)pair.second;
            GitRebaseEditorHandler editorHandler = (GitRebaseEditorHandler)pair.first;
            File file2 = executable.convertFilePathBack(path, new File(workingDir));
            return editorHandler.editCommits(file2);
        }
    }
}

