/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.rebase.GitRebaseEntry;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class GitInteractiveRebaseFile {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final File myFile;

    GitInteractiveRebaseFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull File file2) {
        this.myProject = project;
        this.myRoot = root;
        this.myFile = file2;
    }

    @NotNull
    public List<GitRebaseEntry> load() throws IOException, NoopException {
        String encoding = GitConfigUtil.getLogEncoding(this.myProject, this.myRoot);
        ArrayList<GitRebaseEntry> entries = new ArrayList<GitRebaseEntry>();
        StringScanner s = new StringScanner(FileUtil.loadFile((File)this.myFile, (String)encoding));
        boolean noop = false;
        while (s.hasMoreData()) {
            if (s.isEol() || this.isComment(s)) {
                s.nextLine();
                continue;
            }
            if (s.startsWith("noop")) {
                noop = true;
                s.nextLine();
                continue;
            }
            String action = s.spaceToken();
            String hash = s.spaceToken();
            String comment = s.line();
            entries.add(new GitRebaseEntry(action, hash, comment));
        }
        if (noop && entries.isEmpty()) {
            throw new NoopException();
        }
        return entries;
    }

    private boolean isComment(@NotNull StringScanner s) {
        String commentChar = GitVersionSpecialty.KNOWS_CORE_COMMENT_CHAR.existsIn(this.myProject) ? "\u0001" : "#";
        return s.startsWith(commentChar);
    }

    public void cancel() throws IOException {
        try (PrintWriter out = new PrintWriter(new FileWriter(this.myFile));){
            out.println("# rebase is cancelled");
        }
    }

    public void save(@NotNull List<? extends GitRebaseEntry> entries) throws IOException {
        String encoding = GitConfigUtil.getLogEncoding(this.myProject, this.myRoot);
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.myFile), encoding));){
            boolean knowsDropAction = GitVersionSpecialty.KNOWS_REBASE_DROP_ACTION.existsIn(this.myProject);
            for (GitRebaseEntry gitRebaseEntry : entries) {
                if (gitRebaseEntry.getAction() == GitRebaseEntry.Action.DROP.INSTANCE && !knowsDropAction) continue;
                out.println(gitRebaseEntry);
            }
        }
    }

    static class NoopException
    extends Exception {
        NoopException() {
        }
    }
}

