/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import git4idea.push.GitPushRepoResult;
import git4idea.repo.GitRepository;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class GroupedPushResult {
    @NotNull
    final Map<GitRepository, GitPushRepoResult> successful;
    @NotNull
    final Map<GitRepository, GitPushRepoResult> errors;
    @NotNull
    final Map<GitRepository, GitPushRepoResult> rejected;
    @NotNull
    final Map<GitRepository, GitPushRepoResult> customRejected;

    private GroupedPushResult(@NotNull Map<GitRepository, GitPushRepoResult> successful, @NotNull Map<GitRepository, GitPushRepoResult> errors, @NotNull Map<GitRepository, GitPushRepoResult> rejected, @NotNull Map<GitRepository, GitPushRepoResult> customRejected) {
        this.successful = successful;
        this.errors = errors;
        this.rejected = rejected;
        this.customRejected = customRejected;
    }

    @NotNull
    static GroupedPushResult group(@NotNull Map<GitRepository, GitPushRepoResult> results) {
        HashMap<GitRepository, GitPushRepoResult> successful = new HashMap<GitRepository, GitPushRepoResult>();
        HashMap<GitRepository, GitPushRepoResult> rejected = new HashMap<GitRepository, GitPushRepoResult>();
        HashMap<GitRepository, GitPushRepoResult> customRejected = new HashMap<GitRepository, GitPushRepoResult>();
        HashMap<GitRepository, GitPushRepoResult> errors = new HashMap<GitRepository, GitPushRepoResult>();
        for (Map.Entry<GitRepository, GitPushRepoResult> entry : results.entrySet()) {
            GitRepository repository = entry.getKey();
            GitPushRepoResult result2 = entry.getValue();
            HashMap<GitRepository, GitPushRepoResult> map2 = switch (result2.getType()) {
                case GitPushRepoResult.Type.REJECTED_NO_FF -> rejected;
                case GitPushRepoResult.Type.ERROR -> errors;
                case GitPushRepoResult.Type.REJECTED_STALE_INFO, GitPushRepoResult.Type.REJECTED_OTHER -> customRejected;
                default -> successful;
            };
            map2.put(repository, result2);
        }
        return new GroupedPushResult(successful, errors, rejected, customRejected);
    }
}

