/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.PushTargetEditorListener;
import com.intellij.dvcs.push.ui.PushTargetTextField;
import com.intellij.dvcs.push.ui.VcsEditableTextComponent;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.dvcs.push.ui.VcsLinkedTextComponent;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTarget;
import git4idea.remote.GitDefineRemoteDialog;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushTargetPanel
extends PushTargetPanel<GitPushTarget> {
    private static final Logger LOG = Logger.getInstance(GitPushTargetPanel.class);
    private static final Comparator<GitRemoteBranch> REMOTE_BRANCH_COMPARATOR = new MyRemoteBranchComparator();
    private static final String SEPARATOR = " : ";
    private static final Color NEW_BRANCH_LABEL_FG = new JBColor(46397, 7054941);
    private static final Color NEW_BRANCH_LABEL_SELECTION_FG = UIUtil.getTreeSelectionForeground();
    private static final Color NEW_BRANCH_LABEL_BG = new JBColor(15465713, 3226418);
    private static final Color NEW_BRANCH_LABEL_SELECTION_BG = new JBColor(ColorUtil.toAlpha((Color)NEW_BRANCH_LABEL_SELECTION_FG, (int)20), ColorUtil.toAlpha((Color)NEW_BRANCH_LABEL_SELECTION_FG, (int)30));
    private static final RelativeFont NEW_BRANCH_LABEL_FONT = RelativeFont.TINY.small();
    private static final TextIcon NEW_BRANCH_LABEL = new TextIcon(GitBundle.message("push.dialog.target.panel.new", new Object[0]), NEW_BRANCH_LABEL_FG, NEW_BRANCH_LABEL_BG, 0);
    @NotNull
    private final GitPushSupport myPushSupport;
    @NotNull
    private final GitRepository myRepository;
    @NotNull
    private final GitPushSource mySource;
    @NotNull
    private final Git myGit;
    @NotNull
    private final VcsEditableTextComponent myTargetRenderer;
    @NotNull
    private final PushTargetTextField myTargetEditor;
    @NotNull
    private final VcsLinkedTextComponent myRemoteRenderer;
    @NotNull
    private final Project myProject;
    @Nullable
    private GitPushTarget myCurrentTarget;
    @Nullable
    @Nls
    private String myError;
    @Nullable
    private Runnable myFireOnChangeAction;
    private boolean myBranchWasUpdatedManually;
    private boolean myEventFromRemoteChooser;

    public GitPushTargetPanel(@NotNull GitPushSupport support, @NotNull GitRepository repository, @Nullable GitPushTarget defaultTarget) {
        this(support, repository, support.getSource(repository), defaultTarget);
    }

    public GitPushTargetPanel(@NotNull GitPushSupport support, @NotNull GitRepository repository, @NotNull GitPushSource source, @Nullable GitPushTarget defaultTarget) {
        this.myPushSupport = support;
        this.myRepository = repository;
        this.mySource = source;
        this.myGit = Git.getInstance();
        this.myProject = this.myRepository.getProject();
        this.myTargetRenderer = new VcsEditableTextComponent("", null);
        this.myTargetEditor = new PushTargetTextField(repository.getProject(), GitPushTargetPanel.getTargetNames(this.myRepository), "");
        this.myRemoteRenderer = new VcsLinkedTextComponent("", new VcsLinkListener(){

            public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode, @NotNull MouseEvent event) {
                if (GitPushTargetPanel.this.myRepository.getRemotes().isEmpty()) {
                    GitPushTargetPanel.this.showDefineRemoteDialog();
                } else {
                    Component eventComponent = event.getComponent();
                    if (eventComponent != null) {
                        GitPushTargetPanel.this.showRemoteSelector(eventComponent, event.getPoint());
                    }
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JPanel remoteAndSeparator = new JPanel(new BorderLayout());
        remoteAndSeparator.setOpaque(false);
        remoteAndSeparator.add((Component)this.myRemoteRenderer, "Center");
        remoteAndSeparator.add((Component)new JBLabel(SEPARATOR), "East");
        this.add(remoteAndSeparator, "West");
        this.add((Component)this.myTargetEditor, "Center");
        this.updateComponents(defaultTarget);
        this.setFocusCycleRoot(true);
        this.myRemoteRenderer.setFocusable(true);
        this.myTargetEditor.setFocusable(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)((Object)new MyGitTargetFocusTraversalPolicy()));
        this.myRemoteRenderer.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                    GitPushTargetPanel.this.showRemoteSelector((Component)GitPushTargetPanel.this.myRemoteRenderer, new Point(GitPushTargetPanel.this.myRemoteRenderer.getLocation()));
                }
            }
        });
        UndoUtil.disableUndoFor((Document)this.myTargetEditor.getDocument());
    }

    private void updateComponents(@Nullable GitPushTarget target) {
        this.myCurrentTarget = target;
        String initialBranch = "";
        String initialRemote = "";
        boolean noRemotes = this.myRepository.getRemotes().isEmpty();
        if (target == null) {
            if (this.myRepository.getCurrentBranch() == null) {
                this.myError = GitBundle.message("push.dialog.target.panel.detached.head", new Object[0]);
            } else if (this.myRepository.isFresh()) {
                this.myError = GitBundle.message("push.dialog.target.panel.empty.repository", new Object[0]);
            } else if (!noRemotes) {
                this.myError = GitBundle.message("push.dialog.target.panel.can.t.push", new Object[0]);
            }
        } else {
            initialBranch = GitPushTargetPanel.getTextFieldText(target);
            initialRemote = target.getBranch().getRemote().getName();
        }
        this.myTargetRenderer.updateLinkText(initialBranch);
        this.myTargetEditor.setText(initialBranch);
        this.myRemoteRenderer.updateLinkText(noRemotes ? GitBundle.message("push.dialog.target.panel.define.remote", new Object[0]) : initialRemote);
        this.myTargetEditor.setVisible(!noRemotes);
    }

    private void showDefineRemoteDialog() {
        GitDefineRemoteDialog dialog2 = new GitDefineRemoteDialog(this.myRepository, this.myGit, "origin", "");
        if (dialog2.showAndGet()) {
            this.addRemoteUnderModal(dialog2.getRemoteName(), dialog2.getRemoteUrl());
        }
    }

    private void addRemoteUnderModal(final @NotNull String remoteName, final @NotNull String remoteUrl) {
        ProgressManager.getInstance().run((Task)new Task.Modal(this.myRepository.getProject(), GitBundle.message("push.dialog.target.panel.adding.remote", new Object[0]), true){
            private GitCommandResult myResult;

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                this.myResult = GitPushTargetPanel.this.myGit.addRemote(GitPushTargetPanel.this.myRepository, remoteName, remoteUrl);
                GitPushTargetPanel.this.myRepository.update();
            }

            public void onSuccess() {
                if (this.myResult.success()) {
                    GitPushTargetPanel.this.updateComponents(GitPushTargetPanel.this.myPushSupport.getDefaultTarget(GitPushTargetPanel.this.myRepository, GitPushTargetPanel.this.mySource));
                    if (GitPushTargetPanel.this.myFireOnChangeAction != null) {
                        GitPushTargetPanel.this.myFireOnChangeAction.run();
                    }
                } else {
                    String message = GitBundle.message("push.dialog.target.panel.couldnt.add.remote", this.myResult.getErrorOutputAsHtmlString());
                    LOG.warn(message);
                    Messages.showErrorDialog((Project)this.myProject, (String)XmlStringUtil.wrapInHtml((CharSequence)message), (String)GitBundle.message("push.dialog.target.panel.add.remote", new Object[0]));
                }
            }
        });
    }

    private void showRemoteSelector(@NotNull Component component2, @NotNull Point point) {
        List<PopupItem> remotes = this.getPopupItems();
        if (remotes.size() <= 1) {
            return;
        }
        ListPopupImpl popup2 = new ListPopupImpl(this.myProject, (ListPopupStep)new BaseListPopupStep<PopupItem>(null, remotes){

            public PopupStep onChosen(@NotNull PopupItem selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> {
                    if (selectedValue.isDefineRemote()) {
                        GitPushTargetPanel.this.showDefineRemoteDialog();
                    } else {
                        GitPushTargetPanel.this.myRemoteRenderer.updateLinkText(selectedValue.getPresentable());
                        GitPushTargetPanel.this.myEventFromRemoteChooser = true;
                        if (!GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                            String defaultPushTargetBranch;
                            if (!GitPushTargetPanel.this.myBranchWasUpdatedManually && (defaultPushTargetBranch = GitPushTargetPanel.this.getDefaultPushTargetBranch()) != null) {
                                GitPushTargetPanel.this.myTargetEditor.setText(defaultPushTargetBranch);
                            }
                            if (GitPushTargetPanel.this.myFireOnChangeAction != null) {
                                GitPushTargetPanel.this.myFireOnChangeAction.run();
                            }
                        }
                        GitPushTargetPanel.this.myEventFromRemoteChooser = false;
                    }
                });
            }

            @Nullable
            public ListSeparator getSeparatorAbove(PopupItem value) {
                return value.isDefineRemote() ? new ListSeparator() : null;
            }
        }){

            public void cancel(InputEvent e) {
                super.cancel(e);
                if (GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                    GitPushTargetPanel.this.repaint();
                    IdeFocusManager.getInstance((Project)GitPushTargetPanel.this.myProject).requestFocus((Component)GitPushTargetPanel.this.myTargetEditor, true);
                }
            }
        };
        popup2.show(new RelativePoint(component2, point));
    }

    @Nullable
    private String getDefaultPushTargetBranch() {
        GitPushTarget fromPushSpec;
        GitLocalBranch sourceBranch = this.myRepository.getCurrentBranch();
        GitRemote remote = GitPushTarget.findRemote(this.myRepository.getRemotes(), this.myRemoteRenderer.getText());
        if (remote != null && sourceBranch != null && (fromPushSpec = GitPushTarget.getFromPushSpec(this.myRepository, remote, sourceBranch)) != null) {
            return fromPushSpec.getBranch().getNameForRemoteOperations();
        }
        return null;
    }

    @NotNull
    private List<PopupItem> getPopupItems() {
        ArrayList<PopupItem> items = new ArrayList<PopupItem>(ContainerUtil.map(this.myRepository.getRemotes(), PopupItem::forRemote));
        items.add(PopupItem.DEFINE_REMOTE);
        return items;
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer2, boolean isSelected, boolean isActive, @Nullable String forceRenderedText) {
        SimpleTextAttributes targetTextAttributes = PushLogTreeUtil.addTransparencyIfNeeded((SimpleColoredComponent)renderer2, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (boolean)isActive);
        if (this.myError != null) {
            renderer2.append(this.myError, PushLogTreeUtil.addTransparencyIfNeeded((SimpleColoredComponent)renderer2, (SimpleTextAttributes)SimpleTextAttributes.ERROR_ATTRIBUTES, (boolean)isActive));
        } else {
            Collection<GitRemote> remotes = this.myRepository.getRemotes();
            this.myRemoteRenderer.setSelected(isSelected);
            this.myRemoteRenderer.setTransparent(!remotes.isEmpty() && !isActive);
            this.myRemoteRenderer.render(renderer2);
            if (!remotes.isEmpty()) {
                renderer2.append(SEPARATOR, targetTextAttributes);
                if (forceRenderedText != null) {
                    renderer2.append(forceRenderedText);
                    return;
                }
                GitPushTarget target = this.getValue();
                boolean newRemoteBranch = target != null && target.isNewBranchCreated();
                this.myTargetRenderer.setSelected(isSelected);
                this.myTargetRenderer.setTransparent(!isActive);
                this.myTargetRenderer.render(renderer2);
                if (newRemoteBranch) {
                    renderer2.setIconOnTheRight(true);
                    NEW_BRANCH_LABEL.setInsets((Insets)JBUI.insets((int)2));
                    NEW_BRANCH_LABEL.setRound(JBUIScale.scale((int)4));
                    NEW_BRANCH_LABEL.setFont(NEW_BRANCH_LABEL_FONT.derive(renderer2.getFont()));
                    NEW_BRANCH_LABEL.setForeground(isSelected ? NEW_BRANCH_LABEL_SELECTION_FG : NEW_BRANCH_LABEL_FG);
                    NEW_BRANCH_LABEL.setBackground(isSelected ? NEW_BRANCH_LABEL_SELECTION_BG : NEW_BRANCH_LABEL_BG);
                    renderer2.setIcon((Icon)NEW_BRANCH_LABEL);
                }
            }
        }
    }

    @Nullable
    public GitPushTarget getValue() {
        return this.myCurrentTarget;
    }

    @NlsSafe
    @NotNull
    private static String getTextFieldText(@Nullable GitPushTarget target) {
        return target != null ? target.getBranch().getNameForRemoteOperations() : "";
    }

    public void fireOnCancel() {
        this.myTargetEditor.setText(GitPushTargetPanel.getTextFieldText(this.myCurrentTarget));
    }

    public void fireOnChange() {
        if (this.myError != null || this.myRepository.getRemotes().isEmpty()) {
            return;
        }
        String remoteName = this.myRemoteRenderer.getText();
        String branchName = this.myTargetEditor.getText();
        try {
            GitPushTarget target = GitPushTarget.parse(this.myRepository, remoteName, branchName);
            if (!target.equals(this.myCurrentTarget)) {
                this.myCurrentTarget = target;
                this.myTargetRenderer.updateLinkText(branchName);
                if (!this.myEventFromRemoteChooser) {
                    this.myBranchWasUpdatedManually = true;
                }
            }
        }
        catch (ParseException e) {
            LOG.error("Invalid remote name shouldn't be allowed. [" + remoteName + ", " + branchName + "]", (Throwable)e);
        }
    }

    @Nullable
    public ValidationInfo verify() {
        if (this.myError != null) {
            return new ValidationInfo(this.myError, (JComponent)this.myTargetEditor);
        }
        try {
            GitPushTarget.parse(this.myRepository, this.myRemoteRenderer.getText(), this.myTargetEditor.getText());
            return null;
        }
        catch (ParseException e) {
            return new ValidationInfo(e.getMessage(), (JComponent)this.myTargetEditor);
        }
    }

    public void setFireOnChangeAction(@NotNull Runnable action) {
        this.myFireOnChangeAction = action;
    }

    @NotNull
    private static List<String> getTargetNames(@NotNull GitRepository repository) {
        return repository.getBranches().getRemoteBranches().stream().sorted(REMOTE_BRANCH_COMPARATOR).map(GitRemoteBranch::getNameForRemoteOperations).collect(Collectors.toList());
    }

    public void addTargetEditorListener(final @NotNull PushTargetEditorListener listener2) {
        this.myTargetEditor.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                GitPushTargetPanel.this.processActiveUserChanges(listener2);
            }
        });
        this.myTargetEditor.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GitPushTargetPanel.this.processActiveUserChanges(listener2);
            }
        });
        this.myTargetEditor.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    if (GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                        UndoUtil.enableUndoFor((Document)GitPushTargetPanel.this.myTargetEditor.getDocument());
                    } else {
                        UndoUtil.disableUndoFor((Document)GitPushTargetPanel.this.myTargetEditor.getDocument());
                    }
                }
            }
        });
    }

    private void processActiveUserChanges(@NotNull PushTargetEditorListener listener2) {
        if (this.myTargetEditor.isShowing()) {
            listener2.onTargetInEditModeChanged(this.myTargetEditor.getText());
        }
    }

    public void forceUpdateEditableUiModel(@NotNull String forcedText) {
        if (!this.myTargetEditor.isShowing()) {
            this.myTargetEditor.setText(forcedText);
        }
    }

    private class MyGitTargetFocusTraversalPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyGitTargetFocusTraversalPolicy() {
        }

        @NotNull
        protected List<Component> getOrderedComponents() {
            return ContainerUtil.newArrayList((Object[])new Component[]{GitPushTargetPanel.this.myTargetEditor.getFocusTarget(), GitPushTargetPanel.this.myRemoteRenderer});
        }

        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (GitPushTargetPanel.this.getPopupItems().size() > 1) {
                return super.getComponentAfter(aContainer, aComponent);
            }
            return aComponent;
        }

        public Component getComponentBefore(Container aContainer, Component aComponent) {
            if (GitPushTargetPanel.this.getPopupItems().size() > 1) {
                return super.getComponentBefore(aContainer, aComponent);
            }
            return aComponent;
        }
    }

    private static final class PopupItem {
        static final PopupItem DEFINE_REMOTE = new PopupItem(null);
        @Nullable
        GitRemote remote;

        @NotNull
        static PopupItem forRemote(@NotNull GitRemote remote) {
            return new PopupItem(remote);
        }

        private PopupItem(@Nullable GitRemote remote) {
            this.remote = remote;
        }

        @Nls
        @NotNull
        String getPresentable() {
            return this.remote == null ? GitBundle.message("push.dialog.target.panel.define.remote", new Object[0]) : this.remote.getName();
        }

        boolean isDefineRemote() {
            return this.remote == null;
        }

        public String toString() {
            return this.getPresentable();
        }
    }

    private static class MyRemoteBranchComparator
    implements Comparator<GitRemoteBranch> {
        private MyRemoteBranchComparator() {
        }

        @Override
        public int compare(@NotNull GitRemoteBranch o1, @NotNull GitRemoteBranch o2) {
            String remoteName2;
            String remoteName1 = o1.getRemote().getName();
            int remoteComparison = remoteName1.compareTo(remoteName2 = o2.getRemote().getName());
            if (remoteComparison != 0) {
                if (remoteName1.equals("origin")) {
                    return -1;
                }
                if (remoteName2.equals("origin")) {
                    return 1;
                }
                return remoteComparison;
            }
            return o1.getNameForLocalOperations().compareTo(o2.getNameForLocalOperations());
        }
    }
}

