/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import com.intellij.openapi.util.NlsSafe;
import git4idea.GitLocalBranch;
import org.jetbrains.annotations.NotNull;

public abstract class GitPushSource
implements PushSource {
    @NotNull
    public static GitPushSource create(@NotNull GitLocalBranch branch) {
        return new OnBranch(branch);
    }

    @NotNull
    public static GitPushSource createRef(@NotNull GitLocalBranch branch, @NotNull String revision) {
        return new OnRevision(branch, revision);
    }

    @NotNull
    public static GitPushSource createDetached(@NotNull String revision) {
        return new DetachedHead(revision);
    }

    @NotNull
    public abstract GitLocalBranch getBranch();

    @NotNull
    public abstract String getRevision();

    public abstract boolean isBranchRef();

    public String toString() {
        return this.getPresentation();
    }

    static final class OnBranch
    extends GitPushSource {
        @NotNull
        private final GitLocalBranch myBranch;

        private OnBranch(@NotNull GitLocalBranch branch) {
            this.myBranch = branch;
        }

        @NotNull
        public String getPresentation() {
            return this.myBranch.getName();
        }

        @Override
        @NotNull
        public GitLocalBranch getBranch() {
            return this.myBranch;
        }

        @Override
        @NotNull
        public String getRevision() {
            return this.myBranch.getFullName();
        }

        @Override
        public boolean isBranchRef() {
            return true;
        }
    }

    static final class OnRevision
    extends GitPushSource {
        @NotNull
        private final GitLocalBranch myBranch;
        @NlsSafe
        private final String myRevision;

        private OnRevision(@NotNull GitLocalBranch branch, @NotNull String revision) {
            this.myBranch = branch;
            this.myRevision = revision;
        }

        @NotNull
        public String getPresentation() {
            return DvcsUtil.getShortHash((String)this.myRevision);
        }

        @Override
        @NotNull
        public GitLocalBranch getBranch() {
            return this.myBranch;
        }

        @Override
        @NotNull
        public String getRevision() {
            return this.myRevision;
        }

        @Override
        public boolean isBranchRef() {
            return false;
        }
    }

    static class DetachedHead
    extends GitPushSource {
        @NotNull
        private final String myRevision;

        DetachedHead(@NotNull String revision) {
            this.myRevision = revision;
        }

        @NotNull
        public String getPresentation() {
            return DvcsUtil.getShortHash((String)this.myRevision);
        }

        @Override
        @NotNull
        public GitLocalBranch getBranch() {
            throw new IllegalStateException("Push is not allowed from detached HEAD");
        }

        @Override
        @NotNull
        public String getRevision() {
            return this.myRevision;
        }

        @Override
        public boolean isBranchRef() {
            return false;
        }
    }
}

