/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.repo.Repository;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.merge.MergeChangeCollector;
import git4idea.push.GitPushNativeResult;
import git4idea.push.GitPushNativeResultParser;
import git4idea.push.GitPushParams;
import git4idea.push.GitPushParamsImpl;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTagMode;
import git4idea.push.GitPushTarget;
import git4idea.push.GitRejectedPushUpdateDialog;
import git4idea.push.GroupedPushResult;
import git4idea.push.PushUpdateSettings;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitRebaseOverMergeProblem;
import git4idea.update.GitUpdateProcess;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import git4idea.update.HashRange;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushOperation {
    private static final Logger LOG = Logger.getInstance(GitPushOperation.class);
    private static final int MAX_PUSH_ATTEMPTS = 10;
    private final Project myProject;
    @NotNull
    private final GitPushSupport myPushSupport;
    private final Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> myPushSpecs;
    @Nullable
    private final GitPushTagMode myTagMode;
    private final ForceMode myForceMode;
    private final boolean mySkipHook;
    private final Git myGit;
    private final ProgressIndicator myProgressIndicator;
    private final GitVcsSettings mySettings;
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final Map<GitRepository, HashRange> myUpdatedRanges = new LinkedHashMap<GitRepository, HashRange>();

    public GitPushOperation(@NotNull Project project, @NotNull GitPushSupport pushSupport, @NotNull Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> pushSpecs, @Nullable GitPushTagMode tagMode, boolean force, boolean skipHook) {
        this(project, pushSupport, pushSpecs, tagMode, GitPushOperation.getForceMode(force), skipHook);
    }

    @NotNull
    private static ForceMode getForceMode(boolean force) {
        if (force) {
            return AdvancedSettings.getBoolean((String)"git.use.push.force.with.lease") ? ForceMode.FORCE_WITH_LEASE : ForceMode.FORCE;
        }
        return ForceMode.NONE;
    }

    public GitPushOperation(@NotNull Project project, @NotNull GitPushSupport pushSupport, @NotNull Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> pushSpecs, @Nullable GitPushTagMode tagMode, @NotNull ForceMode forceMode, boolean skipHook) {
        this.myProject = project;
        this.myPushSupport = pushSupport;
        this.myPushSpecs = pushSpecs;
        this.myTagMode = tagMode;
        this.myForceMode = forceMode;
        this.mySkipHook = skipHook;
        this.myGit = Git.getInstance();
        this.myProgressIndicator = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)new EmptyProgressIndicator());
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
        this.myRepositoryManager = GitRepositoryManager.getInstance(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GitPushResult execute() {
        PushUpdateSettings updateSettings = this.readPushUpdateSettings();
        Label beforePushLabel = null;
        Label afterPushLabel = null;
        Map<GitRepository, String> preUpdatePositions = this.updateRootInfoAndRememberPositions();
        Boolean rebaseOverMergeProblemDetected = null;
        HashMap<GitRepository, GitPushRepoResult> results = new HashMap<GitRepository, GitPushRepoResult>();
        HashMap<GitRepository, GitUpdateResult> updatedRoots = new HashMap<GitRepository, GitUpdateResult>();
        try {
            Collection<GitRepository> remainingRoots = this.myPushSpecs.keySet();
            for (int pushAttempt = 0; pushAttempt < 10 && !remainingRoots.isEmpty(); ++pushAttempt) {
                LOG.debug("Starting push attempt #" + pushAttempt);
                Map<GitRepository, GitPushRepoResult> resultMap = this.push(this.myRepositoryManager.sortByDependency(remainingRoots));
                results.putAll(resultMap);
                GroupedPushResult result2 = GroupedPushResult.group(resultMap);
                if (!result2.errors.isEmpty()) break;
                if (!result2.customRejected.isEmpty()) {
                    break;
                }
                if (!result2.rejected.isEmpty()) {
                    if (this.myForceMode.isForce() || GitPushOperation.pushingToNotTrackedBranch(result2.rejected)) break;
                    if (GitPushOperation.pushingNotCurrentBranch(result2.rejected)) {
                        break;
                    }
                    if (pushAttempt == 0 && !this.mySettings.autoUpdateIfPushRejected()) {
                        rebaseOverMergeProblemDetected = !this.findRootsWithMergeCommits(this.myRepositoryManager.getRepositories()).isEmpty();
                        updateSettings = this.showDialogAndGetExitCode(result2.rejected.keySet(), updateSettings, rebaseOverMergeProblemDetected);
                        if (updateSettings == null) {
                            break;
                        }
                        this.savePushUpdateSettings(updateSettings, rebaseOverMergeProblemDetected);
                    }
                    if (beforePushLabel == null) {
                        beforePushLabel = LocalHistory.getInstance().putSystemLabel(this.myProject, GitBundle.message("push.local.history.system.label.before", new Object[0]));
                    }
                    List<GitRepository> rootsToUpdate = this.myRepositoryManager.getRepositories();
                    LOG.debug("roots to update: " + rootsToUpdate);
                    GitUpdateResult updateResult = this.update(rootsToUpdate, updateSettings.getUpdateMethod(), rebaseOverMergeProblemDetected == null);
                    for (GitRepository repository : rootsToUpdate) {
                        updatedRoots.put(repository, updateResult);
                    }
                    if (!updateResult.isSuccess() || updateResult == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) break;
                    if (updateResult == GitUpdateResult.INCOMPLETE) {
                        break;
                    }
                }
                remainingRoots = GitPushOperation.getRejectedAndNotPushed(results);
            }
        }
        finally {
            if (beforePushLabel != null) {
                afterPushLabel = LocalHistory.getInstance().putSystemLabel(this.myProject, GitBundle.message("push.local.history.system.label.after", new Object[0]));
            }
            for (GitRepository repository : this.myPushSpecs.keySet()) {
                repository.update();
            }
        }
        return this.prepareCombinedResult(results, updatedRoots, preUpdatePositions, beforePushLabel, afterPushLabel);
    }

    @NotNull
    private Collection<VirtualFile> findRootsWithMergeCommits(@NotNull Collection<? extends GitRepository> rootsToSearch) {
        return ContainerUtil.mapNotNull(rootsToSearch, repo -> {
            PushSpec pushSpec = this.myPushSpecs.get(repo);
            if (pushSpec == null) {
                GitPushSource source = this.myPushSupport.getSource((GitRepository)repo);
                GitPushTarget target = this.myPushSupport.getDefaultTarget((GitRepository)repo);
                if (target == null) {
                    return null;
                }
                pushSpec = new PushSpec((PushSource)source, (PushTarget)target);
            }
            String baseRef = ((GitPushTarget)pushSpec.getTarget()).getBranch().getFullName();
            String currentRef = ((GitPushSource)pushSpec.getSource()).getBranch().getFullName();
            return GitRebaseOverMergeProblem.hasProblem(this.myProject, repo.getRoot(), baseRef, currentRef) ? repo.getRoot() : null;
        });
    }

    @NotNull
    public GitPushOperation deriveForceWithoutLease(@NotNull List<GitRepository> newRepositories) {
        Map newPushSpec = ContainerUtil.filter(this.myPushSpecs, repo -> newRepositories.contains(repo));
        return new GitPushOperation(this.myProject, this.myPushSupport, (Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>>)newPushSpec, this.myTagMode, ForceMode.FORCE, this.mySkipHook);
    }

    private static boolean pushingToNotTrackedBranch(@NotNull Map<GitRepository, GitPushRepoResult> rejected) {
        boolean pushingToNotTrackedBranch = ContainerUtil.exists(rejected.entrySet(), entry -> {
            GitRepository repository = (GitRepository)entry.getKey();
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            assert (currentBranch != null);
            GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
            return trackInfo == null || !trackInfo.getRemoteBranch().getFullName().equals(((GitPushRepoResult)entry.getValue()).getTargetBranch());
        });
        LOG.debug("Pushing to not tracked branch condition is [" + pushingToNotTrackedBranch + "]");
        return pushingToNotTrackedBranch;
    }

    private static boolean pushingNotCurrentBranch(@NotNull Map<GitRepository, GitPushRepoResult> rejected) {
        boolean pushingNotCurrentBranch = ContainerUtil.exists(rejected.entrySet(), entry -> {
            GitRepository repository = (GitRepository)entry.getKey();
            String currentBranch = Objects.requireNonNull(repository.getCurrentBranch()).getFullName();
            return !StringUtil.equals((CharSequence)currentBranch, (CharSequence)((GitPushRepoResult)entry.getValue()).getSourceBranch());
        });
        LOG.debug("Pushing non current branch condition is [" + pushingNotCurrentBranch + "]");
        return pushingNotCurrentBranch;
    }

    @NotNull
    private static List<GitRepository> getRejectedAndNotPushed(@NotNull Map<GitRepository, GitPushRepoResult> results) {
        return ContainerUtil.filter(results.keySet(), repository -> ((GitPushRepoResult)results.get(repository)).getType() == GitPushRepoResult.Type.REJECTED_NO_FF || ((GitPushRepoResult)results.get(repository)).getType() == GitPushRepoResult.Type.NOT_PUSHED);
    }

    @NotNull
    private Map<GitRepository, String> updateRootInfoAndRememberPositions() {
        Set<GitRepository> repositories = this.myPushSpecs.keySet();
        repositories.forEach(Repository::update);
        return StreamEx.of(repositories).toMap(Repository::getCurrentRevision);
    }

    @NotNull
    private GitPushResult prepareCombinedResult(@NotNull Map<GitRepository, GitPushRepoResult> allRoots, @NotNull Map<GitRepository, GitUpdateResult> updatedRoots, @NotNull Map<GitRepository, String> preUpdatePositions, @Nullable Label beforeUpdateLabel, @Nullable Label afterUpdateLabel) {
        HashMap<GitRepository, GitPushRepoResult> results = new HashMap<GitRepository, GitPushRepoResult>();
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        for (Map.Entry<GitRepository, GitPushRepoResult> entry : allRoots.entrySet()) {
            GitRepository repository = entry.getKey();
            GitPushRepoResult simpleResult = entry.getValue();
            GitUpdateResult updateResult = updatedRoots.get(repository);
            if (updateResult == null) {
                results.put(repository, simpleResult);
                continue;
            }
            this.collectUpdatedFiles(updatedFiles, repository, preUpdatePositions.get(repository));
            results.put(repository, GitPushRepoResult.addUpdateResult(simpleResult, updateResult));
        }
        return new GitPushResult(results, updatedFiles, beforeUpdateLabel, afterUpdateLabel, this.myUpdatedRanges);
    }

    @NotNull
    private Map<GitRepository, GitPushRepoResult> push(@NotNull List<? extends GitRepository> repositories) {
        PushSpec<GitPushSource, GitPushTarget> spec;
        LinkedHashMap<GitRepository, GitPushRepoResult> results = new LinkedHashMap<GitRepository, GitPushRepoResult>();
        for (GitRepository gitRepository : repositories) {
            GitPushRepoResult repoResult;
            spec = this.myPushSpecs.get(gitRepository);
            ResultWithOutput resultWithOutput = this.doPush(gitRepository, spec);
            LOG.debug("Pushed to " + DvcsUtil.getShortRepositoryName((Repository)gitRepository) + ": " + resultWithOutput);
            GitLocalBranch source = ((GitPushSource)spec.getSource()).getBranch();
            GitPushTarget target = (GitPushTarget)spec.getTarget();
            if (resultWithOutput.isError()) {
                repoResult = GitPushRepoResult.error(source, target.getBranch(), resultWithOutput.getErrorAsString());
            } else {
                List<GitPushNativeResult> nativeResults = resultWithOutput.parsedResults;
                GitPushNativeResult sourceResult = GitPushOperation.getPushedBranchOrCommit(nativeResults);
                if (sourceResult == null) {
                    LOG.error("No result for branch or commit among: [" + nativeResults + "]\nFull result: " + resultWithOutput);
                    continue;
                }
                List tagResults = ContainerUtil.filter(nativeResults, result2 -> !result2.equals(sourceResult) && (result2.getType() == GitPushNativeResult.Type.NEW_REF || result2.getType() == GitPushNativeResult.Type.FORCED_UPDATE));
                int commits2 = this.collectNumberOfPushedCommits(gitRepository.getRoot(), sourceResult);
                repoResult = GitPushRepoResult.convertFromNative(sourceResult, tagResults, commits2, source, target.getBranch());
            }
            LOG.debug("Converted result: " + repoResult);
            results.put(gitRepository, repoResult);
        }
        for (GitRepository gitRepository : repositories) {
            if (results.containsKey(gitRepository)) continue;
            spec = this.myPushSpecs.get(gitRepository);
            results.put(gitRepository, GitPushRepoResult.notPushed(((GitPushSource)spec.getSource()).getBranch(), ((GitPushTarget)spec.getTarget()).getBranch()));
        }
        return results;
    }

    @Nullable
    private static GitPushNativeResult getPushedBranchOrCommit(@NotNull List<? extends GitPushNativeResult> results) {
        return (GitPushNativeResult)ContainerUtil.find(results, result2 -> GitPushOperation.isBranch(result2) || GitPushOperation.isHash(result2) || GitPushOperation.isHeadRelativeReference(result2));
    }

    private static boolean isBranch(@NotNull GitPushNativeResult result2) {
        String sourceRef = result2.getSourceRef();
        return sourceRef.startsWith("refs/heads/") || VcsLogUtil.HASH_REGEX.matcher(sourceRef).matches();
    }

    private static boolean isHash(@NotNull GitPushNativeResult result2) {
        String sourceRef = result2.getSourceRef();
        return VcsLogUtil.HASH_REGEX.matcher(sourceRef).matches();
    }

    private static boolean isHeadRelativeReference(@NotNull GitPushNativeResult result2) {
        String sourceRef = result2.getSourceRef();
        return sourceRef.startsWith("HEAD");
    }

    private int collectNumberOfPushedCommits(@NotNull VirtualFile root, @NotNull GitPushNativeResult result2) {
        if (result2.getType() != GitPushNativeResult.Type.SUCCESS) {
            return -1;
        }
        String range = result2.getRange();
        if (range == null) {
            LOG.error("Range of pushed commits not reported in " + result2);
            return -1;
        }
        try {
            return GitHistoryUtils.history(this.myProject, root, range).size();
        }
        catch (VcsException e) {
            LOG.error("Couldn't collect commits from range " + range);
            return -1;
        }
    }

    private void collectUpdatedFiles(@NotNull UpdatedFiles updatedFiles, @NotNull GitRepository repository, @NotNull String preUpdatePosition) {
        try {
            new MergeChangeCollector(this.myProject, repository, new GitRevisionNumber(preUpdatePosition)).collect(updatedFiles);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    private ResultWithOutput doPush(@NotNull GitRepository repository, @NotNull PushSpec<GitPushSource, GitPushTarget> pushSpec) {
        GitPushParamsImpl params;
        GitCommandResult res;
        GitPushSource pushSource = (GitPushSource)pushSpec.getSource();
        GitPushTarget pushTarget = (GitPushTarget)pushSpec.getTarget();
        GitLocalBranch sourceBranch = pushSource.getBranch();
        GitRemoteBranch targetBranch = pushTarget.getBranch();
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(this.myProgressIndicator);
        boolean setUpstream = pushTarget.isNewBranchCreated() && pushSource.isBranchRef() && !GitPushOperation.branchTrackingInfoIsSet(repository, sourceBranch);
        String tagMode = this.myTagMode == null ? null : this.myTagMode.getArgument();
        String spec = GitPushOperation.createPushSpec(pushSource, pushTarget, setUpstream);
        GitRemote remote = targetBranch.getRemote();
        List<GitPushParams.ForceWithLease> forceWithLease = Collections.emptyList();
        if (this.myForceMode == ForceMode.FORCE_WITH_LEASE) {
            Hash hash = repository.getBranches().getHash(targetBranch);
            String expectedHash = hash != null ? hash.asString() : "";
            forceWithLease = Collections.singletonList(new GitPushParamsImpl.ForceWithLeaseReference(targetBranch.getNameForRemoteOperations(), expectedHash));
        }
        if ((res = this.myGit.push(repository, params = new GitPushParamsImpl(remote, spec, this.myForceMode.isForce(), setUpstream, this.mySkipHook, tagMode, forceWithLease), progressListener)).success()) {
            ((GitAuthenticationListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS)).authenticationSucceeded(repository, remote);
        }
        return new ResultWithOutput(res);
    }

    private static String createPushSpec(@NotNull GitPushSource source, @NotNull GitPushTarget target, boolean setUpstream) {
        boolean needFullRefName = setUpstream || !source.isBranchRef();
        String remoteBranchName = target.getBranch().getNameForRemoteOperations();
        String targetRef = needFullRefName && !remoteBranchName.startsWith("refs/") ? "refs/heads/" + remoteBranchName : remoteBranchName;
        return source.getRevision() + ":" + targetRef;
    }

    private static boolean branchTrackingInfoIsSet(@NotNull GitRepository repository, @NotNull GitLocalBranch source) {
        return ContainerUtil.exists(repository.getBranchTrackInfos(), info -> info.getLocalBranch().equals(source));
    }

    private void savePushUpdateSettings(@NotNull PushUpdateSettings settings, boolean rebaseOverMergeDetected) {
        UpdateMethod updateMethod = settings.getUpdateMethod();
        if (!rebaseOverMergeDetected && this.mySettings.getUpdateMethod() != updateMethod && this.mySettings.getUpdateMethod() != UpdateMethod.BRANCH_DEFAULT) {
            this.mySettings.setUpdateMethod(updateMethod);
        }
    }

    @NotNull
    private PushUpdateSettings readPushUpdateSettings() {
        UpdateMethod updateMethod = this.mySettings.getUpdateMethod();
        if (updateMethod == UpdateMethod.BRANCH_DEFAULT) {
            updateMethod = GitUpdater.resolveUpdateMethod(this.myPushSpecs.keySet().iterator().next());
        }
        return new PushUpdateSettings(updateMethod);
    }

    @Nullable
    private PushUpdateSettings showDialogAndGetExitCode(@NotNull Set<? extends GitRepository> repositories, @NotNull PushUpdateSettings initialSettings, boolean rebaseOverMergeProblemDetected) {
        Ref updateSettings = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            GitRejectedPushUpdateDialog dialog2 = new GitRejectedPushUpdateDialog(this.myProject, repositories, initialSettings, rebaseOverMergeProblemDetected);
            GitRejectedPushUpdateDialog.Companion.PushRejectedExitCode exitCode = dialog2.showAndGet();
            if (!exitCode.equals((Object)GitRejectedPushUpdateDialog.Companion.PushRejectedExitCode.CANCEL)) {
                this.mySettings.setAutoUpdateIfPushRejected(dialog2.getShouldAutoUpdateInFuture());
                updateSettings.set((Object)new PushUpdateSettings(GitPushOperation.convertUpdateMethodFromDialogExitCode(exitCode)));
            }
        });
        return (PushUpdateSettings)updateSettings.get();
    }

    @NotNull
    private static UpdateMethod convertUpdateMethodFromDialogExitCode(GitRejectedPushUpdateDialog.Companion.PushRejectedExitCode exitCode) {
        return switch (exitCode) {
            case GitRejectedPushUpdateDialog.Companion.PushRejectedExitCode.MERGE -> UpdateMethod.MERGE;
            case GitRejectedPushUpdateDialog.Companion.PushRejectedExitCode.REBASE -> UpdateMethod.REBASE;
            default -> throw new IllegalStateException("Unexpected exit code: " + exitCode);
        };
    }

    @NotNull
    protected GitUpdateResult update(@NotNull Collection<? extends GitRepository> rootsToUpdate, @NotNull UpdateMethod updateMethod, boolean checkForRebaseOverMergeProblem) {
        GitUpdateProcess updateProcess = new GitUpdateProcess(this.myProject, this.myProgressIndicator, new HashSet<GitRepository>(rootsToUpdate), UpdatedFiles.create(), null, checkForRebaseOverMergeProblem, false);
        GitUpdateResult updateResult = updateProcess.update(updateMethod);
        Map<GitRepository, HashRange> ranges = updateProcess.getUpdatedRanges();
        if (ranges != null) {
            this.joinUpdatedRanges(ranges);
        }
        for (GitRepository gitRepository : rootsToUpdate) {
            gitRepository.getRoot().refresh(true, true);
            gitRepository.update();
        }
        return updateResult;
    }

    private void joinUpdatedRanges(@NotNull Map<GitRepository, HashRange> newRanges) {
        for (GitRepository repository : newRanges.keySet()) {
            HashRange newRange = newRanges.get(repository);
            HashRange current = this.myUpdatedRanges.get(repository);
            HashRange joinedRange = current == null ? newRange : new HashRange(current.getStart(), newRange.getEnd());
            this.myUpdatedRanges.put(repository, joinedRange);
        }
    }

    static enum ForceMode {
        NONE,
        FORCE,
        FORCE_WITH_LEASE;


        public boolean isForce() {
            return this != NONE;
        }
    }

    private static class ResultWithOutput {
        @NotNull
        private final List<GitPushNativeResult> parsedResults;
        @NotNull
        private final GitCommandResult resultOutput;

        ResultWithOutput(@NotNull GitCommandResult resultOutput) {
            this.resultOutput = resultOutput;
            this.parsedResults = GitPushNativeResultParser.parse(resultOutput.getOutput());
        }

        boolean isError() {
            return this.parsedResults.isEmpty();
        }

        @NotNull
        String getErrorAsString() {
            return this.resultOutput.getErrorOutputAsJoinedString();
        }

        public String toString() {
            return "Parsed results: " + this.parsedResults + "\nCommand output:" + this.resultOutput;
        }
    }
}

