/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.OutgoingResult;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.VcsError;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import git4idea.GitCommit;
import git4idea.GitUtil;
import git4idea.history.GitHistoryUtils;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitRepository;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitOutgoingCommitsProvider
extends OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> {
    @NotNull
    private final Project myProject;

    public GitOutgoingCommitsProvider(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public OutgoingResult getOutgoingCommits(@NotNull GitRepository repository, @NotNull PushSpec<GitPushSource, GitPushTarget> pushSpec, boolean initial) {
        GitPushSource gitPushSource = (GitPushSource)pushSpec.getSource();
        String source = gitPushSource.getRevision();
        GitPushTarget target = (GitPushTarget)pushSpec.getTarget();
        String destination = target.getBranch().getFullName();
        try {
            List<GitCommit> commits2 = !target.isNewBranchCreated() ? GitHistoryUtils.history(this.myProject, repository.getRoot(), destination + ".." + source) : GitHistoryUtils.history(this.myProject, repository.getRoot(), source, "--not", "--remotes=" + target.getBranch().getRemote().getName(), "--max-count=1000");
            return new OutgoingResult(commits2, Collections.emptyList());
        }
        catch (VcsException e) {
            return new OutgoingResult(Collections.emptyList(), Collections.singletonList(new VcsError(GitUtil.cleanupErrorPrefixes(e.getMessage()))));
        }
    }
}

