/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MergeProvider2;
import com.intellij.openapi.vcs.merge.MergeSession;
import com.intellij.openapi.vcs.merge.MergeSessionEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitDefaultMergeDialogCustomizer;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt;
import git4idea.merge.GitMergeUtil;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.util.GitFileUtils;
import git4idea.util.StringScanner;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMergeProvider
implements MergeProvider2 {
    private static final Logger LOG = Logger.getInstance(GitMergeProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<VirtualFile> myReverseRoots;

    private GitMergeProvider(@NotNull Project project, @NotNull Set<VirtualFile> reverseRoots) {
        this.myProject = project;
        this.myReverseRoots = reverseRoots;
    }

    public GitMergeProvider(@NotNull Project project, boolean reverse) {
        this(project, GitMergeProvider.findReverseRoots(project, reverse ? ReverseRequest.REVERSE : ReverseRequest.FORWARD));
    }

    @NotNull
    public static MergeProvider detect(@NotNull Project project) {
        return new GitMergeProvider(project, GitMergeProvider.findReverseRoots(project, ReverseRequest.DETECT));
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    private static Set<VirtualFile> findReverseRoots(@NotNull Project project, @NotNull ReverseRequest reverseOrDetect) {
        if (Registry.is((String)"git.do.not.swap.merge.conflict.sides")) {
            return Collections.emptySet();
        }
        HashSet<VirtualFile> reverseMap = new HashSet<VirtualFile>();
        for (GitRepository repository : GitUtil.getRepositoryManager(project).getRepositories()) {
            boolean reverse;
            if (reverseOrDetect == ReverseRequest.DETECT) {
                reverse = GitMergeUtil.isReverseRoot(repository);
            } else {
                boolean bl = reverse = reverseOrDetect == ReverseRequest.REVERSE;
            }
            if (!reverse) continue;
            reverseMap.add(repository.getRoot());
        }
        return reverseMap;
    }

    @NotNull
    public MergeData loadRevisions(@NotNull VirtualFile file2) throws VcsException {
        VirtualFile root = GitUtil.getRootForFile(this.myProject, file2);
        FilePath path = VcsUtil.getFilePath((VirtualFile)file2);
        return GitMergeUtil.loadMergeData(this.myProject, root, path, this.myReverseRoots.contains(root));
    }

    public void conflictResolvedForFile(@NotNull VirtualFile file2) {
        try {
            GitFileUtils.addFilesForce(this.myProject, GitUtil.getRootForFile(this.myProject, file2), Collections.singletonList(file2));
        }
        catch (VcsException e) {
            LOG.error("Confirming conflict resolution failed", (Throwable)e);
        }
    }

    public boolean isBinary(@NotNull VirtualFile file2) {
        return file2.getFileType().isBinary();
    }

    @NotNull
    public MergeSession createMergeSession(@NotNull List<VirtualFile> files) {
        return (MergeSession)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> new MyMergeSession(files), GitBundle.message("merge.progress.indicator.loading.unmerged.files.title", new Object[0]), true, this.myProject);
    }

    public MergeDialogCustomizer createDefaultMergeDialogCustomizer() {
        return new GitDefaultMergeDialogCustomizer(this.myProject);
    }

    @NotNull
    @NlsContexts.ColumnName
    public static String calcColumnName(boolean isTheirs, @NlsSafe @Nullable String branchName) {
        if (isTheirs) {
            if (branchName != null) {
                return GitBundle.message("merge.tool.column.theirs.with.branch.status", branchName);
            }
            return GitBundle.message("merge.tool.column.theirs.status", new Object[0]);
        }
        if (branchName != null) {
            return GitBundle.message("merge.tool.column.yours.with.branch.status", branchName);
        }
        return GitBundle.message("merge.tool.column.yours.status", new Object[0]);
    }

    private static enum ReverseRequest {
        REVERSE,
        FORWARD,
        DETECT;

    }

    private class MyMergeSession
    implements MergeSessionEx {
        private final Map<VirtualFile, GitConflict> myConflicts = new HashMap<VirtualFile, GitConflict>();
        private final String currentBranchName;
        private final String mergeHeadBranchName;

        MyMergeSession(List<VirtualFile> filesToMerge) {
            try {
                Map<GitRepository, List<VirtualFile>> filesByRoot = GitUtil.sortFilesByRepository(GitMergeProvider.this.myProject, filesToMerge);
                for (Map.Entry<GitRepository, List<VirtualFile>> e : filesByRoot.entrySet()) {
                    HashMap<String, Conflict> cs = new HashMap<String, Conflict>();
                    VirtualFile root = e.getKey().getRoot();
                    List<VirtualFile> files = e.getValue();
                    GitLineHandler h = new GitLineHandler(GitMergeProvider.this.myProject, root, GitCommand.LS_FILES);
                    h.setStdoutSuppressed(true);
                    h.setSilent(true);
                    h.addParameters("--exclude-standard", "--unmerged", "-t", "-z");
                    h.endOptions();
                    String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
                    StringScanner s = new StringScanner(output);
                    while (s.hasMoreData()) {
                        if (!"M".equals(s.spaceToken())) {
                            s.boundedToken('\u0000');
                            continue;
                        }
                        s.spaceToken();
                        s.spaceToken();
                        int source = Integer.parseInt(s.tabToken());
                        String file2 = s.boundedToken('\u0000');
                        Conflict c = (Conflict)cs.get(file2);
                        if (c == null) {
                            c = new Conflict();
                            c.myRoot = root;
                            cs.put(file2, c);
                        }
                        if (source == 3) {
                            c.myStatusTheirs = GitConflict.Status.MODIFIED;
                            continue;
                        }
                        if (source == 2) {
                            c.myStatusYours = GitConflict.Status.MODIFIED;
                            continue;
                        }
                        if (source == 1) continue;
                        throw new IllegalStateException("Unknown revision " + source + " for the file: " + file2);
                    }
                    for (VirtualFile f : files) {
                        String path = VcsFileUtil.relativePath((VirtualFile)root, (VirtualFile)f);
                        Conflict c = (Conflict)cs.get(path);
                        if (c == null) {
                            LOG.error(String.format("The conflict not found for file: %s(%s)%nFull ls-files output: %n%s%nAll files: %n%s", f.getPath(), path, output, files));
                            continue;
                        }
                        c.myFile = f;
                        if (c.myStatusTheirs == null) {
                            c.myStatusTheirs = GitConflict.Status.DELETED;
                        }
                        if (c.myStatusYours == null) {
                            c.myStatusYours = GitConflict.Status.DELETED;
                        }
                        this.myConflicts.put(f, new GitConflict(root, VcsUtil.getFilePath((VirtualFile)f), c.myStatusYours, c.myStatusTheirs));
                    }
                }
                this.currentBranchName = GitDefaultMergeDialogCustomizerKt.getSingleCurrentBranchName(filesByRoot.keySet());
                this.mergeHeadBranchName = GitDefaultMergeDialogCustomizerKt.getSingleMergeBranchName(filesByRoot.keySet());
            }
            catch (VcsException ex) {
                throw new IllegalStateException("The git operation should not fail in this context", ex);
            }
        }

        public ColumnInfo @NotNull [] getMergeInfoColumns() {
            return new ColumnInfo[]{new StatusColumn(false, this.currentBranchName), new StatusColumn(true, this.mergeHeadBranchName)};
        }

        public boolean canMerge(@NotNull VirtualFile file2) {
            GitConflict c = this.myConflicts.get(file2);
            return c != null && !file2.isDirectory();
        }

        public void conflictResolvedForFile(@NotNull VirtualFile file2, @NotNull MergeSession.Resolution resolution) {
            this.conflictResolvedForFiles(Collections.singletonList(file2), resolution);
        }

        public void conflictResolvedForFiles(@NotNull List<? extends VirtualFile> files, @NotNull MergeSession.Resolution resolution) {
            MultiMap<VirtualFile, GitConflict> byRoot = this.groupConflictsByRoot(files);
            for (VirtualFile root : byRoot.keySet()) {
                Collection conflicts = byRoot.get((Object)root);
                GitConflict.ConflictSide resolutionSide = resolution != MergeSession.Resolution.Merged ? this.getAcceptedConflictSide(resolution, root) : null;
                try {
                    GitMergeUtil.markConflictResolved(GitMergeProvider.this.myProject, root, conflicts, resolutionSide);
                }
                catch (VcsException e) {
                    LOG.error(String.format("Unexpected exception during the git operation. Files - %s", ContainerUtil.map((Collection)conflicts, GitConflict::getFilePath)), (Throwable)e);
                }
            }
        }

        public void acceptFilesRevisions(@NotNull List<? extends VirtualFile> files, @NotNull MergeSession.Resolution resolution) throws VcsException {
            assert (resolution == MergeSession.Resolution.AcceptedYours || resolution == MergeSession.Resolution.AcceptedTheirs);
            MultiMap<VirtualFile, GitConflict> byRoot = this.groupConflictsByRoot(files);
            for (VirtualFile root : byRoot.keySet()) {
                Collection conflicts = byRoot.get((Object)root);
                GitConflict.ConflictSide conflictSide = this.getAcceptedConflictSide(resolution, root);
                GitMergeUtil.acceptOneVersion(GitMergeProvider.this.myProject, root, conflicts, conflictSide);
            }
        }

        @NotNull
        private GitConflict.ConflictSide getAcceptedConflictSide(@NotNull MergeSession.Resolution resolution, @NotNull VirtualFile root) {
            assert (resolution == MergeSession.Resolution.AcceptedYours || resolution == MergeSession.Resolution.AcceptedTheirs);
            boolean isReversed = GitMergeProvider.this.myReverseRoots.contains(root);
            boolean acceptYours = !isReversed ? resolution == MergeSession.Resolution.AcceptedYours : resolution == MergeSession.Resolution.AcceptedTheirs;
            return acceptYours ? GitConflict.ConflictSide.OURS : GitConflict.ConflictSide.THEIRS;
        }

        @NotNull
        private MultiMap<VirtualFile, GitConflict> groupConflictsByRoot(@NotNull List<? extends VirtualFile> files) {
            MultiMap byRoot = MultiMap.create();
            for (VirtualFile virtualFile : files) {
                GitConflict c = this.myConflicts.get(virtualFile);
                if (c == null) {
                    LOG.error("Conflict was not loaded for the file: " + virtualFile.getPath());
                    continue;
                }
                byRoot.putValue((Object)c.getRoot(), (Object)c);
            }
            return byRoot;
        }

        private class StatusColumn
        extends ColumnInfo<VirtualFile, String> {
            private final boolean myIsLast;

            StatusColumn(@Nullable boolean isLast, String branchName) {
                super(GitMergeProvider.calcColumnName(isLast, branchName));
                this.myIsLast = isLast;
            }

            public String valueOf(VirtualFile file2) {
                GitConflict c = MyMergeSession.this.myConflicts.get(file2);
                if (c == null) {
                    return "";
                }
                boolean isReversed = GitMergeProvider.this.myReverseRoots.contains(c.getRoot());
                GitConflict.Status currentStatus = c.getStatus(GitConflict.ConflictSide.OURS, isReversed);
                GitConflict.Status lastStatus = c.getStatus(GitConflict.ConflictSide.THEIRS, isReversed);
                GitConflict.Status status = this.myIsLast ? lastStatus : currentStatus;
                return GitBundle.message(switch (status) {
                    default -> throw new IncompatibleClassChangeError();
                    case GitConflict.Status.ADDED, GitConflict.Status.MODIFIED -> "merge.tool.column.status.modified";
                    case GitConflict.Status.DELETED -> "merge.tool.column.status.deleted";
                }, new Object[0]);
            }

            public String getMaxStringValue() {
                return GitBundle.message("merge.tool.column.status.modified", new Object[0]);
            }

            public int getAdditionalWidth() {
                return 10;
            }
        }
    }

    private static class Conflict {
        VirtualFile myFile;
        VirtualFile myRoot;
        GitConflict.Status myStatusTheirs;
        GitConflict.Status myStatusYours;

        private Conflict() {
        }
    }
}

