/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.log.GitExternalLogTabsProperties;
import git4idea.log.GitShowExternalLogActionKt;
import git4idea.log.MyContentComponent;
import git4idea.log.ShowLogInDialogTask;
import git4idea.repo.GitRepositoryImpl;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0003\u001a.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0002\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019H\u0002\u001a&\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a1\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000b\u0010\u001d\u001a\u00070\u0001\u00a2\u0006\u0002\b\u001e\u001aF\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000b\u0010\"\u001a\u00070\u0001\u00a2\u0006\u0002\b#2\u000b\u0010$\u001a\u00070\u0001\u00a2\u0006\u0002\b%\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"EXTERNAL", "", "calcLogId", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "calcTabName", "cm", "Lcom/intellij/ui/content/ContentManager;", "createManagerAndContent", "Lgit4idea/log/MyContentComponent;", "project", "Lcom/intellij/openapi/project/Project;", "vcs", "Lgit4idea/GitVcs;", "isToolWindowTab", "", "doOnProviderRemoval", "", "disposable", "Lcom/intellij/openapi/Disposable;", "closeTab", "Lkotlin/Function0;", "getGitRootsFromUser", "selectAlreadyOpened", "", "selectProjectLog", "requestedRoots", "showExternalGitLogInDialog", "dialogTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "showExternalGitLogInToolwindow", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "tabTitle", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "tabDescription", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "intellij.vcs.git"})
public final class GitShowExternalLogActionKt {
    @NotNull
    private static final String EXTERNAL = "EXTERNAL";

    public static final void showExternalGitLogInDialog(@NotNull Project project, @NotNull GitVcs vcs, @NotNull List<? extends VirtualFile> roots, @NotNull String dialogTitle) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)vcs), (String)"vcs");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        ProgressManager.getInstance().run((Task)new ShowLogInDialogTask(project, roots, vcs, dialogTitle));
    }

    public static final void showExternalGitLogInToolwindow(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull GitVcs vcs, @NotNull List<? extends VirtualFile> roots, @NotNull String tabTitle, @NotNull String tabDescription) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)((Object)vcs), (String)"vcs");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)tabTitle, (String)"tabTitle");
        Intrinsics.checkNotNullParameter((Object)tabDescription, (String)"tabDescription");
        Function0 showContent2 = (Function0)new Function0<Unit>(toolWindow, project, vcs, roots, tabTitle, tabDescription){
            final /* synthetic */ ToolWindow $toolWindow;
            final /* synthetic */ Project $project;
            final /* synthetic */ GitVcs $vcs;
            final /* synthetic */ List<VirtualFile> $roots;
            final /* synthetic */ String $tabTitle;
            final /* synthetic */ String $tabDescription;
            {
                this.$toolWindow = $toolWindow;
                this.$project = $project;
                this.$vcs = $vcs;
                this.$roots = $roots;
                this.$tabTitle = $tabTitle;
                this.$tabDescription = $tabDescription;
                super(0);
            }

            public final void invoke() {
                ContentManager contentManager = this.$toolWindow.getContentManager();
                Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
                ContentManager cm = contentManager;
                if (!GitShowExternalLogActionKt.access$selectProjectLog(this.$project, this.$vcs, this.$roots) && !GitShowExternalLogActionKt.access$selectAlreadyOpened(cm, this.$roots)) {
                    boolean isToolWindowTab = Intrinsics.areEqual((Object)this.$toolWindow.getId(), (Object)"Version Control");
                    MyContentComponent component2 = GitShowExternalLogActionKt.access$createManagerAndContent(this.$project, this.$vcs, this.$roots, isToolWindowTab);
                    Content content = ContentFactory.getInstance().createContent((JComponent)component2, this.$tabTitle, false);
                    Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getInstance().createCont\u2026mponent, tabTitle, false)");
                    Content content2 = content;
                    content2.setDisposer(component2.getDisposable());
                    content2.setDescription(this.$tabDescription);
                    content2.setCloseable(true);
                    cm.addContent(content2);
                    cm.setSelectedContent(content2);
                    GitShowExternalLogActionKt.access$doOnProviderRemoval(this.$project, component2.getDisposable(), (Function0)new Function0<Unit>(cm, content2){
                        final /* synthetic */ ContentManager $cm;
                        final /* synthetic */ Content $content;
                        {
                            this.$cm = $cm;
                            this.$content = $content;
                            super(0);
                        }

                        public final void invoke() {
                            this.$cm.removeContent(this.$content, true);
                        }
                    });
                }
            }
        };
        if (!toolWindow.isVisible()) {
            toolWindow.activate(() -> GitShowExternalLogActionKt.showExternalGitLogInToolwindow$lambda$0(showContent2), true);
        } else {
            showContent2.invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final MyContentComponent createManagerAndContent(Project project, GitVcs vcs, List<? extends VirtualFile> roots, boolean isToolWindowTab) {
        Collection<VcsRoot> collection;
        void $this$mapTo$iv$iv;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
        Disposable disposable2 = disposable;
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(project)");
        GitRepositoryManager repositoryManager = gitRepositoryManager;
        for (VirtualFile virtualFile : roots) {
            repositoryManager.addExternalRepository(virtualFile, GitRepositoryImpl.createInstance(virtualFile, project, disposable2));
        }
        Iterable iterable = roots;
        VcsLogTabsProperties vcsLogTabsProperties = (VcsLogTabsProperties)ApplicationManager.getApplication().getService(GitExternalLogTabsProperties.class);
        Project project2 = project;
        boolean $i$f$map = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new VcsRoot((AbstractVcs)vcs, (VirtualFile)it));
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        VcsLogTabsProperties vcsLogTabsProperties2 = vcsLogTabsProperties;
        Project project3 = project2;
        VcsLogManager manager = new VcsLogManager(project3, vcsLogTabsProperties2, collection2);
        Disposer.register((Disposable)disposable2, () -> GitShowExternalLogActionKt.createManagerAndContent$lambda$4(manager, roots, repositoryManager));
        MainVcsLogUi mainVcsLogUi = manager.createLogUi(GitShowExternalLogActionKt.calcLogId(roots), isToolWindowTab ? VcsLogTabLocation.TOOL_WINDOW : VcsLogTabLocation.STANDALONE);
        Intrinsics.checkNotNullExpressionValue((Object)mainVcsLogUi, (String)"manager.createLogUi(calc\u2026ogTabLocation.STANDALONE)");
        MainVcsLogUi mainVcsLogUi2 = mainVcsLogUi;
        Disposer.register((Disposable)disposable2, (Disposable)((Disposable)mainVcsLogUi2));
        return new MyContentComponent((JComponent)new VcsLogPanel(manager, (VcsLogUiEx)mainVcsLogUi2), (Collection<? extends VirtualFile>)roots, disposable2);
    }

    private static final String calcLogId(List<? extends VirtualFile> roots) {
        Iterable iterable = roots;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        return "EXTERNAL " + CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)calcLogId.1.INSTANCE, (int)30, null);
    }

    @Nls
    private static final String calcTabName(ContentManager cm, List<? extends VirtualFile> roots) {
        String name = VcsLogBundle.message((String)"vcs.log.tab.name", (Object[])new Object[0]) + " (" + ((VirtualFile)CollectionsKt.first(roots)).getName() + (roots.size() > 1 ? "+" : "") + ")";
        String candidate = null;
        candidate = name;
        int cnt = 1;
        while (true) {
            boolean bl;
            block2: {
                Content[] contentArray = cm.getContents();
                Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"cm.contents");
                Object[] $this$any$iv = contentArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Content content = (Content)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)content.getDisplayName(), (Object)candidate)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) break;
            candidate = name + "-" + cnt;
            ++cnt;
        }
        return candidate;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<VirtualFile> getGitRootsFromUser(Project project) {
        void $this$filterTo$iv$iv;
        VirtualFile[] virtualFiles;
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, true, false, true);
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"chooseFiles(descriptor, project, null)");
        VirtualFile[] $this$filter$iv = virtualFiles = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!GitUtil.isGitRoot(new File(it.getPath()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean selectProjectLog(Project project, GitVcs vcs, List<? extends VirtualFile> requestedRoots) {
        VirtualFile[] virtualFileArray = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getInstance(project).getRootsUnderVcs(vcs)");
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        List projectRoots = CollectionsKt.listOf((Object[])Arrays.copyOf(virtualFileArray2, virtualFileArray2.length));
        if (!projectRoots.containsAll((Collection)requestedRoots)) {
            return false;
        }
        if (requestedRoots.containsAll(projectRoots)) {
            return VcsLogContentUtil.INSTANCE.selectMainLog(project);
        }
        VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{(VcsLogFilter)VcsLogFilterObject.fromRoots((Collection)requestedRoots)};
        VcsLogFilterCollection filters = VcsLogFilterObject.collection((VcsLogFilter[])vcsLogFilterArray);
        return VcsProjectLog.getInstance((Project)project).openLogTab(filters) != null;
    }

    private static final boolean selectAlreadyOpened(ContentManager cm, Collection<? extends VirtualFile> roots) {
        Object object;
        block2: {
            Content[] contentArray = cm.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"cm.contents");
            Object[] $this$firstOrNull$iv = contentArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JComponent component2;
                Content content = (Content)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)content.getComponent(), (String)"content.component");
                boolean bl2 = component2 instanceof MyContentComponent ? Comparing.haveEqualElements(roots, ((MyContentComponent)component2).getRoots()) : false;
                if (!bl2) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        Content content = (Content)object;
        if (content == null) {
            return false;
        }
        Content content2 = content;
        cm.setSelectedContent(content2);
        return true;
    }

    private static final void doOnProviderRemoval(Project project, Disposable disposable, Function0<Unit> closeTab) {
        VcsLogProvider.LOG_PROVIDER_EP.getPoint((AreaInstance)project).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<VcsLogProvider>(closeTab){
            final /* synthetic */ Function0<Unit> $closeTab;
            {
                this.$closeTab = $closeTab;
            }

            public void extensionRemoved(@NotNull VcsLogProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                if (Intrinsics.areEqual((Object)extension.getSupportedVcs(), (Object)GitVcs.getKey())) {
                    this.$closeTab.invoke();
                }
            }
        }, false, disposable);
    }

    private static final void showExternalGitLogInToolwindow$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void createManagerAndContent$lambda$4$lambda$3(List $roots, GitRepositoryManager $repositoryManager) {
        Intrinsics.checkNotNullParameter((Object)$roots, (String)"$roots");
        Intrinsics.checkNotNullParameter((Object)((Object)$repositoryManager), (String)"$repositoryManager");
        Iterable $this$forEach$iv = $roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            $repositoryManager.removeExternalRepository(it);
        }
    }

    private static final void createManagerAndContent$lambda$4(VcsLogManager $manager, List $roots, GitRepositoryManager $repositoryManager) {
        Intrinsics.checkNotNullParameter((Object)$manager, (String)"$manager");
        Intrinsics.checkNotNullParameter((Object)$roots, (String)"$roots");
        Intrinsics.checkNotNullParameter((Object)((Object)$repositoryManager), (String)"$repositoryManager");
        $manager.dispose(() -> GitShowExternalLogActionKt.createManagerAndContent$lambda$4$lambda$3($roots, $repositoryManager));
    }

    public static final /* synthetic */ List access$getGitRootsFromUser(Project project) {
        return GitShowExternalLogActionKt.getGitRootsFromUser(project);
    }

    public static final /* synthetic */ String access$calcTabName(ContentManager cm, List roots) {
        return GitShowExternalLogActionKt.calcTabName(cm, roots);
    }

    public static final /* synthetic */ MyContentComponent access$createManagerAndContent(Project project, GitVcs vcs, List roots, boolean isToolWindowTab) {
        return GitShowExternalLogActionKt.createManagerAndContent(project, vcs, roots, isToolWindowTab);
    }

    public static final /* synthetic */ void access$doOnProviderRemoval(Project project, Disposable disposable, Function0 closeTab) {
        GitShowExternalLogActionKt.doOnProviderRemoval(project, disposable, (Function0<Unit>)closeTab);
    }

    public static final /* synthetic */ boolean access$selectProjectLog(Project project, GitVcs vcs, List requestedRoots) {
        return GitShowExternalLogActionKt.selectProjectLog(project, vcs, requestedRoots);
    }

    public static final /* synthetic */ boolean access$selectAlreadyOpened(ContentManager cm, Collection roots) {
        return GitShowExternalLogActionKt.selectAlreadyOpened(cm, roots);
    }
}

