/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import git4idea.GitVcs;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitCompressedDetailsCollector;
import git4idea.history.GitLogUtil;
import git4idea.log.GitLogProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00110\u0010H\u0016J6\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00110\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lgit4idea/log/GitLogIndexer;", "Lcom/intellij/vcs/log/impl/VcsLogIndexer;", "project", "Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepositoryManager;)V", "getSupportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "readAllFullDetails", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "encoder", "Lcom/intellij/vcs/log/impl/VcsLogIndexer$PathsEncoder;", "commitConsumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/vcs/log/impl/VcsLogIndexer$CompressedDetails;", "readFullDetails", "hashes", "", "", "Companion", "intellij.vcs.git"})
public final class GitLogIndexer
implements VcsLogIndexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GitRepositoryManager repositoryManager;
    private static final int RENAME_LIMIT = 1;

    public GitLogIndexer(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)repositoryManager), (String)"repositoryManager");
        this.project = project;
        this.repositoryManager = repositoryManager;
    }

    public void readAllFullDetails(@NotNull VirtualFile root, @NotNull VcsLogIndexer.PathsEncoder encoder, @NotNull Consumer<? super VcsLogIndexer.CompressedDetails> commitConsumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(commitConsumer, (String)"commitConsumer");
        GitRepository gitRepository = GitLogProvider.getRepository(this.repositoryManager, root);
        if (gitRepository == null) {
            return;
        }
        GitRepository repository = gitRepository;
        GitCommitRequirements requirements = new GitCommitRequirements(GitLogProvider.shouldIncludeRootChanges(repository), new GitCommitRequirements.DiffRenameLimit.Value(1), GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS);
        GitCompressedDetailsCollector gitCompressedDetailsCollector = new GitCompressedDetailsCollector(this.project, root, encoder);
        String[] stringArray = ArrayUtil.toStringArray((Collection)GitLogUtil.LOG_ALL);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toStringArray(GitLogUtil.LOG_ALL)");
        String[] stringArray2 = stringArray;
        gitCompressedDetailsCollector.readFullDetails(commitConsumer, requirements, true, Arrays.copyOf(stringArray2, stringArray2.length));
    }

    public void readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes2, @NotNull VcsLogIndexer.PathsEncoder encoder, @NotNull Consumer<? super VcsLogIndexer.CompressedDetails> commitConsumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(hashes2, (String)"hashes");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(commitConsumer, (String)"commitConsumer");
        GitRepository gitRepository = GitLogProvider.getRepository(this.repositoryManager, root);
        if (gitRepository == null) {
            return;
        }
        GitRepository repository = gitRepository;
        GitCommitRequirements requirements = new GitCommitRequirements(GitLogProvider.shouldIncludeRootChanges(repository), new GitCommitRequirements.DiffRenameLimit.Value(1), GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS);
        new GitCompressedDetailsCollector(this.project, root, encoder).readFullDetailsForHashes(hashes2, requirements, true, commitConsumer);
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getKey()");
        return vcsKey;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgit4idea/log/GitLogIndexer$Companion;", "", "()V", "RENAME_LIMIT", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

