/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.Compressor;
import com.intellij.util.io.ZipUtil;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.util.PersistentUtil;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexUtil;
import git4idea.log.GitLogIndexDataUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u001d\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0017\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0000\u00a2\u0006\u0002\b\u0015R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgit4idea/log/GitLogIndexDataUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createArchiveWithLogData", "", "project", "Lcom/intellij/openapi/project/Project;", "outputArchiveDir", "Ljava/nio/file/Path;", "createArchiveWithLogData$intellij_vcs_git", "extractLogDataFromArchive", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "extractLogDataFromArchive$intellij_vcs_git", "indexingFinished", "", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "indexingFinished$intellij_vcs_git", "intellij.vcs.git"})
@ApiStatus.Internal
public final class GitLogIndexDataUtils {
    @NotNull
    public static final GitLogIndexDataUtils INSTANCE = new GitLogIndexDataUtils();
    @NotNull
    private static final Logger LOG;

    private GitLogIndexDataUtils() {
    }

    public final void extractLogDataFromArchive$intellij_vcs_git(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Map map2 = VcsProjectLog.getLogProviders((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getLogProviders(project)");
        String logId = PersistentUtil.calcLogId((Project)project, (Map)map2);
        Path path = PersistentUtil.LOG_CACHE.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"LOG_CACHE.toPath()");
        Path logCache = path;
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        String logIndexDirName = PersistentUtil.getProjectLogDataDirectoryName((String)string, (String)logId);
        Path currentLogDataPath = logCache.resolve(logIndexDirName);
        Path tempLogDataPath = logCache.resolve(logIndexDirName + "_temp");
        Path logDataBackupPath = logCache.resolve(logIndexDirName + "_backup");
        String string2 = GitBundle.message("vcs.log.status.bar.extracting.log.index.data", new Object[0]);
        new Task.Backgroundable(project, tempLogDataPath, virtualFile, currentLogDataPath, logDataBackupPath, string2){
            final /* synthetic */ Project $project;
            final /* synthetic */ Path $tempLogDataPath;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ Path $currentLogDataPath;
            final /* synthetic */ Path $logDataBackupPath;
            {
                this.$project = $project;
                this.$tempLogDataPath = $tempLogDataPath;
                this.$virtualFile = $virtualFile;
                this.$currentLogDataPath = $currentLogDataPath;
                this.$logDataBackupPath = $logDataBackupPath;
                super($project, $super_call_param$1);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    FileUtil.delete((Path)this.$tempLogDataPath);
                    ZipUtil.extract((Path)this.$virtualFile.toNioPath(), (Path)this.$tempLogDataPath, null, (boolean)true);
                }
                catch (IOException e) {
                    GitLogIndexDataUtils.access$getLOG$p().error("Unable to extract log index data from " + this.$virtualFile.getName(), (Throwable)e);
                }
            }

            public void onSuccess() {
                boolean isDataPackFull;
                VcsProjectLog vcsProjectLog = VcsProjectLog.getInstance((Project)this.$project);
                VcsLogData data = vcsProjectLog.getDataManager();
                VcsLogData vcsLogData = data;
                boolean bl = vcsLogData != null && (vcsLogData = vcsLogData.getDataPack()) != null ? vcsLogData.isFull() : (isDataPackFull = false);
                if (isDataPackFull && GitLogIndexDataUtils.INSTANCE.indexingFinished$intellij_vcs_git(data)) {
                    GitLogIndexDataUtils.access$getLOG$p().info("Shared log index data wasn't applied because local indexing completed faster");
                    return;
                }
                vcsProjectLog.runOnDisposedLog(() -> extractLogDataFromArchive.1.onSuccess$lambda$0(this.$currentLogDataPath, this.$logDataBackupPath, this.$tempLogDataPath));
            }

            private static final void onSuccess$lambda$0(Path $currentLogDataPath, Path $logDataBackupPath, Path $tempLogDataPath) {
                FileUtil.rename((File)$currentLogDataPath.toFile(), (String)((Object)$logDataBackupPath.getFileName()).toString());
                FileUtil.rename((File)$tempLogDataPath.toFile(), (String)((Object)$currentLogDataPath.getFileName()).toString());
                FileUtil.delete((Path)$logDataBackupPath);
            }
        }.queue();
    }

    public final void createArchiveWithLogData$intellij_vcs_git(@NotNull Project project, @NotNull Path outputArchiveDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)outputArchiveDir, (String)"outputArchiveDir");
        VcsProjectLog.getInstance((Project)project).runOnDisposedLog(() -> GitLogIndexDataUtils.createArchiveWithLogData$lambda$2(project, outputArchiveDir));
    }

    public final boolean indexingFinished$intellij_vcs_git(@Nullable VcsLogData logData) {
        boolean bl;
        block4: {
            if (logData == null) {
                return false;
            }
            Set set = VcsLogPersistentIndex.getRootsForIndexing((Map)logData.getLogProviders());
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getRootsForIndexing(logData.logProviders)");
            Set rootsForIndexing = set;
            VcsLogIndex vcsLogIndex = logData.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogIndex, (String)"logData.index");
            VcsLogIndex index = vcsLogIndex;
            Iterable $this$any$iv = rootsForIndexing;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile root = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!index.isIndexed(root)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createArchiveWithLogData$lambda$2$lambda$1(Project $project, Path $outputArchiveDir) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$outputArchiveDir, (String)"$outputArchiveDir");
        Map map2 = VcsProjectLog.getLogProviders((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getLogProviders(project)");
        String logId = PersistentUtil.calcLogId((Project)$project, (Map)map2);
        Path path = PersistentUtil.LOG_CACHE.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"LOG_CACHE.toPath()");
        Path logCache = path;
        String string = $project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        String logIndexDirName = PersistentUtil.getProjectLogDataDirectoryName((String)string, (String)logId);
        Path path2 = $outputArchiveDir.resolve(logIndexDirName + ".zip");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"outputArchiveDir.resolve(\"$logIndexDirName.zip\")");
        Path archive = path2;
        Closeable closeable = (Closeable)new Compressor.Zip(archive.toFile());
        Throwable throwable = null;
        try {
            Compressor.Zip zip = (Compressor.Zip)closeable;
            boolean bl = false;
            zip.addDirectory(logCache.resolve(logIndexDirName));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void createArchiveWithLogData$lambda$2(Project $project, Path $outputArchiveDir) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$outputArchiveDir, (String)"$outputArchiveDir");
        Runnable runnable = () -> GitLogIndexDataUtils.createArchiveWithLogData$lambda$2$lambda$1($project, $outputArchiveDir);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, GitBundle.message("vcs.log.archiving.log.index.data", new Object[0]), false, $project);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(GitIndexUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(GitIndexUtil::class.java)");
        LOG = logger;
    }
}

