/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.ui;

import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.IgnoredViewDialog;
import com.intellij.openapi.vcs.changes.UnversionedViewDialog;
import com.intellij.openapi.vcs.changes.ui.AbstractChangesBrowserFilePathNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilePathsNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDnDSupport;
import com.intellij.openapi.vcs.changes.ui.HoverChangesTree;
import com.intellij.openapi.vcs.changes.ui.HoverIcon;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import git4idea.conflicts.GitConflictsUtil;
import git4idea.i18n.GitBundle;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitStageTracker;
import git4idea.index.actions.StagingAreaOperation;
import git4idea.index.ui.GitFileStatusNode;
import git4idea.index.ui.GitStageDataKeys;
import git4idea.index.ui.GitStageTree;
import git4idea.index.ui.GitStageTreeKt;
import git4idea.index.ui.GitStageUiSettings;
import git4idea.index.ui.GitStageUiSettingsListener;
import git4idea.index.ui.NodeKind;
import git4idea.repo.GitConflict;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b&\u0018\u00002\u00020\u0001:\b89:;<=>?B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH$J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\u00112\u0006\u0010%\u001a\u00020&H$J\u0016\u0010'\u001a\u0004\u0018\u00010\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u001e\u0010+\u001a\u00020\u001d2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\f2\u0006\u0010.\u001a\u00020\u0011H$J\b\u0010/\u001a\u00020\u001dH\u0016J\f\u00100\u001a\b\u0012\u0004\u0012\u00020-01J\u0016\u00102\u001a\u00020\u001d2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000b0\fH$J\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020-052\u0006\u00106\u001a\u000207R$\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006@"}, d2={"Lgit4idea/index/ui/GitStageTree;", "Lcom/intellij/openapi/vcs/changes/ui/HoverChangesTree;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lgit4idea/index/ui/GitStageUiSettings;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/index/ui/GitStageUiSettings;Lcom/intellij/openapi/Disposable;)V", "ignoredFilePaths", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lcom/intellij/openapi/vcs/FilePath;", "getIgnoredFilePaths", "()Ljava/util/Map;", "operations", "Lgit4idea/index/actions/StagingAreaOperation;", "getOperations", "()Ljava/util/List;", "state", "Lgit4idea/index/GitStageTracker$State;", "getState", "()Lgit4idea/index/GitStageTracker$State;", "createHoverIcon", "Lcom/intellij/openapi/vcs/changes/ui/HoverIcon;", "node", "Lgit4idea/index/ui/GitStageTree$ChangesBrowserGitFileStatusNode;", "customizeTreeModel", "", "builder", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "getData", "", "dataId", "", "getDndOperation", "targetKind", "Lgit4idea/index/ui/NodeKind;", "getHoverIcon", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "getToggleClickCount", "", "performStageOperation", "nodes", "Lgit4idea/index/ui/GitFileStatusNode;", "operation", "rebuildTree", "selectedStatusNodes", "Lcom/intellij/util/containers/JBIterable;", "showMergeDialog", "conflictedFiles", "statusNodesListSelection", "Lcom/intellij/openapi/ListSelection;", "preferLimitedContext", "", "ChangesBrowserGitFileStatusNode", "GitStageHoverIcon", "MyDnDSupport", "MyDragBean", "MyIgnoredNode", "MyKindNode", "MyTreeModelBuilder", "MyUntrackedNode", "intellij.vcs.git"})
public abstract class GitStageTree
extends HoverChangesTree {
    @NotNull
    private final GitStageUiSettings settings;

    public GitStageTree(@NotNull Project project, @NotNull GitStageUiSettings settings, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(project, false, true);
        this.settings = settings;
        this.setKeepTreeState(true);
        this.setScrollToSelection(false);
        new MyDnDSupport().install(parentDisposable);
        this.settings.addListener(new GitStageUiSettingsListener(){

            @Override
            public void settingsChanged() {
                this.rebuildTree();
            }
        }, parentDisposable);
    }

    @NotNull
    protected abstract GitStageTracker.State getState();

    @NotNull
    protected abstract Map<VirtualFile, List<FilePath>> getIgnoredFilePaths();

    @NotNull
    protected abstract List<StagingAreaOperation> getOperations();

    public int getToggleClickCount() {
        return 2;
    }

    protected abstract void performStageOperation(@NotNull List<GitFileStatusNode> var1, @NotNull StagingAreaOperation var2);

    @Nullable
    protected abstract StagingAreaOperation getDndOperation(@NotNull NodeKind var1);

    protected abstract void showMergeDialog(@NotNull List<? extends VirtualFile> var1);

    @Nullable
    protected abstract HoverIcon createHoverIcon(@NotNull ChangesBrowserGitFileStatusNode var1);

    @Nullable
    public HoverIcon getHoverIcon(@NotNull ChangesBrowserNode<?> node) {
        Object v1;
        block6: {
            HoverIcon hoverIcon;
            Intrinsics.checkNotNullParameter(node, (String)"node");
            if (Intrinsics.areEqual(node, (Object)this.getRoot())) {
                return null;
            }
            if (node instanceof ChangesBrowserGitFileStatusNode && (hoverIcon = this.createHoverIcon((ChangesBrowserGitFileStatusNode)node)) != null) {
                return hoverIcon;
            }
            GitFileStatusNode gitFileStatusNode = (GitFileStatusNode)VcsTreeModelData.children(node).iterateUserObjects(GitFileStatusNode.class).first();
            if (gitFileStatusNode == null) {
                return null;
            }
            GitFileStatusNode statusNode = gitFileStatusNode;
            Iterable iterable = this.getOperations();
            for (Object t : iterable) {
                StagingAreaOperation it = (StagingAreaOperation)t;
                boolean bl = false;
                if (!it.matches(statusNode)) continue;
                v1 = t;
                break block6;
            }
            v1 = null;
        }
        StagingAreaOperation stagingAreaOperation = v1;
        if (stagingAreaOperation == null) {
            return null;
        }
        StagingAreaOperation operation = stagingAreaOperation;
        if (operation.getIcon() == null) {
            return null;
        }
        return new GitStageHoverIcon(operation);
    }

    public void rebuildTree() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        MyTreeModelBuilder builder = new MyTreeModelBuilder(project, this.getGroupingSupport().getGrouping());
        builder.createKindNode(NodeKind.STAGED);
        builder.createKindNode(NodeKind.UNSTAGED);
        NodeKind[] nodeKindArray = NodeKind.values();
        GitStageTreeKt.forEachStatus(this.getState(), Arrays.copyOf(nodeKindArray, nodeKindArray.length), (Function3<? super VirtualFile, ? super GitFileStatus, ? super NodeKind, Unit>)((Function3)new Function3<VirtualFile, GitFileStatus, NodeKind, Unit>(builder){
            final /* synthetic */ MyTreeModelBuilder $builder;
            {
                this.$builder = $builder;
                super(3);
            }

            public final void invoke(@NotNull VirtualFile root, @NotNull GitFileStatus status, @NotNull NodeKind kind) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
                this.$builder.insertStatus(root, status, kind);
            }
        }));
        if (this.settings.ignoredFilesShown()) {
            builder.insertIgnoredPaths(this.getIgnoredFilePaths());
        }
        this.customizeTreeModel(builder);
        this.updateTreeModel(builder.build());
    }

    protected void customizeTreeModel(@NotNull TreeModelBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (GitStageDataKeys.GIT_STAGE_TREE.is(dataId)) {
            object = this;
        } else if (GitStageDataKeys.GIT_STAGE_UI_SETTINGS.is(dataId)) {
            object = this.settings;
        } else if (GitStageDataKeys.GIT_FILE_STATUS_NODES.is(dataId)) {
            object = this.selectedStatusNodes();
        } else if (VcsDataKeys.FILE_PATHS.is(dataId)) {
            object = this.selectedStatusNodes().map(arg_0 -> GitStageTree.getData$lambda$1(getData.1.INSTANCE, arg_0));
        } else if (VcsDataKeys.VIRTUAL_FILES.is(dataId)) {
            object = this.selectedStatusNodes().map(arg_0 -> GitStageTree.getData$lambda$2(getData.2.INSTANCE, arg_0)).filter(arg_0 -> GitStageTree.getData$lambda$3(getData.3.INSTANCE, arg_0));
        } else if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            List list2 = this.selectedStatusNodes().map(arg_0 -> GitStageTree.getData$lambda$4(getData.4.INSTANCE, arg_0)).filter(arg_0 -> GitStageTree.getData$lambda$5(getData.5.INSTANCE, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"selectedStatusNodes().ma\u2026 null }\n        .toList()");
            Collection $this$toTypedArray$iv = list2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            object = thisCollection$iv.toArray(new VirtualFile[0]);
        } else if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            List list3 = this.selectedStatusNodes().map(arg_0 -> GitStageTree.getData$lambda$6(getData.6.INSTANCE, arg_0)).filter(arg_0 -> GitStageTree.getData$lambda$7(getData.7.INSTANCE, arg_0)).map(arg_0 -> GitStageTree.getData$lambda$8((Function1)new Function1<VirtualFile, OpenFileDescriptor>(this){
                final /* synthetic */ GitStageTree this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final OpenFileDescriptor invoke(@Nullable VirtualFile it) {
                    Project project = this.this$0.getProject();
                    VirtualFile virtualFile = it;
                    Intrinsics.checkNotNull((Object)virtualFile);
                    return new OpenFileDescriptor(project, virtualFile);
                }
            }, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"override fun getData(dat\u2026getData(dataId)\n    }\n  }");
            Collection $this$toTypedArray$iv = list3;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            object = thisCollection$iv.toArray(new OpenFileDescriptor[0]);
        } else {
            object = PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) ? (!this.selectedStatusNodes().isEmpty() ? new VirtualFileDeleteProvider() : null) : super.getData(dataId);
        }
        return object;
    }

    @NotNull
    public final JBIterable<GitFileStatusNode> selectedStatusNodes() {
        JBIterable jBIterable = VcsTreeModelData.selected((JTree)((JTree)((Object)this))).iterateUserObjects(GitFileStatusNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"selected(this).iterateUs\u2026leStatusNode::class.java)");
        return jBIterable;
    }

    @NotNull
    public final ListSelection<GitFileStatusNode> statusNodesListSelection(boolean preferLimitedContext) {
        ListSelection listSelection;
        VcsTreeModelData vcsTreeModelData;
        GitFileStatusNode selected;
        List list2 = VcsTreeModelData.selected((JTree)((JTree)((Object)this))).userObjects(GitFileStatusNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"selected(this).userObjec\u2026leStatusNode::class.java)");
        List entries = list2;
        if (entries.size() > 1) {
            ListSelection listSelection2 = ListSelection.createAt((List)entries, (int)0).asExplicitSelection();
            Intrinsics.checkNotNullExpressionValue((Object)listSelection2, (String)"createAt(entries, 0)\n   \u2026   .asExplicitSelection()");
            return listSelection2;
        }
        GitFileStatusNode gitFileStatusNode = selected = (GitFileStatusNode)CollectionsKt.singleOrNull((List)entries);
        NodeKind selectedKind = gitFileStatusNode != null ? gitFileStatusNode.getKind() : null;
        if (preferLimitedContext && (selectedKind == NodeKind.UNSTAGED || selectedKind == NodeKind.UNTRACKED)) {
            VcsTreeModelData vcsTreeModelData2 = VcsTreeModelData.allUnderTag((JTree)((JTree)((Object)this)), (Object)((Object)NodeKind.UNSTAGED));
            vcsTreeModelData = vcsTreeModelData2;
            Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData2, (String)"{\n        VcsTreeModelDa\u2026odeKind.UNSTAGED)\n      }");
        } else if (preferLimitedContext && (selectedKind == NodeKind.STAGED || selectedKind == NodeKind.IGNORED || selectedKind == NodeKind.CONFLICTED)) {
            VcsTreeModelData vcsTreeModelData3 = VcsTreeModelData.allUnderTag((JTree)((JTree)((Object)this)), (Object)((Object)selectedKind));
            vcsTreeModelData = vcsTreeModelData3;
            Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData3, (String)"{\n        VcsTreeModelDa\u2026is, selectedKind)\n      }");
        } else {
            VcsTreeModelData vcsTreeModelData4 = VcsTreeModelData.all((JTree)((JTree)((Object)this)));
            vcsTreeModelData = vcsTreeModelData4;
            Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData4, (String)"{\n        VcsTreeModelData.all(this)\n      }");
        }
        VcsTreeModelData allEntriesData = vcsTreeModelData;
        List list3 = allEntriesData.userObjects(GitFileStatusNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"allEntriesData.userObjec\u2026leStatusNode::class.java)");
        List allEntries = list3;
        if (allEntries.size() <= entries.size()) {
            ListSelection listSelection3 = ListSelection.createAt((List)entries, (int)0).asExplicitSelection();
            listSelection = listSelection3;
            Intrinsics.checkNotNullExpressionValue((Object)listSelection3, (String)"{\n      ListSelection.cr\u2026ExplicitSelection()\n    }");
        } else {
            ListSelection listSelection4 = ListSelection.create((List)allEntries, (Object)selected);
            listSelection = listSelection4;
            Intrinsics.checkNotNullExpressionValue((Object)listSelection4, (String)"{\n      ListSelection.cr\u2026lEntries, selected)\n    }");
        }
        return listSelection;
    }

    private static final FilePath getData$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FilePath)$tmp0.invoke(p0);
    }

    private static final VirtualFile getData$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VirtualFile)$tmp0.invoke(p0);
    }

    private static final boolean getData$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final VirtualFile getData$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VirtualFile)$tmp0.invoke(p0);
    }

    private static final boolean getData$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final VirtualFile getData$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VirtualFile)$tmp0.invoke(p0);
    }

    private static final boolean getData$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final OpenFileDescriptor getData$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (OpenFileDescriptor)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lgit4idea/index/ui/GitStageTree$GitStageHoverIcon;", "Lcom/intellij/openapi/vcs/changes/ui/HoverIcon;", "operation", "Lgit4idea/index/actions/StagingAreaOperation;", "(Lgit4idea/index/ui/GitStageTree;Lgit4idea/index/actions/StagingAreaOperation;)V", "getOperation", "()Lgit4idea/index/actions/StagingAreaOperation;", "equals", "", "other", "", "hashCode", "", "invokeAction", "", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "intellij.vcs.git"})
    private final class GitStageHoverIcon
    extends HoverIcon {
        @NotNull
        private final StagingAreaOperation operation;

        public GitStageHoverIcon(StagingAreaOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Icon icon = operation.getIcon();
            Intrinsics.checkNotNull((Object)icon);
            super(icon, operation.getActionText().get());
            this.operation = operation;
        }

        @NotNull
        public final StagingAreaOperation getOperation() {
            return this.operation;
        }

        public void invokeAction(@NotNull ChangesBrowserNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            List list2 = VcsTreeModelData.children(node).userObjects(GitFileStatusNode.class);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"children(node).userObjec\u2026leStatusNode::class.java)");
            List nodes = list2;
            GitStageTree.this.performStageOperation(nodes, this.operation);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof GitStageHoverIcon && Intrinsics.areEqual((Object)this.operation, (Object)((GitStageHoverIcon)((Object)other)).operation);
        }

        public int hashCode() {
            return this.operation.hashCode();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00060\nR\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J \u0010\u001b\u001a\u00020\u00152\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001dJ\u0012\u0010 \u001a\u00020\u00152\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u001aJ\u001e\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tR\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\nR\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lgit4idea/index/ui/GitStageTree$MyTreeModelBuilder;", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "grouping", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "(Lgit4idea/index/ui/GitStageTree;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;)V", "parentNodes", "", "Lgit4idea/index/ui/NodeKind;", "Lgit4idea/index/ui/GitStageTree$MyKindNode;", "Lgit4idea/index/ui/GitStageTree;", "untrackedFilesMap", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lgit4idea/index/GitFileStatus;", "build", "Ljavax/swing/tree/DefaultTreeModel;", "createKindNode", "kind", "createUntrackedNode", "", "insertFileStatusNode", "node", "Lgit4idea/index/ui/GitFileStatusNode;", "subtreeRoot", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "insertIgnoredPaths", "ignoredFiles", "", "", "Lcom/intellij/openapi/vcs/FilePath;", "insertIntoRootNode", "insertStatus", "root", "status", "intellij.vcs.git"})
    private final class MyTreeModelBuilder
    extends TreeModelBuilder {
        @NotNull
        private final Map<NodeKind, MyKindNode> parentNodes;
        @NotNull
        private final Map<VirtualFile, Collection<GitFileStatus>> untrackedFilesMap;

        public MyTreeModelBuilder(@NotNull Project project, ChangesGroupingPolicyFactory grouping) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)grouping, (String)"grouping");
            super(project, grouping);
            this.parentNodes = new LinkedHashMap();
            this.untrackedFilesMap = new LinkedHashMap();
        }

        public final void insertStatus(@NotNull VirtualFile root, @NotNull GitFileStatus status, @NotNull NodeKind kind) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            if (kind == NodeKind.UNTRACKED) {
                Collection collection;
                Map<VirtualFile, Collection<GitFileStatus>> $this$getOrPut$iv = this.untrackedFilesMap;
                boolean $i$f$getOrPut = false;
                Collection value$iv = $this$getOrPut$iv.get(root);
                if (value$iv == null) {
                    boolean bl = false;
                    Collection answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(root, answer$iv);
                    collection = answer$iv;
                } else {
                    collection = value$iv;
                }
                collection.add((GitFileStatus)status);
            } else {
                this.insertFileStatusNode(new GitFileStatusNode(root, status, kind), this.createKindNode(kind));
            }
        }

        private final void insertFileStatusNode(GitFileStatusNode node, ChangesBrowserNode<?> subtreeRoot) {
            this.insertChangeNode(node.getFilePath(), subtreeRoot, (ChangesBrowserNode)new ChangesBrowserGitFileStatusNode(node));
        }

        public final void insertIntoRootNode(@NotNull ChangesBrowserNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            this.myModel.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)this.myRoot, this.myRoot.getChildCount());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MyKindNode createKindNode(@NotNull NodeKind kind) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Map<NodeKind, MyKindNode> map2 = this.parentNodes;
            GitStageTree gitStageTree = GitStageTree.this;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get((Object)kind);
            if (value$iv == null) {
                MyKindNode myKindNode;
                boolean bl = false;
                MyKindNode it = myKindNode = gitStageTree.new MyKindNode(kind);
                boolean bl2 = false;
                this.insertIntoRootNode(it);
                MyKindNode answer$iv = myKindNode;
                $this$getOrPut$iv.put(kind, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (MyKindNode)((Object)object);
        }

        public final void insertIgnoredPaths(@NotNull Map<VirtualFile, ? extends List<? extends FilePath>> ignoredFiles) {
            MyIgnoredNode myIgnoredNode;
            Intrinsics.checkNotNullParameter(ignoredFiles, (String)"ignoredFiles");
            List allIgnored = CollectionsKt.flatten((Iterable)ignoredFiles.values());
            if (ContainerUtil.isEmpty((Collection)allIgnored)) {
                return;
            }
            Project project = GitStageTree.this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            MyIgnoredNode it = myIgnoredNode = new MyIgnoredNode(project, allIgnored);
            boolean bl = false;
            this.insertIntoRootNode((ChangesBrowserNode)it);
            MyIgnoredNode ignoredNode = myIgnoredNode;
            if (!ignoredNode.isManyFiles()) {
                Map<VirtualFile, ? extends List<? extends FilePath>> $this$forEach$iv = ignoredFiles;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<VirtualFile, ? extends List<? extends FilePath>>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<VirtualFile, ? extends List<? extends FilePath>> element$iv;
                    Map.Entry<VirtualFile, ? extends List<? extends FilePath>> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    VirtualFile root = entry.getKey();
                    List<? extends FilePath> ignoredInRoot = entry.getValue();
                    Iterable $this$forEach$iv2 = ignoredInRoot;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        FilePath it2 = (FilePath)element$iv2;
                        boolean bl3 = false;
                        this.insertFileStatusNode(new GitFileStatusNode(root, GitFileStatusKt.ignoredStatus(it2), NodeKind.IGNORED), (ChangesBrowserNode)ignoredNode);
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void createUntrackedNode() {
            List allUntrackedStatuses = CollectionsKt.flatten((Iterable)this.untrackedFilesMap.values());
            if (allUntrackedStatuses.isEmpty()) {
                return;
            }
            if (ChangesBrowserSpecificFilePathsNode.isManyFiles((Collection)allUntrackedStatuses)) {
                void $this$mapTo$iv$iv;
                MyUntrackedNode $this$map$iv;
                Project project = GitStageTree.this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                Iterable iterable = allUntrackedStatuses;
                Project project2 = project;
                boolean $i$f$map = false;
                void var4_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    GitFileStatus gitFileStatus = (GitFileStatus)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getPath());
                }
                List list2 = (List)destination$iv$iv;
                Project project3 = project2;
                MyUntrackedNode it = $this$map$iv = new MyUntrackedNode(project3, list2);
                boolean bl = false;
                this.insertIntoRootNode((ChangesBrowserNode)it);
            } else {
                MyKindNode unstagedNode = this.createKindNode(NodeKind.UNSTAGED);
                Map<VirtualFile, Collection<GitFileStatus>> $this$forEach$iv = this.untrackedFilesMap;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<VirtualFile, Collection<GitFileStatus>>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<VirtualFile, Collection<GitFileStatus>> element$iv;
                    Map.Entry<VirtualFile, Collection<GitFileStatus>> entry = element$iv = iterator.next();
                    boolean bl = false;
                    VirtualFile root = entry.getKey();
                    Collection<GitFileStatus> untrackedInRoot = entry.getValue();
                    Iterable $this$forEach$iv2 = untrackedInRoot;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        GitFileStatus it = (GitFileStatus)element$iv2;
                        boolean bl2 = false;
                        this.insertFileStatusNode(new GitFileStatusNode(root, it, NodeKind.UNTRACKED), unstagedNode);
                    }
                }
            }
        }

        @NotNull
        public DefaultTreeModel build() {
            this.createUntrackedNode();
            DefaultTreeModel defaultTreeModel = super.build();
            Intrinsics.checkNotNullExpressionValue((Object)defaultTreeModel, (String)"super.build()");
            return defaultTreeModel;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J(\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0016R\u001d\u0010\u0005\u001a\u0004\u0018\u00010\u00068@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lgit4idea/index/ui/GitStageTree$ChangesBrowserGitFileStatusNode;", "Lcom/intellij/openapi/vcs/changes/ui/AbstractChangesBrowserFilePathNode;", "Lgit4idea/index/ui/GitFileStatusNode;", "node", "(Lgit4idea/index/ui/GitFileStatusNode;)V", "conflict", "Lgit4idea/repo/GitConflict;", "getConflict$intellij_vcs_git", "()Lgit4idea/repo/GitConflict;", "conflict$delegate", "Lkotlin/Lazy;", "appendParentPath", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "parentPath", "Lcom/intellij/openapi/vcs/FilePath;", "filePath", "userObject", "originPath", "render", "selected", "", "expanded", "hasFocus", "intellij.vcs.git"})
    protected static final class ChangesBrowserGitFileStatusNode
    extends AbstractChangesBrowserFilePathNode<GitFileStatusNode> {
        @NotNull
        private final Lazy conflict$delegate;

        public ChangesBrowserGitFileStatusNode(@NotNull GitFileStatusNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super((Object)node, node.getFileStatus());
            this.conflict$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GitConflict>(this){
                final /* synthetic */ ChangesBrowserGitFileStatusNode this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final GitConflict invoke() {
                    Object object = this.this$0.getUserObject();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getUserObject()");
                    return GitStageTreeKt.createConflict((GitFileStatusNode)object);
                }
            }));
        }

        @Nullable
        public final GitConflict getConflict$intellij_vcs_git() {
            Lazy lazy = this.conflict$delegate;
            return (GitConflict)lazy.getValue();
        }

        @NotNull
        protected FilePath filePath(@NotNull GitFileStatusNode userObject) {
            Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
            return userObject.getFilePath();
        }

        @Nullable
        protected FilePath originPath(@NotNull GitFileStatusNode userObject) {
            Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
            return userObject.getOrigPath();
        }

        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
                super.render(renderer2, selected, expanded, hasFocus);
                GitConflict gitConflict = this.getConflict$intellij_vcs_git();
                if (gitConflict == null) break block0;
                GitConflict conflict2 = gitConflict;
                boolean bl = false;
                renderer2.append(FontUtil.spaceAndThinSpace() + GitConflictsUtil.INSTANCE.getConflictType$intellij_vcs_git(conflict2), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }

        protected void appendParentPath(@NotNull ChangesBrowserNodeRenderer renderer2, @Nullable FilePath parentPath) {
            Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
            if (this.getConflict$intellij_vcs_git() == null) {
                super.appendParentPath(renderer2, parentPath);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0017J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016R\u0011\u0010\u0003\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lgit4idea/index/ui/GitStageTree$MyKindNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lgit4idea/index/ui/NodeKind;", "kind", "(Lgit4idea/index/ui/GitStageTree;Lgit4idea/index/ui/NodeKind;)V", "getKind", "()Lgit4idea/index/ui/NodeKind;", "getSortWeight", "", "getTextPresentation", "", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "intellij.vcs.git"})
    protected class MyKindNode
    extends ChangesBrowserNode<NodeKind> {
        public MyKindNode(NodeKind kind) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            super((Object)kind);
            this.markAsHelperNode();
        }

        @NotNull
        public final NodeKind getKind() {
            Object object = this.userObject;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type git4idea.index.ui.NodeKind");
            return (NodeKind)((Object)object);
        }

        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
            renderer2.append(this.getTextPresentation(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            if (this.getKind() == NodeKind.CONFLICTED) {
                renderer2.append(FontUtil.spaceAndThinSpace(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                renderer2.append(VcsBundle.message((String)"changes.nodetitle.merge.conflicts.resolve.link.label", (Object[])new Object[0]), SimpleTextAttributes.LINK_BOLD_ATTRIBUTES, () -> MyKindNode.render$lambda$2(this, GitStageTree.this));
            }
            this.appendCount((ColoredTreeCellRenderer)renderer2);
        }

        @Nls
        @NotNull
        public String getTextPresentation() {
            String string = GitBundle.message(this.getKind().getKey(), new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(kind.key)");
            return string;
        }

        public int getSortWeight() {
            return ((Number)MapsKt.getValue(NodeKind.Companion.getSortOrder$intellij_vcs_git(), (Object)((Object)this.getKind()))).intValue();
        }

        private static final VirtualFile render$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (VirtualFile)$tmp0.invoke(p0);
        }

        private static final boolean render$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void render$lambda$2(MyKindNode this$0, GitStageTree this$1) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)this$1), (String)"this$1");
            List list2 = this$0.traverseObjectsUnder().filter(GitFileStatusNode.class).map(arg_0 -> MyKindNode.render$lambda$2$lambda$0(render.1.conflictedFiles.1.INSTANCE, arg_0)).filter(arg_0 -> MyKindNode.render$lambda$2$lambda$1(render.1.conflictedFiles.2.INSTANCE, arg_0)).toList();
            Intrinsics.checkNotNull((Object)list2, (String)"null cannot be cast to non-null type kotlin.collections.List<com.intellij.openapi.vfs.VirtualFile>");
            List conflictedFiles2 = list2;
            this$1.showMergeDialog(conflictedFiles2);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0017\u00a8\u0006\r"}, d2={"Lgit4idea/index/ui/GitStageTree$MyIgnoredNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserSpecificFilePathsNode;", "Lgit4idea/index/ui/NodeKind;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getSortWeight", "", "getTextPresentation", "", "intellij.vcs.git"})
    private static final class MyIgnoredNode
    extends ChangesBrowserSpecificFilePathsNode<NodeKind> {
        public MyIgnoredNode(@NotNull Project project, @NotNull List<? extends FilePath> files) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            super((Object)NodeKind.IGNORED, (Collection)files, () -> MyIgnoredNode._init_$lambda$0(project));
            this.markAsHelperNode();
            this.setAttributes(SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }

        @Nls
        @NotNull
        public String getTextPresentation() {
            String string = GitBundle.message(NodeKind.IGNORED.getKey(), new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(NodeKind.IGNORED.key)");
            return string;
        }

        public int getSortWeight() {
            return ((Number)MapsKt.getValue(NodeKind.Companion.getSortOrder$intellij_vcs_git(), (Object)((Object)NodeKind.IGNORED))).intValue();
        }

        private static final void _init_$lambda$0(Project $project) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            new IgnoredViewDialog($project).show();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0017\u00a8\u0006\r"}, d2={"Lgit4idea/index/ui/GitStageTree$MyUntrackedNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserSpecificFilePathsNode;", "Lgit4idea/index/ui/NodeKind;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getSortWeight", "", "getTextPresentation", "", "intellij.vcs.git"})
    private static final class MyUntrackedNode
    extends ChangesBrowserSpecificFilePathsNode<NodeKind> {
        public MyUntrackedNode(@NotNull Project project, @NotNull List<? extends FilePath> files) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            super((Object)NodeKind.UNTRACKED, (Collection)files, () -> MyUntrackedNode._init_$lambda$0(project, files));
            this.markAsHelperNode();
            this.setAttributes(SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }

        @Nls
        @NotNull
        public String getTextPresentation() {
            String string = GitBundle.message(NodeKind.UNTRACKED.getKey(), new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(NodeKind.UNTRACKED.key)");
            return string;
        }

        public int getSortWeight() {
            return ((Number)MapsKt.getValue(NodeKind.Companion.getSortOrder$intellij_vcs_git(), (Object)((Object)NodeKind.UNTRACKED))).intValue();
        }

        private static final void _init_$lambda$0(Project $project, List $files) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
            new UnversionedViewDialog($project, $files).show();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006H\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0014"}, d2={"Lgit4idea/index/ui/GitStageTree$MyDnDSupport;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeDnDSupport;", "(Lgit4idea/index/ui/GitStageTree;)V", "acceptDrop", "", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "bean", "Lgit4idea/index/ui/GitStageTree$MyDragBean;", "canAcceptDrop", "", "canHandleDropEvent", "aEvent", "Lcom/intellij/ide/dnd/DnDEvent;", "dropNode", "createDragStartBean", "Lcom/intellij/ide/dnd/DnDDragStartBean;", "info", "Lcom/intellij/ide/dnd/DnDActionInfo;", "drop", "intellij.vcs.git"})
    private final class MyDnDSupport
    extends ChangesTreeDnDSupport {
        public MyDnDSupport() {
            super((ChangesTree)GitStageTree.this);
        }

        @Nullable
        protected DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            if (info.isMove()) {
                List list2 = GitStageTree.this.selectedStatusNodes().toList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"selectedStatusNodes().toList()");
                List selection = list2;
                if (!((Collection)selection).isEmpty()) {
                    return new DnDDragStartBean((Object)new MyDragBean((ChangesTree)GitStageTree.this, selection));
                }
            }
            return null;
        }

        protected boolean canHandleDropEvent(@NotNull DnDEvent aEvent, @Nullable ChangesBrowserNode<?> dropNode) {
            Intrinsics.checkNotNullParameter((Object)aEvent, (String)"aEvent");
            Object dragBean = aEvent.getAttachedObject();
            if (dragBean instanceof MyDragBean && dropNode != null && ((MyDragBean)dragBean).getSourceComponent() == GitStageTree.this && this.canAcceptDrop(dropNode, (MyDragBean)dragBean)) {
                ((MyDragBean)dragBean).setTargetNode(dropNode);
                return true;
            }
            return false;
        }

        public void drop(@NotNull DnDEvent aEvent) {
            block1: {
                ChangesBrowserNode<?> changesBrowserNode;
                Intrinsics.checkNotNullParameter((Object)aEvent, (String)"aEvent");
                Object dragBean = aEvent.getAttachedObject();
                if (!(dragBean instanceof MyDragBean)) break block1;
                ChangesBrowserNode<?> changesBrowserNode2 = changesBrowserNode = ((MyDragBean)dragBean).getTargetNode();
                if (changesBrowserNode2 != null) {
                    ChangesBrowserNode<?> it = changesBrowserNode2;
                    boolean bl = false;
                    this.acceptDrop(it, (MyDragBean)dragBean);
                }
            }
        }

        private final boolean canAcceptDrop(ChangesBrowserNode<?> node, MyDragBean bean) {
            boolean bl;
            block5: {
                Object object = node.getUserObject();
                NodeKind nodeKind = object instanceof NodeKind ? (NodeKind)((Object)object) : null;
                if (nodeKind == null) {
                    return false;
                }
                NodeKind targetKind = nodeKind;
                StagingAreaOperation stagingAreaOperation = GitStageTree.this.getDndOperation(targetKind);
                if (stagingAreaOperation == null) {
                    return false;
                }
                StagingAreaOperation operation = stagingAreaOperation;
                Iterable $this$all$iv = bean.getNodes();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        GitFileStatusNode p0 = (GitFileStatusNode)element$iv;
                        boolean bl2 = false;
                        if (operation.matches(p0)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        private final void acceptDrop(ChangesBrowserNode<?> node, MyDragBean bean) {
            Object object = node.getUserObject();
            NodeKind nodeKind = object instanceof NodeKind ? (NodeKind)((Object)object) : null;
            if (nodeKind == null) {
                return;
            }
            NodeKind targetKind = nodeKind;
            StagingAreaOperation stagingAreaOperation = GitStageTree.this.getDndOperation(targetKind);
            if (stagingAreaOperation == null) {
                return;
            }
            StagingAreaOperation operation = stagingAreaOperation;
            GitStageTree.this.performStageOperation(bean.getNodes(), operation);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lgit4idea/index/ui/GitStageTree$MyDragBean;", "", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "nodes", "", "Lgit4idea/index/ui/GitFileStatusNode;", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Ljava/util/List;)V", "getNodes", "()Ljava/util/List;", "sourceComponent", "Ljavax/swing/JComponent;", "getSourceComponent", "()Ljavax/swing/JComponent;", "targetNode", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "getTargetNode", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "setTargetNode", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;)V", "getTree", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "intellij.vcs.git"})
    private static final class MyDragBean {
        @NotNull
        private final ChangesTree tree;
        @NotNull
        private final List<GitFileStatusNode> nodes;
        @Nullable
        private ChangesBrowserNode<?> targetNode;

        public MyDragBean(@NotNull ChangesTree tree2, @NotNull List<GitFileStatusNode> nodes) {
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            this.tree = tree2;
            this.nodes = nodes;
        }

        @NotNull
        public final ChangesTree getTree() {
            return this.tree;
        }

        @NotNull
        public final List<GitFileStatusNode> getNodes() {
            return this.nodes;
        }

        @Nullable
        public final ChangesBrowserNode<?> getTargetNode() {
            return this.targetNode;
        }

        public final void setTargetNode(@Nullable ChangesBrowserNode<?> changesBrowserNode) {
            this.targetNode = changesBrowserNode;
        }

        @NotNull
        public final JComponent getSourceComponent() {
            return (JComponent)this.tree;
        }
    }
}

