/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.ui;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.actions.diff.PresentableGoToChangePopupAction;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import git4idea.index.GitStageDiffUtilKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerListener;
import git4idea.index.KindTag;
import git4idea.index.ui.GitFileStatusNode;
import git4idea.index.ui.GitStageDiffPreview;
import git4idea.index.ui.GitStageTree;
import git4idea.index.ui.NodeKind;
import java.util.Objects;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002!\"B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0014J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lgit4idea/index/ui/GitStageDiffPreview;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "tree", "Lgit4idea/index/ui/GitStageTree;", "tracker", "Lgit4idea/index/GitStageTracker;", "isInEditor", "", "parent", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/index/ui/GitStageTree;Lgit4idea/index/GitStageTracker;ZLcom/intellij/openapi/Disposable;)V", "disposableFlag", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "createGoToChangeAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getToolbarWrapper", "Lcom/intellij/ui/components/panels/Wrapper;", "iterateAllChanges", "", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "iterateSelectedChanges", "selectChange", "", "change", "shouldAddToolbarBottomBorder", "toolbarComponents", "Lcom/intellij/diff/FrameDiffTool$ToolbarComponents;", "wrap", "modelData", "Lcom/intellij/openapi/vcs/changes/ui/VcsTreeModelData;", "GitFileStatusNodeWrapper", "MyGoToChangePopupAction", "intellij.vcs.git"})
public final class GitStageDiffPreview
extends ChangeViewDiffRequestProcessor {
    @NotNull
    private final GitStageTree tree;
    private final boolean isInEditor;
    @NotNull
    private final CheckedDisposable disposableFlag;

    public GitStageDiffPreview(@NotNull Project project, @NotNull GitStageTree tree2, @NotNull GitStageTracker tracker, boolean isInEditor, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)tree2), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(project, "Stage");
        this.tree = tree2;
        this.isInEditor = isInEditor;
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable()");
        this.disposableFlag = checkedDisposable;
        this.tree.addSelectionListener(() -> GitStageDiffPreview._init_$lambda$0(this), (Disposable)this);
        tracker.addListener(new GitStageTrackerListener(){

            @Override
            public void update() {
                this.updatePreview(this.getComponent().isShowing(), true);
            }
        }, (Disposable)this);
        Disposer.register((Disposable)parent, (Disposable)((Disposable)this));
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)this.disposableFlag));
    }

    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        Intrinsics.checkNotNullParameter((Object)toolbarComponents, (String)"toolbarComponents");
        return !this.isInEditor || super.shouldAddToolbarBottomBorder(toolbarComponents);
    }

    @NotNull
    public final Wrapper getToolbarWrapper() {
        Wrapper wrapper = this.myToolbarWrapper;
        Intrinsics.checkNotNullExpressionValue((Object)wrapper, (String)"myToolbarWrapper");
        return wrapper;
    }

    protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        if (!(change instanceof GitFileStatusNodeWrapper) && !(change instanceof ChangeViewDiffRequestProcessor.ChangeWrapper)) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.tree.getRoot()), (Object)change.getUserObject());
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode node = defaultMutableTreeNode;
        TreeUtil.selectPath((JTree)((JTree)((Object)this.tree)), (TreePath)TreeUtil.getPathFromRoot((TreeNode)node), (boolean)false);
    }

    @NotNull
    public Iterable<ChangeViewDiffRequestProcessor.Wrapper> iterateSelectedChanges() {
        VcsTreeModelData vcsTreeModelData = VcsTreeModelData.selected((JTree)((JTree)((Object)this.tree)));
        Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData, (String)"selected(tree)");
        return this.wrap(vcsTreeModelData);
    }

    @NotNull
    public Iterable<ChangeViewDiffRequestProcessor.Wrapper> iterateAllChanges() {
        VcsTreeModelData vcsTreeModelData = VcsTreeModelData.all((JTree)((JTree)((Object)this.tree)));
        Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData, (String)"all(tree)");
        return this.wrap(vcsTreeModelData);
    }

    @NotNull
    protected AnAction createGoToChangeAction() {
        return (AnAction)new MyGoToChangePopupAction();
    }

    private final Iterable<ChangeViewDiffRequestProcessor.Wrapper> wrap(VcsTreeModelData modelData) {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)modelData.iterateUserObjects(GitFileStatusNode.class).filter(arg_0 -> GitStageDiffPreview.wrap$lambda$1(wrap.1.INSTANCE, arg_0)).map(arg_0 -> GitStageDiffPreview.wrap$lambda$2(wrap.2.INSTANCE, arg_0))).append((Iterable)modelData.iterateUserObjects(Change.class).map(arg_0 -> GitStageDiffPreview.wrap$lambda$3(wrap.3.INSTANCE, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty<Wrapper>()\n      .\u2026ap { ChangeWrapper(it) })");
        return (Iterable)jBIterable;
    }

    private static final void _init_$lambda$0(GitStageDiffPreview this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        boolean modelUpdateInProgress = this$0.tree.isModelUpdateInProgress();
        BaseSingleTaskControllerKt.runInEdtAsync((CheckedDisposable)this$0.disposableFlag, (Function0)((Function0)new Function0<Unit>(this$0, modelUpdateInProgress){
            final /* synthetic */ GitStageDiffPreview this$0;
            final /* synthetic */ boolean $modelUpdateInProgress;
            {
                this.this$0 = $receiver;
                this.$modelUpdateInProgress = $modelUpdateInProgress;
                super(0);
            }

            public final void invoke() {
                this.this$0.updatePreview(this.this$0.getComponent().isShowing(), this.$modelUpdateInProgress);
            }
        }));
    }

    private static final boolean wrap$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final GitFileStatusNodeWrapper wrap$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (GitFileStatusNodeWrapper)((Object)$tmp0.invoke(p0));
    }

    private static final ChangeViewDiffRequestProcessor.ChangeWrapper wrap$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChangeViewDiffRequestProcessor.ChangeWrapper)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014\u00a8\u0006\t"}, d2={"Lgit4idea/index/ui/GitStageDiffPreview$MyGoToChangePopupAction;", "Lcom/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$Default;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "(Lgit4idea/index/ui/GitStageDiffPreview;)V", "getChanges", "Lcom/intellij/openapi/ListSelection;", "onSelected", "", "change", "intellij.vcs.git"})
    private final class MyGoToChangePopupAction
    extends PresentableGoToChangePopupAction.Default<ChangeViewDiffRequestProcessor.Wrapper> {
        @NotNull
        protected ListSelection<ChangeViewDiffRequestProcessor.Wrapper> getChanges() {
            ListSelection listSelection = GitStageDiffPreview.this.tree.statusNodesListSelection(false).map(arg_0 -> MyGoToChangePopupAction.getChanges$lambda$0(getChanges.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"tree.statusNodesListSele\u2026GitFileStatusNodeWrapper)");
            return listSelection;
        }

        protected void onSelected(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            GitStageDiffPreview.this.setCurrentChange(change);
            GitStageDiffPreview.this.selectChange(change);
        }

        private static final ChangeViewDiffRequestProcessor.Wrapper getChanges$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (ChangeViewDiffRequestProcessor.Wrapper)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lgit4idea/index/ui/GitStageDiffPreview$GitFileStatusNodeWrapper;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "node", "Lgit4idea/index/ui/GitFileStatusNode;", "(Lgit4idea/index/ui/GitFileStatusNode;)V", "getNode", "()Lgit4idea/index/ui/GitFileStatusNode;", "createProducer", "Lcom/intellij/diff/chains/DiffRequestProducer;", "project", "Lcom/intellij/openapi/project/Project;", "equals", "", "other", "", "getFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "getPresentableName", "", "getTag", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "getUserObject", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class GitFileStatusNodeWrapper
    extends ChangeViewDiffRequestProcessor.Wrapper {
        @NotNull
        private final GitFileStatusNode node;

        public GitFileStatusNodeWrapper(@NotNull GitFileStatusNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.node = node;
        }

        @NotNull
        public final GitFileStatusNode getNode() {
            return this.node;
        }

        @NotNull
        public String getPresentableName() {
            String string = this.node.getFilePath().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.filePath.name");
            return string;
        }

        @NotNull
        public Object getUserObject() {
            return this.node;
        }

        @NotNull
        public FilePath getFilePath() {
            return this.node.getFilePath();
        }

        @NotNull
        public FileStatus getFileStatus() {
            return this.node.getFileStatus();
        }

        @NotNull
        public ChangesBrowserNode.Tag getTag() {
            return (ChangesBrowserNode.Tag)KindTag.Companion.getTag$intellij_vcs_git(WhenMappings.$EnumSwitchMapping$0[this.node.getKind().ordinal()] == 1 ? NodeKind.UNSTAGED : this.node.getKind());
        }

        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            Project project2 = project;
            Intrinsics.checkNotNull((Object)project2);
            return (DiffRequestProducer)GitStageDiffUtilKt.createTwoSidesDiffRequestProducer(project2, this.node);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type git4idea.index.ui.GitStageDiffPreview.GitFileStatusNodeWrapper");
            GitFileStatusNodeWrapper cfr_ignored_0 = (GitFileStatusNodeWrapper)((Object)other);
            if (this.node.getKind() != ((GitFileStatusNodeWrapper)((Object)other)).node.getKind()) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.node.getFilePath(), (Object)((GitFileStatusNodeWrapper)((Object)other)).node.getFilePath());
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.node.getKind(), this.node.getFilePath()};
            return Objects.hash(objectArray);
        }

        @NotNull
        public String toString() {
            return "GitFileStatusNodeWrapper(node=" + this.node + ")";
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NodeKind.values().length];
                try {
                    nArray[NodeKind.UNTRACKED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

